/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.message.command;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.enterprise.replication.SnapshotDataProviders;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.ErrorMessageFactory;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ClientIdRegistry;
import io.axoniq.axonserver.grpc.SerializedCommand;
import io.axoniq.axonserver.grpc.SerializedCommandResponse;
import io.axoniq.axonserver.grpc.command.CommandResponse;
import io.axoniq.axonserver.interceptor.CommandInterceptors;
import io.axoniq.axonserver.interceptor.DefaultExecutionContext;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.message.DispatchQueueMetrics;
import io.axoniq.axonserver.message.FlowControlQueues;
import io.axoniq.axonserver.message.QueueMetrics;
import io.axoniq.axonserver.message.command.CommandHandler;
import io.axoniq.axonserver.message.command.CommandInformation;
import io.axoniq.axonserver.message.command.CommandMetricsRegistry;
import io.axoniq.axonserver.message.command.CommandRegistrationCache;
import io.axoniq.axonserver.message.command.WrappedCommand;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.plugin.ExecutionContext;
import io.axoniq.axonserver.rest.HttpStreamingQuery;
import io.axoniq.axonserver.util.ConstraintCache;
import io.axoniq.axonserver.util.NonReplacingConstraintCache;
import io.micrometer.core.instrument.Tags;
import java.util.Comparator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component(value="CommandDispatcher")
public class CommandDispatcher {
    private final Logger f;
    private final Map<String, MeterFactory.RateMeter> c;
    private final CommandRegistrationCache j;
    private final NonReplacingConstraintCache<String, CommandInformation> H;
    private final FlowControlQueues<WrappedCommand> m;
    private final CommandInterceptors h;
    private final CommandMetricsRegistry b;
    private final Map<String, AtomicInteger> I;

    private /* synthetic */ void g(ClientStreamIdentification a3, boolean a4) {
        CommandDispatcher a5;
        a5.K(a3);
        if (!a4) {
            a5.getCommandQueues().g(a3.toString(), (T a2) -> {
                CommandDispatcher a3;
                SerializedCommand serializedCommand = a2.g();
                CommandInformation commandInformation = (CommandInformation)a3.H.remove((Object)serializedCommand.getMessageIdentifier());
                if (commandInformation == null) {
                    return null;
                }
                if ((a2 = a3.j.getHandlerForCommand(a2.g().g(), serializedCommand.wrapped(), serializedCommand.getRoutingKey())) == null) {
                    commandInformation.g().accept(a3.g(serializedCommand.getMessageIdentifier(), ErrorCode.NO_HANDLER_FOR_COMMAND, "No Handler for command: " + serializedCommand.getName()));
                    return null;
                }
                CommandDispatcher commandDispatcher = a3;
                commandDispatcher.f.debug(SnapshotDataProviders.g((Object)"brUkGoEs\u0006`[;Rt\u001c;]f"), (Object)serializedCommand.getName(), (Object)a2.g());
                commandDispatcher.H.putIfAbsent((Object)serializedCommand.getMessageIdentifier(), (Object)new CommandInformation(serializedCommand.getName(), serializedCommand.getMessageIdentifier(), serializedCommand.wrapped().getClientId(), (CommandHandler)a2, commandInformation.g()));
                return a2.h.toString();
            });
        }
        a5.g(a3);
    }

    public void dispatch(String a2, Authentication a4, SerializedCommand a6, Consumer<SerializedCommandResponse> a7) {
        CommandDispatcher a8;
        String string = a2;
        a8.I.computeIfAbsent(string, a3 -> {
            CommandDispatcher a4;
            a3 = new AtomicInteger();
            a4.b.gauge((MetricName)BaseMetricName.La, Tags.of((String)"context", (String)string), ((AtomicInteger)a3)::get);
            return a3;
        }).incrementAndGet();
        a7 = a5 -> {
            CommandDispatcher a6;
            SerializedCommandResponse serializedCommandResponse = a5;
            a7.accept(serializedCommandResponse);
            if (a6.g(serializedCommandResponse)) {
                a6.b.error(a6.getCommand(), a2, a5.getErrorCode());
            }
            ((AtomicInteger)a6.I.get(a2)).decrementAndGet();
        };
        CommandDispatcher commandDispatcher = a8;
        commandDispatcher.commandRate(a2).g();
        commandDispatcher.g(a2, a4, a6, a7);
    }

    private /* synthetic */ boolean g(SerializedCommandResponse a2) {
        if (ErrorCode.NO_HANDLER_FOR_COMMAND.getCode().equals(a2.getErrorCode()) || ErrorCode.TOO_MANY_REQUESTS.getCode().equals(a2.getErrorCode()) || ErrorCode.OTHER.getCode().equals(a2.getErrorCode()) || ErrorCode.EXCEPTION_IN_INTERCEPTOR.getCode().equals(a2.getErrorCode()) || ErrorCode.CONNECTION_TO_HANDLER_LOST.getCode().equals(a2.getErrorCode()) || ErrorCode.COMMAND_DUPLICATED.getCode().equals(a2.getErrorCode())) {
            return true;
        }
        return false;
    }

    public MeterFactory.RateMeter commandRate(String a3) {
        CommandDispatcher a4;
        return a4.c.computeIfAbsent(a3, a2 -> {
            CommandDispatcher a3;
            return a3.b.rateMeter(a2, (MetricName)BaseMetricName.A, (MetricName)BaseMetricName.q);
        });
    }

    public int activeCommandCount() {
        CommandDispatcher a2;
        return a2.H.size();
    }

    private /* synthetic */ void g(String a2, Authentication a3, SerializedCommand a4, Consumer<SerializedCommandResponse> a5) {
        CommandDispatcher a6;
        long l2 = System.currentTimeMillis();
        a3 = new DefaultExecutionContext(a2, a3);
        a5 = arg_0 -> a6.g((DefaultExecutionContext)a3, a5, arg_0);
        try {
            CommandHandler commandHandler;
            CommandDispatcher commandDispatcher = a6;
            SerializedCommand serializedCommand = commandDispatcher.h.commandRequest(a4, (ExecutionContext)a3);
            CommandHandler commandHandler2 = commandHandler = commandDispatcher.j.getHandlerForCommand(a2, serializedCommand.wrapped(), serializedCommand.getRoutingKey());
            commandDispatcher.g(serializedCommand, commandHandler2, a7 -> {
                CommandDispatcher a8;
                SerializedCommandResponse serializedCommandResponse = a7;
                a5.accept(serializedCommandResponse);
                if (!a8.g(serializedCommandResponse) && commandHandler2 != null) {
                    a8.b.add(a4.getCommand(), a4.wrapped().getClientId(), commandHandler2.g(), a2, System.currentTimeMillis() - l2);
                }
            }, ErrorCode.NO_HANDLER_FOR_COMMAND, "No Handler for command: " + serializedCommand.getCommand());
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a2;
            objectArray[1] = a4.getCommand();
            objectArray[2] = exception;
            a6.f.warn(SnapshotDataProviders.g((Object)"]f\u001c;ccE~VoOtH;BrUkGoEsOuA;EtKvGuB;]f"), objectArray);
            a5.accept(a6.g(a4.getMessageIdentifier(), ErrorCode.fromException((Throwable)exception), exception.getMessage()));
            a3.compensate((Throwable)exception);
            return;
        }
    }

    private /* synthetic */ void g(DefaultExecutionContext a2, SerializedCommandResponse a3, Consumer<SerializedCommandResponse> a4) {
        CommandDispatcher a5;
        try {
            a4.accept(a5.h.commandResponse(a3, (ExecutionContext)a2));
            return;
        }
        catch (Exception exception) {
            CommandDispatcher commandDispatcher = a5;
            commandDispatcher.f.warn(HttpStreamingQuery.g((Object)"\u0017TV\t)Q\u000fL\u001c]\u0005F\u0002\t\u0005GL[\tZ\u001cF\u0002Z\t\t\u0005G\u0018L\u001eJ\tY\u0018F\u001e"), (Object)a2.contextName(), (Object)exception);
            a4.accept(commandDispatcher.g(a3.getRequestIdentifier(), ErrorCode.fromException((Throwable)exception), exception.getMessage()));
            a2.compensate((Throwable)exception);
            return;
        }
    }

    public void handleResponse(SerializedCommandResponse a2) {
        CommandDispatcher a3;
        CommandInformation commandInformation = (CommandInformation)a3.H.remove((Object)a2.getRequestIdentifier());
        if (commandInformation != null) {
            CommandInformation commandInformation2 = commandInformation;
            a3.f.debug(SnapshotDataProviders.g((Object)"HCuBrH|\u0006iChVtHhC;Rt\u001c;]f"), (Object)commandInformation2);
            commandInformation2.g().accept(a2);
            return;
        }
        a3.f.info(HttpStreamingQuery.g((Object)"j\u0003\\\u0000MLG\u0003]LO\u0005G\b\t\u000fF\u0001D\rG\b\t\u001eL\u001d\\\tZ\u0018\u0013LR\u0011"), (Object)a2.getRequestIdentifier());
    }

    @Nonnull
    private /* synthetic */ SerializedCommandResponse g(String a2, ErrorCode a3, String a4) {
        return new SerializedCommandResponse(CommandResponse.newBuilder().setMessageIdentifier(UUID.randomUUID().toString()).setRequestIdentifier(a2).setErrorCode(a3.getCode()).setErrorMessage(ErrorMessageFactory.g((String)a4)).build());
    }

    @EventListener
    public void on(TopologyEvents.CommandHandlerDisconnected a2) {
        CommandDispatcher a3;
        a3.g(a2.g(), a2.g());
    }

    private /* synthetic */ void K(ClientStreamIdentification a2) {
        CommandDispatcher a3;
        a3.j.remove(a2);
    }

    public void deleteMetrics(String a2) {
        CommandDispatcher a3;
        MeterFactory.RateMeter rateMeter = (MeterFactory.RateMeter)a3.c.remove(a2);
        if (rateMeter != null) {
            rateMeter.K();
        }
        a3.I.remove(a2);
        CommandDispatcher commandDispatcher = a3;
        commandDispatcher.b.remove((MetricName)BaseMetricName.La, a2);
        commandDispatcher.b.removeForContext(a2);
    }

    private /* synthetic */ void g(ClientStreamIdentification a4) {
        CommandDispatcher a5;
        a5.H.entrySet().stream().filter(a3 -> ((CommandInformation)a3.getValue()).g(a4)).map(Map.Entry::getKey).collect(Collectors.toList()).forEach(a2 -> {
            CommandDispatcher a3;
            CommandInformation commandInformation = (CommandInformation)a3.H.remove(a2);
            if (commandInformation != null) {
                commandInformation.g().accept(a3.g(a2, ErrorCode.CONNECTION_TO_HANDLER_LOST, "Connection lost while executing command on: " + commandInformation.G()));
            }
        });
    }

    public FlowControlQueues<WrappedCommand> getCommandQueues() {
        CommandDispatcher a2;
        return a2.m;
    }

    private /* synthetic */ void g(DefaultExecutionContext a2, Consumer a3, SerializedCommandResponse a4) {
        CommandDispatcher a5;
        a5.g(a2, a4, a3);
    }

    private /* synthetic */ void g(SerializedCommand a2, CommandHandler a3, Consumer<SerializedCommandResponse> a4, ErrorCode a52, String a6) {
        block4: {
            CommandDispatcher a7;
            if (a3 == null) {
                CommandDispatcher commandDispatcher = a7;
                commandDispatcher.f.warn(HttpStreamingQuery.g((Object)"g\u0003\t$H\u0002M\u0000L\u001e\t\nF\u001e\t\u000fF\u0001D\rG\b\u0013LR\u0011"), (Object)a2.getName());
                a4.accept(commandDispatcher.g(a2.getMessageIdentifier(), a52, a6));
                return;
            }
            try {
                CommandDispatcher commandDispatcher = a7;
                commandDispatcher.f.debug(SnapshotDataProviders.g((Object)"brUkGoEs\u0006`[;Rt\u001c;]f"), (Object)a2.getName(), (Object)a3.g());
                a52 = new CommandInformation(a2.getName(), a2.getMessageIdentifier(), a2.wrapped().getClientId(), a3, a4);
                if (commandDispatcher.H.putIfAbsent((Object)a2.getMessageIdentifier(), (Object)a52) == null) break block4;
                Object[] objectArray = new Object[1];
                objectArray[0] = a2.getMessageIdentifier();
                a4.accept(a7.g(a2.getMessageIdentifier(), ErrorCode.COMMAND_DUPLICATED, String.format(HttpStreamingQuery.g((Object)"J\u0003D\u0001H\u0002ML@\b\tIZLM\u0019Y\u0000@\u000fH\u0018L\b"), objectArray)));
                return;
            }
            catch (MessagingPlatformException a52) {
                a7.H.remove((Object)a2.getMessageIdentifier());
                a4.accept(a7.g(a2.getMessageIdentifier(), a52.getErrorCode(), a52.getMessage()));
                return;
            }
        }
        a3.g(a2);
    }

    public void dispatchProxied(String a2, SerializedCommand a3, Consumer<SerializedCommandResponse> a4) {
        CommandDispatcher a5;
        String string = a3.getClientStreamId();
        a2 = new ClientStreamIdentification(a2, string);
        CommandDispatcher commandDispatcher = a5;
        a2 = commandDispatcher.j.findByClientAndCommand((ClientStreamIdentification)a2, a3.getCommand());
        Object[] objectArray = new Object[2];
        objectArray[0] = string;
        objectArray[1] = a3.getCommand();
        commandDispatcher.g(a3, (CommandHandler)a2, a4, ErrorCode.CLIENT_DISCONNECTED, String.format(SnapshotDataProviders.g((Object)"ewO~Ho\u0006>U;HtR;@tSuB;QsOwC;ViIxChUrH|\u001c;\u0003h"), objectArray));
    }

    public CommandDispatcher(CommandRegistrationCache registrations, NonReplacingConstraintCache<String, CommandInformation> commandCache, CommandMetricsRegistry metricRegistry, MeterFactory meterFactory, CommandInterceptors commandInterceptors, ClientIdRegistry clientIdRegistry, @Value(value="${axoniq.axonserver.command-queue-capacity-per-client:10000}") int a2) {
        CommandDispatcher commandDispatcher = this;
        CommandDispatcher commandDispatcher2 = this;
        this.f = LoggerFactory.getLogger(CommandDispatcher.class);
        CommandDispatcher commandDispatcher3 = this;
        this.c = new ConcurrentHashMap();
        CommandDispatcher commandDispatcher4 = this;
        commandDispatcher3.I = new ConcurrentHashMap();
        commandDispatcher2.j = registrations;
        commandDispatcher2.H = commandCache;
        commandDispatcher.b = metricRegistry;
        commandDispatcher.h = commandInterceptors;
        registrations = new DispatchQueueMetrics(meterFactory, (MetricName)BaseMetricName.C, (MetricName)BaseMetricName.j, clientIdRegistry);
        CommandDispatcher commandDispatcher5 = this;
        commandDispatcher.m = new FlowControlQueues(Comparator.comparing(WrappedCommand::g).reversed(), a2, (QueueMetrics)registrations, ErrorCode.TOO_MANY_REQUESTS);
        metricRegistry.gauge((MetricName)BaseMetricName.V, commandCache, ConstraintCache::size);
    }
}

