/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.message.event;

import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.event.Event;
import io.axoniq.axonserver.grpc.event.GetAggregateEventsRequest;
import io.axoniq.axonserver.grpc.event.GetAggregateSnapshotsRequest;
import io.axoniq.axonserver.grpc.event.GetEventsRequest;
import io.axoniq.axonserver.grpc.event.QueryEventsRequest;
import io.axoniq.axonserver.grpc.event.QueryEventsResponse;
import io.axoniq.axonserver.localstorage.SerializedEvent;
import io.axoniq.axonserver.localstorage.SerializedEventWithToken;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.message.event.EventStore;
import io.axoniq.axonserver.message.event.H;
import io.axoniq.axonserver.message.event.SequenceValidationStrategy;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.rest.svg.jsfunction.ShowDetail;
import io.axoniq.axonserver.taskscheduler.task.NodeContext;
import io.axoniq.axonserver.topology.EventStoreLocator;
import io.micrometer.core.instrument.Tags;
import java.security.Principal;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;
import reactor.util.retry.RetryBackoffSpec;

@Component
public class EventDispatcher {
    private final Map<ClientStreamIdentification, List<H>> D;
    private final Map<String, AtomicInteger> J;
    private final MeterFactory g;
    private final boolean K;
    @Value(value="${axoniq.axonserver.read-sequence-validation-strategy:LOG}")
    private SequenceValidationStrategy A;
    private final Map<String, AtomicInteger> C;
    private final Map<String, AtomicInteger> l;
    static final String F = "{}:  Error on connection from event store: {}";
    private final Map<String, MeterFactory.RateMeter> E;
    private final int i;
    private final Map<String, MeterFactory.RateMeter> G;
    private final RetryBackoffSpec f;
    private final Map<String, MeterFactory.RateMeter> c;
    private final Logger j;
    private final long H;
    private final EventStoreLocator m;
    private final Map<String, MeterFactory.RateMeter> h;
    private final Map<String, AtomicInteger> b;
    private static final Logger I = AuditLog.getLogger();

    public EventDispatcher(EventStoreLocator eventStoreLocator, MeterFactory meterFactory, @Value(value="${axoniq.axonserver.event.aggregate.retry.attempts:3}") int maxRetryAttempts, @Value(value="${axoniq.axonserver.event.aggregate.retry.delay:100}") long retryDelayMillis, @Value(value="${axoniq.axonserver.event.aggregate.prefetch:5}") int aggregateEventsPrefetch, @Value(value="${axoniq.axonserver.event.aggregate.timeout:30000}") long a2, @Value(value="${axoniq.axonserver.legacy-metrics-enabled:true}") boolean a3) {
        EventDispatcher eventDispatcher = this;
        EventDispatcher eventDispatcher2 = this;
        EventDispatcher eventDispatcher3 = this;
        EventDispatcher eventDispatcher4 = this;
        this.j = LoggerFactory.getLogger(EventDispatcher.class);
        EventDispatcher eventDispatcher5 = this;
        eventDispatcher4.D = new ConcurrentHashMap();
        EventDispatcher eventDispatcher6 = this;
        eventDispatcher5.E = new ConcurrentHashMap();
        EventDispatcher eventDispatcher7 = this;
        eventDispatcher4.G = new ConcurrentHashMap();
        EventDispatcher eventDispatcher8 = this;
        eventDispatcher4.h = new ConcurrentHashMap();
        EventDispatcher eventDispatcher9 = this;
        eventDispatcher4.c = new ConcurrentHashMap();
        eventDispatcher4.A = SequenceValidationStrategy.h;
        EventDispatcher eventDispatcher10 = this;
        eventDispatcher4.C = new ConcurrentHashMap();
        EventDispatcher eventDispatcher11 = this;
        eventDispatcher4.b = new ConcurrentHashMap();
        EventDispatcher eventDispatcher12 = this;
        eventDispatcher4.l = new ConcurrentHashMap();
        EventDispatcher eventDispatcher13 = this;
        eventDispatcher4.J = new ConcurrentHashMap();
        eventDispatcher3.m = eventStoreLocator;
        eventDispatcher3.g = meterFactory;
        eventDispatcher2.K = a3;
        eventDispatcher2.f = Retry.backoff((long)maxRetryAttempts, (Duration)Duration.ofMillis(retryDelayMillis));
        eventDispatcher.i = aggregateEventsPrefetch;
        eventDispatcher.H = a2;
    }

    public Flux<SerializedEvent> aggregateEvents(String a2, Authentication a3, GetAggregateEventsRequest a4) {
        EventDispatcher a5;
        if (I.isDebugEnabled()) {
            Object[] objectArray = new Object[3];
            objectArray[0] = AuditLog.username((Principal)a3);
            objectArray[1] = a2;
            objectArray[2] = a4.getAggregateId();
            I.debug(NodeContext.g((Object)"-d\u000b_\rb+?$z\u0007j\u0013l\u0002?\u0002pVs\u001fl\u0002?\u0013i\u0013q\u0002lVy\u0019mVd\u000b1"), objectArray);
        }
        long l2 = System.currentTimeMillis();
        return a5.m.eventStore(a2).flatMapMany(a9 -> {
            EventDispatcher a10;
            String string = ShowDetail.g((Object)"\rU\u001eK\u0001^\rY\u0017[");
            string = Tags.of((String)"context", (String)a2);
            return Flux.deferContextual(a6 -> {
                EventDispatcher a7;
                a6 = (AtomicLong)a6.get((Object)ShowDetail.g((Object)"\rU\u001eK\u0001^\rY\u0017["));
                boolean bl = a4.getAllowSnapshots() && ((AtomicLong)a6).get() == -1L;
                GetAggregateEventsRequest getAggregateEventsRequest = a4.toBuilder().setAllowSnapshots(bl).setInitialSequence(((AtomicLong)a6).get() + 1L).build();
                a7.j.debug(NodeContext.g((Object)"M\u0013~\u0012v\u0018xVz\u0000z\u0018k\u0005?\u0010m\u0019rVl\u0013nUd\u000b?\u0010p\u0004?\u0017x\u0011m\u0013x\u0017k\u0013?\rb"), (Object)(((AtomicLong)a6).get() + 1L), (Object)a4.getAggregateId());
                return a9.aggregateEvents(a2, a3, getAggregateEventsRequest);
            }).doFirst(() -> a10.g(a2, (Tags)string)).limitRate(a10.i * 5, a10.i).doOnEach(a2 -> {
                if (a2.hasValue()) {
                    ((AtomicLong)a2.getContextView().get((Object)ShowDetail.g((Object)"\rU\u001eK\u0001^\rY\u0017["))).set(((SerializedEvent)a2.get()).f());
                }
            }).timeout(Duration.ofMillis(a10.H)).onErrorMap(TimeoutException.class, a2 -> {
                EventDispatcher a3;
                return new MessagingPlatformException(ErrorCode.LIST_AGGREGATE_EVENTS_TIMEOUT, "Timeout exception: No events were emitted from event store in last " + a3.H + "ms. Check the logs for virtual machine errors like OutOfMemoryError.");
            }).retryWhen((Retry)a10.f.doBeforeRetry(a3 -> {
                EventDispatcher a4;
                Object[] objectArray = new Object[3];
                objectArray[0] = a3.failure().getClass().getName();
                objectArray[1] = a3.failure().getMessage();
                objectArray[2] = a4.getAggregateId();
                a4.j.warn(NodeContext.g((Object)"$z\u0002m\u000fv\u0018xVk\u0019?\u0004z\u0017{Vz\u0000z\u0018k\u0005?\u0017x\u0011m\u0013x\u0017k\u0013?\u0005k\u0004z\u0017rV{\u0003zVk\u0019?\rbLd\u000b3Vy\u0019mV~\u0011x\u0004z\u0011~\u0002zL?\rb"), objectArray);
            })).onErrorMap(a2 -> {
                if (Exceptions.isRetryExhausted((Throwable)a2)) {
                    return a2.getCause();
                }
                return a2;
            }).doOnError(a3 -> {
                EventDispatcher a4;
                EventDispatcher eventDispatcher = a4;
                eventDispatcher.j.error(ShowDetail.g((Object)"O x=xrn'x;d5* o3n;d5*3m5x7m3~7*7|7d&y|*"), a3);
                String[] stringArray = new String[4];
                stringArray[0] = "context";
                stringArray[1] = a2;
                stringArray[2] = "error";
                stringArray[3] = ErrorCode.fromException((Throwable)a3).getCode();
                eventDispatcher.g.counter((MetricName)BaseMetricName.I, Tags.of((String[])stringArray)).increment();
            }).doOnNext(a3 -> {
                EventDispatcher a4;
                a4.j.trace(NodeContext.g((Object)"z\u0000z\u0018kVd\u000b?\u0010p\u0004?\u0017x\u0011m\u0013x\u0017k\u0013?\rb"), a3, (Object)a4.getAggregateId());
            }).doOnComplete(() -> a10.K((Tags)string, l2)).doOnTerminate(() -> {
                EventDispatcher a3;
                ((AtomicInteger)a3.l.get(a2)).decrementAndGet();
            }).contextWrite(a3 -> a3.put((Object)NodeContext.g((Object)")@:^%K)L3N"), (Object)new AtomicLong(a4.getInitialSequence() - 1L))).name(NodeContext.g((Object)"\u0013i\u0013q\u0002@\u0005k\u0004z\u0017r")).tag("context", a2).tag("stream", ShowDetail.g((Object)"3m5x7m3~7U7|7d&y")).tag("origin", NodeContext.g((Object)"\u0015s\u001fz\u0018k)m\u0013n\u0003z\u0005k")).metrics();
        }).onErrorResume(Flux::error);
    }

    public Map<String, Iterable<Long>> eventTrackerStatus(String a2) {
        EventDispatcher a3;
        HashMap<String, Iterable<Long>> hashMap = new HashMap<String, Iterable<Long>>();
        a3.D.forEach((a4, a5) -> {
            if (a4.g().equals(a2)) {
                a5 = a5.stream().map(H::g).collect(Collectors.toList());
                hashMap.put(a4.toString(), (Iterable<Long>)a5);
            }
        });
        return hashMap;
    }

    public MeterFactory.RateMeter eventRate(String a2) {
        EventDispatcher a3;
        EventDispatcher eventDispatcher = a3;
        return eventDispatcher.g(a2, eventDispatcher.E, BaseMetricName.a, BaseMetricName.Ba);
    }

    public Mono<Void> appendSnapshot(String a2, Event a3, Authentication a4) {
        EventDispatcher a5;
        if (I.isDebugEnabled()) {
            Object[] objectArray = new Object[3];
            objectArray[0] = AuditLog.username((Principal)a4);
            objectArray[1] = a2;
            objectArray[2] = a3.getAggregateIdentifier();
            I.debug(ShowDetail.g((Object)"\tq/J)w\u000f*\u0000o#\u007f7y&*&erf;y&*7|7d&yrl=xrq/$"), objectArray);
        }
        long l2 = System.currentTimeMillis();
        return a5.m.eventStore(a2).flatMap(a8 -> {
            EventDispatcher a9;
            return a8.appendSnapshot(a2, a3, a4).doFirst(() -> {
                EventDispatcher a4;
                AtomicInteger atomicInteger = a4.b.computeIfAbsent(a2, a2 -> new AtomicInteger());
                atomicInteger.incrementAndGet();
                a4.g.gauge((MetricName)BaseMetricName.ha, Tags.of((String)"context", (String)a2), atomicInteger::get);
            }).doOnSuccess(a4 -> {
                EventDispatcher a5;
                EventDispatcher eventDispatcher = a5;
                eventDispatcher.g(a2, eventDispatcher.G, BaseMetricName.m, BaseMetricName.ca).g();
                eventDispatcher.g.timer((MetricName)BaseMetricName.B, Tags.of((String)"context", (String)a2)).record(System.currentTimeMillis() - l2, TimeUnit.MILLISECONDS);
            }).doOnError(a3 -> {
                EventDispatcher a4;
                EventDispatcher eventDispatcher = a4;
                eventDispatcher.j.warn(F, (Object)ShowDetail.g((Object)"3z\"o<n\u0001d3z!b=~"), (Object)a3.getMessage());
                String[] stringArray = new String[4];
                stringArray[0] = "context";
                stringArray[1] = a2;
                stringArray[2] = "error";
                stringArray[3] = ErrorCode.fromException((Throwable)a3).getCode();
                eventDispatcher.g.counter((MetricName)BaseMetricName.T, Tags.of((String[])stringArray)).increment();
            }).doOnTerminate(() -> {
                EventDispatcher a3;
                ((AtomicInteger)a3.b.get(a2)).decrementAndGet();
            });
        });
    }

    public void deleteMetrics(String a2) {
        EventDispatcher a3;
        MeterFactory.RateMeter rateMeter = (MeterFactory.RateMeter)a3.E.remove(a2);
        if (rateMeter != null) {
            rateMeter.K();
        }
        if ((rateMeter = (MeterFactory.RateMeter)a3.G.remove(a2)) != null) {
            rateMeter.K();
        }
        if ((rateMeter = (MeterFactory.RateMeter)a3.h.remove(a2)) != null) {
            rateMeter.K();
        }
        if ((rateMeter = (MeterFactory.RateMeter)a3.c.remove(a2)) != null) {
            rateMeter.K();
        }
        EventDispatcher eventDispatcher = a3;
        eventDispatcher.g.remove((MetricName)BaseMetricName.P, "context", a2);
        eventDispatcher.g.remove((MetricName)BaseMetricName.D, "context", a2);
        eventDispatcher.g.remove((MetricName)BaseMetricName.B, "context", a2);
        eventDispatcher.g.remove((MetricName)BaseMetricName.T, "context", a2);
        eventDispatcher.g.remove((MetricName)BaseMetricName.I, "context", a2);
        eventDispatcher.g.remove((MetricName)BaseMetricName.r, "context", a2);
        eventDispatcher.g.remove((MetricName)BaseMetricName.R, "context", a2);
        eventDispatcher.g.remove((MetricName)BaseMetricName.ua, "context", a2);
        eventDispatcher.g.remove((MetricName)BaseMetricName.u, "context", a2);
        eventDispatcher.g.remove((MetricName)BaseMetricName.ha, "context", a2);
        eventDispatcher.g.remove((MetricName)BaseMetricName.M, "context", a2);
        eventDispatcher.g.remove((MetricName)BaseMetricName.e, "context", a2);
        eventDispatcher.J.remove(a2);
        a3.l.remove(a2);
        a3.b.remove(a2);
        a3.C.remove(a2);
    }

    public Mono<Long> highestSequenceNumber(String a2, String a3) {
        EventDispatcher a5;
        return a5.m.eventStore(a2).flatMap(a4 -> a4.highestSequenceNumber(a2, a3));
    }

    public Mono<Long> lastEventToken(String a2) {
        EventDispatcher a4;
        return a4.m.eventStore(a2).flatMap(a3 -> a3.lastEventToken(a2));
    }

    public Mono<Void> appendEvent(String a2, Authentication a3, Flux<SerializedEvent> a4) {
        EventDispatcher a5;
        if (I.isDebugEnabled()) {
            I.debug(ShowDetail.g((Object)"Q)w\u0012q/WrX7{'o!~r~=*3z\"o<nro$o<~!$"), (Object)AuditLog.username((Principal)a3), (Object)a2);
        }
        long l2 = System.currentTimeMillis();
        return a5.m.eventStore(a2).flatMap(a8 -> {
            EventDispatcher a9;
            a4 = a4.doOnNext(a3 -> {
                EventDispatcher a4;
                EventDispatcher eventDispatcher = a4;
                eventDispatcher.g(a2, eventDispatcher.E, BaseMetricName.a, BaseMetricName.Ba).g();
            });
            return a8.appendEvents(a2, a4, a3).doFirst(() -> {
                EventDispatcher a4;
                AtomicInteger atomicInteger = a4.C.computeIfAbsent(a2, a2 -> new AtomicInteger());
                atomicInteger.incrementAndGet();
                a4.g.gauge((MetricName)BaseMetricName.u, Tags.of((String)"context", (String)a2), atomicInteger::get);
            }).doOnSuccess(a4 -> {
                EventDispatcher a5;
                a5.g.timer((MetricName)BaseMetricName.P, Tags.of((String)"context", (String)a2)).record(System.currentTimeMillis() - l2, TimeUnit.MILLISECONDS);
            }).doOnError(a3 -> {
                EventDispatcher a4;
                String[] stringArray = new String[4];
                stringArray[0] = "context";
                stringArray[1] = a2;
                stringArray[2] = "error";
                stringArray[3] = ErrorCode.fromException((Throwable)a3).getCode();
                a4.g.counter((MetricName)BaseMetricName.D, Tags.of((String[])stringArray)).increment();
            }).doOnTerminate(() -> {
                EventDispatcher a3;
                ((AtomicInteger)a3.C.get(a2)).decrementAndGet();
            });
        });
    }

    private /* synthetic */ void K(Tags a2, long a3) {
        EventDispatcher a4;
        a4.g.timer((MetricName)BaseMetricName.r, a2).record(System.currentTimeMillis() - a3, TimeUnit.MILLISECONDS);
    }

    public Mono<Long> eventTokenAt(String a2, Instant a3) {
        EventDispatcher a5;
        return a5.m.eventStore(a2, false).flatMap(a4 -> a4.eventTokenAt(a2, a3));
    }

    public long getNrOfEvents(String a2) {
        EventDispatcher a3;
        if ((a2 = (Long)a3.m.eventStore((String)a2).flatMap(arg_0 -> EventDispatcher.g((String)a2, arg_0)).switchIfEmpty(Mono.just((Object)-1L)).block()) != null) {
            return (Long)a2;
        }
        return -1L;
    }

    public Flux<QueryEventsResponse> queryEvents(String a2, Authentication a3, Flux<QueryEventsRequest> a5) {
        EventDispatcher a7;
        return a5.switchOnFirst((a4, a6) -> {
            if (a4.isOnNext()) {
                EventDispatcher a7;
                QueryEventsRequest queryEventsRequest = (QueryEventsRequest)a4.get();
                return a7.m.eventStore(a2, queryEventsRequest.getForceReadFromLeader()).flatMapMany(a5 -> a5.queryEvents(a2, a6, a3));
            }
            if (a4.isOnError()) {
                return Flux.error((Throwable)a4.getThrowable());
            }
            return Flux.empty();
        });
    }

    private static /* synthetic */ Mono g(String a2, EventStore a3) {
        return a3.lastEventToken(a2);
    }

    private /* synthetic */ void g(String a4, Tags a5) {
        EventDispatcher a6;
        AtomicInteger atomicInteger = a6.l.computeIfAbsent(a4, a2 -> new AtomicInteger());
        atomicInteger.incrementAndGet();
        a6.g.gauge((MetricName)BaseMetricName.M, a5, atomicInteger::get);
        a6.h.computeIfAbsent(a4, a3 -> {
            EventDispatcher a4;
            return a4.g.rateMeter((MetricName)BaseMetricName.Ca, a5);
        }).g();
    }

    private /* synthetic */ MeterFactory.RateMeter g(String a2, Map<String, MeterFactory.RateMeter> a3, BaseMetricName a4, BaseMetricName a6) {
        EventDispatcher a7;
        return a3.computeIfAbsent(a2, a5 -> {
            EventDispatcher a6;
            return a6.g.rateMeter((MetricName)a4, (MetricName)(a6.K ? a6 : null), Tags.of((String)"context", (String)a2));
        });
    }

    public Flux<SerializedEventWithToken> events(String a2, Authentication a3, Flux<GetEventsRequest> a4) {
        EventDispatcher a5;
        return a4.switchOnFirst((a7, a8) -> {
            if (a7.isOnNext()) {
                EventDispatcher a9;
                H h2;
                GetEventsRequest getEventsRequest = (GetEventsRequest)a7.get();
                H h3 = h2 = new H(getEventsRequest.getClientId(), a2, getEventsRequest.getTrackingToken() - 1L);
                ClientStreamIdentification clientStreamIdentification = new ClientStreamIdentification(h3.h, h3.b);
                a9.D.computeIfAbsent(clientStreamIdentification, a2 -> new CopyOnWriteArrayList()).add(h2);
                Object[] objectArray = new Object[3];
                objectArray[0] = getEventsRequest.getClientId();
                objectArray[1] = getEventsRequest.getComponentName();
                objectArray[2] = getEventsRequest.getTrackingToken();
                a9.j.info(NodeContext.g((Object)"%k\u0017m\u0002v\u0018xVk\u0004~\u0015t\u001fq\u0011?\u0013i\u0013q\u0002?\u0006m\u0019|\u0013l\u0005p\u0004?\u0010p\u0004?\rbLd\u000b?[?\rb"), objectArray);
                return a9.m.eventStore(a2, getEventsRequest.getForceReadFromLeader()).flatMapMany(a5 -> a5.events(a2, a3, a8)).doOnNext(a3 -> h2.g()).doFinally(a3 -> {
                    EventDispatcher a4;
                    a4.g(h2);
                });
            }
            if (a7.isOnError()) {
                return Flux.error((Throwable)a7.getThrowable());
            }
            return Flux.empty();
        });
    }

    public Flux<SerializedEvent> aggregateSnapshots(String a2, Authentication a4, GetAggregateSnapshotsRequest a6) {
        EventDispatcher a7;
        long l2 = System.currentTimeMillis();
        Tags tags = Tags.of((String)"context", (String)a2);
        return a7.m.eventStore(a2).flatMapMany(a5 -> a5.aggregateSnapshots(a2, a4, a6)).doFirst(() -> {
            EventDispatcher a6;
            AtomicInteger atomicInteger = a6.J.computeIfAbsent(a2, a2 -> new AtomicInteger());
            atomicInteger.incrementAndGet();
            a6.g.gauge((MetricName)BaseMetricName.e, tags, atomicInteger::get);
            a6.c.computeIfAbsent(a2, a3 -> {
                EventDispatcher a4;
                return a4.g.rateMeter((MetricName)BaseMetricName.c, tags);
            }).g();
        }).doOnError(a3 -> {
            EventDispatcher a4;
            String[] stringArray = new String[4];
            stringArray[0] = "context";
            stringArray[1] = a2;
            stringArray[2] = "error";
            stringArray[3] = ErrorCode.fromException((Throwable)a3).getCode();
            a4.g.counter((MetricName)BaseMetricName.I, Tags.of((String[])stringArray)).increment();
        }).doOnComplete(() -> {
            EventDispatcher a4;
            a4.g.timer((MetricName)BaseMetricName.R, tags).record(System.currentTimeMillis() - l2, TimeUnit.MILLISECONDS);
        }).doOnTerminate(() -> {
            EventDispatcher a3;
            ((AtomicInteger)a3.J.get(a2)).decrementAndGet();
        });
    }

    public Mono<Long> firstEventToken(String a2) {
        EventDispatcher a4;
        return a4.m.eventStore(a2, false).flatMap(a3 -> a3.firstEventToken(a2));
    }

    public MeterFactory.RateMeter snapshotRate(String a2) {
        EventDispatcher a3;
        EventDispatcher eventDispatcher = a3;
        return eventDispatcher.g(a2, eventDispatcher.G, BaseMetricName.m, BaseMetricName.ca);
    }

    private /* synthetic */ void g(@Nonnull H a2) {
        EventDispatcher eventDispatcher = this;
        eventDispatcher.j.info(ShowDetail.g((Object)"X7g=|7nr~ k1a7xrc<l=*)w"), (Object)a2);
        H h2 = a2;
        eventDispatcher.D.computeIfPresent(new ClientStreamIdentification(h2.h, h2.b), (a3, a4) -> {
            EventDispatcher a5;
            List list = a4;
            a5.j.debug(NodeContext.g((Object)"\rbL?\rbVl\u0002m\u0013~\u001bl"), (Object)a2.b, (Object)a4.size());
            list.remove(a2);
            if (list.isEmpty()) {
                return null;
            }
            return a4;
        });
    }
}

