/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.message.query;

import io.axoniq.axonserver.ProcessingInstructionHelper;
import io.axoniq.axonserver.component.processor.ClientsByEventProcessor;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.ErrorMessageFactory;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ClientIdRegistry;
import io.axoniq.axonserver.grpc.SerializedQuery;
import io.axoniq.axonserver.grpc.query.QueryRequest;
import io.axoniq.axonserver.grpc.query.QueryResponse;
import io.axoniq.axonserver.interceptor.DefaultExecutionContext;
import io.axoniq.axonserver.interceptor.QueryInterceptors;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.message.DispatchQueueMetrics;
import io.axoniq.axonserver.message.FlowControlQueues;
import io.axoniq.axonserver.message.QueueMetrics;
import io.axoniq.axonserver.message.command.InsufficientBufferCapacityException;
import io.axoniq.axonserver.message.query.ActiveQuery;
import io.axoniq.axonserver.message.query.QueryDefinition;
import io.axoniq.axonserver.message.query.QueryHandler;
import io.axoniq.axonserver.message.query.QueryInstruction;
import io.axoniq.axonserver.message.query.QueryMetricsRegistry;
import io.axoniq.axonserver.message.query.QueryRegistrationCache;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.plugin.ExecutionContext;
import io.axoniq.axonserver.util.ConstraintCache;
import io.axoniq.axonserver.util.NonReplacingConstraintCache;
import io.axoniq.axonserver.util.ObjectUtils;
import io.axoniq.axonserver.util.StringUtils;
import io.micrometer.core.instrument.Tags;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component(value="QueryDispatcher")
public class QueryDispatcher {
    private final Logger f;
    private final QueryRegistrationCache c;
    private final FlowControlQueues<QueryInstruction> j;
    private final DispatchQueueMetrics H;
    private final QueryMetricsRegistry m;
    private final Map<String, AtomicInteger> h;
    private final QueryInterceptors b;
    private final NonReplacingConstraintCache<String, ActiveQuery> I;

    private /* synthetic */ void g(String a2, ActiveQuery a3) {
        QueryDispatcher a4;
        try {
            a4.f.trace(ClientsByEventProcessor.g((Object)"5f\u0002\u007f\u0010{\u0012g\u0018a\u0016/\u0000z\u0014}\b/\nr_!_"), (Object)a3.g());
            a3.g();
            return;
        }
        catch (MessagingPlatformException messagingPlatformException) {
            QueryDispatcher queryDispatcher = a4;
            queryDispatcher.f.debug(ObjectUtils.g((Object)"I\u001a~\u0007~Hh\u001d~\u0001b\u000f,\fe\u001b|\tx\u000bd\u0001b\u000f,\u0007jH}\u001di\u001auHw\u0015\"HO\tb\u000bi\u0004`\u0001b\u000f,\u001fe\u001cdHi\u001a~\u0007~F"), (Object)a3.g(), (Object)messagingPlatformException);
            a3.g(messagingPlatformException.getErrorCode(), messagingPlatformException.getMessage());
            queryDispatcher.I.remove((Object)a2);
            return;
        }
    }

    public QueryDispatcher(QueryRegistrationCache registrationCache, NonReplacingConstraintCache<String, ActiveQuery> queryCache, QueryMetricsRegistry queryMetricsRegistry, QueryInterceptors queryInterceptors, MeterFactory meterFactory, ClientIdRegistry clientIdRegistry, @Value(value="${axoniq.axonserver.query-queue-capacity-per-client:10000}") int a2) {
        QueryDispatcher queryDispatcher = this;
        QueryDispatcher queryDispatcher2 = this;
        this.f = LoggerFactory.getLogger(QueryDispatcher.class);
        QueryDispatcher queryDispatcher3 = this;
        this.h = new ConcurrentHashMap();
        queryDispatcher2.c = registrationCache;
        queryDispatcher2.m = queryMetricsRegistry;
        queryDispatcher.I = queryCache;
        queryDispatcher.b = queryInterceptors;
        QueryDispatcher queryDispatcher4 = this;
        queryDispatcher.H = new DispatchQueueMetrics(meterFactory, (MetricName)BaseMetricName.X, (MetricName)BaseMetricName.ea, clientIdRegistry);
        QueryDispatcher queryDispatcher5 = this;
        queryDispatcher4.j = new FlowControlQueues(Comparator.comparing(QueryInstruction::g).reversed(), a2, (QueueMetrics)this.H, ErrorCode.TOO_MANY_REQUESTS);
        queryMetricsRegistry.gauge((MetricName)BaseMetricName.l, queryCache, ConstraintCache::size);
    }

    public void handleResponse(QueryResponse a2, String a3, String a4) {
        QueryDispatcher a5;
        String string = a2.getRequestIdentifier();
        if ((string = a5.g(a3, string)) != null) {
            ClientStreamIdentification clientStreamIdentification = new ClientStreamIdentification(string.f(), a3);
            long l2 = System.currentTimeMillis() - string.g();
            if (string.g()) {
                a5.m.addEndToEndResponseTime(string.g(), string.G(), a4, clientStreamIdentification.g(), string.K(), l2);
            }
            if (string.g(a2, a3) && string.K()) {
                string.g(a3);
                return;
            }
        } else {
            a5.f.debug(ClientsByEventProcessor.g((Object)"A\u001e/Yb\u001e}\u0014&Qf\u001fi\u001e}\u001cn\u0005f\u001eaQi\u001e}Qt\f"), (Object)a2.getRequestIdentifier());
        }
    }

    private /* synthetic */ void g(DefaultExecutionContext a2, QueryResponse a3, Consumer<QueryResponse> a4) {
        QueryDispatcher a5;
        try {
            a4.accept(a5.b.queryResponse(a3, (ExecutionContext)a2));
            return;
        }
        catch (Exception exception) {
            a5.f.warn(ObjectUtils.g((Object)"\u0013qR,-t\u000bi\u0018x\u0001c\u0006,\u0001bH~\r\u007f\u0018c\u0006\u007f\r,\u0001b\u001ci\u001ao\r|\u001cc\u001a"), (Object)a2.contextName(), (Object)exception);
            Exception exception2 = exception;
            a4.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.EXCEPTION_IN_INTERCEPTOR.getCode()).setRequestIdentifier(a3.getRequestIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.g((String)exception2.getMessage())).build());
            a2.compensate((Throwable)exception2);
            return;
        }
    }

    private /* synthetic */ void g(String a2, String a3, String a4, Consumer<QueryHandler> a5) {
        QueryDispatcher a6;
        a2 = new QueryDefinition(a2, a3);
        if ((a2 = a6.c.find((QueryDefinition)a2, a4)) != null) {
            a5.accept((QueryHandler)a2);
        }
    }

    private /* synthetic */ void g(DefaultExecutionContext a2, Consumer a3, QueryResponse a4) {
        QueryDispatcher a5;
        a5.g(a2, a4, a3);
    }

    public void completeWithError(String a2, String a3, ErrorCode a4, String a5) {
        QueryDispatcher a6;
        Object[] objectArray = new Object[4];
        objectArray[0] = a3;
        objectArray[1] = a2;
        objectArray[2] = a4.getCode();
        objectArray[3] = a5;
        a6.f.debug(ClientsByEventProcessor.g((Object)"2`\u001c\u007f\u001dj\u0005f\u001fhQx\u0018{\u0019/\u0014}\u0003`\u0003/\u0005g\u0014/\u0012`\u001cb\u0004a\u0018l\u0010{\u0018`\u001f/\u0006f\u0005gQnQ|\u0001j\u0012f\u0017f\u0012/\u0019n\u001fk\u001dj\u0003/*l\u001df\u0014a\u0005\\\u0005}\u0014n\u001cF\u00152\nr,#Qi\u001e}Q{\u0019jQ~\u0004j\u0003vQT\u0018kLt\fR_/4}\u0003`\u0003/\u0012`\u0015jK/\nr_/4}\u0003`\u0003B\u0014|\u0002n\u0016jK/\nr_"), objectArray);
        ActiveQuery activeQuery = (ActiveQuery)a6.I.get((Object)a2);
        if (activeQuery != null && activeQuery.g(a3, a4, a5)) {
            a6.I.remove((Object)a2);
        }
    }

    private /* synthetic */ String g(String a2, String a3) {
        return a2 + "/" + a3;
    }

    public void flowControlProxied(String a2, String a3, long a4, String a6, String a7) {
        QueryDispatcher a8;
        a8.g(a6, a3, a7, a5 -> {
            QueryDispatcher a6;
            a6.K(a5, a2, a3, a4);
        });
    }

    private /* synthetic */ void g(String a2, String a3, Runnable a42) {
        try {
            a42.run();
            return;
        }
        catch (MessagingPlatformException a42) {
            QueryDispatcher a5;
            QueryDispatcher queryDispatcher = a5;
            queryDispatcher.f.debug(ObjectUtils.g((Object)"I\u001a~\u0007~Hh\u0001\u007f\u0018m\u001co\u0000e\u0006kHj\u0004c\u001f,\u0019y\r~\u0011,\u0001b\u001bx\u001ay\u000bx\u0001c\u0006,\u001ccHx\t~\u000fi\u001c,\u000b`\u0001i\u0006xHw\u0015"), (Object)a3);
            queryDispatcher.completeWithError(a2, a3, a42.getErrorCode(), a42.getMessage());
            return;
        }
    }

    private /* synthetic */ boolean g(QueryResponse a2) {
        if (ErrorCode.NO_HANDLER_FOR_QUERY.getCode().equals(a2.getErrorCode()) || ErrorCode.TOO_MANY_REQUESTS.getCode().equals(a2.getErrorCode()) || ErrorCode.OTHER.getCode().equals(a2.getErrorCode()) || ErrorCode.QUERY_REJECTED_BY_INTERCEPTOR.getCode().equals(a2.getErrorCode()) || ErrorCode.QUERY_TIMEOUT.getCode().equals(a2.getErrorCode()) || ErrorCode.CONNECTION_TO_HANDLER_LOST.getCode().equals(a2.getErrorCode()) || ErrorCode.QUERY_DUPLICATED.getCode().equals(a2.getErrorCode())) {
            return true;
        }
        return false;
    }

    public void query(SerializedQuery a3, Authentication a6, Consumer<QueryResponse> a7, Consumer<String> a8) {
        QueryDispatcher a9;
        String string = a3.context();
        a7 = a5 -> {
            QueryDispatcher a6;
            QueryResponse queryResponse = a5;
            a7.accept(queryResponse);
            if (a6.g(queryResponse)) {
                a6.m.error(a3.query().getQuery(), string, a5.getErrorCode());
            }
        };
        a8 = a4 -> {
            QueryDispatcher a5;
            a8.accept((String)a4);
            ((AtomicInteger)a5.h.get(string)).decrementAndGet();
        };
        QueryDispatcher queryDispatcher = a9;
        queryDispatcher.queryRate(string).g();
        queryDispatcher.h.computeIfAbsent(string, a2 -> {
            QueryDispatcher a3;
            AtomicInteger atomicInteger = new AtomicInteger();
            a3.m.gauge((MetricName)BaseMetricName.Y, Tags.of((String)"context", (String)a2), atomicInteger::get);
            return atomicInteger;
        }).incrementAndGet();
        a9.g(a3, string, a6, a7, a8);
    }

    private /* synthetic */ boolean g(QueryRequest a2) {
        return ProcessingInstructionHelper.g((List)a2.getProcessingInstructionsList());
    }

    private /* synthetic */ void K(QueryHandler a2, String a3, String a4, long a5) {
        QueryDispatcher a6;
        String string = a3;
        a6.g(string, a2.K(), () -> a2.g(string, a4, a5));
    }

    private /* synthetic */ void g(ActiveQuery a2, long a3, QueryHandler a4) {
        QueryDispatcher a5;
        a5.K(a4, a2.g(), a2.K(), a3);
    }

    public void deleteMetrics(String a2) {
        QueryDispatcher a3;
        a3.h.remove(a2);
        QueryDispatcher queryDispatcher = a3;
        queryDispatcher.m.remove((MetricName)BaseMetricName.Y, a2);
        queryDispatcher.m.removeForContext(a2);
    }

    public void cancel(String a2) {
        QueryDispatcher a3;
        if ((a2 = (ActiveQuery)a3.I.remove((Object)a2)) != null) {
            a2.K();
        }
    }

    public void cancelProxied(String a2, String a3) {
        QueryDispatcher a4;
        QueryDispatcher queryDispatcher = a4;
        queryDispatcher.cancel(queryDispatcher.g(a2, a3));
    }

    public void handleComplete(String a2, String a3, String a4) {
        QueryDispatcher a5;
        ActiveQuery activeQuery = a5.g(a3, a2);
        if (activeQuery != null) {
            if (activeQuery.K(a3)) {
                a5.I.remove((Object)activeQuery.g());
            }
            long l2 = System.currentTimeMillis() - activeQuery.g();
            if (activeQuery.g()) {
                a5.m.addHandlerResponseTime(activeQuery.g(), activeQuery.G(), a4, activeQuery.f(), l2);
                return;
            }
        } else {
            a5.f.debug(ClientsByEventProcessor.g((Object)"?`Q'\u001c`\u0003jX/\u0018a\u0017`\u0003b\u0010{\u0018`\u001f/\u0017`\u0003/\nrQ`\u001f/\u0012`\u001c\u007f\u001dj\u0005j\u0015"), (Object)a2);
        }
    }

    public MeterFactory.RateMeter queryRate(String a2) {
        QueryDispatcher a3;
        return a3.m.rateMeter(a2);
    }

    public void dispatchProxied(SerializedQuery a2, Consumer<QueryResponse> a3, Consumer<String> a4) {
        QueryDispatcher a5;
        a5.dispatchProxied(a2, a3, a4, true);
    }

    public FlowControlQueues<QueryInstruction> getQueryQueue() {
        QueryDispatcher a2;
        return a2.j;
    }

    private /* synthetic */ void g(SerializedQuery a2, String a3, Authentication a4, Consumer<QueryResponse> a5, Consumer<String> a6) {
        Set set;
        QueryRequest queryRequest;
        QueryDispatcher a7;
        block5: {
            SerializedQuery serializedQuery;
            Consumer<QueryResponse> consumer;
            block4: {
                a4 = new DefaultExecutionContext(a3, a4);
                consumer = arg_0 -> a7.g((DefaultExecutionContext)a4, a5, arg_0);
                try {
                    QueryDispatcher queryDispatcher = a7;
                    serializedQuery = queryDispatcher.b.queryRequest(a2, (ExecutionContext)a4);
                    queryRequest = serializedQuery.query();
                    set = queryDispatcher.c.find(a3, queryRequest);
                    if (!set.isEmpty()) break block4;
                    consumer.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.NO_HANDLER_FOR_QUERY.getCode()).setRequestIdentifier(queryRequest.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.g((String)("No handler for query: " + queryRequest.getQuery()))).build());
                    a6.accept(ObjectUtils.g((Object)"B\u0007O\u0004e\rb\u001c"));
                    return;
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = a3;
                    objectArray[1] = a2.query().getQuery();
                    objectArray[2] = exception;
                    a7.f.warn(ClientsByEventProcessor.g((Object)"\nrK/\u0017n\u0018c\u0014kQ{\u001e/\u0015f\u0002\u007f\u0010{\u0012gQ~\u0004j\u0003vQt\f"), objectArray);
                    queryRequest = ErrorCode.fromException((Throwable)exception);
                    consumer.accept(QueryResponse.newBuilder().setErrorCode(queryRequest.getCode()).setRequestIdentifier(a2.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.g((String)StringUtils.getOrDefault((String)queryRequest.getCode(), (String)exception.getClass().getName()))).build());
                    a6.accept(ObjectUtils.g((Object)"J\te\u0004i\f"));
                    a4.compensate((Throwable)exception);
                    return;
                }
            }
            set = new ActiveQuery(queryRequest.getMessageIdentifier(), serializedQuery, true, consumer, a6, set, a7.g(queryRequest));
            if (a7.I.putIfAbsent((Object)queryRequest.getMessageIdentifier(), (Object)set) == null) break block5;
            a5.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.QUERY_DUPLICATED.getCode()).setRequestIdentifier(a2.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.g((String)ClientsByEventProcessor.g((Object)"^\u0004j\u0003vQx\u0018{\u0019/\u0002z\u0001\u007f\u001df\u0014kQF5/\u0010c\u0003j\u0010k\b/\u0001}\u0014|\u0014a\u0005"))).build());
            a6.accept(ObjectUtils.g((Object)",y\u0018`\u0001o\tx\rE\f"));
            return;
        }
        a7.g(queryRequest.getMessageIdentifier(), (ActiveQuery)set);
    }

    private /* synthetic */ ActiveQuery g(String a2, String a3) {
        QueryDispatcher a4;
        ActiveQuery activeQuery = (ActiveQuery)a4.I.get(a3);
        if (activeQuery == null) {
            a3 = (String)a3 + "/" + a2;
            activeQuery = (ActiveQuery)a4.I.get(a3);
        }
        return activeQuery;
    }

    public void flowControl(String a2, long a3) {
        QueryDispatcher a4;
        if ((a2 = (ActiveQuery)a4.I.get((Object)a2)) != null) {
            a2.g().forEach(arg_0 -> a4.g((ActiveQuery)a2, a3, arg_0));
        }
    }

    public void dispatchProxied(SerializedQuery a22, Consumer<QueryResponse> a3, Consumer<String> a4, boolean a52) {
        QueryDispatcher a6;
        SerializedQuery serializedQuery = a22;
        QueryRequest queryRequest = serializedQuery.query();
        String string = serializedQuery.context();
        String string2 = serializedQuery.clientStreamId();
        if ((string = a6.c.find(string, queryRequest, string2)) == null) {
            Object[] objectArray = new Object[2];
            objectArray[0] = string2;
            objectArray[1] = queryRequest.getQuery();
            a3.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.CLIENT_DISCONNECTED.getCode()).setRequestIdentifier(queryRequest.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.g((String)String.format(ClientsByEventProcessor.g((Object)"L\u001df\u0014a\u0005/T|Qa\u001e{Qi\u001ez\u001fkQx\u0019f\u001djQ\u007f\u0003`\u0012j\u0002|\u0018a\u00165Q*\u0002"), objectArray))).build());
            a4.accept(string2);
            return;
        }
        string2 = a6.g(queryRequest.getMessageIdentifier(), a22.clientStreamId());
        ActiveQuery a52 = new ActiveQuery(string2, a22, false, a3, a4, Collections.singleton(string), a52 && a6.g(queryRequest));
        try {
            if (a6.I.putIfAbsent((Object)string2, (Object)a52) != null) {
                a3.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.QUERY_DUPLICATED.getCode()).setRequestIdentifier(a22.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.g((String)ObjectUtils.g((Object)"]\u001di\u001auH{\u0001x\u0000,\u001by\u0018|\u0004e\rhHE,,\t`\u001ai\th\u0011,\u0018~\r\u007f\rb\u001c"))).build());
                a4.accept(ClientsByEventProcessor.g((Object)"5z\u0001c\u0018l\u0010{\u0014F\u0015"));
                return;
            }
            a6.g(string2, a52);
            return;
        }
        catch (InsufficientBufferCapacityException a22) {
            a52.g(string.K(), ErrorCode.QUERY_DISPATCH_ERROR, a22.getMessage());
            return;
        }
    }
}

