/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.plugin;

import io.axoniq.axonserver.admin.replicationgroup.requestprocessor.UpdateReplicationGroupPayload;
import io.axoniq.axonserver.configuration.admin.AdminConfigurationFactory;
import io.axoniq.axonserver.configuration.admin.AdminContextPluginStatus;
import io.axoniq.axonserver.configuration.admin.AdminContextPlugins;
import io.axoniq.axonserver.configuration.common.PluginPackage;
import io.axoniq.axonserver.configuration.common.PluginPackages;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.logging.PluginEventsLogger;
import io.axoniq.axonserver.plugin.OsgiController;
import io.axoniq.axonserver.plugin.PluginInfo;
import java.util.HashMap;
import java.util.Optional;
import javax.transaction.Transactional;
import org.springframework.stereotype.Component;

@Component
public class AdminPluginContextManager {
    private final AdminContextPlugins m;
    private final PluginPackages h;
    private final OsgiController b;
    private final AdminConfigurationFactory I;

    @Transactional
    public void deleteAll() {
        AdminPluginContextManager a2;
        a2.m.deleteAll();
    }

    @Transactional
    public void updateStatus(String a3, String a4, String a5, boolean a6) {
        AdminPluginContextManager a7;
        a5 = (PluginPackage)a7.h.findByNameAndVersion(a4, a5).orElseThrow(() -> new MessagingPlatformException(ErrorCode.OTHER, PluginEventsLogger.g((Object)"O|jwv~?~pd?vpeqt")));
        a5 = a7.m.findByContextAndPlugin(a3, (PluginPackage)a5).orElse(a7.I.adminContextPluginStatus(a3, (PluginPackage)a5));
        if (a6 && !a5.isActive()) {
            a7.m.findByContextAndPluginNameAndActive(a3, a4, true).ifPresent(a2 -> {
                AdminPluginContextManager a3;
                a2.setActive(false);
                a3.m.save(a2);
            });
        }
        a5.setActive(a6);
        a7.m.save((AdminContextPluginStatus)a5);
    }

    @Transactional
    public void remove(String a2, String a3) {
        AdminPluginContextManager a4;
        a4.h.findByNameAndVersion(a2, a3).ifPresent(arg_0 -> ((AdminContextPlugins)a4.m).deleteAllByPlugin(arg_0));
    }

    public AdminPluginContextManager(AdminContextPlugins a2, AdminConfigurationFactory a3, PluginPackages a4, OsgiController a5) {
        AdminPluginContextManager a6;
        AdminPluginContextManager adminPluginContextManager = a6;
        AdminPluginContextManager adminPluginContextManager2 = a6;
        adminPluginContextManager2.m = a2;
        adminPluginContextManager2.I = a3;
        adminPluginContextManager.h = a4;
        adminPluginContextManager.b = a5;
    }

    @Transactional
    public void updateConfiguration(String a2, String a3, String a4, String a5) {
        AdminPluginContextManager a6;
        a3 = (PluginPackage)a6.h.findByNameAndVersion(a3, a4).orElseThrow(() -> new MessagingPlatformException(ErrorCode.OTHER, UpdateReplicationGroupPayload.g((Object)"7S\u0012X\u000eQGQ\bKGY\bJ\t[")));
        a2 = a6.m.findByContextAndPlugin(a2, (PluginPackage)a3).orElse(a6.I.adminContextPluginStatus(a2, (PluginPackage)a3));
        a2.setConfiguration(a5);
        a6.m.save((AdminContextPluginStatus)a2);
    }

    public Iterable<PluginInfo> listPlugins() {
        AdminPluginContextManager a2;
        HashMap hashMap = new HashMap();
        a2.h.findAll().forEach(a3 -> {
            if (!a3.isDeleted()) {
                AdminPluginContextManager a4;
                hashMap.put(a3.getKey(), new PluginInfo(a3.getName(), a3.getVersion(), a3.getFilename(), a4.b.getStatus(a3.getKey())));
            }
        });
        a2.m.findAll().forEach(a4 -> hashMap.computeIfAbsent(a4.getPlugin().getKey(), a3 -> new PluginInfo(a4.getPlugin().getName(), a4.getPlugin().getVersion(), null, null)).addContextInfo(a4.getContext(), a4.isActive()));
        return hashMap.values();
    }

    @Transactional
    public void removeForContext(String a2, String a4, String a5) {
        AdminPluginContextManager a6;
        a6.h.findByNameAndVersion(a4, a5).ifPresent(a3 -> {
            AdminPluginContextManager a4;
            a4.m.deleteAllByContextAndPlugin(a2, a3);
        });
    }

    public Optional<AdminContextPluginStatus> getStatus(String a2, String a3, String a4) {
        AdminPluginContextManager a5;
        a3 = (PluginPackage)a5.h.findByNameAndVersion(a3, a4).orElseThrow(() -> new MessagingPlatformException(ErrorCode.OTHER, UpdateReplicationGroupPayload.g((Object)"7S\u0012X\u000eQGQ\bKGY\bJ\t[")));
        return a5.m.findByContextAndPlugin(a2, (PluginPackage)a3);
    }

    @Transactional
    public void delete(String a2) {
        AdminPluginContextManager a3;
        a3.m.deleteAllByContext(a2);
    }
}

