/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.plugin;

import io.axoniq.axonserver.configuration.common.PluginKey;
import io.axoniq.axonserver.configuration.common.PluginPackage;
import io.axoniq.axonserver.configuration.common.PluginPackages;
import io.axoniq.axonserver.configuration.runtime.ContextPlugin;
import io.axoniq.axonserver.configuration.runtime.ContextPlugins;
import io.axoniq.axonserver.configuration.runtime.RuntimeConfigurationFactory;
import io.axoniq.axonserver.exception.CriticalEventException;
import io.axoniq.axonserver.interceptor.PluginEnabledEvent;
import io.axoniq.axonserver.interceptor.PluginRemovedEvent;
import io.axoniq.axonserver.plugin.OsgiController;
import io.axoniq.axonserver.plugin.PluginConfigurationSerializer;
import io.axoniq.axonserver.plugin.PluginInfo;
import io.axoniq.axonserver.plugin.PluginNotFoundException;
import io.axoniq.axonserver.plugin.PluginPackageProvider;
import io.axoniq.axonserver.plugin.SimplePluginKey;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public class PluginContextManager {
    private final PluginPackages c;
    private final PluginConfigurationSerializer j;
    private final RuntimeConfigurationFactory H;
    private final ContextPlugins m;
    private final ApplicationEventPublisher h;
    private final Logger b;
    private final OsgiController I;

    @Transactional
    public ContextPlugin updateStatus(String a2, String a4, String a5, boolean a6) {
        PluginContextManager a7;
        PluginPackage pluginPackage = (PluginPackage)a7.c.findByNameAndVersion(a4, a5).orElseThrow(() -> new PluginNotFoundException(a4, a5));
        pluginPackage = a7.m.findByContextAndPlugin(a2, pluginPackage).orElse(a7.H.contextPlugin(a2, pluginPackage));
        if (a6 && !pluginPackage.isActive()) {
            a7.m.findByContextAndPluginNameAndActive(a2, a4, true).ifPresent(a3 -> {
                PluginContextManager a4;
                a3.setActive(false);
                a4.m.save(a3);
                a4.h.publishEvent((Object)new PluginEnabledEvent(a2, a3.getPluginKey(), a4.j.deserialize(a3.getConfiguration()), false));
            });
        }
        pluginPackage.setActive(a6);
        a7.m.save((ContextPlugin)pluginPackage);
        a7.h.publishEvent((Object)new PluginEnabledEvent(a2, (PluginKey)new SimplePluginKey(a4, a5), a7.j.deserialize(pluginPackage.getConfiguration()), a6));
        return pluginPackage;
    }

    public Optional<ContextPlugin> getStatus(String a2, String a3, String a4) {
        PluginContextManager a5;
        a3 = (PluginPackage)a5.c.findByNameAndVersion(a3, a4).orElseThrow(() -> new PluginNotFoundException(a3, a4));
        return a5.m.findByContextAndPlugin(a2, (PluginPackage)a3);
    }

    @Transactional
    public void updateConfiguration(String a2, String a3, String a4, Map<String, Map<String, Object>> a5) {
        PluginContextManager a6;
        PluginPackage pluginPackage = (PluginPackage)a6.c.findByNameAndVersion(a3, a4).orElseThrow(() -> new PluginNotFoundException(a3, a4));
        pluginPackage = a6.m.findByContextAndPlugin(a2, pluginPackage).orElse(a6.H.contextPlugin(a2, pluginPackage));
        PluginContextManager pluginContextManager = a6;
        pluginPackage.setConfiguration(pluginContextManager.j.serialize(a5));
        pluginContextManager.m.save((ContextPlugin)pluginPackage);
        a6.h.publishEvent((Object)new PluginEnabledEvent(a2, (PluginKey)new SimplePluginKey(a3, a4), a5, pluginPackage.isActive()));
    }

    public void publishConfiguration(PluginPackage a2) {
        PluginContextManager a4;
        a4.m.findAllByPlugin(a2).forEach(a3 -> {
            PluginContextManager a4;
            a4.h.publishEvent((Object)new PluginEnabledEvent(a3.getContext(), a2.getKey(), a4.j.deserialize(a3.getConfiguration()), a3.isActive()));
        });
    }

    @Transactional
    public void uninstall(PluginKey a4) {
        PluginContextManager a5;
        Object object = a5.c.findByNameAndVersion(a4.getSymbolicName(), a4.getVersion());
        if (((Optional)object).isPresent()) {
            object = a5.m.findAllByPlugin((PluginPackage)((Optional)object).get());
            object.forEach(a3 -> {
                PluginContextManager a4;
                a4.h.publishEvent((Object)new PluginEnabledEvent(a3.getContext(), a4, null, false));
            });
            object.forEach(a2 -> {
                PluginContextManager a3;
                a3.m.delete(a2);
            });
        }
    }

    public List<ContextPlugin> findAllByContextIn(List<String> a2) {
        PluginContextManager a3;
        return a3.m.findAllByContextIn(a2);
    }

    public List<ContextPlugin> findAll(PluginKey a2) {
        PluginContextManager a3;
        return a3.c.findByNameAndVersion(a2.getSymbolicName(), a2.getVersion()).map(arg_0 -> ((ContextPlugins)a3.m).findAllByPlugin(arg_0)).orElse(Collections.emptyList());
    }

    @Transactional
    public void uninstallForContexts(List<String> a3) {
        PluginContextManager a4;
        a4.m.findAllByContextIn(a3).forEach(a2 -> {
            PluginContextManager a3;
            PluginContextManager pluginContextManager = a3;
            pluginContextManager.m.delete(a2);
            pluginContextManager.h.publishEvent((Object)new PluginEnabledEvent(a2.getContext(), a2.getPluginKey(), null, false));
        });
    }

    public void start() {
        PluginContextManager a3;
        a3.m.findAll().forEach(a2 -> {
            PluginContextManager a3;
            if (a2.isActive()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = a2.getContext();
                objectArray[1] = a2.getPlugin().getName();
                objectArray[2] = a2.getPlugin().getVersion();
                a3.b.info(CriticalEventException.g((Object)"bm#0Xsmyoqmu9kd?bm"), objectArray);
                a3.h.publishEvent((Object)new PluginEnabledEvent(a2.getContext(), a2.getPluginKey(), a3.j.deserialize(a2.getConfiguration()), true));
                return;
            }
            a3.b.info(PluginPackageProvider.g((Object)"#3bn\b\"-)1 x5%n6!,n9-,'.+"), (Object)a2.getContext(), (Object)a2.getPluginKey());
        });
    }

    public Iterable<PluginInfo> listPlugins() {
        PluginContextManager a2;
        HashMap hashMap = new HashMap();
        a2.c.findAll().forEach(a3 -> {
            PluginContextManager a4;
            hashMap.put(a3.getKey(), new PluginInfo(a3.getName(), a3.getVersion(), a3.getFilename(), a4.I.getStatus(a3.getKey())));
        });
        a2.m.findAll().forEach(a3 -> ((PluginInfo)hashMap.get(a3.getPluginKey())).addContextInfo(a3.getContext(), a3.isActive()));
        return hashMap.values();
    }

    public PluginContextManager(ContextPlugins pluginStatusRepository, PluginPackages packageRepository, PluginConfigurationSerializer pluginConfigurationSerializer, RuntimeConfigurationFactory runtimeConfigurationFactory, OsgiController osgiController, @Qualifier(value="localEventPublisher") ApplicationEventPublisher a2) {
        PluginContextManager pluginContextManager = this;
        PluginContextManager pluginContextManager2 = this;
        PluginContextManager pluginContextManager3 = this;
        this.b = LoggerFactory.getLogger(PluginContextManager.class);
        pluginContextManager3.m = pluginStatusRepository;
        pluginContextManager3.c = packageRepository;
        pluginContextManager2.j = pluginConfigurationSerializer;
        pluginContextManager2.H = runtimeConfigurationFactory;
        pluginContextManager.I = osgiController;
        pluginContextManager.h = a2;
    }

    @Transactional
    public void removeForContext(PluginKey a2, String a4) {
        PluginContextManager a5;
        Optional optional = a5.c.findByNameAndVersion(a2.getSymbolicName(), a2.getVersion());
        if (!optional.isPresent()) {
            return;
        }
        a5.m.findByContextAndPlugin(a4, (PluginPackage)optional.get()).ifPresent(a3 -> {
            PluginContextManager a4;
            PluginContextManager pluginContextManager = a4;
            pluginContextManager.h.publishEvent((Object)new PluginEnabledEvent(a3.getContext(), a2, null, false));
            pluginContextManager.m.delete(a3);
        });
    }

    @Transactional
    public void update(ContextPlugin a2) {
        PluginContextManager a3;
        a3.m.save(a2);
        a3.h.publishEvent((Object)new PluginEnabledEvent(a2.getContext(), a2.getPluginKey(), a3.j.deserialize(a2.getConfiguration()), a2.isActive()));
    }

    @Transactional
    public void remove(ContextPlugin a2) {
        PluginContextManager a3;
        PluginContextManager pluginContextManager = a3;
        pluginContextManager.m.delete(a2);
        pluginContextManager.h.publishEvent((Object)new PluginRemovedEvent(a2.getContext(), a2.getPluginKey()));
    }
}

