/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.plugin;

import io.axoniq.axonserver.config.AxonServerStandardConfiguration;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.common.CommonConfigurationFactory;
import io.axoniq.axonserver.configuration.common.PluginKey;
import io.axoniq.axonserver.configuration.common.PluginPackage;
import io.axoniq.axonserver.configuration.common.PluginPackages;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.plugin.OsgiController;
import io.axoniq.axonserver.plugin.PluginConfigurationManager;
import io.axoniq.axonserver.plugin.PluginContextManager;
import io.axoniq.axonserver.plugin.PluginEvent;
import io.axoniq.axonserver.plugin.PluginInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.stereotype.Component;

@Component
public class PluginPackageManager
implements SmartLifecycle {
    private boolean f;
    private final PluginContextManager c;
    private final ApplicationEventPublisher j;
    private final Logger H;
    private final PluginPackages m;
    private final String h;
    private final OsgiController b;
    private final CommonConfigurationFactory I;

    public Optional<PluginPackage> getPluginPackage(String a2, String a4, String a5) {
        PluginPackageManager a6;
        return a6.m.findByNameAndVersion(a2, a4).map(a3 -> {
            if (a3.getFilename().equals(a5)) {
                return a3;
            }
            return null;
        });
    }

    public boolean isRunning() {
        PluginPackageManager a2;
        return a2.f;
    }

    public File getLocation(PluginKey a3) {
        PluginPackageManager a4;
        return a4.m.findByNameAndVersion(a3.getSymbolicName(), a3.getVersion()).map(a2 -> new File(a2.getFilename())).orElse(null);
    }

    public Iterable<PluginInfo> listPlugins() {
        PluginPackageManager a2;
        return a2.c.listPlugins();
    }

    public int getPhase() {
        return 0;
    }

    public PluginPackageManager(PluginPackages a4, OsgiController a5, PluginContextManager a6, ApplicationEventPublisher a7, MessagingPlatformConfiguration a8, CommonConfigurationFactory a9) {
        PluginPackageManager a10;
        PluginPackageManager pluginPackageManager = a10;
        PluginPackageManager pluginPackageManager2 = a10;
        a10.H = LoggerFactory.getLogger(PluginPackageManager.class);
        pluginPackageManager2.m = a4;
        pluginPackageManager2.b = a5;
        pluginPackageManager.c = a6;
        pluginPackageManager.j = a7;
        a10.h = a8.getPluginPackageDirectory();
        a10.I = a9;
        a10.b.registerPluginListener((a2, a3) -> {
            PluginPackageManager a4;
            a4.j.publishEvent((Object)new PluginEvent(a2, a3));
        });
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ void g(InputStream a2, File a3) {
        FileOutputStream fileOutputStream = new FileOutputStream(a3);
        byte[] byArray = new byte[5000];
        int n = a2.read(byArray);
        while (n > 0) {
            fileOutputStream.write(byArray, 0, n);
            n = a2.read(byArray);
        }
        fileOutputStream.close();
        return;
        {
            catch (IOException iOException) {
                throw new MessagingPlatformException(ErrorCode.OTHER, a3 + ": Writing plugin stream to file failed", (Throwable)iOException);
            }
        }
        {
            catch (Throwable throwable) {
                Throwable throwable2;
                try {
                    fileOutputStream.close();
                    throwable2 = throwable;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    Throwable throwable4 = throwable;
                    throwable2 = throwable4;
                    throwable4.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Transactional
    public PluginPackage addPlugin(String a2, InputStream a32) {
        PluginPackageManager a4;
        File file = new File(a4.h + File.separatorChar + a2);
        a4.g(a32, file);
        try {
            PluginPackageManager pluginPackageManager;
            PluginPackage pluginPackage;
            block5: {
                block4: {
                    block3: {
                        PluginPackageManager pluginPackageManager2 = a4;
                        a32 = pluginPackageManager2.b.addPlugin(file);
                        Optional optional = pluginPackageManager2.m.findByNameAndVersion(a32.getSymbolicName(), a32.getVersion());
                        if (!optional.isPresent()) break block3;
                        pluginPackage = (PluginPackage)optional.get();
                        if (a2.equals(pluginPackage.getFilename())) break block4;
                        FileUtils.g((File)new File(a4.h + File.separatorChar + pluginPackage.getFilename()));
                        pluginPackage.setFilename(a2);
                        a4.m.save(pluginPackage);
                        pluginPackageManager = a4;
                        break block5;
                    }
                    PluginPackageManager pluginPackageManager3 = a4;
                    pluginPackage = pluginPackageManager3.I.pluginPackage(a32.getSymbolicName(), a32.getVersion(), a2);
                    pluginPackage = pluginPackageManager3.m.save(pluginPackage);
                }
                pluginPackageManager = a4;
            }
            pluginPackageManager.c.publishConfiguration(pluginPackage);
            return pluginPackage;
        }
        catch (RuntimeException a32) {
            FileUtils.g((File)file);
            throw a32;
        }
    }

    public File getFullPath(String a3, String a4) {
        PluginPackageManager a5;
        return a5.m.findByNameAndVersion(a3, a4).map(a2 -> {
            PluginPackageManager a3;
            return new File(a3.h + File.separatorChar + a2.getFilename());
        }).orElseThrow(() -> new MessagingPlatformException(ErrorCode.OTHER, PluginConfigurationManager.g((Object)"UGpLlE%Ej_%Mj^kO")));
    }

    public void start() {
        PluginPackageManager pluginPackageManager;
        PluginPackageManager a3;
        a3.b.start();
        try {
            Files.createDirectories(new File(a3.h).toPath(), new FileAttribute[0]);
            a3.m.findAll().forEach(a2 -> {
                PluginPackageManager a3;
                block3: {
                    try {
                        if (!a2.isDeleted()) break block3;
                        a3.g(a2);
                        return;
                    }
                    catch (Exception exception) {
                        a3.H.error(AxonServerStandardConfiguration.g((Object)"w@XMTE\u0011U^\u0001BUPSE\u0001AMDFXO\u0011ZL"), (Object)a2.getKey(), (Object)exception);
                        return;
                    }
                }
                PluginPackageManager pluginPackageManager = a3;
                pluginPackageManager.b.startPlugin(pluginPackageManager.h + File.separatorChar + a2.getFilename());
                a3.g(a2.getKey(), PluginConfigurationManager.g((Object)"xqJw_`O"));
            });
            a3.c.start();
            pluginPackageManager = a3;
        }
        catch (Exception exception) {
            PluginPackageManager pluginPackageManager2 = a3;
            pluginPackageManager = pluginPackageManager2;
            pluginPackageManager2.H.error(AxonServerStandardConfiguration.g((Object)"gPH]DU\u0001EN\u0011RE@CU\u0011Q]TVH_"), (Throwable)exception);
        }
        pluginPackageManager.f = true;
    }

    public void stop() {
        PluginPackageManager a2;
        a2.b.stop();
        a2.f = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void uninstallPlugin(PluginKey a3) {
        PluginPackageManager a4;
        PluginPackageManager pluginPackageManager = a4;
        pluginPackageManager.c.uninstall(a3);
        pluginPackageManager.b.uninstallPlugin(a3);
        PluginPackages pluginPackages = pluginPackageManager.m;
        synchronized (pluginPackages) {
            a4.m.findByNameAndVersion(a3.getSymbolicName(), a3.getVersion()).ifPresent(a2 -> {
                PluginPackageManager a3;
                a3.m.delete(a2);
                FileUtils.g((File)new File(a3.h + File.separatorChar + a2.getFilename()));
            });
            return;
        }
    }
}

