/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.admin.application.api.Client;
import io.axoniq.axonserver.enterprise.replication.BackupInfoController;
import io.axoniq.axonserver.enterprise.replication.GrpcRaftController;
import io.axoniq.axonserver.enterprise.replication.SnapshotDataProviders;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.rest.BackupInfoRestController;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Parameter;
import java.security.Principal;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/backup"})
public class ClusterBackupInfoRestController {
    private static final Logger m = AuditLog.getLogger();
    private final BackupInfoRestController h;
    private final GrpcRaftController b;
    private final BackupInfoController I;

    @GetMapping(value={"/log/filenames"})
    public List<String> g(@Parameter(deprecated=true, description="Indicates the replication group, use 'replicationgroup' paramater") @RequestParam(value="context", defaultValue="default") String context, @RequestParam(value="replicationgroup", required=false) String replicationGroup, @Parameter(hidden=true) Principal a2) {
        if (replicationGroup == null) {
            replicationGroup = context;
        }
        if (m.isInfoEnabled()) {
            m.info(SnapshotDataProviders.g((Object)"@]f{;t~WnChR;Rt\u0006wOhR;DzEpSk\u0006}OwCh\u0006}Ii\u0006iCkJrEzRrIu\u0006|TtSk\u0006`[5"), (Object)AuditLog.username((Principal)a2), (Object)StringUtils.sanitize((String)replicationGroup));
        }
        if ((context = this.b.getRaftGroup(replicationGroup)) == null) {
            throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, replicationGroup + ": replication group not found");
        }
        return context.localLogEntryStore().getBackupFilenames().collect(Collectors.toList());
    }

    @PostMapping(value={"/createControlDbBackup"})
    public String g(@Parameter(hidden=true) Principal a3) throws SQLException {
        m.info(Client.g((Object)"kQMw\u0010xU[EOC^\u0010^_\nSXUKDO\u0010I_DDX_FTH\u0010HQI[_@\u0004"), (Object)AuditLog.username((Principal)a3));
        this.b.getRaftGroups().forEach(a2 -> {
            ClusterBackupInfoRestController a3;
            ClusterBackupInfoRestController clusterBackupInfoRestController = a3;
            String string = a2;
            clusterBackupInfoRestController.I.registerControlDbBackup(string, clusterBackupInfoRestController.b.getRaftGroup(string).logEntryProcessor().G(), System.currentTimeMillis());
        });
        return this.h.g();
    }

    public ClusterBackupInfoRestController(BackupInfoRestController a2, GrpcRaftController a3, BackupInfoController a4) {
        ClusterBackupInfoRestController a5;
        ClusterBackupInfoRestController clusterBackupInfoRestController = a5;
        a5.h = a2;
        clusterBackupInfoRestController.b = a3;
        clusterBackupInfoRestController.I = a4;
    }
}

