/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.admin.context.requestprocessor.VisibleContextCache;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.ClusterTemplateController;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.cluster.DistributeLicenseService;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.context.ContextNameValidation;
import io.axoniq.axonserver.enterprise.replication.admin.RaftConfigServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.ContextRole;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.licensing.LicenseException;
import io.axoniq.axonserver.localstorage.file.multitier.LowerTierEventStoreFactory;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.rest.ClusterRestController;
import io.axoniq.axonserver.rest.json.RestResponse;
import io.axoniq.axonserver.topology.ClusterTopology;
import io.swagger.v3.oas.annotations.Parameter;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/*
 * Duplicate member names - consider using --renamedupmembers true
 * Exception performing whole class analysis ignored.
 */
@CrossOrigin
@RestController(value="ClusterRestController")
@RequestMapping(value={"/v1/cluster"})
public class ClusterRestController {
    private final Predicate<String> E;
    private final ClusterTopology i;
    private final DistributeLicenseService G;
    private static final Logger f = AuditLog.getLogger();
    private final RaftConfigServiceFactory c;
    private final ClusterTemplateController j;
    private final ClusterController H;
    public static final String m = "_none";
    private final FeatureChecker h;
    private final ApplicationEventPublisher b;
    private static final Logger I = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @PostMapping(value={"/upload-license"})
    public void g(@RequestParam(value="licenseFile") MultipartFile licenseFile, @Parameter(hidden=true) Principal a2) throws IOException {
        f.info(VisibleContextCache.g((Object)"_vyP$_a|qhwy$amnacwh$xtieya#"), (Object)AuditLog.username((Principal)a2));
        I.info(LowerTierEventStoreFactory.g((Object)"Q*hos&|*q<zoj?s ~+z+3oo*m)p=r&q(?#v,z!l*?:o+~;za1a"));
        try {
            this.G.distributeLicense(licenseFile.getBytes());
            return;
        }
        catch (MessagingPlatformException messagingPlatformException) {
            if (ErrorCode.NO_LEADER_AVAILABLE.equals((Object)messagingPlatformException.getErrorCode())) {
                throw new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, VisibleContextCache.g((Object)"Ck-hheia\u007f$kk\u007f$Reiidj#$Hj~q\u007fa-peey$ylh$Reiidj-vhtamneymbj-c\u007fkxt-m~$nvheyai$oakk\u007fa-q}hbeimcc-e-hdghj~a#"));
            }
            throw messagingPlatformException;
        }
        catch (LicenseException licenseException) {
            throw new MessagingPlatformException(ErrorCode.INVALID_PROPERTY_VALUE, licenseException.getMessage());
        }
    }

    @GetMapping(path={"{name}"})
    public JsonClusterNode g(@PathVariable(value="name") String name, @Parameter(hidden=true) Principal a2) {
        f.info(LowerTierEventStoreFactory.g((Object)"\u0014d2BoM*n:z<koq {*?+z;~&s<?)p=?4ba"), (Object)AuditLog.username((Principal)a2), (Object)name);
        a2 = this.H.getNode(name);
        if (a2 == null) {
            throw new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, "Node " + name + " not found");
        }
        return JsonClusterNode.from((ClusterNode)a2, (boolean)this.H.isActive(name));
    }

    @GetMapping(value={"/download-template"})
    @ResponseBody
    public void g(HttpServletResponse resp, @Parameter(hidden=true) Principal a2) throws IOException {
        f.info(VisibleContextCache.g((Object)"V\u007fpY-Vhuxa~p-gaq~phv-phi}hlph$ikzjakl`#"), (Object)AuditLog.username((Principal)a2));
        if (this.i.isAdminNode()) {
            a2 = LowerTierEventStoreFactory.g((Object)"|#j<k*mbk*r?s.k*16r#");
            String string = this.j.buildYamlTemplate();
            HttpServletResponse httpServletResponse = resp;
            resp = httpServletResponse.getOutputStream();
            httpServletResponse.setContentType(VisibleContextCache.g((Object)"yaup\"taedj6$nllv~ay9xpk)5"));
            httpServletResponse.addHeader(LowerTierEventStoreFactory.g((Object)"\fp!k*q;2\u000bv<o l&k&p!"), "attachment; filename=\"" + (String)a2 + "\"");
            HttpServletResponse httpServletResponse2 = resp;
            httpServletResponse2.write(string.getBytes(StandardCharsets.UTF_8));
            httpServletResponse2.flush();
            httpServletResponse2.close();
            return;
        }
        throw new RuntimeException(VisibleContextCache.g((Object)"Tkx$nec$xwh$yldw-bxjnpdkceamy}-kcht$kvbi-eiidj-jb`h"));
    }

    @PostMapping
    public ResponseEntity<RestResponse> g(@Valid @RequestBody ClusterJoinRequest jsonClusterNode2, @Parameter(hidden=true) Principal a2) {
        ClusterRestController clusterRestController;
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = jsonClusterNode2.getInternalHostName();
        objectArray[2] = jsonClusterNode2.internalGrpcPort;
        f.info(LowerTierEventStoreFactory.g((Object)"D4b\u0012?\u001dz>j*l;?;pou v!?,s:l;z=?.kod2%4ba"), objectArray);
        a2 = NodeInfo.newBuilder((NodeInfo)this.H.getMe().toNodeInfo());
        String string = jsonClusterNode2.getContext();
        if (string != null && !string.isEmpty()) {
            if (jsonClusterNode2.getNoContexts() != null && jsonClusterNode2.getNoContexts().booleanValue()) {
                throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, VisibleContextCache.g((Object)"Necjbp-gbiomca-nbmcmcc-gbjyaup-sdpe$ckNkcph|yw#"));
            }
            if (!RaftAdminGroup.g((String)string) && !this.E.test(string)) {
                throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, "Invalid context name: " + string);
            }
            I.debug(LowerTierEventStoreFactory.g((Object)"~+{g6u?\u001dz(v<k*m&q(?\"f<z#yo~!{o~+{&q(?\"zok ?,p!k*g;?md2=a"), (Object)string);
            clusterRestController = this;
            a2.addContexts(ContextRole.newBuilder().setName(string).build());
        } else if (jsonClusterNode2.getNoContexts() != null && jsonClusterNode2.getNoContexts().booleanValue()) {
            I.debug(VisibleContextCache.g((Object)"l`i,$>-Vhcdwya\u007fmcc-itwhhk$lji$l`imcc-ih$yk-jb$nkcph|yw#"));
            clusterRestController = this;
            a2.addContexts(ContextRole.newBuilder().setName("_none").build());
        } else {
            I.debug(LowerTierEventStoreFactory.g((Object)"~+{g6u?\u001dz(v<k*m&q(?\"f<z#yo~!{o~+{&q(?\"zok ?.s#?,p!k*g;la"));
            clusterRestController = this;
        }
        if (clusterRestController.H.nodes().count() > 1L) {
            return ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).body((Object)new RestResponse(false, VisibleContextCache.g((Object)"Jb`h$lh\u007fal`t$\u007fajm~phvh`-mc$l$nhxwya\u007f")));
        }
        try {
            ClusterRestController clusterRestController2 = this;
            ClusterJoinRequest clusterJoinRequest = jsonClusterNode2;
            jsonClusterNode2 = clusterRestController2.c.getRaftConfigServiceStub(clusterJoinRequest.internalHostName, clusterJoinRequest.internalGrpcPort.intValue()).joinCluster(a2.build());
            clusterRestController2.b.publishEvent((Object)new ClusterEvents.LicenseUpdated(jsonClusterNode2.getLicense().toByteArray()));
            return ResponseEntity.accepted().body((Object)new RestResponse(true, LowerTierEventStoreFactory.g((Object)"^,|*o;z+?%p&qom*n:z<kc?\"~6?;~$zo~oh'v#zok ??m |*l<")));
        }
        catch (Exception jsonClusterNode2) {
            return new RestResponse(false, jsonClusterNode2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)jsonClusterNode2));
        }
    }

    @DeleteMapping(path={"{name}"})
    public void g(@PathVariable(value="name") String name, @Parameter(hidden=true) Principal a2) {
        f.info(VisibleContextCache.g((Object)"V\u007fpY-Vhuxa~p-pb$iaaaya-jb`h$vy#"), (Object)AuditLog.username((Principal)a2), (Object)name);
        this.c.getRaftConfigService().deleteNode(name);
    }

    @GetMapping
    public List<JsonClusterNode> g(@Parameter(hidden=true) Principal a3) {
        f.info(LowerTierEventStoreFactory.g((Object)"\u0014d2BoM*n:z<kok ?#v<koq {*la"), (Object)AuditLog.username((Principal)a3));
        return this.H.nodes().map(a2 -> {
            ClusterRestController a3;
            ClusterNode clusterNode = a2;
            return JsonClusterNode.from((ClusterNode)clusterNode, (boolean)a3.H.isActive(clusterNode.getName()));
        }).collect(Collectors.toList());
    }

    public ClusterRestController(ClusterController a2, RaftConfigServiceFactory a3, FeatureChecker a4, DistributeLicenseService a5, ApplicationEventPublisher a6, ClusterTopology a7, ClusterTemplateController a8) {
        ClusterRestController a9;
        ClusterRestController clusterRestController = a9;
        ClusterRestController clusterRestController2 = a9;
        ClusterRestController clusterRestController3 = a9;
        ClusterRestController clusterRestController4 = a9;
        a9.E = new ContextNameValidation();
        a9.H = a2;
        clusterRestController3.c = a3;
        clusterRestController3.h = a4;
        clusterRestController2.G = a5;
        clusterRestController2.b = a6;
        clusterRestController.i = a7;
        clusterRestController.j = a8;
    }
}

