/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.LifecycleController;
import io.axoniq.axonserver.component.ComponentItems;
import io.axoniq.axonserver.component.command.ComponentCommand;
import io.axoniq.axonserver.component.command.DefaultCommands;
import io.axoniq.axonserver.config.GrpcContextAuthenticationProvider;
import io.axoniq.axonserver.grpc.SerializedCommand;
import io.axoniq.axonserver.localstorage.StorageResolver;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.message.command.CommandDispatcher;
import io.axoniq.axonserver.message.command.CommandRegistrationCache;
import io.axoniq.axonserver.rest.A;
import io.axoniq.axonserver.rest.CommandRestController;
import io.axoniq.axonserver.rest.json.CommandRequestJson;
import io.axoniq.axonserver.rest.json.CommandResponseJson;
import io.axoniq.axonserver.util.ObjectUtils;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import java.security.Principal;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="CommandRestController")
@RequestMapping(value={"/v1"})
public class CommandRestController {
    private static final Logger h = AuditLog.getLogger();
    private final CommandDispatcher b;
    private final CommandRegistrationCache I;

    @GetMapping(value={"commands"})
    public List<JsonClientMapping> K(@Parameter(hidden=true) Principal a2) {
        h.info(StorageResolver.g((Object)"\u000b:-\u001cp\u001350%$#5p5?a<(#5p <-p\u0002?,= >%#a')9\"8a8 &$p p35&92$$\"$4a8 >%<$\"o"), (Object)AuditLog.username((Principal)a2));
        return this.I.getAll().entrySet().stream().map(JsonClientMapping::g).collect(Collectors.toList());
    }

    public CommandRestController(CommandDispatcher a2, CommandRegistrationCache a3) {
        CommandRestController a4;
        CommandRestController commandRestController = a4;
        commandRestController.b = a2;
        commandRestController.I = a3;
    }

    @GetMapping(value={"commands/queues"})
    public List<A> g(@Parameter(hidden=true) Principal a2) {
        h.info(LifecycleController.g((Object)"=5\u001b\u0013F\u001c\u0003?\u0013+\u0015:F:\tn\n'\u0015:F/\n\"F\r\t#\u000b/\b*7;\u0003;\u0003=H"), (Object)AuditLog.username((Principal)a2));
        return this.b.getCommandQueues().g().entrySet().stream().map(A::g).collect(Collectors.toList());
    }

    @GetMapping(value={"/components/{component}/commands"})
    public Iterable<ComponentCommand> g(@PathVariable(value="component") String component, @RequestParam(value="context") String context, @Parameter(hidden=true) Principal a2) {
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = component;
        objectArray[2] = StringUtils.sanitize((String)context);
        h.info(StorageResolver.g((Object)"\u000b:-\u001cp\u001350%$#5p5?a<(#5p <-p\u0002?,= >%#a6.\"a')9\"8a3.=1?/5/$ar:-cp(>a3.>559$ar:-cp)12p p35&92$$\"$4a8 >%<$\"o"), objectArray);
        return new ComponentItems(component, context, (Iterable)new DefaultCommands(this.I));
    }

    @PostMapping(value={"commands/run"})
    @Parameters(value={@Parameter(name="AxonIQ-Access-Token", description="Access Token", in=ParameterIn.HEADER)})
    public Future<CommandResponseJson> g(@RequestHeader(value="AxonIQ-Context", defaultValue="default", required=false) String context, @RequestBody @Valid CommandRequestJson command, @Parameter(hidden=true) Authentication a2) {
        h.info(LifecycleController.g((Object)"\u0015\u001d3;n4+\u0017;\u0003=\u0012n\u0012!F*\u000f=\u0016/\u0012-\u000en\u0007nD5\u001blF\r\t#\u000b/\b*H"), (Object)AuditLog.username((Principal)a2), (Object)command.getName());
        CompletableFuture<CommandResponseJson> completableFuture = new CompletableFuture<CommandResponseJson>();
        this.b.dispatch(context, (Authentication)ObjectUtils.g((Object)a2, (Object)GrpcContextAuthenticationProvider.I), new SerializedCommand(command.asCommand()), a3 -> completableFuture.complete(new CommandResponseJson(a3.wrapped())));
        return completableFuture;
    }

    @GetMapping(value={"commands/count"})
    public int g(@Parameter(hidden=true) Principal a2) {
        if (h.isDebugEnabled()) {
            h.debug(StorageResolver.g((Object)"\u000b:-\u001cp\u001350%$#5p'?3p58$p 35975a3.=,1/4a3.%/$o"), (Object)AuditLog.username((Principal)a2));
        }
        return this.b.activeCommandCount();
    }
}

