/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.axoniq.axonserver.config.GrpcContextAuthenticationProvider;
import io.axoniq.axonserver.exception.ErrorMessageFactory;
import io.axoniq.axonserver.grpc.event.GetAggregateEventsRequest;
import io.axoniq.axonserver.grpc.event.GetAggregateSnapshotsRequest;
import io.axoniq.axonserver.grpc.event.GetEventsRequest;
import io.axoniq.axonserver.localstorage.SerializedEvent;
import io.axoniq.axonserver.localstorage.SerializedEventWithToken;
import io.axoniq.axonserver.localstorage.transaction.PreparedTransaction;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.message.event.EventDispatcher;
import io.axoniq.axonserver.rest.EventsRestController;
import io.axoniq.axonserver.util.ObjectUtils;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import java.security.Principal;
import java.util.concurrent.TimeUnit;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

@RestController(value="EventsRestController")
@RequestMapping(value={"/v1"})
public class EventsRestController {
    private final Logger h;
    private static final Logger b = AuditLog.getLogger();
    private final EventDispatcher I;

    private /* synthetic */ void g(SseEmitter a2, Runnable a4) {
        a2.onError(a3 -> a4.run());
        a2.onCompletion(a4::run);
        a2.onTimeout(a4::run);
    }

    private /* synthetic */ void G(SseEmitter a2) {
        try {
            a2.send(SseEmitter.event().comment(ErrorMessageFactory.g((Object)"77\u0016y\u001d?R*\u0006+\u00178\u001f")));
            return;
        }
        catch (Exception exception) {
            EventsRestController a3;
            a3.h.debug(PreparedTransaction.g((Object)"6\u001b\u0001\u0006\u0001I\u001c\u0007S\u001a\u0016\u0007\u0017\u0000\u001d\u000eS\n\u001c\u0004\u0003\u0005\u0016\u001d\u0016\r"), (Throwable)exception);
            return;
        }
        finally {
            a2.complete();
        }
    }

    @GetMapping(path={"events"})
    @Parameters(value={@Parameter(name="AxonIQ-Access-Token", description="Access Token", in=ParameterIn.HEADER)})
    public SseEmitter g(@RequestHeader(value="AxonIQ-Context", defaultValue="default", required=false) String context, @RequestParam(value="aggregateId", required=false) String aggregateId, @RequestParam(value="initialSequence", defaultValue="0", required=false) long initialSequence, @RequestParam(value="allowSnapshots", defaultValue="true", required=false) boolean allowSnapshots, @RequestParam(value="trackingToken", defaultValue="0", required=false) long trackingToken, @RequestParam(value="timeout", defaultValue="3600", required=false) long a22, @RequestParam(value="maxEvents", defaultValue="10000", required=false) long a5, @Parameter(hidden=true) Authentication a6) {
        Object[] objectArray = new Object[5];
        objectArray[0] = AuditLog.username((Principal)a6);
        objectArray[1] = context;
        objectArray[2] = aggregateId;
        objectArray[3] = initialSequence;
        objectArray[4] = trackingToken;
        b.info(ErrorMessageFactory.g((Object)")\"\u000f\u0019\t$/y <\u0003,\u0017*\u0006y\u00146\u0000y\u00137R<\u0004<\u001c-_*\u0006+\u00178\u001fy\u001d?R8\u0015>\u0000<\u00158\u0006<R{\t$PuR*\u00068\u0000-\u001b7\u0015y\u0013-R*\u0017(\u0007<\u001c:\u0017y\t$^y\u00066\u0019<\u001cy\t$\\"), objectArray);
        SseEmitter a22 = new SseEmitter(Long.valueOf(TimeUnit.SECONDS.toMillis(a22)));
        if (aggregateId != null) {
            GetAggregateEventsRequest getAggregateEventsRequest = GetAggregateEventsRequest.newBuilder().setAggregateId(aggregateId).setAllowSnapshots(allowSnapshots).setInitialSequence(initialSequence).build();
            ObjectMapper objectMapper = new ObjectMapper();
            aggregateId = this.I.aggregateEvents(context, (Authentication)ObjectUtils.g((Object)a6, (Object)GrpcContextAuthenticationProvider.I), getAggregateEventsRequest).subscribe(a4 -> {
                EventsRestController a5;
                a5.g(a22, objectMapper, a4);
            }, arg_0 -> ((SseEmitter)a22).completeWithError(arg_0), () -> {
                EventsRestController a3;
                a3.G(a22);
            });
            this.g(a22, () -> ((Disposable)aggregateId).dispose());
            return a22;
        }
        GetEventsRequest getEventsRequest = GetEventsRequest.newBuilder().setTrackingToken(trackingToken).setNumberOfPermits(a5).setClientId(PreparedTransaction.g((Object)"!, =")).build();
        Sinks.Many many = Sinks.many().unicast().onBackpressureBuffer();
        this.I.events(context, (Authentication)ObjectUtils.g((Object)a6, (Object)GrpcContextAuthenticationProvider.I), many.asFlux()).subscribe(a3 -> {
            EventsRestController a4;
            a4.g(a22, a3);
        }, arg_0 -> ((SseEmitter)a22).completeWithError(arg_0), () -> {
            EventsRestController a3;
            a3.G(a22);
        });
        many.emitNext((Object)getEventsRequest, Sinks.EmitFailureHandler.FAIL_FAST);
        this.g(a22, () -> many.emitComplete(Sinks.EmitFailureHandler.FAIL_FAST));
        return a22;
    }

    @PostMapping(value={"snapshots"})
    @Parameters(value={@Parameter(name="AxonIQ-Access-Token", description="Access Token", in=ParameterIn.HEADER)})
    public Mono<Void> K(@RequestHeader(value="AxonIQ-Context", required=false, defaultValue="default") String context, @RequestBody @Valid JsonEvent jsonEvent, @Parameter(hidden=true) Authentication a2) {
        b.info(ErrorMessageFactory.g((Object)"\u0002\t$2\"\u000f\u0004R\u000b\u0017(\u0007<\u0001-R-\u001dy\u0013)\u0002<\u001c=R<\u0004<\u001c-Z*["), (Object)AuditLog.username((Principal)a2), (Object)context);
        return this.I.appendSnapshot(StringUtils.getOrDefault((String)context, (String)"default"), jsonEvent.asEvent(), (Authentication)ObjectUtils.g((Object)a2, (Object)GrpcContextAuthenticationProvider.I));
    }

    @PostMapping(value={"events"})
    @Parameters(value={@Parameter(name="AxonIQ-Access-Token", description="Access Token", in=ParameterIn.HEADER)})
    public Mono<Void> g(@RequestHeader(value="AxonIQ-Context", required=false, defaultValue="default") String context, @Valid @RequestBody JsonEventList jsonEvents, @Parameter(hidden=true) Authentication a3) {
        if (jsonEvents.messages.isEmpty()) {
            throw new IllegalArgumentException(PreparedTransaction.g((Object)">\u0000\u0000\u001a\u001a\u0007\u0014I\u001e\f\u0000\u001a\u0012\u000e\u0016\u001a"));
        }
        jsonEvents = Flux.fromStream(jsonEvents.messages.stream().map(a2 -> new SerializedEvent(a2.asEvent())));
        return this.I.appendEvent(context, a3, (Flux)jsonEvents);
    }

    @GetMapping(path={"snapshots"})
    @Parameters(value={@Parameter(name="AxonIQ-Access-Token", description="Access Token", in=ParameterIn.HEADER)})
    public SseEmitter g(@RequestHeader(value="AxonIQ-Context", defaultValue="default", required=false) String context, @RequestParam(value="aggregateId", required=true) String aggregateId, @RequestParam(value="maxSequence", defaultValue="-1", required=false) long maxSequence, @RequestParam(value="initialSequence", defaultValue="0", required=false) long a2, @Parameter(hidden=true) Authentication a4) {
        Object[] objectArray = new Object[5];
        objectArray[0] = AuditLog.username((Principal)a4);
        objectArray[1] = context;
        objectArray[2] = aggregateId;
        objectArray[3] = a2;
        objectArray[4] = maxSequence;
        b.info(ErrorMessageFactory.g((Object)"\u0002\t$2\"\u000f\u0004R\u000b\u0017(\u0007<\u0001-R?\u001d+R5\u001b*\u0006y\u001d?R*\u001c8\u0002*\u001a6\u0006*R6\u0014y\u0013>\u0015+\u0017>\u0013-\u0017yP\"\u000f{^y)\"\u000ft\t$/"), objectArray);
        SseEmitter sseEmitter = new SseEmitter();
        aggregateId = GetAggregateSnapshotsRequest.newBuilder().setAggregateId(aggregateId).setInitialSequence(a2).setMaxSequence(maxSequence >= 0L ? maxSequence : Long.MAX_VALUE).build();
        this.I.aggregateSnapshots(StringUtils.getOrDefault((String)context, (String)"default"), (Authentication)ObjectUtils.g((Object)a4, (Object)GrpcContextAuthenticationProvider.I), (GetAggregateSnapshotsRequest)aggregateId).doOnError(arg_0 -> ((SseEmitter)sseEmitter).completeWithError(arg_0)).doOnComplete(() -> {
            EventsRestController a3;
            a3.G(sseEmitter);
        }).subscribe(a3 -> {
            try {
                sseEmitter.send(SseEmitter.event().data((Object)new JsonEvent(a3.g())));
                return;
            }
            catch (Exception a22) {
                EventsRestController a4;
                a4.h.debug(ErrorMessageFactory.g((Object)"7!\u0011<\u0002-\u001b6\u001cy\u001d7R*\u00177\u00160\u001c>R<\u0004<\u001c-RtR\"\u000f"), (Object)a22.getMessage(), (Object)a22);
                return;
            }
        });
        return sseEmitter;
    }

    public EventsRestController(EventDispatcher a2) {
        EventsRestController a3;
        EventsRestController eventsRestController = a3;
        eventsRestController.h = LoggerFactory.getLogger(EventsRestController.class);
        eventsRestController.I = a2;
    }

    @PostMapping(value={"snapshot"})
    @Parameters(value={@Parameter(name="AxonIQ-Access-Token", description="Access Token", in=ParameterIn.HEADER)})
    @Deprecated
    public Mono<Void> g(@RequestHeader(value="AxonIQ-Context", required=false, defaultValue="default") String context, @RequestBody @Valid JsonEvent jsonEvent, @Parameter(hidden=true) Authentication a2) {
        b.warn(PreparedTransaction.g((Object)"2\b\u00143\u0012\u000e4S;\u0016\u0018\u0006\f\u0000\u001dS\u001d\u001cI\u0012\u0019\u0003\f\u001d\rS\f\u0005\f\u001d\u001d[\u001aZI\u0006\u001a\u001a\u0007\u0014I\u0017\f\u0003\u001b\u0016\n\u0012\u001d\u0016\rS(# "), (Object)AuditLog.username((Principal)a2), (Object)context);
        return this.K(context, jsonEvent, a2);
    }

    private /* synthetic */ void g(SseEmitter a22, ObjectMapper a3, SerializedEvent a4) {
        try {
            a22.send(SseEmitter.event().data((Object)a3.writeValueAsString((Object)new JsonEvent(a4.g()))));
            return;
        }
        catch (Exception a22) {
            EventsRestController a5;
            a5.h.debug(ErrorMessageFactory.g((Object)"7!\u0011<\u0002-\u001b6\u001cy\u001d7R*\u00177\u00160\u001c>R<\u0004<\u001c-RtR\"\u000f"), (Object)a22.getMessage(), (Object)a22);
            return;
        }
    }

    private /* synthetic */ void g(SseEmitter a2, SerializedEventWithToken a32) {
        try {
            a2.send(SseEmitter.event().id(String.valueOf(a32.g() + 1L)).data((Object)new JsonEvent(a32.g())));
            return;
        }
        catch (Exception a32) {
            EventsRestController a4;
            Exception exception = a32;
            a4.h.debug(PreparedTransaction.g((Object)",\u000b\n\u0016\u0019\u0007\u0000\u001c\u0007S\u0006\u001dI\u0000\f\u001d\r\u001a\u0007\u0014I\u0016\u001f\u0016\u0007\u0007I^I\b\u0014"), (Object)exception.getMessage(), (Object)a32);
            a2.completeWithError((Throwable)exception);
            return;
        }
    }
}

