/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.diagnostics.DiagnosticsOptions;
import io.axoniq.axonserver.grpc.event.GetAggregateEventsRequest;
import io.axoniq.axonserver.grpc.event.GetAggregateSnapshotsRequest;
import io.axoniq.axonserver.grpc.event.GetEventsRequest;
import io.axoniq.axonserver.localstorage.LocalEventStore;
import io.axoniq.axonserver.localstorage.SerializedEvent;
import io.axoniq.axonserver.localstorage.SerializedEventWithToken;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.rest.ApplicationJSON;
import io.axoniq.axonserver.rest.EventsRestController;
import io.axoniq.axonserver.rest.K;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import java.io.IOException;
import java.security.Principal;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

@RestController
@RequestMapping(value={"/v1/local"})
public class LocalEventsRestController {
    private final LocalEventStore h;
    private static final Logger b;
    private static final Logger I;

    @GetMapping(path={"events"})
    @Parameters(value={@Parameter(name="AxonIQ-Access-Token", description="Access Token", in=ParameterIn.HEADER)})
    public SseEmitter g(@RequestHeader(value="AxonIQ-Context", defaultValue="default", required=false) String context, @RequestParam(value="aggregateId", required=false) String aggregateId, @RequestParam(value="initialSequence", defaultValue="0", required=false) long initialSequence, @RequestParam(value="allowSnapshots", defaultValue="true", required=false) boolean allowSnapshots, @RequestParam(value="trackingToken", defaultValue="0", required=false) long trackingToken, @RequestParam(value="timeout", defaultValue="3600", required=false) long a32, @Parameter(hidden=true) Authentication a5) {
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a5);
        objectArray[1] = aggregateId;
        objectArray[2] = context;
        I.info(DiagnosticsOptions.g((Object)"\to/IrF7e'q!`r`=4 q3prq$q<`!44f=yrx=w3xrq$q<`rg&{ qrr=fru5s q5u&qro/4;zrw=z&q*`ro/:"), objectArray);
        SseEmitter a32 = new SseEmitter(Long.valueOf(TimeUnit.SECONDS.toMillis(a32)));
        if (aggregateId == null) {
            K k = new K(EventsRestController.JsonEvent::new);
            this.h.events(context, a5, Flux.create(a4 -> {
                FluxSink fluxSink = a4;
                fluxSink.next((Object)GetEventsRequest.newBuilder().setTrackingToken(trackingToken).setNumberOfPermits(10000L).setClientId(ApplicationJSON.g((Object)":\r;\u001c")).build());
                a32.onCompletion(() -> ((FluxSink)fluxSink).complete());
                a32.onTimeout(() -> ((FluxSink)a4).complete());
                a32.onError(arg_0 -> ((FluxSink)a4).error(arg_0));
            })).subscribe(arg_0 -> LocalEventsRestController.g(a32, (Function)k, arg_0), arg_0 -> ((SseEmitter)a32).completeWithError(arg_0), () -> ((SseEmitter)a32).complete());
            return a32;
        }
        GetAggregateEventsRequest getAggregateEventsRequest = GetAggregateEventsRequest.newBuilder().setAggregateId(aggregateId).setAllowSnapshots(allowSnapshots).setInitialSequence(initialSequence).build();
        aggregateId = new K(a2 -> new EventsRestController.JsonEvent(a2.g()));
        this.h.aggregateEvents(context, a5, getAggregateEventsRequest).subscribe(arg_0 -> LocalEventsRestController.K(a32, (Function)((Object)aggregateId), arg_0), arg_0 -> ((SseEmitter)a32).completeWithError(arg_0), () -> {
            SseEmitter sseEmitter;
            try {
                a32.send(SseEmitter.event().comment(ApplicationJSON.g((Object)"\r\u0006,H'\u000eh\u001b<\u001a-\t%")));
                sseEmitter = a32;
            }
            catch (IOException iOException) {
                b.debug(DiagnosticsOptions.g((Object)"\u0017f { 4=zrg7z6}<srw=y\"x7`7p"), (Throwable)iOException);
                sseEmitter = a32;
            }
            sseEmitter.complete();
        });
        return a32;
    }

    static {
        I = AuditLog.getLogger();
        b = LoggerFactory.getLogger(LocalEventsRestController.class);
    }

    @GetMapping(path={"snapshots"})
    @Parameters(value={@Parameter(name="AxonIQ-Access-Token", description="Access Token", in=ParameterIn.HEADER)})
    public SseEmitter g(@RequestHeader(value="AxonIQ-Context", defaultValue="default", required=false) String context, @RequestParam(value="aggregateId", required=true) String aggregateId, @RequestParam(value="maxSequence", defaultValue="-1", required=false) long maxSequence, @RequestParam(value="initialSequence", defaultValue="0", required=false) long a3, @Parameter(hidden=true) Authentication a4) {
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a4);
        objectArray[1] = aggregateId;
        objectArray[2] = context;
        I.info(ApplicationJSON.g((Object)"\u0013\u001355h:-\u0019=\r;\u001ch\u001c'H:\r)\fh\u001b&\t8\u001b \u0007<\u001bh\u000e:\u0007%H$\u0007+\t$H-\u001e-\u0006<H;\u001c'\u001a-H.\u0007:H)\u000f/\u001a-\u000f)\u001c-H3\u0015h\u0001&H+\u0007&\u001c-\u0010<H3\u0015f"), objectArray);
        SseEmitter sseEmitter = new SseEmitter();
        K k = new K(a2 -> new EventsRestController.JsonEvent(a2.g()));
        aggregateId = GetAggregateSnapshotsRequest.newBuilder().setAggregateId(aggregateId).setInitialSequence(a3).setMaxSequence(maxSequence >= 0L ? maxSequence : Long.MAX_VALUE).build();
        this.h.aggregateSnapshots(context, a4, (GetAggregateSnapshotsRequest)aggregateId).doOnCancel(() -> sseEmitter.completeWithError((Throwable)new RuntimeException(DiagnosticsOptions.g((Object)"\u001e}!`;z543s5f7s3`74!z3d!|=`!41u<w7x>q6:")))).subscribe(arg_0 -> LocalEventsRestController.g(sseEmitter, (Function)k, arg_0), arg_0 -> ((SseEmitter)sseEmitter).completeWithError(arg_0), () -> ((SseEmitter)sseEmitter).complete());
        return sseEmitter;
    }

    private static /* synthetic */ void K(SseEmitter a2, Function a32, SerializedEvent a4) {
        try {
            a2.send(a32.apply(a4));
            return;
        }
        catch (IOException a32) {
            b.debug(DiagnosticsOptions.g((Object)"Q f=fr{<4!q<p;z54)i"), (Object)a4);
            return;
        }
    }

    private static /* synthetic */ void g(SseEmitter a2, Function a32, SerializedEventWithToken a4) {
        try {
            a2.send(a32.apply(a4.g()));
            return;
        }
        catch (IOException a32) {
            b.debug(ApplicationJSON.g((Object)"\r\u001a:\u0007:H'\u0006h\u001b-\u0006,\u0001&\u000fh\u00135"), (Object)a4);
            return;
        }
    }

    private static /* synthetic */ void g(SseEmitter a2, Function a32, SerializedEvent a4) {
        try {
            a2.send(a32.apply(a4));
            return;
        }
        catch (IOException a32) {
            b.debug(DiagnosticsOptions.g((Object)"Q f=fr{<4!q<p;z54)i"), (Object)a4);
            return;
        }
    }

    public LocalEventsRestController(LocalEventStore a2) {
        LocalEventsRestController a3;
        a3.h = a2;
    }
}

