/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.common.PluginKey;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.interceptor.PluginRemovedEvent;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.plugin.PluginController;
import io.axoniq.axonserver.plugin.PluginInfo;
import io.axoniq.axonserver.plugin.SimplePluginKey;
import io.axoniq.axonserver.rest.PluginConfigurationJSON;
import io.axoniq.axonserver.rest.PluginPropertyGroup;
import io.axoniq.axonserver.taskscheduler.TaskPublisher;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Parameter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"v1/plugins"})
@CrossOrigin
public class PluginsRestController {
    private final PluginController j;
    public static final String H = "Plugins disabled";
    private final boolean m;
    private static final Logger h = AuditLog.getLogger();
    private final FeatureChecker b;
    private final Logger I;

    @GetMapping(value={"configuration"})
    public Iterable<PluginPropertyGroup> g(@RequestParam(value="name") String name, @RequestParam(value="version") String version, @RequestParam(required=false, name="targetContext") String context, @Parameter(hidden=true) Principal a2) {
        if (!this.m || !this.b.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, H);
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)version);
        h.info(PluginRemovedEvent.g((Object)"\u001cy:_gP\"s2g4vgd(pga(l!k w5c3k(lgm!\"<\u007fhy:,g"), objectArray);
        try {
            return this.j.listProperties((PluginKey)new SimplePluginKey(name, version), context);
        }
        catch (RuntimeException runtimeException) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = name;
            objectArray2[1] = version;
            objectArray2[2] = runtimeException;
            this.I.warn(TaskPublisher.g((Object)"\u001d,2!>){94m)(/?2(-({=)\"+()92((m=\")m 0a6&"), objectArray2);
            throw runtimeException;
        }
    }

    @PostMapping(consumes={"multipart/form-data"})
    public PluginKey g(@RequestPart(value="bundle") MultipartFile pluginBundle22, @Parameter(hidden=true) Principal a2) throws IOException {
        MultipartFile pluginBundle22;
        block6: {
            if (!this.m || !this.b.plugins()) {
                throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, H);
            }
            h.info(PluginRemovedEvent.g((Object)"\u001cy:_gP\"s2g4vgv(\".l4v&n+\"7n2e.lgy:,g"), (Object)AuditLog.username((Principal)a2), (Object)StringUtils.sanitize((String)pluginBundle22.getOriginalFilename()));
            a2 = pluginBundle22.getInputStream();
            try {
                PluginsRestController pluginsRestController = this;
                String string = pluginsRestController.g(pluginBundle22.getOriginalFilename());
                pluginBundle22 = pluginsRestController.j.addPlugin(string, (InputStream)a2);
                if (a2 == null) break block6;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                block7: {
                    if (a2 != null) {
                        try {
                            ((InputStream)a2).close();
                            throwable2 = throwable;
                            break block7;
                        }
                        catch (Throwable pluginBundle22) {
                            throwable.addSuppressed(pluginBundle22);
                        }
                    }
                    throwable2 = throwable;
                }
                throw throwable2;
            }
            ((InputStream)a2).close();
        }
        return pluginBundle22;
    }

    @PostMapping(value={"configuration"})
    public void g(@RequestBody PluginConfigurationJSON configurationJSON, @Parameter(hidden=true) Principal a2) {
        if (!this.m || !this.b.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, H);
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)configurationJSON.getName());
        objectArray[2] = StringUtils.sanitize((String)configurationJSON.getVersion());
        h.info(TaskPublisher.g((Object)"\u00006&\u0010{\u001f><.((9{94m.=?,/({.4#=$<8),/$4#{\"=m 0t6&c{"), objectArray);
        this.j.updateConfiguration((PluginKey)new SimplePluginKey(configurationJSON.getName(), configurationJSON.getVersion()), configurationJSON.getContext(), configurationJSON.getProperties());
    }

    private /* synthetic */ String g(String a2) {
        if (a2 == null) {
            throw new MessagingPlatformException(ErrorCode.OTHER, PluginRemovedEvent.g((Object)"L(\"7n2e.lgr&a,c ggr5m1k#g#"));
        }
        if (a2.contains(File.separator)) {
            throw new MessagingPlatformException(ErrorCode.OTHER, TaskPublisher.g((Object)"\u001d$7(5,6({>3\".!?m5\"/m8\"59:$5m?$)(894?\"m((+,),/\")"));
        }
        int n = a2.lastIndexOf(46);
        if (n > 0) {
            return a2.substring(0, n) + "-" + System.currentTimeMillis() + a2.substring(n);
        }
        return a2 + "-" + System.currentTimeMillis();
    }

    @DeleteMapping
    public void g(@RequestParam(value="name") String name, @RequestParam(value="version") String version, @Parameter(hidden=true) Principal a2) {
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)version);
        h.info(PluginRemovedEvent.g((Object)"Y<\u007f\u001a\"\u0015g6w\"q3\"3mgw)k)q3c+ngr+w k)\"<\u007fhy:,g"), objectArray);
        this.j.uninstallPlugin((PluginKey)new SimplePluginKey(name, version));
    }

    @PostMapping(value={"status"})
    public void g(@RequestParam(value="name") String name, @RequestParam(value="version") String version, @RequestParam(required=false, name="targetContext") String context, @RequestParam boolean active, @Parameter(hidden=true) Principal a2) {
        if (!this.m || !this.b.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, H);
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = active ? PluginRemovedEvent.g((Object)"4v&p3") : TaskPublisher.g((Object)">/\"+");
        objectArray[2] = StringUtils.sanitize((String)name);
        objectArray[3] = StringUtils.sanitize((String)version);
        h.info(TaskPublisher.g((Object)"\u00006&\u0010{\u001f><.((9{94m 0{=78<$5m 0t6&c{"), objectArray);
        this.j.updatePluginStatus((PluginKey)new SimplePluginKey(name, version), context, active);
    }

    public PluginsRestController(PluginController a2, MessagingPlatformConfiguration a3, FeatureChecker a4) {
        PluginsRestController a5;
        PluginsRestController pluginsRestController = a5;
        PluginsRestController pluginsRestController2 = a5;
        pluginsRestController2.I = LoggerFactory.getLogger(PluginsRestController.class);
        pluginsRestController2.m = a3.isPluginsEnabled();
        pluginsRestController.j = a2;
        pluginsRestController.b = a4;
    }

    @DeleteMapping(value={"context"})
    public void g(@RequestParam(value="name") String name, @RequestParam(value="version") String version, @RequestParam(required=false, name="targetContext") String context, @Parameter(hidden=true) Principal a2) {
        if (!this.m || !this.b.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, H);
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)version);
        objectArray[3] = StringUtils.sanitize((String)context);
        h.info(PluginRemovedEvent.g((Object)"\u001cy:_gP\"s2g4vgv(\"2l5g k4v\"pgr+w k)\"<\u007fhy:\"!m5\"$m)v\"z3\"<\u007fi"), objectArray);
        this.j.unregisterPluginForContext((PluginKey)new SimplePluginKey(name, version), context);
    }

    @GetMapping
    public Iterable<PluginInfo> g(@Parameter(hidden=true) Principal a2) {
        h.info(TaskPublisher.g((Object)"\u0016 0\u0006m\t(*8>>/m/\"{!2>/m88)?>#/m+!.*2#(c{"), (Object)AuditLog.username((Principal)a2));
        return this.j.listPlugins();
    }
}

