/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.config.AccessControlConfiguration;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.config.SslConfiguration;
import io.axoniq.axonserver.message.command.CommandDispatcher;
import io.axoniq.axonserver.message.event.EventDispatcher;
import io.axoniq.axonserver.message.query.QueryDispatcher;
import io.axoniq.axonserver.message.query.subscription.metric.HubSubscriptionMetrics;
import io.axoniq.axonserver.message.query.subscription.metric.SubscriptionQueryMetricRegistry;
import io.axoniq.axonserver.plugin.PluginContextInfo;
import io.axoniq.axonserver.rest.LicenseInfo;
import io.axoniq.axonserver.rest.PublicRestController;
import io.axoniq.axonserver.rest.json.NodeConfiguration;
import io.axoniq.axonserver.rest.json.StatusInfo;
import io.axoniq.axonserver.rest.json.UserInfo;
import io.axoniq.axonserver.rest.svg.mapping.AxonServer;
import io.axoniq.axonserver.topology.Topology;
import io.axoniq.axonserver.version.VersionInfo;
import io.axoniq.axonserver.version.VersionInfoProvider;
import io.swagger.v3.oas.annotations.Operation;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@CrossOrigin
@RestController(value="PublicRestController")
@RequestMapping(value={"/v1/public"})
public class PublicRestController {
    private final Topology l;
    private final CommandDispatcher F;
    @Value(value="${axoniq.axonserver.devmode.enabled:false}")
    private boolean E;
    private final VersionInfoProvider i;
    private final EventDispatcher G;
    private final Function<Predicate<String>, Stream<AxonServer>> f;
    private final boolean c;
    private final QueryDispatcher j;
    private final AccessControlConfiguration H;
    private final SubscriptionQueryMetricRegistry m;
    private final Map<String, Boolean> h;
    private final SslConfiguration b;
    private final FeatureChecker I;

    @GetMapping(path={"license"})
    @Operation(summary="Retrieves license information")
    public LicenseInfo g() {
        PublicRestController a2;
        LicenseInfo licenseInfo;
        LicenseInfo licenseInfo2 = licenseInfo = new LicenseInfo();
        PublicRestController publicRestController = a2;
        licenseInfo.setExpiryDate(a2.I.getExpiryDate());
        licenseInfo.setEdition(publicRestController.I.getEdition());
        licenseInfo2.setLicensee(publicRestController.I.getLicensee());
        licenseInfo2.setFeatureList(a2.I.getFeatureList());
        return licenseInfo2;
    }

    @GetMapping(path={"me"})
    @Operation(summary="Retrieves general information on the configuration of the current node, including hostnames and ports for the gRPC and HTTP connections and contexts")
    public NodeConfiguration g() {
        PublicRestController a2;
        NodeConfiguration nodeConfiguration;
        NodeConfiguration nodeConfiguration2 = nodeConfiguration = new NodeConfiguration(a2.l.getMe());
        PublicRestController publicRestController = a2;
        NodeConfiguration nodeConfiguration3 = nodeConfiguration;
        PublicRestController publicRestController2 = a2;
        nodeConfiguration.setAuthentication(a2.H.isEnabled());
        nodeConfiguration.setSsl(publicRestController2.b.isEnabled());
        nodeConfiguration3.setAdminNode(publicRestController2.l.isAdminNode());
        nodeConfiguration3.setDevelopmentMode(a2.E);
        nodeConfiguration.setContextNames(publicRestController.l.getMyContextNames());
        nodeConfiguration2.setStorageContextNames(publicRestController.l.getMyStorageContextNames());
        nodeConfiguration2.setPluginsEnabled(a2.c && a2.I.plugins());
        NodeConfiguration nodeConfiguration4 = nodeConfiguration;
        PublicRestController publicRestController3 = a2;
        nodeConfiguration.setInitialized(a2.l.initialized());
        nodeConfiguration.setMaxApplications(publicRestController3.I.getMaxApplications());
        nodeConfiguration4.setMaxConnections(publicRestController3.I.maxConnections());
        nodeConfiguration4.setMaxContexts(a2.I.getMaxContexts().orElse(Integer.MAX_VALUE).intValue());
        nodeConfiguration.setMaxReplicationGroups(a2.I.getMaxReplicationGroups().orElse(Integer.MAX_VALUE).intValue());
        NodeConfiguration nodeConfiguration5 = nodeConfiguration;
        nodeConfiguration5.setMaxUsers(a2.I.getMaxUsers());
        return nodeConfiguration5;
    }

    @GetMapping(path={"status"})
    @Operation(summary="Retrieves status information, used by UI")
    public StatusInfo g(@RequestParam(value="context", defaultValue="default", required=false) String a2) {
        StatusInfo statusInfo;
        HubSubscriptionMetrics hubSubscriptionMetrics = this.m.get(a2);
        StatusInfo statusInfo2 = statusInfo = new StatusInfo();
        statusInfo2.setCommandRate(this.F.commandRate(a2));
        statusInfo2.setQueryRate(this.j.queryRate(a2));
        if (!a2.startsWith(PluginContextInfo.g((Object)"S"))) {
            StatusInfo statusInfo3 = statusInfo;
            PublicRestController publicRestController = this;
            statusInfo.setEventRate(this.G.eventRate(a2));
            statusInfo.setSnapshotRate(publicRestController.G.snapshotRate(a2));
            statusInfo3.setNrOfEvents(publicRestController.G.getNrOfEvents(a2));
            statusInfo3.setEventTrackers(this.G.eventTrackerStatus(a2));
        }
        StatusInfo statusInfo4 = statusInfo;
        HubSubscriptionMetrics hubSubscriptionMetrics2 = hubSubscriptionMetrics;
        statusInfo.setNrOfActiveSubscriptionQueries(hubSubscriptionMetrics2.activesCount().longValue());
        statusInfo4.setNrOfSubscriptionQueries(hubSubscriptionMetrics2.totalCount().longValue());
        statusInfo4.setNrOfSubscriptionQueriesUpdates(hubSubscriptionMetrics.updatesCount().longValue());
        return statusInfo;
    }

    @GetMapping
    @Operation(summary="Retrieves all nodes in the cluster that the current node knows about.", description="For _admin nodes the result contains all nodes, for non _admin nodes theresult only contains nodes from contexts available on this node and the _admin nodes.")
    public List<JsonServerNode> g() {
        PublicRestController a2;
        return ((Stream)a2.f.apply(null)).map(JsonServerNode::new).sorted(Comparator.comparing(JsonServerNode::getName)).collect(Collectors.toList());
    }

    @GetMapping(path={"mycontexts"})
    @Operation(summary="Retrieves names for all storage (non admin) contexts for the current node")
    public Iterable<String> g() {
        PublicRestController a2;
        return a2.l.getMyStorageContextNames();
    }

    @GetMapping(path={"version"})
    @Operation(summary="Retrieves version information of the product")
    public VersionInfo g() {
        PublicRestController a2;
        return a2.i.get();
    }

    public PublicRestController(Function<Predicate<String>, Stream<AxonServer>> a2, Topology a3, CommandDispatcher a4, QueryDispatcher a5, EventDispatcher a6, FeatureChecker a7, MessagingPlatformConfiguration a8, VersionInfoProvider a9, SubscriptionQueryMetricRegistry a10) {
        PublicRestController a11;
        PublicRestController publicRestController = a11;
        PublicRestController publicRestController2 = a11;
        MessagingPlatformConfiguration messagingPlatformConfiguration = a8;
        PublicRestController publicRestController3 = a11;
        PublicRestController publicRestController4 = a11;
        PublicRestController publicRestController5 = a11;
        a11.f = a2;
        publicRestController5.l = a3;
        publicRestController5.F = a4;
        publicRestController4.j = a5;
        publicRestController4.G = a6;
        publicRestController3.I = a7;
        publicRestController3.b = a8.getSsl();
        a11.H = messagingPlatformConfiguration.getAccesscontrol();
        publicRestController2.c = messagingPlatformConfiguration.isPluginsEnabled();
        publicRestController2.i = a9;
        publicRestController.m = a10;
        publicRestController.h = a8.getPreview();
    }

    @GetMapping(path={"user"})
    @Operation(summary="Retrieves information on the user logged in in the current Http Session")
    public UserInfo g(HttpServletRequest a2) {
        if (a2.getUserPrincipal() instanceof Authentication) {
            a2 = (Authentication)a2.getUserPrincipal();
            return new UserInfo(a2.getName(), a2.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet()));
        }
        return null;
    }
}

