/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.taskscheduler;

import io.axoniq.axonserver.cluster.grpc.RaftGroupManager;
import io.axoniq.axonserver.configuration.runtime.RuntimeConfigurationFactory;
import io.axoniq.axonserver.configuration.runtime.Task;
import io.axoniq.axonserver.configuration.runtime.TaskPayload;
import io.axoniq.axonserver.configuration.runtime.Tasks;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.grpc.TaskStatus;
import io.axoniq.axonserver.grpc.tasks.ScheduleTask;
import io.axoniq.axonserver.grpc.tasks.UpdateTask;
import io.axoniq.axonserver.localstorage.SerializedEvent;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.replication.ReplicationLeaderProvider;
import io.axoniq.axonserver.taskscheduler.BaseTaskManager;
import io.axoniq.axonserver.taskscheduler.C;
import io.axoniq.axonserver.taskscheduler.ScheduledTaskExecutor;
import io.axoniq.axonserver.taskscheduler.TaskResultPublisher;
import java.time.Clock;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class ClusterTaskManager
extends BaseTaskManager {
    private final RaftGroupManager h;
    private final RuntimeConfigurationFactory b;
    private final TaskResultPublisher I;

    @EventListener
    @Transactional
    public void on(ClusterEvents.ReplicationGroupDeleted a2) {
        ClusterTaskManager a3;
        m.debug(SerializedEvent.g((Object)"\u001a\u00022\u0002*\u000e0\u0000~\u0013?\u00145\u0014~\u00011\u0015~\u001c#"), (Object)a2.replicationGroup());
        a3.deleteAllByReplicationGroup(a2.replicationGroup());
    }

    public void updateTask(UpdateTask a2) {
        ClusterTaskManager a4;
        a4.J.findById(a2.getTaskId()).ifPresent(a3 -> {
            ClusterTaskManager a4;
            a4.g(a3, a2);
        });
    }

    private /* synthetic */ void K(String a3) {
        ClusterTaskManager a4;
        if ((a3 = (Map)a4.A.remove(a3)) != null) {
            a3.values().forEach(a2 -> a2.cancel(false));
        }
    }

    public void schedule(String a2, ScheduleTask a3) {
        ClusterTaskManager a4;
        ClusterTaskManager clusterTaskManager = a4;
        String string = a2 = clusterTaskManager.b.task(a3.getTaskId(), a3.getTaskExecutor(), a2, (TaskPayload)new C(a4, a3));
        string.setRetryInterval(Long.valueOf(a3.getRetryInterval()));
        a2.setTimestamp(Long.valueOf(a3.getInstant()));
        string.setStatus(TaskStatus.SCHEDULED);
        clusterTaskManager.saveAndSchedule((Task)a2);
    }

    public ClusterTaskManager(ScheduledTaskExecutor taskExecutor, Tasks taskRepository, TaskResultPublisher taskResultPublisher, ReplicationLeaderProvider raftLeaderProvider, PlatformTransactionManager platformTransactionManager, @Qualifier(value="taskScheduler") ScheduledExecutorService scheduler, MeterFactory meterFactory, Clock clock, RaftGroupManager raftGroupManager, RuntimeConfigurationFactory a2) {
        super(taskExecutor, taskRepository, () -> ((ReplicationLeaderProvider)raftLeaderProvider).leaderFor(), arg_0 -> ((ReplicationLeaderProvider)raftLeaderProvider).isLeader(arg_0), platformTransactionManager, scheduler, meterFactory, clock);
        ClusterTaskManager clusterTaskManager = this;
        this.I = taskResultPublisher;
        clusterTaskManager.h = raftGroupManager;
        clusterTaskManager.b = a2;
    }

    public List<Task> findAllByReplicationGroup(String a2) {
        ClusterTaskManager a3;
        return a3.J.findAllByContext(a2);
    }

    @EventListener
    @Order(value=100)
    public void on(ClusterEvents.BecomeLeader a2) {
        ClusterTaskManager a4;
        a4.h.currentTerm(a2.replicationGroup()).ifPresent(a3 -> {
            ClusterTaskManager a4;
            if (a2.term() < a3) {
                return;
            }
            a4.g(a2.replicationGroup());
        });
    }

    @EventListener
    public void on(ClusterEvents.LeaderStepDown a2) {
        ClusterTaskManager a3;
        a3.K(a2.replicationGroup());
    }

    private /* synthetic */ void g(Task a2, UpdateTask a4) {
        ClusterTaskManager a5;
        if (a5.H.test(a2.getReplicationGroup())) {
            a5.unschedule(a2.getReplicationGroup(), a2.getTaskId());
        }
        if (TaskStatus.COMPLETED.equals((Object)a4.getStatus()) || TaskStatus.CANCELLED.equals((Object)a4.getStatus())) {
            new TransactionTemplate(a5.i).execute(a3 -> {
                ClusterTaskManager a4;
                a4.J.delete(a2);
                return null;
            });
            return;
        }
        Task task = a2;
        UpdateTask updateTask = a4;
        Task task2 = a2;
        task2.setTimestamp(Long.valueOf(a4.getInstant()));
        task2.setRetryInterval(Long.valueOf(a4.getRetryInterval()));
        task.setStatus(updateTask.getStatus());
        task.setMessage(updateTask.getErrorMessage());
        new TransactionTemplate(a5.i).execute(a3 -> {
            ClusterTaskManager a4;
            return a4.J.save(a2);
        });
        a5.doScheduleTask(a2);
    }

    protected CompletableFuture<Void> processResult(String a2, String a3, TaskStatus a4, long a5, long a6, String a7) {
        ClusterTaskManager a8;
        return a8.I.publishResult(a2, a3, a4, Long.valueOf(a5), a6, a7);
    }

    private /* synthetic */ void g(String a2) {
        ClusterTaskManager a3;
        a3.J.findScheduled(a2, 0L, a3.b.get()).forEach(arg_0 -> ((ClusterTaskManager)a3).doScheduleTask(arg_0));
    }

    @Transactional
    public void deleteAllByReplicationGroup(String a2) {
        ClusterTaskManager a3;
        ClusterTaskManager clusterTaskManager = a3;
        clusterTaskManager.K(a2);
        clusterTaskManager.J.deleteAllByContext(a2);
    }
}

