/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.grpc;

import io.axoniq.axonserver.AxonServerAccessController;
import io.axoniq.axonserver.admin.user.requestprocessor.UserController;
import io.axoniq.axonserver.configuration.admin.AdminUser;
import io.axoniq.axonserver.configuration.admin.AdminUserRole;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.AxonServerClientService;
import io.axoniq.axonserver.grpc.GrpcExceptionBuilder;
import io.axoniq.axonserver.grpc.admin.ApplicationRoles;
import io.axoniq.axonserver.grpc.admin.AuthenticateUserRequest;
import io.axoniq.axonserver.grpc.admin.AuthenticationServiceGrpc;
import io.axoniq.axonserver.grpc.admin.ContextRole;
import io.axoniq.axonserver.grpc.admin.Token;
import io.axoniq.axonserver.grpc.admin.UserRoles;
import io.axoniq.axonserver.localstorage.SerializedTransactionWithToken;
import io.axoniq.axonserver.localstorage.file.EventSourceNotFoundException;
import io.grpc.stub.StreamObserver;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Controller;

@Controller
public class AuthenticationGrpcController
extends AuthenticationServiceGrpc.AuthenticationServiceImplBase
implements AxonServerClientService {
    private final AxonServerAccessController h;
    private final UserController b;
    private final PasswordEncoder I;

    public void authenticateToken(Token a22, StreamObserver<ApplicationRoles> a4) {
        try {
            AuthenticationGrpcController a5;
            a22 = a5.h.authenticate(a22.getToken());
            ApplicationRoles.Builder builder = ApplicationRoles.newBuilder().setApplicationName(a22.getName());
            a22.getAuthorities().forEach(a3 -> {
                AuthenticationGrpcController a4;
                builder.addApplicationRole(a4.g(a3));
            });
            StreamObserver<ApplicationRoles> streamObserver = a4;
            streamObserver.onNext((Object)builder.build());
            streamObserver.onCompleted();
            return;
        }
        catch (Exception a22) {
            a4.onError((Throwable)GrpcExceptionBuilder.build((Throwable)a22));
            return;
        }
    }

    public void authenticateUser(AuthenticateUserRequest a2, StreamObserver<UserRoles> a3) {
        AuthenticationGrpcController a4;
        AdminUser adminUser = a4.b.findUser(a2.getUserName());
        if (adminUser == null) {
            a3.onError((Throwable)GrpcExceptionBuilder.build((Throwable)new MessagingPlatformException(ErrorCode.AUTHENTICATION_INVALID_TOKEN, SerializedTransactionWithToken.g((Object)"tKKDQLY\u0005QJZLS"))));
            return;
        }
        if (!a4.I.matches((CharSequence)a2.getPassword(), adminUser.getPassword())) {
            a3.onError((Throwable)GrpcExceptionBuilder.build((Throwable)new MessagingPlatformException(ErrorCode.AUTHENTICATION_INVALID_TOKEN, EventSourceNotFoundException.g((Object)"'j\u0018e\u0002m\n$\u0002k\tm\u0000"))));
            return;
        }
        a2 = UserRoles.newBuilder().setUserName(adminUser.getUserName());
        adminUser.getRoles().forEach(arg_0 -> a4.g((UserRoles.Builder)a2, arg_0));
        StreamObserver<UserRoles> streamObserver = a3;
        streamObserver.onNext((Object)a2.build());
        streamObserver.onCompleted();
    }

    private /* synthetic */ ContextRole g(String a2, String a3) {
        return ContextRole.newBuilder().setRole(a2).setContext(a3).build();
    }

    public AuthenticationGrpcController(UserController a2, AxonServerAccessController a3, PasswordEncoder a4) {
        AuthenticationGrpcController a5;
        AuthenticationGrpcController authenticationGrpcController = a5;
        a5.b = a2;
        authenticationGrpcController.h = a3;
        authenticationGrpcController.I = a4;
    }

    private /* synthetic */ ContextRole g(GrantedAuthority a2) {
        AuthenticationGrpcController a3;
        a2 = a2.getAuthority().split(SerializedTransactionWithToken.g((Object)"}"), 2);
        if (a2.length == 2) {
            return a3.g(a2[0], a2[1]);
        }
        return a3.g(a2[0], a3.h.defaultContextForRest());
    }

    private /* synthetic */ void g(UserRoles.Builder a2, AdminUserRole a3) {
        AuthenticationGrpcController a4;
        a2.addUserRoles(a4.g(a3.getRole(), a3.getContext()));
    }
}

