/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest;

import io.axoniq.axonserver.admin.context.api.ContextAdminService;
import io.axoniq.axonserver.admin.context.api.ContextOverview;
import io.axoniq.axonserver.admin.context.api.ContextPropertiesUpdate;
import io.axoniq.axonserver.admin.context.api.RemoveContext;
import io.axoniq.axonserver.admin.context.api.ReplicationGroupContext;
import io.axoniq.axonserver.admin.context.requestprocessor.DefaultContextPropertiesUpdate;
import io.axoniq.axonserver.admin.replicationgroup.api.ReplicationGroup;
import io.axoniq.axonserver.admin.replicationgroup.api.ReplicationGroupAdminService;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroup;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroupMember;
import io.axoniq.axonserver.enterprise.replication.ContextLeaderProvider;
import io.axoniq.axonserver.enterprise.replication.admin.AdminReplicationGroupController;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.localstorage.ContextPropertyDefinition;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.replication.ReplicationLeaderProvider;
import io.axoniq.axonserver.rest.ContextJSON;
import io.axoniq.axonserver.rest.NodeAndRole;
import io.axoniq.axonserver.rest.json.RestResponse;
import io.axoniq.axonserver.rest.svg.mapping.AxonServers;
import io.axoniq.axonserver.transport.rest.A;
import io.axoniq.axonserver.transport.rest.B;
import io.axoniq.axonserver.transport.rest.J;
import io.axoniq.axonserver.transport.rest.PrincipalAuthentication;
import io.axoniq.axonserver.util.StringUtils;
import io.axoniq.axonserver.version.VersionInfo;
import io.swagger.v3.oas.annotations.Parameter;
import java.security.Principal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Deprecated
@RestController
@CrossOrigin
@RequestMapping(value={"/v1"})
public class ContextRestController {
    private final ReplicationLeaderProvider c;
    private final ContextLeaderProvider j;
    private final Logger H;
    private final ContextAdminService m;
    private static final Logger h = AuditLog.getLogger();
    private final AdminReplicationGroupController b;
    private final ReplicationGroupAdminService I;

    @GetMapping(value={"public/context-properties"})
    public ContextPropertyDefinition[] g(@Parameter(hidden=true) Principal a2) {
        h.info(AxonServers.g((Object)"2C\u0014eIj\fI\u001c]\u001aLIL\u0006\u0018\u000e]\u001d\u0018\nW\u0007L\f@\u001d\u0018\u0019J\u0006H\fJ\u001dQ\fKG"), (Object)AuditLog.username((Principal)a2));
        return ContextPropertyDefinition.values();
    }

    @PatchMapping(path={"context/{name}"})
    public Mono<ResponseEntity<RestResponse>> g(@PathVariable(name="name") String name, @RequestBody @Valid Map<String, String> metaData, @Parameter(hidden=true) Principal a3) {
        return this.m.updateContext((ContextPropertiesUpdate)new DefaultContextPropertiesUpdate(name, metaData), (Authentication)new PrincipalAuthentication(a3)).thenReturn((Object)this.g(VersionInfo.g((Object)"n\u0006L\u0000_\u0011J\u0001\u000f\u0010_\u0001N\u0011JEL\nA\u0011J\u001d[E]\u0000^\u0010J\u0016["))).onErrorResume(a2 -> Mono.just((Object)new RestResponse(false, a2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)a2))));
    }

    public Mono<Void> K(String a3) {
        ContextRestController a4;
        return a4.g(a3).repeatWhenEmpty(100, a2 -> a2.delayElements(Duration.ofMillis(100L))).onErrorMap(IllegalStateException.class, a2 -> new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, VersionInfo.g((Object)"0A\u0004M\tJE[\n\u000f\u0003F\u000bKEC\u0000N\u0001J\u0017\u000f\u0003@\u0017\u000f\u0011G\u0000\u000f\u000bJ\u0012C\u001c\u000f\u0006]\u0000N\u0011J\u0001\u000f\u0017J\u0015C\fL\u0004[\f@\u000b\u000f\u0002]\nZ\u0015\u000f\u0012F\u0011G\fAE[\rJE]\u0000^\u0010F\u0017J\u0001\u000f\u0011F\bJ"))).then();
    }

    private /* synthetic */ Mono<Void> K(String a2, boolean a3, Principal a4) {
        ContextRestController a5;
        return a5.m.deleteContext((RemoveContext)new J(a5, a2, a3), (Authentication)new PrincipalAuthentication(a4));
    }

    @DeleteMapping(path={"context/{name}"})
    public Mono<ResponseEntity<RestResponse>> g(@PathVariable(value="name") String name, @RequestParam(name="preserveEventStore", required=false, defaultValue="false") boolean preserveEventStore, @Parameter(hidden=true) Principal a3) {
        return this.K(name, preserveEventStore, a3).thenReturn((Object)this.g(AxonServers.g((Object)"([\n]\u0019L\f\\I\\\fT\fL\f\u0018\nW\u0007L\f@\u001d\u0018\u001b]\u0018M\fK\u001d"))).onErrorResume(a2 -> Mono.just((Object)new RestResponse(false, a2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)a2))));
    }

    @GetMapping(path={"public/context"})
    public Flux<ContextJSON> K(@Parameter(hidden=true) Principal a3) {
        return this.m.getContexts((Authentication)new PrincipalAuthentication(a3)).map(a2 -> {
            ContextRestController a3;
            ContextJSON contextJSON = new ContextJSON(a2.name());
            ContextOverview contextOverview = a2;
            contextJSON.setChangePending(contextOverview.replicationGroup().changePending());
            if (contextOverview.pendingSince() != null) {
                contextJSON.setPendingSince(Objects.requireNonNull(a2.pendingSince()).getTime());
            }
            ContextJSON contextJSON2 = contextJSON;
            ContextOverview contextOverview2 = a2;
            contextJSON.setLeader(a3.j.getLeader(a2.name()));
            contextJSON2.setReplicationGroup(contextOverview2.replicationGroup().name());
            contextJSON2.setRoles(contextOverview2.replicationGroup().members().stream().map(NodeAndRole::new).sorted().collect(Collectors.toList()));
            if (a2.replicationGroup().members().stream().anyMatch(AdminReplicationGroupMember::isPendingDelete)) {
                contextJSON.setChangePending(true);
            }
            ContextJSON contextJSON3 = contextJSON;
            contextJSON3.setMetaData(a2.metaData());
            return contextJSON3;
        }).sort(Comparator.comparing(ContextJSON::getContext));
    }

    @PostMapping(path={"context"})
    public Mono<ResponseEntity<RestResponse>> g(@RequestBody @Valid ContextJSON contextJson, @Parameter(hidden=true) Principal a3) {
        return Mono.defer(() -> {
            ContextRestController a4;
            String string;
            Mono mono = Mono.empty();
            String string2 = string = StringUtils.isEmpty((String)contextJson.getReplicationGroup()) ? contextJson.getContext() : contextJson.getReplicationGroup();
            if ((AdminReplicationGroup)a4.b.findByName(string).orElse(null) == null) {
                if (contextJson.getRoles() == null || contextJson.getRoles().isEmpty()) {
                    throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, AxonServers.g((Object)"$Q\u001aK\u0000V\u000e\u0018\u001b]\u0019T\u0000[\bL\u0000W\u0007\u0018\u000eJ\u0006M\u0019\u0018\u0007W\r]\u001a"));
                }
                mono = a4.g(contextJson, string, (Authentication)new PrincipalAuthentication(a3)).then(a4.K(string));
            }
            mono = mono.then(a4.g(contextJson, string, a3).timeout(Duration.ofSeconds(45L)));
            return mono;
        }).thenReturn((Object)this.g(AxonServers.g((Object)"y\n[\fH\u001d]\r\u0018\b\\\r\u0018\nW\u0007L\f@\u001d\u0018\u001b]\u0018M\fK\u001d"))).onErrorResume(a2 -> Mono.just((Object)new RestResponse(false, a2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)a2))));
    }

    @PostMapping(path={"context/init"})
    public Mono<ResponseEntity<RestResponse>> g(@RequestParam(name="context", required=false) String context, @Parameter(hidden=true) Principal a3) {
        return Mono.defer(() -> {
            ContextRestController contextRestController;
            ContextRestController a4;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (StringUtils.isEmpty((String)context)) {
                contextRestController = a4;
                arrayList.add("default");
            } else {
                arrayList.add(context);
                contextRestController = a4;
            }
            return contextRestController.m.initCluster(arrayList, (Authentication)new PrincipalAuthentication(a3));
        }).thenReturn((Object)this.g(VersionInfo.g((Object)"n\u0006L\u0000_\u0011J\u0001\u000f\fA\f[EL\tZ\u0016[\u0000]E]\u0000^\u0010J\u0016["))).onErrorResume(a2 -> Mono.just((Object)new RestResponse(false, a2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)a2))));
    }

    private /* synthetic */ Mono<Void> g(ContextJSON a2, String a3, Principal a4) {
        ContextRestController a5;
        return a5.m.createContext((ReplicationGroupContext)new A(a5, a2, a3), (Authentication)new PrincipalAuthentication(a4));
    }

    private /* synthetic */ Mono<Void> g(ContextJSON a2, String a3, Authentication a4) {
        ContextRestController a5;
        return a5.I.createReplicationGroup((ReplicationGroup)new B(a5, a3, a2), a4);
    }

    public ContextRestController(ContextAdminService a2, ReplicationGroupAdminService a3, ContextLeaderProvider a4, ReplicationLeaderProvider a5, AdminReplicationGroupController a6) {
        ContextRestController a7;
        ContextRestController contextRestController = a7;
        ContextRestController contextRestController2 = a7;
        ContextRestController contextRestController3 = a7;
        contextRestController3.H = LoggerFactory.getLogger(ContextRestController.class);
        contextRestController3.m = a2;
        contextRestController2.I = a3;
        contextRestController2.j = a4;
        contextRestController.c = a5;
        contextRestController.b = a6;
    }

    @GetMapping(path={"public/visiblecontexts"})
    public Mono<List<String>> g(@RequestParam(name="includeAdmin", required=false, defaultValue="false") boolean includeAdmin, @Parameter(hidden=true) Principal a2) {
        return this.m.getVisibleContexts(includeAdmin, (Authentication)new PrincipalAuthentication(a2)).collectList();
    }

    private /* synthetic */ ResponseEntity<RestResponse> g(String a2) {
        return ResponseEntity.accepted().body((Object)new RestResponse(true, a2));
    }

    public Mono<String> g(String a2) {
        ContextRestController a3;
        return Mono.fromCallable(() -> {
            ContextRestController a3;
            return a3.c.getLeader(a2);
        }).subscribeOn(Schedulers.boundedElastic());
    }

    @GetMapping(path={"public/context/updates"}, produces={"text/event-stream"})
    public Flux<ServerSentEvent<String>> g(@Parameter(hidden=true) Principal a3) {
        a3 = this.m.subscribeContextUpdates((Authentication)new PrincipalAuthentication(a3)).doOnSubscribe(a2 -> {
            ContextRestController a3;
            a3.H.info(AxonServers.g((Object)":M\u000bK\nJ\u0000Z\f\\IL\u0006\u0018\nW\u0007L\f@\u001d\u0018\u001cH\rY\u001d]\u001a"));
        }).doOnError(a2 -> {
            ContextRestController a3;
            a3.H.warn(VersionInfo.g((Object)" ]\u0017@\u0017\u000f\nL\u0006Z\u0017]\u0000KEX\rF\tJEC\f\\\u0011F\u000bHEI\n]EL\nA\u0011J\u001d[EZ\u0015K\u0004[\u0000\\_\u000f\u001eR"), (Object)a2.getMessage());
        }).onErrorResume(a2 -> Mono.empty()).map(a2 -> ServerSentEvent.builder().data((Object)a2.name()).event(a2.state().name()).build());
        Flux flux = Flux.interval((Duration)Duration.ofSeconds(2L)).map(a2 -> ServerSentEvent.builder().event(VersionInfo.g((Object)"\u000eJ\u0000_HN\tF\u0013J")).build());
        Publisher[] publisherArray = new Publisher[2];
        publisherArray[0] = a3;
        publisherArray[1] = flux;
        return Flux.merge((Publisher[])publisherArray);
    }
}

