/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.axoniq.axonserver.admin.context.requestprocessor.VisibleContextCache;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.eventstore.transformation.api.EventStoreTransformationService;
import io.axoniq.axonserver.plugin.PluginPackageProvider;
import io.axoniq.axonserver.rest.EventsRestController;
import io.axoniq.axonserver.transport.rest.PrincipalAuthentication;
import java.security.Principal;
import java.util.UUID;
import javax.validation.Valid;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import springfox.documentation.annotations.ApiIgnore;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@RestController
@ConditionalOnProperty(value={"axoniq.axonserver.event-transformation.enabled"}, matchIfMissing=true)
public class EventStoreTransformationRestController {
    private final EventStoreTransformationService I;

    @PatchMapping(value={"v1/transformations/{transformationId}/apply"})
    public void g(@RequestHeader(value="AxonIQ-Context", defaultValue="default", required=false) String context, @PathVariable(value="transformationId") String transformationId, @RequestParam(value="lastSequence") long lastSequence, @ApiIgnore org.springframework.security.core.Authentication a2) {
        this.I.startApplying(context, transformationId, lastSequence, (Authentication)new PrincipalAuthentication((Principal)a2)).block();
    }

    public static String g(Object a2) {
        a2 = (String)a2;
        int n = ((String)a2).length();
        int n2 = n - 1;
        char[] cArray = new char[n];
        char c2 = '\u0001';
        int cfr_ignored_0 = (2 ^ 5) << 4 ^ 2 << 1;
        int n3 = n2;
        int n4 = (3 ^ 5) << 4 ^ 5;
        while (n3 >= 0) {
            int n5 = n2--;
            cArray[n5] = (char)(((String)a2).charAt(n5) ^ n4);
            if (n2 < 0) break;
            int n6 = n2--;
            cArray[n6] = (char)(((String)a2).charAt(n6) ^ c2);
            n3 = n2;
        }
        return new String(cArray);
    }

    @PostMapping(value={"v1/transformations"})
    public String g(@RequestHeader(value="AxonIQ-Context", defaultValue="default", required=false) String context, @RequestParam(value="description") String description, @ApiIgnore Principal a2) {
        String string;
        String string2 = string = UUID.randomUUID().toString();
        this.I.start(string2, context, description, (Authentication)new PrincipalAuthentication(a2)).block();
        return string2;
    }

    @PostMapping(value={"v1/eventstore/compact"})
    public void g(@RequestHeader(value="AxonIQ-Context", defaultValue="default", required=false) String context, @ApiIgnore org.springframework.security.core.Authentication a2) {
        String string = UUID.randomUUID().toString();
        this.I.startCompacting(string, context, (Authentication)new PrincipalAuthentication((Principal)a2)).block();
    }

    @PatchMapping(value={"v1/transformations/{transformationId}/event/replace/{token}"})
    public void g(@RequestHeader(value="AxonIQ-Context", defaultValue="default", required=false) String context, @PathVariable(value="transformationId") String transformationId, @PathVariable(value="token") long token, @Valid @RequestBody EventsRestController.JsonEvent event, @RequestParam(value="sequence") long a2, @ApiIgnore Principal a3) {
        this.I.replaceEvent(context, transformationId, token, event.asEvent(), a2, (Authentication)new PrincipalAuthentication(a3)).block();
    }

    @GetMapping(value={"v1/transformations"})
    public Flux<ObjectNode> g(@RequestHeader(value="AxonIQ-Context", defaultValue="default", required=false) String context, @ApiIgnore org.springframework.security.core.Authentication a3) {
        return this.I.transformations(context, (Authentication)new PrincipalAuthentication((Principal)a3)).map(a2 -> {
            ObjectNode objectNode;
            ObjectNode objectNode2 = objectNode = new ObjectMapper().createObjectNode();
            objectNode2.put(PluginPackageProvider.g((Object)"1*"), a2.id());
            objectNode2.put(VisibleContextCache.g((Object)"hlwyWhuxacgh"), (Long)a2.lastSequence().orElse(null));
            objectNode.put(PluginPackageProvider.g((Object)"+:9:-="), a2.status().name());
            return objectNode;
        });
    }

    public EventStoreTransformationRestController(EventStoreTransformationService a2) {
        EventStoreTransformationRestController a3;
        a3.I = a2;
    }

    @PatchMapping(value={"v1/transformations/{transformationId}/event/delete/{token}"})
    public void g(@RequestHeader(value="AxonIQ-Context", defaultValue="default", required=false) String context, @PathVariable(value="transformationId") String transformationId, @PathVariable(value="token") long token, @RequestParam(value="sequence") long a2, @ApiIgnore Principal a3) {
        this.I.deleteEvent(context, transformationId, token, a2, (Authentication)new PrincipalAuthentication(a3)).block();
    }

    @PatchMapping(value={"v1/transformations/{transformationId}/cancel"})
    public void g(@RequestHeader(value="AxonIQ-Context", defaultValue="default", required=false) String context, @PathVariable(value="transformationId") String transformationId, @ApiIgnore Principal a2) {
        this.I.cancel(context, transformationId, (Authentication)new PrincipalAuthentication(a2)).block();
    }
}

