/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest;

import io.axoniq.axonserver.admin.replicationgroup.api.JoinReplicationGroup;
import io.axoniq.axonserver.admin.replicationgroup.api.LeaveReplicationGroup;
import io.axoniq.axonserver.admin.replicationgroup.api.RemoveReplicationGroup;
import io.axoniq.axonserver.admin.replicationgroup.api.ReplicationGroup;
import io.axoniq.axonserver.admin.replicationgroup.api.ReplicationGroupAdminService;
import io.axoniq.axonserver.admin.replicationgroup.api.ReplicationGroupOverview;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroupMember;
import io.axoniq.axonserver.exception.CriticalEventException;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.cluster.Role;
import io.axoniq.axonserver.localstorage.file.EventSourceNotFoundException;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.replication.ReplicationLeaderProvider;
import io.axoniq.axonserver.rest.ContextJSON;
import io.axoniq.axonserver.rest.NodeAndRole;
import io.axoniq.axonserver.rest.ReplicationGroupJSON;
import io.axoniq.axonserver.rest.json.RestResponse;
import io.axoniq.axonserver.transport.rest.F;
import io.axoniq.axonserver.transport.rest.G;
import io.axoniq.axonserver.transport.rest.K;
import io.axoniq.axonserver.transport.rest.PrincipalAuthentication;
import io.axoniq.axonserver.transport.rest.f;
import io.swagger.v3.oas.annotations.Parameter;
import java.security.Principal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@CrossOrigin
@RequestMapping(value={"/v1"})
public class ReplicationGroupRestController {
    private final ReplicationGroupAdminService m;
    private final ReplicationLeaderProvider h;
    private final Logger b;
    private static final Logger I = AuditLog.getLogger();

    @GetMapping(path={"replicationgroups/roles"})
    public Set<String> g(@Parameter(hidden=true) Principal a3) {
        I.info(EventSourceNotFoundException.g((Object)"5\u007f\u0013YNV\u000bu\u001ba\u001dpNp\u0001$\u0002m\u001dpNv\u000bt\u0002m\re\u001am\u0001jNc\u001ck\u001btNv\u0001h\u000bw@"), (Object)AuditLog.username((Principal)a3));
        return Arrays.stream(Role.values()).filter(a2 -> {
            if (!Role.UNRECOGNIZED.equals(a2)) {
                return true;
            }
            return false;
        }).map(Enum::name).collect(Collectors.toSet());
    }

    private /* synthetic */ Mono<Void> g(String a2, String a3, String a4, Authentication a5) {
        ReplicationGroupRestController a6;
        return a6.m.addNodeToReplicationGroup((JoinReplicationGroup)new G(a6, a3, a2, a4), a5);
    }

    @PostMapping(path={"replicationgroups/{replicationgroup}/{node}"})
    public Mono<ResponseEntity<RestResponse>> K(@PathVariable(value="replicationgroup") String name, @PathVariable(value="node") String node, @RequestParam(value="role", required=false, defaultValue="PRIMARY") String role, @Parameter(hidden=true) Principal a2) {
        return Mono.defer(() -> {
            ReplicationGroupRestController a7;
            ReplicationGroupRestController replicationGroupRestController = a7;
            replicationGroupRestController.b.info(CriticalEventException.g((Object)"Xt}0w\u007f}u9b|alujd9b|s|you}0\u007f\u007fk0w\u007f}u#0bm9=9qwt9sv~muad#0bm"), (Object)node, (Object)name);
            return replicationGroupRestController.g(name, node, role, (Authentication)new PrincipalAuthentication(a2)).thenReturn((Object)a7.g(EventSourceNotFoundException.g((Object)"/g\ra\u001ep\u000b`Ne\n`Nj\u0001`\u000b$\u001ca\u001fq\u000bw\u001a"))).onErrorResume(a2 -> Mono.just((Object)new RestResponse(false, a2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)a2))));
        });
    }

    @NotNull
    private /* synthetic */ Mono<Void> g(ReplicationGroupJSON a2, Authentication a3) {
        ReplicationGroupRestController a4;
        return a4.m.createReplicationGroup((ReplicationGroup)new F(a4, a2), a3);
    }

    @DeleteMapping(path={"replicationgroups/{name}"})
    public Mono<ResponseEntity<RestResponse>> g(@PathVariable(value="name") String name, @RequestParam(value="preserveEventStore", required=false, defaultValue="false") boolean preserveEventStore, @Parameter(hidden=true) Principal a3) {
        return this.g(name, preserveEventStore, (Authentication)new PrincipalAuthentication(a3)).thenReturn((Object)this.g(CriticalEventException.g((Object)"Qzs|`mu}0}uuumu9b|alujd"))).onErrorResume(a2 -> Mono.just((Object)new RestResponse(false, a2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)a2))));
    }

    @NotNull
    private /* synthetic */ Mono<Void> g(String a2, boolean a3, Authentication a4) {
        ReplicationGroupRestController a5;
        return a5.m.deleteReplicationGroup((RemoveReplicationGroup)new f(a5, a2, a3), a4);
    }

    private /* synthetic */ ResponseEntity<RestResponse> g(String a2) {
        return ResponseEntity.accepted().body((Object)new RestResponse(true, a2));
    }

    @PostMapping(path={"replicationgroups"})
    public Mono<ResponseEntity<RestResponse>> K(@RequestBody @Valid ReplicationGroupJSON replicationGroupJSON, @Parameter(hidden=true) Principal a2) {
        return Mono.defer(() -> {
            ReplicationGroupRestController a5;
            ReplicationGroupJSON replicationGroupJSON = replicationGroupJSON;
            a5.b.info(CriticalEventException.g((Object)"Xt}0kui|psxdp\u007fw0~bvei0kuhe|cm0kuzupf|t9vvb9b|`uyzqmyv~9wk\u007fl`#0bm"), (Object)replicationGroupJSON.getName());
            if (!replicationGroupJSON.hasRoles()) {
                throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_CREATION_NOT_ALLOWED, EventSourceNotFoundException.g((Object)"/`\n$\u000fpNh\u000be\u001dpNk\u0000aNj\u0001`\u000b$\bk\u001c$\u001al\u000b$\u000ft\u001eh\u0007g\u000fp\u0007k\u0000$\tv\u0001q\u001e"));
            }
            return a5.g(replicationGroupJSON, (Authentication)new PrincipalAuthentication(a2)).thenReturn((Object)a5.g(CriticalEventException.g((Object)"Qzs|`mu}0zb|qmu9b|alujd"))).onErrorResume(a2 -> Mono.just((Object)new RestResponse(false, a2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)a2))));
        });
    }

    @DeleteMapping(path={"replicationgroups/{replicationgroup}/{node}"})
    public Mono<ResponseEntity<RestResponse>> g(@PathVariable(value="replicationgroup") String name, @PathVariable(value="node") String node, @RequestParam(name="preserveEventStore", required=false, defaultValue="false") boolean preserveEventStore, @Parameter(hidden=true) Principal a2) {
        return Mono.defer(() -> {
            ReplicationGroupRestController a7;
            Object[] objectArray = new Object[3];
            objectArray[0] = node;
            objectArray[1] = name;
            objectArray[2] = preserveEventStore ? CriticalEventException.g((Object)"=9[|uiyww9uouwd9cm\u007fku") : "";
            a7.b.info(EventSourceNotFoundException.g((Object)"@\u000bh\u000bp\u000b$\u0000k\naNv\u000bu\u001ba\u001dpNv\u000bg\u000bm\u0018a\n$\bk\u001c$\u0000k\naT$\u0015yN)Ne\u0000`Nv\u000bt\u0002m\re\u001am\u0001jNc\u001ck\u001btT$\u0015yN\u007f\u0013"), objectArray);
            return a7.g(name, node, preserveEventStore, (Authentication)new PrincipalAuthentication(a2)).thenReturn((Object)a7.g(EventSourceNotFoundException.g((Object)"/g\ra\u001ep\u000b`N`\u000bh\u000bp\u000b$\u001ca\u001fq\u000bw\u001a"))).onErrorResume(a2 -> Mono.just((Object)new RestResponse(false, a2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)a2))));
        });
    }

    @NotNull
    private /* synthetic */ Mono<Void> g(String a2, String a3, boolean a4, Authentication a5) {
        ReplicationGroupRestController a6;
        return a6.m.removeNodeFromReplicationGroup((LeaveReplicationGroup)new K(a6, a3, a2, a4), a5);
    }

    public ReplicationGroupRestController(ReplicationLeaderProvider a2, ReplicationGroupAdminService a3) {
        ReplicationGroupRestController a4;
        ReplicationGroupRestController replicationGroupRestController = a4;
        a4.b = LoggerFactory.getLogger(ReplicationGroupRestController.class);
        replicationGroupRestController.h = a2;
        replicationGroupRestController.m = a3;
    }

    @GetMapping(path={"public/replicationgroups"})
    public Flux<ReplicationGroupJSON> g(@Parameter(hidden=true) Principal a3) {
        return this.m.getReplicationGroups((Authentication)new PrincipalAuthentication(a3)).map(a2 -> {
            ReplicationGroupRestController a3;
            ReplicationGroupJSON replicationGroupJSON = new ReplicationGroupJSON(a2.name());
            ReplicationGroupOverview replicationGroupOverview = a2;
            replicationGroupJSON.setChangePending(replicationGroupOverview.changePending());
            if (replicationGroupOverview.pendingSince() != null) {
                replicationGroupJSON.setPendingSince(a2.pendingSince().getTime());
            }
            ReplicationGroupJSON replicationGroupJSON2 = replicationGroupJSON;
            ReplicationGroupOverview replicationGroupOverview2 = a2;
            replicationGroupJSON2.setLeader(a3.h.getLeader(replicationGroupOverview2.name()));
            replicationGroupJSON2.setRoles(replicationGroupOverview2.members().stream().map(NodeAndRole::new).sorted().collect(Collectors.toList()));
            if (a2.members().stream().anyMatch(AdminReplicationGroupMember::isPendingDelete)) {
                replicationGroupJSON.setChangePending(true);
            }
            replicationGroupJSON.setContexts(a2.contexts().stream().map(ContextJSON::new).collect(Collectors.toList()));
            return replicationGroupJSON;
        }).sort(Comparator.comparing(ReplicationGroupJSON::getName));
    }
}

