/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest;

import io.axoniq.axonserver.access.roles.RoleController;
import io.axoniq.axonserver.admin.user.api.UserAdminService;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.config.ExternalLogin;
import io.axoniq.axonserver.configuration.admin.AdminUserRole;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.message.query.subscription.metric.GlobalSubscriptionMetricRegistry;
import io.axoniq.axonserver.transport.rest.E;
import io.axoniq.axonserver.transport.rest.PrincipalAuthentication;
import io.axoniq.axonserver.transport.rest.UserRestController;
import io.swagger.v3.oas.annotations.Parameter;
import java.security.Principal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="UserRestController")
@CrossOrigin
@RequestMapping(value={"/v1"})
public class UserRestController {
    private static final Logger m;
    private static final Logger h;
    private final UserAdminService b;
    private final RoleController I;

    @PostMapping(value={"users"})
    public void g(@RequestBody @Valid UserJson userJson, @Parameter(hidden=true) Principal a3) {
        if (a3 != null && userJson.userName.equals(a3.getName())) {
            throw new MessagingPlatformException(ErrorCode.AUTHENTICATION_INVALID_TOKEN, GlobalSubscriptionMetricRegistry.g((Object)"\u0019^#\u00116];^ T3\u0011#^wR?P9V2\u0011.^\"Cw^ _wR%T3T9E>P;B"));
        }
        Set<Object> set = new HashSet();
        if (userJson.roles != null) {
            set = Arrays.stream(userJson.roles).map(AdminUserRole::parse).collect(Collectors.toSet());
        }
        UserJson userJson2 = userJson;
        this.b.createOrUpdateUser(userJson2.userName, userJson2.password, set.stream().map(a2 -> {
            UserRestController a3;
            return new E(a3, a2);
        }).collect(Collectors.toSet()), (Authentication)new PrincipalAuthentication(a3));
    }

    static {
        h = LoggerFactory.getLogger(UserRestController.class);
        m = AuditLog.getLogger();
    }

    @GetMapping(value={"public/users"})
    public List<UserJson> g(@Parameter(hidden=true) Principal a2) {
        try {
            return this.b.users((Authentication)new PrincipalAuthentication(a2)).stream().map(UserJson::new).sorted(Comparator.comparing(UserJson::getUserName)).collect(Collectors.toList());
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = AuditLog.username((Principal)a2);
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            h.info(ExternalLogin.g((Object)"&1\u0000\u0017]\u0006\u00149\tj\b9\u00188\u000ej\u001b+\u0014&\u0018.]g]1\u0000"), objectArray);
            throw new MessagingPlatformException(ErrorCode.OTHER, exception.getMessage());
        }
    }

    @DeleteMapping(path={"users/{name}"})
    public void g(@PathVariable(value="name") String name, @Parameter(hidden=true) Principal a2) {
        try {
            this.b.deleteUser(name, (Authentication)new PrincipalAuthentication(a2));
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = AuditLog.username((Principal)a2);
            objectArray[1] = name;
            objectArray[2] = exception.getMessage();
            m.error(GlobalSubscriptionMetricRegistry.g((Object)"j,L\n\u0011\u0013T;T#TwD$T%\u0011,LwW6X;T3\u0011z\u0011,L"), objectArray);
            throw new MessagingPlatformException(ErrorCode.OTHER, exception.getMessage());
        }
    }

    public UserRestController(UserAdminService a2, RoleController a3) {
        UserRestController a4;
        UserRestController userRestController = a4;
        userRestController.b = a2;
        userRestController.I = a3;
    }
}

