/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest.v2;

import io.axoniq.axonserver.admin.application.api.ApplicationAdminService;
import io.axoniq.axonserver.admin.application.api.ApplicationOverview;
import io.axoniq.axonserver.admin.application.api.ApplicationRequest;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.component.instance.Client;
import io.axoniq.axonserver.component.instance.Clients;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.transport.rest.PrincipalAuthentication;
import io.axoniq.axonserver.transport.rest.v2.ApplicationRestControllerV2;
import io.axoniq.axonserver.transport.rest.v2.M;
import io.axoniq.axonserver.transport.rest.v2.URIUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.net.URI;
import java.security.Principal;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"v2/applications"})
@CrossOrigin
public class ApplicationRestControllerV2 {
    private final ApplicationAdminService b;
    private final Clients I;

    @NotNull
    private /* synthetic */ Set<String> g() {
        ApplicationRestControllerV2 a2;
        return StreamSupport.stream(a2.I.spliterator(), false).map(Client::principal).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @DeleteMapping(value={"{name}"})
    @Operation(responses={@ApiResponse(responseCode="204", description="when an application is deleted")})
    public Mono<ResponseEntity<Void>> f(@PathVariable(value="name") String applicationName, @Parameter(hidden=true) Principal a2) {
        return this.b.deleteApplication(applicationName, (Authentication)new PrincipalAuthentication(a2)).then(Mono.just((Object)ResponseEntity.noContent().build()));
    }

    private /* synthetic */ Mono g(M a2, PrincipalAuthentication a3, ApplicationOverview a4) {
        ApplicationRestControllerV2 a5;
        return a5.b.createOrUpdateApplication((ApplicationRequest)a2, (Authentication)a3).map(ResponseEntity::ok);
    }

    @GetMapping(produces={"application/json"})
    @Operation(responses={@ApiResponse(responseCode="200", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApplicationType.class)))})})
    public Flux<ApplicationType> g(@Parameter(hidden=true) Principal a2) {
        ApplicationRestControllerV2 applicationRestControllerV2 = this;
        Set set = applicationRestControllerV2.g();
        return applicationRestControllerV2.b.getApplications((Authentication)new PrincipalAuthentication(a2)).map(a3 -> {
            ApplicationOverview applicationOverview = a3;
            return new ApplicationType(applicationOverview, set.contains(applicationOverview.name()));
        });
    }

    @PatchMapping(value={"{name}"})
    @Operation(responses={@ApiResponse(responseCode="200", description="when a new token is generated")})
    public Mono<ResponseEntity<String>> K(@PathVariable(value="name") String applicationName, @Parameter(hidden=true) Principal a2) {
        return this.b.refreshToken(applicationName, (Authentication)new PrincipalAuthentication(a2)).map(ResponseEntity::ok);
    }

    private /* synthetic */ Mono g(M a2, PrincipalAuthentication a3, HttpServletRequest a5, ApplicationType a6, Throwable a7) {
        ApplicationRestControllerV2 a8;
        return a8.b.createOrUpdateApplication((ApplicationRequest)a2, (Authentication)a3).map(a4 -> ResponseEntity.created((URI)URIUtils.g((StringBuffer)a5.getRequestURL(), (String)a6.getName())).body(a4));
    }

    @PutMapping(consumes={"application/json"}, produces={"text/plain"})
    @Operation(responses={@ApiResponse(responseCode="200", description="when an application is updated"), @ApiResponse(responseCode="201", description="when a new application is created")})
    public Mono<ResponseEntity<String>> g(@RequestBody ApplicationType application, @Parameter(hidden=true) Principal principal, @Parameter(hidden=true) HttpServletRequest a3) {
        principal = new PrincipalAuthentication(principal);
        M m = new M(application);
        return this.b.getApplication(application.name, (Authentication)principal).flatMap(arg_0 -> this.g(m, (PrincipalAuthentication)principal, arg_0)).onErrorResume(a2 -> ErrorCode.fromException((Throwable)a2).equals((Object)ErrorCode.NO_SUCH_APPLICATION), arg_0 -> this.g(m, (PrincipalAuthentication)principal, a3, application, arg_0));
    }

    public ApplicationRestControllerV2(ApplicationAdminService a2, Clients a3) {
        ApplicationRestControllerV2 a4;
        ApplicationRestControllerV2 applicationRestControllerV2 = a4;
        applicationRestControllerV2.b = a2;
        applicationRestControllerV2.I = a3;
    }

    @GetMapping(produces={"application/json"}, path={"{name}"})
    @Operation(responses={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=ApplicationType.class))})})
    public Mono<ApplicationType> g(@PathVariable(value="name") String name, @Parameter(hidden=true) Principal a2) {
        ApplicationRestControllerV2 applicationRestControllerV2 = this;
        Set set = applicationRestControllerV2.g();
        return applicationRestControllerV2.b.getApplication(name, (Authentication)new PrincipalAuthentication(a2)).map(a4 -> new ApplicationType(a4, set.contains(name)));
    }
}

