/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.ui;

import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.applicationevents.ContextEvents;
import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.message.query.subscription.metric.GlobalSubscriptionMetricRegistry;
import io.axoniq.axonserver.ui.ClusterUpdatesService;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;

@Service
public class ClusterUpdatesService {
    private static final Logger h = AuditLog.getLogger();
    private final Logger b = LoggerFactory.getLogger(ClusterUpdatesService.class);
    private final Sinks.Many<SimpleUpdate> I = Sinks.many().multicast().onBackpressureBuffer();

    @EventListener
    public void on(ClusterEvents.ReplicationGroupUpdated a2) {
        ClusterUpdatesService a3;
        a3.g(UpdateType.H, a2.replicationGroup(), SimpleUpdateState.I);
    }

    @EventListener
    public void on(ClusterEvents.LeaderConfirmation a2) {
        ClusterUpdatesService a3;
        a3.g(UpdateType.c, a2.replicationGroup(), SimpleUpdateState.I);
    }

    @EventListener
    public void on(ClusterEvents.AxonServerInstanceDisconnected a2) {
        ClusterUpdatesService a3;
        a3.g(UpdateType.b, a2.getNodeName(), SimpleUpdateState.h);
    }

    @EventListener
    public void on(ContextEvents.ContextUpdatedInAdmin a2) {
        ClusterUpdatesService a3;
        a3.g(UpdateType.j, a2.g(), SimpleUpdateState.I);
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupCreated a2) {
        ClusterUpdatesService a3;
        a3.g(UpdateType.H, a2.replicationGroup(), SimpleUpdateState.j);
    }

    @EventListener
    public void on(TopologyEvents.ApplicationConnected a2) {
        ClusterUpdatesService a3;
        a3.g(UpdateType.f, a2.K(), SimpleUpdateState.b);
    }

    @EventListener
    public void on(ClusterEvents.LeaderStepDown a2) {
        ClusterUpdatesService a3;
        a3.g(UpdateType.c, a2.replicationGroup(), SimpleUpdateState.I);
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupDeleted a2) {
        ClusterUpdatesService a3;
        a3.g(UpdateType.H, a2.replicationGroup(), SimpleUpdateState.m);
    }

    @EventListener
    public void on(ContextEvents.ContextUnregisteredInAdmin a2) {
        ClusterUpdatesService a3;
        a3.g(UpdateType.j, a2.context(), SimpleUpdateState.m);
    }

    private /* synthetic */ void g(UpdateType a4, String a5, SimpleUpdateState a6) {
        ClusterUpdatesService a7;
        a7.I.emitNext((Object)new SimpleUpdate(a4, a5 + ":" + a6.name()), (a2, a3) -> {
            if (a3 == Sinks.EmitResult.FAIL_NON_SERIALIZED) {
                return true;
            }
            return false;
        });
    }

    public Flux<SimpleUpdate> subscribeToUpdates(@Nonnull Authentication a2) {
        return this.I.asFlux().publish().autoConnect().doFirst(() -> h.info(GlobalSubscriptionMetricRegistry.g((Object)"j,L\n\u0011\u0004D5B4C>S2UwE8\u00114^9E2I#\u0011\"A3P#T$\u001f"), (Object)AuditLog.username((String)a2.username())));
    }

    @EventListener
    public void on(ClusterEvents.AxonServerNodeDeleted a2) {
        ClusterUpdatesService a3;
        a3.g(UpdateType.h, a2.node(), SimpleUpdateState.b);
    }

    public ClusterUpdatesService() {
        ClusterUpdatesService a2;
    }

    @EventListener
    public void on(TopologyEvents.ApplicationDisconnected a2) {
        ClusterUpdatesService a3;
        a3.g(UpdateType.f, a2.G(), SimpleUpdateState.h);
    }

    @EventListener
    public void on(ClusterEvents.AxonServerNodeConnected a2) {
        ClusterUpdatesService a3;
        a3.g(UpdateType.h, a2.getNodeInfo().getHostName(), SimpleUpdateState.b);
    }

    @EventListener
    public void on(ClusterEvents.BecomeLeader a2) {
        ClusterUpdatesService a3;
        a3.g(UpdateType.c, a2.replicationGroup(), SimpleUpdateState.I);
    }

    @EventListener
    public void on(ContextEvents.ContextRegisteredInAdmin a2) {
        ClusterUpdatesService a3;
        a3.g(UpdateType.j, a2.context(), SimpleUpdateState.j);
    }

    @EventListener
    public void on(ClusterEvents.AxonServerInstanceConnected a2) {
        ClusterUpdatesService a3;
        a3.g(UpdateType.b, a2.getNodeName(), SimpleUpdateState.b);
    }
}

