create table adm_replication_group
(
    replication_group_id varchar(200) not null primary key,
    name                 varchar(200),
    change_pending       boolean,
    pending_since        timestamp,
    meta_data            clob
);

create unique index replication_group_name_idx on adm_replication_group (name);

alter table context
    add (
        replication_group_id varchar(200) references adm_replication_group (replication_group_id)
        );

create table rg_replication_group
(
    replication_group_id varchar(200) not null primary key,
    name                 varchar(200),
    meta_data            clob
);

create table rg_context
(
    name                   varchar(200) primary key,
    replication_group_name varchar(200),
    meta_data              clob
);

alter table context
    rename to adm_context;

alter table context_cluster_node
    rename to adm_context_member;

alter table application
    rename to adm_application_binding;

alter table application_context
    rename to adm_application_binding_context;

alter table application_context_role
    rename to adm_application_binding_context_role;

alter table JPA_CONTEXT_APPLICATION
    rename to rg_application_binding_context;

alter table JPA_CONTEXT_APPLICATION_ROLES
    rename to rg_application_binding_context_role;

alter table JPA_CONTEXT_USER
    rename to rg_user_context;

alter table JPA_CONTEXT_USER_ROLES
    rename to rg_user_context_role;

alter table JPA_RAFT_GROUP_NODE
    rename to rg_member;

alter table JPA_RAFT_STATE
    rename to rg_state;

alter table PROCESSOR_LOAD_BALANCING
    rename to adm_processor_load_balancing;

alter table RAFT_PROCESSOR_LOAD_BALANCING
    rename to rg_processor_load_balancing;

alter table RG_APPLICATION_BINDING_CONTEXT_ROLE
    alter column JPA_CONTEXT_APPLICATION_ID rename to REPLICATION_GROUP_APPLICATION_ID;

alter table rg_user_context_role
    alter column JPA_CONTEXT_USER_ID rename to REPLICATION_GROUP_USER_ID;

create table adm_replication_group_member
(
    id                   bigint generated by default as identity primary key,
    replication_group_id varchar(200) references adm_replication_group (replication_group_id),
    cluster_node_name    varchar(255) references CLUSTER_NODE (NAME),
    cluster_node_label   varchar(255),
    role                 integer,
    pending_delete       boolean
);

create sequence temp_sequence start with -1000;

insert into adm_replication_group(replication_group_id, name, meta_data)
select concat('mig_', name), name, META_DATA
from adm_context;

insert into adm_replication_group_member (id, replication_group_id, cluster_node_name, cluster_node_label, role,
                                          pending_delete)
select nextval('temp_sequence'),
       concat('mig_', CONTEXT_NAME),
       CLUSTER_NODE_NAME,
       CLUSTER_NODE_LABEL,
       ROLE,
       PENDING_DELETE
from ADM_CONTEXT_MEMBER;

update adm_context
set replication_group_id = concat('mig_', name);

insert into rg_replication_group(replication_group_id, name)
select distinct concat('mig_', group_id), GROUP_ID
from RG_MEMBER;

insert into rg_context(replication_group_name, name)
select distinct group_id, GROUP_ID
from RG_MEMBER;

drop sequence temp_sequence;

drop table adm_context_member;

insert into PATHS_TO_FUNCTIONS
values ('GET:/v1/public/replication_groups', 'LIST_REPLICATION_GROUPS');

insert into PATHS_TO_FUNCTIONS
values ('POST:/v1/replication_groups', 'CREATE_REPLICATION_GROUP');

insert into PATHS_TO_FUNCTIONS
values ('DELETE:/v1/replication_groups/.*', 'DELETE_REPLICATION_GROUP');

insert into PATHS_TO_FUNCTIONS
values ('POST:/v1/replication_groups/[^/]*/.*', 'ADD_NODE_TO_REPLICATION_GROUP');

insert into PATHS_TO_FUNCTIONS
values ('DELETE:/v1/replication_groups/[^/]*/.*', 'DELETE_NODE_FROM_REPLICATION_GROUP');

insert into FUNCTION_ROLES(function, role)
values ('LIST_REPLICATION_GROUPS', 'ADMIN');

insert into FUNCTION_ROLES(function, role)
values ('CREATE_REPLICATION_GROUP', 'ADMIN');

insert into FUNCTION_ROLES(function, role)
values ('DELETE_REPLICATION_GROUP', 'ADMIN');

insert into FUNCTION_ROLES(function, role)
values ('ADD_NODE_TO_REPLICATION_GROUP', 'ADMIN');

insert into FUNCTION_ROLES(function, role)
values ('DELETE_NODE_FROM_REPLICATION_GROUP', 'ADMIN');