/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.cluster.replication.file;

import io.axoniq.axonserver.cluster.exception.IteratorClosedException;
import io.axoniq.axonserver.cluster.rules.PrimaryMajorityRule;
import java.io.File;
import java.time.Duration;
import org.springframework.util.Assert;
import org.springframework.util.unit.DataSize;

public class StorageProperties {
    private int validationSegments;
    private long secondaryCleanupDelay;
    private int maxIndexesInMemory;
    private String logStorageFolder;
    private int primaryCleanupDelay;
    private int minActiveBackups;
    private static final boolean WINDOWS;
    private int syncInterval;
    private Long minFreeSpace;
    private static final String FILENAME_PATTERN;
    protected Boolean forceCleanMmapIndex;
    private int segmentSize;
    private long numberOfSegments;
    private String indexSuffix;
    private int forceInterval;
    private Long warnFreeSpace;
    private String logSuffix;
    protected Boolean useMmapIndex;
    private int flags;

    public void setForceCleanMmapIndex(Boolean bl) {
        Object a2 = bl;
        StorageProperties a3 = this;
        a3.forceCleanMmapIndex = a2;
    }

    public void setMinFreeSpace(DataSize dataSize) {
        StorageProperties a2 = dataSize;
        StorageProperties a3 = this;
        a3.minFreeSpace = a2 == null ? null : Long.valueOf(a2.toBytes());
    }

    public long getSegmentSize() {
        StorageProperties a2;
        return a2.segmentSize;
    }

    public String getLogSuffix() {
        StorageProperties a2;
        return a2.logSuffix;
    }

    public long getSyncInterval() {
        StorageProperties a2;
        return a2.syncInterval;
    }

    public void setWarnFreeSpace(DataSize dataSize) {
        StorageProperties a2 = dataSize;
        StorageProperties a3 = this;
        a3.warnFreeSpace = a2 == null ? null : Long.valueOf(a2.toBytes());
    }

    public long warnFreeSpace() {
        StorageProperties a2;
        if (a2.warnFreeSpace == null) {
            return (long)((double)a2.minFreeSpace() * 1.25);
        }
        return a2.warnFreeSpace;
    }

    public int getMaxIndexesInMemory() {
        StorageProperties a2;
        return a2.maxIndexesInMemory;
    }

    public String getStorage(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        return a3.logStorageFolder + File.separator + (String)a2;
    }

    public int getForceInterval() {
        StorageProperties a2;
        return a2.forceInterval;
    }

    public int getPrimaryCleanupDelay() {
        StorageProperties a2;
        return a2.primaryCleanupDelay;
    }

    public long getSecondaryCleanupDelay() {
        StorageProperties a2;
        return a2.secondaryCleanupDelay;
    }

    /*
     * WARNING - void declaration
     */
    public File indexTempFile(String string, Long l2) {
        void a2;
        Object a3 = l2;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a4.getStorage((String)a2);
        objectArray[1] = a3;
        objectArray[2] = a4.indexSuffix + ".temp";
        return new File(String.format(FILENAME_PATTERN, objectArray));
    }

    public void setMaxIndexesInMemory(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.maxIndexesInMemory = a2;
    }

    static {
        FILENAME_PATTERN = "%s" + File.separator + "%020d%s";
        WINDOWS = System.getProperty(PrimaryMajorityRule.I((Object)"\u0006WGJ\bI\f"), IteratorClosedException.I((Object)"\u0000\u001c: +\u0007")).toLowerCase().startsWith(PrimaryMajorityRule.I((Object)"\u001eM\u0007"));
    }

    public long minFreeSpace() {
        StorageProperties a2;
        if (a2.minFreeSpace == null) {
            return 5L * (long)a2.segmentSize;
        }
        return a2.minFreeSpace;
    }

    public void setSegmentSize(DataSize dataSize) {
        StorageProperties a2 = dataSize;
        StorageProperties a3 = this;
        Assert.isTrue((a2.toBytes() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)PrimaryMajorityRule.I((Object)":A\u000eI\fJ\u001d\u0004\u001aM\u0013AII\u001cW\u001d\u0004\u000bAIH\fW\u001a\u0004\u001dL\bJI\u0016X\u0010^\u0010Q\u0017_\u0010^"));
        Assert.isTrue((a2.toBytes() > 0L ? 1 : 0) != 0, (String)IteratorClosedException.I((Object)"\u001d\u0016)\u001e+\u001d:S=\u001a4\u0016n\u001e;\u0000:S,\u0016n\u001e!\u0001+S:\u001b/\u001dnC"));
        a3.segmentSize = (int)a2.toBytes();
    }

    public void setPrimaryCleanupDelay(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.primaryCleanupDelay = a2;
    }

    public void setFlags(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.flags = a2;
    }

    public void setUseMmapIndex(Boolean bl) {
        Object a2 = bl;
        StorageProperties a3 = this;
        a3.useMmapIndex = a2;
    }

    public void setSecondaryCleanupDelay(long a2) {
        a.secondaryCleanupDelay = a2;
    }

    public String getLogStorageFolder() {
        StorageProperties a2;
        return a2.logStorageFolder;
    }

    public StorageProperties() {
        StorageProperties a2;
        StorageProperties storageProperties = a2;
        StorageProperties storageProperties2 = a2;
        StorageProperties storageProperties3 = a2;
        StorageProperties storageProperties4 = a2;
        StorageProperties storageProperties5 = a2;
        StorageProperties storageProperties6 = a2;
        StorageProperties storageProperties7 = a2;
        storageProperties7.forceCleanMmapIndex = true;
        storageProperties7.syncInterval = 1000;
        storageProperties6.forceInterval = 1000;
        storageProperties6.logSuffix = ".log";
        storageProperties5.indexSuffix = ".index";
        storageProperties5.validationSegments = 2;
        storageProperties4.flags = 0;
        storageProperties4.primaryCleanupDelay = 5;
        storageProperties3.segmentSize = 0x1000000;
        storageProperties3.numberOfSegments = 1000L;
        storageProperties2.secondaryCleanupDelay = 30L;
        storageProperties2.logStorageFolder = "log";
        storageProperties.minActiveBackups = 1;
        storageProperties.maxIndexesInMemory = 5;
    }

    public int getValidationSegments() {
        StorageProperties a2;
        return a2.validationSegments;
    }

    public long getNumberOfSegments() {
        StorageProperties a2;
        return a2.numberOfSegments;
    }

    public void setLogStorageFolder(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.logStorageFolder = a2;
    }

    public int getFlags() {
        StorageProperties a2;
        return a2.flags;
    }

    public void setMinActiveBackups(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.minActiveBackups = a2;
    }

    public boolean isUseMmapIndex() {
        StorageProperties a2;
        if (a2.useMmapIndex != null) {
            return a2.useMmapIndex;
        }
        return false;
    }

    public boolean isForceCleanMmapIndex() {
        StorageProperties a2;
        if (a2.forceCleanMmapIndex != null) {
            return a2.forceCleanMmapIndex;
        }
        return WINDOWS;
    }

    public void setForceInterval(Duration duration) {
        Duration a2 = duration;
        StorageProperties a3 = this;
        a3.forceInterval = (int)a2.toMillis();
    }

    public void setNumberOfSegments(long a2) {
        a.numberOfSegments = a2;
    }

    public void setValidationSegments(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.validationSegments = a2;
    }

    public void setSyncInterval(Duration duration) {
        Duration a2 = duration;
        StorageProperties a3 = this;
        a3.syncInterval = (int)a2.toMillis();
    }

    public void setLogSuffix(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.logSuffix = a2;
    }

    public int getMinActiveBackups() {
        StorageProperties a2;
        return a2.minActiveBackups;
    }

    /*
     * WARNING - void declaration
     */
    public File indexFile(String string, Long l2) {
        void a2;
        Object a3 = l2;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a4.getStorage((String)a2);
        objectArray[1] = a3;
        objectArray[2] = a4.indexSuffix;
        return new File(String.format(FILENAME_PATTERN, objectArray));
    }

    public void setIndexSuffix(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.indexSuffix = a2;
    }

    /*
     * WARNING - void declaration
     */
    public File logFile(String string, Long l2) {
        void a2;
        Object a3 = l2;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a4.getStorage((String)a2);
        objectArray[1] = a3;
        objectArray[2] = a4.logSuffix;
        return new File(String.format(FILENAME_PATTERN, objectArray));
    }

    public String getIndexSuffix() {
        StorageProperties a2;
        return a2.indexSuffix;
    }
}

