/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.config;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.config.AccessControlConfiguration;
import io.axoniq.axonserver.config.EventTransformationConfiguration;
import io.axoniq.axonserver.config.SslConfiguration;
import io.axoniq.axonserver.config.SystemInfoProvider;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.replication.ServerProperties;
import io.axoniq.axonserver.transport.rest.v2.EventProcessorRestControllerV2;
import io.axoniq.axonserver.util.StringUtils;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;
import org.springframework.util.unit.DataSize;

@Configuration
@ConfigurationProperties(prefix="axoniq.axonserver")
public class MessagingPlatformConfiguration
implements ServerProperties {
    private String pluginPackageDirectory;
    private static final Logger auditLog;
    private String controldbBackupLocation;
    private int grpcBufferedMessages;
    private String hostname;
    @NestedConfigurationProperty
    private AccessControlConfiguration accesscontrol;
    private final Map<String, Boolean> preview;
    private Duration minKeepAliveTime;
    private int httpPort;
    private static final int DEFAULT_MAX_TRANSACTION_SIZE = 4184304;
    private static final int RESERVED = 10000;
    private int metricsSynchronizationRate;
    private Duration keepAliveTime;
    private int executorThreadCount;
    private String pluginCacheDirectory;
    @Value(value="${spring.datasource.url:#{null}}")
    private String datasourceUrl;
    private Duration keepAliveTimeout;
    private boolean forceConnectionToPrimaryOrMessagingNode;
    private String webSocketAllowedOrigins;
    private int port;
    private int maxMessageSize;
    private Duration metricsInterval;
    private int eventStoreBackgroundThreadCount;
    @NestedConfigurationProperty
    private EventTransformationConfiguration eventTransformation;
    @NestedConfigurationProperty
    private SslConfiguration ssl;
    private int eventStoreProcessorsThreadCount;
    private boolean pluginsEnabled;
    private String pluginCleanPolicy;
    private String domain;
    private boolean setWebSocketAllowedOrigins;
    private final SystemInfoProvider systemInfoProvider;
    public static final int DEFAULT_INTERNAL_GRPC_PORT = 8224;
    private int internalPort;
    private String name;
    private int clusterExecutorThreadCount;
    private String internalHostname;
    private String internalDomain;
    private static final Logger logger;
    private String pidFileLocation;

    public void setDomain(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.domain = a2;
    }

    public void setEventTransformation(EventTransformationConfiguration eventTransformationConfiguration) {
        MessagingPlatformConfiguration a2 = eventTransformationConfiguration;
        MessagingPlatformConfiguration a3 = this;
        a3.eventTransformation = a2;
    }

    public int getEventStoreBackgroundThreadCount() {
        MessagingPlatformConfiguration a2;
        return a2.eventStoreBackgroundThreadCount;
    }

    public void setMinKeepAliveTime(Duration duration) {
        Object a2 = duration;
        MessagingPlatformConfiguration a3 = this;
        a3.minKeepAliveTime = a2;
    }

    static {
        logger = LoggerFactory.getLogger(MessagingPlatformConfiguration.class);
        auditLog = AuditLog.getLogger();
    }

    public int getExecutorThreadCount() {
        MessagingPlatformConfiguration a2;
        return a2.executorThreadCount;
    }

    public int getHttpPort() {
        MessagingPlatformConfiguration a2;
        if (a2.httpPort == 0) {
            a2.httpPort = a2.systemInfoProvider.getPort();
        }
        return a2.httpPort;
    }

    public String getName() {
        MessagingPlatformConfiguration a2;
        if (a2.name == null) {
            a2.name = a2.getHostname();
        }
        return a2.name;
    }

    public String getPidFileLocation() {
        MessagingPlatformConfiguration a2;
        return a2.pidFileLocation;
    }

    public void setKeepAliveTimeout(Duration duration) {
        Object a2 = duration;
        MessagingPlatformConfiguration a3 = this;
        a3.keepAliveTimeout = a2;
    }

    public SslConfiguration getSsl() {
        MessagingPlatformConfiguration a2;
        return a2.ssl;
    }

    public void setEventStoreBackgroundThreadCount(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.eventStoreBackgroundThreadCount = a2;
    }

    public void setForceConnectionToPrimaryOrMessagingNode(boolean bl) {
        boolean a2 = bl;
        MessagingPlatformConfiguration a3 = this;
        a3.forceConnectionToPrimaryOrMessagingNode = a2;
    }

    public int getClusterExecutorThreadCount() {
        MessagingPlatformConfiguration a2;
        return a2.clusterExecutorThreadCount;
    }

    public int getEventStoreProcessorsThreadCount() {
        MessagingPlatformConfiguration a2;
        return a2.eventStoreProcessorsThreadCount;
    }

    public String getPluginCacheDirectory() {
        MessagingPlatformConfiguration a2;
        return a2.pluginCacheDirectory;
    }

    public void setMaxMessageSize(DataSize dataSize) {
        MessagingPlatformConfiguration a2 = dataSize;
        MessagingPlatformConfiguration a3 = this;
        Assert.isTrue((a2.toBytes() >= 0L ? 1 : 0) != 0, (String)TopologyEvents.I((Object)"~%Kd^!@7R#Vd@-I!\u0013)F7GdQ!\u0013#A!R0V6\u00130[%]d\u0003"));
        Assert.isTrue((a2.toBytes() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)EventProcessorRestControllerV2.I((Object)"LHy\tlLrZ`Nd\tr@{L!DtZu\tcL!EdZr\tuA`G!\u001b0\u001d6\u001d9\u001a7\u001d6"));
        a3.maxMessageSize = (int)a2.toBytes();
    }

    public void setKeepAliveTime(Duration duration) {
        Object a2 = duration;
        MessagingPlatformConfiguration a3 = this;
        a3.keepAliveTime = a2;
    }

    public void setInternalHostname(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.internalHostname = a2;
    }

    public void setPluginCacheDirectory(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.pluginCacheDirectory = a2;
    }

    public long getMinKeepAliveTime() {
        MessagingPlatformConfiguration a2;
        return a2.minKeepAliveTime.toMillis();
    }

    public MessagingPlatformConfiguration(SystemInfoProvider systemInfoProvider) {
        MessagingPlatformConfiguration a2;
        MessagingPlatformConfiguration a3 = systemInfoProvider;
        MessagingPlatformConfiguration messagingPlatformConfiguration = a2 = this;
        MessagingPlatformConfiguration messagingPlatformConfiguration2 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration3 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration4 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration5 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration6 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration7 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration8 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration9 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration10 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration11 = a2;
        a2.port = 8124;
        messagingPlatformConfiguration11.internalPort = 8224;
        messagingPlatformConfiguration11.keepAliveTimeout = Duration.ofMillis(5000L);
        messagingPlatformConfiguration10.keepAliveTime = Duration.ofMillis(2500L);
        messagingPlatformConfiguration10.minKeepAliveTime = Duration.ofMillis(1000L);
        messagingPlatformConfiguration9.setWebSocketAllowedOrigins = false;
        messagingPlatformConfiguration9.webSocketAllowedOrigins = "*";
        MessagingPlatformConfiguration messagingPlatformConfiguration12 = a2;
        messagingPlatformConfiguration9.ssl = new SslConfiguration();
        MessagingPlatformConfiguration messagingPlatformConfiguration13 = a2;
        messagingPlatformConfiguration8.accesscontrol = new AccessControlConfiguration();
        MessagingPlatformConfiguration messagingPlatformConfiguration14 = a2;
        messagingPlatformConfiguration8.eventTransformation = new EventTransformationConfiguration();
        messagingPlatformConfiguration8.forceConnectionToPrimaryOrMessagingNode = true;
        messagingPlatformConfiguration7.metricsInterval = Duration.ofMinutes(15L);
        messagingPlatformConfiguration7.controldbBackupLocation = ".";
        messagingPlatformConfiguration6.maxMessageSize = 0x400000;
        messagingPlatformConfiguration6.pidFileLocation = ".";
        messagingPlatformConfiguration5.grpcBufferedMessages = 500;
        messagingPlatformConfiguration5.executorThreadCount = 4;
        messagingPlatformConfiguration4.clusterExecutorThreadCount = 4;
        messagingPlatformConfiguration4.eventStoreBackgroundThreadCount = 8;
        messagingPlatformConfiguration3.eventStoreProcessorsThreadCount = 8;
        messagingPlatformConfiguration3.pluginsEnabled = true;
        messagingPlatformConfiguration2.pluginCacheDirectory = "plugins/cache";
        messagingPlatformConfiguration2.pluginPackageDirectory = "plugins/bundles";
        messagingPlatformConfiguration.pluginCleanPolicy = "onFirstInit";
        MessagingPlatformConfiguration messagingPlatformConfiguration15 = a2;
        messagingPlatformConfiguration.preview = new HashMap();
        messagingPlatformConfiguration.systemInfoProvider = a3;
    }

    public void setInternalPort(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.internalPort = a2;
    }

    public String getPluginPackageDirectory() {
        MessagingPlatformConfiguration a2;
        return a2.pluginPackageDirectory;
    }

    public void setControldbBackupLocation(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.controldbBackupLocation = a2;
    }

    public boolean isForceConnectionToPrimaryOrMessagingNode() {
        MessagingPlatformConfiguration a2;
        return a2.forceConnectionToPrimaryOrMessagingNode;
    }

    public String getHostname() {
        MessagingPlatformConfiguration messagingPlatformConfiguration = this;
        if (StringUtils.isEmpty((String)messagingPlatformConfiguration.hostname)) {
            try {
                MessagingPlatformConfiguration messagingPlatformConfiguration2 = messagingPlatformConfiguration;
                messagingPlatformConfiguration2.hostname = messagingPlatformConfiguration2.systemInfoProvider.getHostName();
                if (!StringUtils.isEmpty((String)messagingPlatformConfiguration2.domain)) {
                    MessagingPlatformConfiguration messagingPlatformConfiguration3 = messagingPlatformConfiguration;
                    if (messagingPlatformConfiguration3.hostname.endsWith("." + messagingPlatformConfiguration3.domain)) {
                        messagingPlatformConfiguration.hostname = messagingPlatformConfiguration.hostname.substring(0, messagingPlatformConfiguration.hostname.length() - messagingPlatformConfiguration.domain.length() - 1);
                    }
                }
            }
            catch (UnknownHostException a2) {
                logger.warn(TopologyEvents.I((Object)"\u0007\\1_ \u0013*\\0\u0013 V0V6^-]!\u0013,\\7G*R)VdU6\\)\u0013-]!GdR W6V7@~\u0013?N"), (Object)a2.getMessage());
            }
        }
        return messagingPlatformConfiguration.hostname;
    }

    public String getInternalDomain() {
        MessagingPlatformConfiguration a2;
        if (a2.internalDomain == null) {
            a2.internalDomain = a2.getDomain();
        }
        return a2.internalDomain;
    }

    public String getInternalHostname() {
        MessagingPlatformConfiguration a2;
        if (StringUtils.isEmpty((String)a2.internalHostname)) {
            a2.internalHostname = a2.getHostname();
        }
        return a2.internalHostname;
    }

    public int getMaxTransactionSize() {
        MessagingPlatformConfiguration a2;
        if (a2.maxMessageSize == 0) {
            return 4184304;
        }
        return a2.maxMessageSize - 10000;
    }

    public void setPluginsEnabled(boolean bl) {
        boolean a2 = bl;
        MessagingPlatformConfiguration a3 = this;
        a3.pluginsEnabled = a2;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void I(String string, String string2, boolean bl, BiConsumer<String, String> biConsumer) {
        void a2;
        boolean a3 = bl;
        MessagingPlatformConfiguration a4 = this;
        String string3 = a3 = a3 ? EventProcessorRestControllerV2.I((Object)"hGuLsG`E!") : "";
        if (StringUtils.isEmpty((String)a2)) {
            logger.error(TopologyEvents.I((Object)"p+F(Wd]+GdW!G!A)Z*VdRdE%_-WdH9[+@0]%^!\u001d"), (Object)a3);
            throw new MessagingPlatformException(ErrorCode.VALIDATION_FAILED, "No " + a3 + "hostname set and system could not provide one.");
        }
        if (Character.isDigit(a2.charAt(0))) {
            logger.warn(EventProcessorRestControllerV2.I((Object)"}iL!R|AnZuG`Dd\tiHr\tcLdG!Zd]!Hr\t`G!`Q\t`Me[dZr\u0007!}i@r\tlHx\tq[nMtJd\ttGvHo]dM![dZtEuZ/"), (Object)a3);
            return;
        }
        int n = a2.indexOf(46);
        if (n != -1) {
            void a5;
            void a6;
            void v1 = a2;
            String string4 = v1.substring(0, n);
            String string5 = v1.substring(n + 1);
            if (StringUtils.isEmpty((String)a6)) {
                Object[] objectArray = new Object[3];
                objectArray[0] = a3;
                objectArray[1] = string4;
                objectArray[2] = string5;
                logger.info(TopologyEvents.I((Object)"p+]\"Z#F6Z*TdW+^%Z*\u0013\"A+^dH9[+@0]%^!\u00134A+C!A0J~\u0013,\\7G*R)VyH9\u001fdW+^%Z*\u000e?N"), objectArray);
                a5.accept(string4, string5);
                return;
            }
            Object[] objectArray = new Object[4];
            objectArray[0] = a3;
            objectArray[1] = a2;
            objectArray[2] = string4;
            objectArray[3] = a6;
            logger.warn(EventProcessorRestControllerV2.I((Object)"HNoFs@oN!MnD`@o\tqHs]!Fg\tuAd\tzTiFr]oHlL!\u000ezT&\u0013!AnZuG`Dd\u0014zT-\teFlHhG<R|"), objectArray);
            a5.accept(string4, a6);
        }
    }

    public void setAccesscontrol(AccessControlConfiguration accessControlConfiguration) {
        MessagingPlatformConfiguration a2;
        block3: {
            MessagingPlatformConfiguration messagingPlatformConfiguration;
            MessagingPlatformConfiguration a3;
            block1: {
                block2: {
                    a2 = accessControlConfiguration;
                    a3 = this;
                    if (!auditLog.isInfoEnabled()) break block1;
                    if (a2 != null) break block2;
                    if (a3.accesscontrol == null) break block1;
                    auditLog.info(TopologyEvents.I((Object)"r'P!@7\u0013'\\*G6\\(\u0013'\\*U-T1A%G-\\*\u0013\u0016v\t|\u0012v\u0000\u001d"));
                    messagingPlatformConfiguration = a3;
                    break block3;
                }
                if (a3.accesscontrol == null || a2.isEnabled() != a3.accesscontrol.isEnabled()) {
                    auditLog.info(EventProcessorRestControllerV2.I((Object)"@JbLrZ!JnGu[nE!@r\toFv\tzT/"), (Object)AuditLog.enablement((boolean)a2.isEnabled()));
                }
            }
            messagingPlatformConfiguration = a3;
        }
        messagingPlatformConfiguration.accesscontrol = a2;
    }

    public void setExecutorThreadCount(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.executorThreadCount = a2;
    }

    public int getMaxMessageSize() {
        MessagingPlatformConfiguration a2;
        return a2.maxMessageSize;
    }

    public void setInternalDomain(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.internalDomain = a2;
    }

    public long getKeepAliveTime() {
        MessagingPlatformConfiguration a2;
        return a2.keepAliveTime.toMillis();
    }

    public boolean isPluginsEnabled() {
        MessagingPlatformConfiguration a2;
        return a2.pluginsEnabled;
    }

    public void setSsl(SslConfiguration sslConfiguration) {
        MessagingPlatformConfiguration a2;
        block3: {
            MessagingPlatformConfiguration messagingPlatformConfiguration;
            MessagingPlatformConfiguration a3;
            block1: {
                block2: {
                    a2 = sslConfiguration;
                    a3 = this;
                    if (!auditLog.isInfoEnabled()) break block1;
                    if (a2 != null) break block2;
                    if (a3.ssl == null) break block1;
                    auditLog.info(TopologyEvents.I((Object)"\u0017`\b\u0013'\\*U-T1A%G-\\*\u0013\u0016v\t|\u0012v\u0000\u001d"));
                    messagingPlatformConfiguration = a3;
                    break block3;
                }
                if (a3.ssl == null || a2.isEnabled() != a3.ssl.isEnabled()) {
                    auditLog.info(EventProcessorRestControllerV2.I((Object)"zRe!@r\toFv\tzT/"), (Object)AuditLog.enablement((boolean)a2.isEnabled()));
                }
            }
            messagingPlatformConfiguration = a3;
        }
        messagingPlatformConfiguration.ssl = a2;
    }

    public void setSetWebSocketAllowedOrigins(boolean bl) {
        boolean a2 = bl;
        MessagingPlatformConfiguration a3 = this;
        a3.setWebSocketAllowedOrigins = a2;
    }

    public void setName(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.name = a2;
    }

    public String getPluginCleanPolicy() {
        MessagingPlatformConfiguration a2;
        return a2.pluginCleanPolicy;
    }

    public String getDomain() {
        MessagingPlatformConfiguration messagingPlatformConfiguration = this;
        if (messagingPlatformConfiguration.domain == null) {
            block4: {
                String a2 = messagingPlatformConfiguration.systemInfoProvider.getHostName();
                int n = a2.indexOf(46);
                if (n == -1) break block4;
                messagingPlatformConfiguration.domain = a2.substring(n + 1);
            }
            try {
                messagingPlatformConfiguration.domain = "";
            }
            catch (UnknownHostException a2) {
                logger.warn(EventProcessorRestControllerV2.I((Object)"jn\\mM!Gn]!Md]d[l@oL!AnZuG`Dd\tg[nD!@oLu\t`Me[dZr\u0013!R|"), (Object)a2.getMessage());
            }
        }
        return messagingPlatformConfiguration.domain;
    }

    public String getFullyQualifiedHostname() {
        MessagingPlatformConfiguration messagingPlatformConfiguration = this;
        Object a2 = messagingPlatformConfiguration.getDomain();
        if (!StringUtils.isEmpty((String)a2)) {
            return messagingPlatformConfiguration.getHostname() + "." + (String)a2;
        }
        return messagingPlatformConfiguration.getHostname();
    }

    public AccessControlConfiguration getAccesscontrol() {
        MessagingPlatformConfiguration a2;
        return a2.accesscontrol;
    }

    public int getPort() {
        MessagingPlatformConfiguration a2;
        return a2.port;
    }

    public void setMetricsSynchronizationRate(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.metricsSynchronizationRate = a2;
    }

    public int getInternalPort() {
        MessagingPlatformConfiguration a2;
        return a2.internalPort;
    }

    public boolean isSetWebSocketAllowedOrigins() {
        MessagingPlatformConfiguration a2;
        return a2.setWebSocketAllowedOrigins;
    }

    public String getControldbBackupLocation() {
        MessagingPlatformConfiguration a2;
        return a2.controldbBackupLocation;
    }

    public void setClusterExecutorThreadCount(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.clusterExecutorThreadCount = a2;
    }

    public void setPluginPackageDirectory(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.pluginPackageDirectory = a2;
    }

    public int getGrpcBufferedMessages() {
        MessagingPlatformConfiguration a2;
        return a2.grpcBufferedMessages;
    }

    @PostConstruct
    public void postConstruct() {
        MessagingPlatformConfiguration a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration = a2;
        messagingPlatformConfiguration.I(a2.getHostname(), messagingPlatformConfiguration.getDomain(), false, (string, string2) -> {
            void a2;
            MessagingPlatformConfiguration a3;
            Object a4 = string2;
            MessagingPlatformConfiguration messagingPlatformConfiguration = a3 = this;
            messagingPlatformConfiguration.setHostname((String)a2);
            messagingPlatformConfiguration.setDomain((String)a4);
        });
        MessagingPlatformConfiguration messagingPlatformConfiguration2 = a2;
        messagingPlatformConfiguration2.I(a2.getInternalHostname(), messagingPlatformConfiguration2.getInternalDomain(), true, (string, string2) -> {
            void a2;
            MessagingPlatformConfiguration a3;
            Object a4 = string2;
            MessagingPlatformConfiguration messagingPlatformConfiguration = a3 = this;
            messagingPlatformConfiguration.setInternalHostname((String)a2);
            messagingPlatformConfiguration.setInternalDomain((String)a4);
        });
        if (a2.datasourceUrl != null && !a2.datasourceUrl.contains(TopologyEvents.I((Object)"\t)V)\t")) && !a2.datasourceUrl.contains(EventProcessorRestControllerV2.I((Object)"`QnGrLs_d[,JnGg@fMc"))) {
            throw new FailedToStartException(TopologyEvents.I((Object)"g,VdW%G%Q%@!\u0013*R)VdU+Adr<\\*\u0013\u0017V6E!Ad^1@0\u0013&Vd\u0014%K+]7V6E!AiP+]\"Z#W&\u0014j\u0013\rUdJ+FdR6Vd^-T6R0Z*TdU6\\)\u0013%]d\\(W!AdE!A7Z+]dV*@1A!\u00130[%GdG,Vdp+]0A+_dw\u0006\u0013-@dZ*\u0013cR<\\*@!A2V6\u001e'\\*G6\\(W&\u0014dR*WdF4W%G!\u00130[!\u00137C6Z*TjW%G%@+F6P!\u001d1A(\u00134A+C!A0JdG+\u00131@!\u0013 R0R&R7Vd]%^!\u0013cR<\\*@!A2V6\u001e'\\*U-T Qc\u001d"));
        }
        if (auditLog.isInfoEnabled()) {
            auditLog.info(EventProcessorRestControllerV2.I((Object)"jnGg@f\\sHu@nG!@o@u@`EhSdM!^h]i\tRzM\tzT!HoM!HbJdZr\tbFo]sFm\tzT/"), (Object)AuditLog.enablement((boolean)a2.ssl.isEnabled()), (Object)AuditLog.enablement((boolean)a2.accesscontrol.isEnabled()));
        }
    }

    public String getWebSocketAllowedOrigins() {
        MessagingPlatformConfiguration a2;
        return a2.webSocketAllowedOrigins;
    }

    public void setEventStoreProcessorsThreadCount(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.eventStoreProcessorsThreadCount = a2;
    }

    public Map<String, Boolean> getPreview() {
        MessagingPlatformConfiguration a2;
        return a2.preview;
    }

    public boolean isExperimentalFeatureEnabled(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        return a3.preview.getOrDefault(a2, false);
    }

    public void setGrpcBufferedMessages(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.grpcBufferedMessages = a2;
    }

    public String getFullyQualifiedInternalHostname() {
        MessagingPlatformConfiguration messagingPlatformConfiguration = this;
        Object a2 = messagingPlatformConfiguration.getInternalDomain();
        if (!StringUtils.isEmpty((String)a2)) {
            return messagingPlatformConfiguration.getInternalHostname() + "." + (String)a2;
        }
        return messagingPlatformConfiguration.getInternalHostname();
    }

    public Duration getMetricsInterval() {
        MessagingPlatformConfiguration a2;
        return a2.metricsInterval;
    }

    public void setHostname(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.hostname = a2;
    }

    @PostConstruct
    public void init() {
        if (auditLog.isInfoEnabled()) {
            MessagingPlatformConfiguration a2;
            a2.preview.forEach((string, bl) -> {
                Boolean a2 = bl;
                String a3 = string;
                if (Boolean.TRUE.equals(a2)) {
                    auditLog.info(TopologyEvents.I((Object)"\u0014A!E-V3\u0013+UdU!R0F6VdH9\u0013!]%Q(V \u001d"), (Object)a3);
                }
            });
        }
    }

    public EventTransformationConfiguration getEventTransformation() {
        MessagingPlatformConfiguration a2;
        return a2.eventTransformation;
    }

    public void setPort(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.port = a2;
    }

    public void setPidFileLocation(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.pidFileLocation = a2;
    }

    public void setWebSocketAllowedOrigins(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.webSocketAllowedOrigins = a2;
    }

    public long getKeepAliveTimeout() {
        MessagingPlatformConfiguration a2;
        return a2.keepAliveTimeout.toMillis();
    }

    public void setMetricsInterval(Duration duration) {
        Object a2 = duration;
        MessagingPlatformConfiguration a3 = this;
        a3.metricsInterval = a2;
    }

    public void setPluginCleanPolicy(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.pluginCleanPolicy = a2;
    }
}

