/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster;

import io.axoniq.axonserver.ClusterTagsCache;
import io.axoniq.axonserver.component.version.ClientVersionUpdate;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.admin.AdminConfigurationFactory;
import io.axoniq.axonserver.configuration.admin.AdminNodes;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.cluster.CurrentNodeProvider;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteConnection;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteConnections;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.licensing.Limits;
import io.axoniq.axonserver.message.command.CommandInformation;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;

@Controller
public class ClusterController
implements SmartLifecycle {
    private final CurrentNodeProvider b;
    private final ClusterTagsCache I;
    private final AdminNodes l;
    private final Limits J;
    private volatile boolean A;
    private final ApplicationEventPublisher B;
    private final AdminConfigurationFactory D;
    private final Logger f;
    private final RemoteConnections E;
    private final MessagingPlatformConfiguration M;

    /*
     * WARNING - void declaration
     */
    public ClusterController(MessagingPlatformConfiguration messagingPlatformConfiguration, AdminNodes adminNodes, AdminConfigurationFactory adminConfigurationFactory, ClusterTagsCache clusterTagsCache, @Qualifier(value="localEventPublisher") ApplicationEventPublisher applicationEventPublisher, Limits limits, RemoteConnections remoteConnections, CurrentNodeProvider currentNodeProvider) {
        void remoteConnections2;
        void limits2;
        void applicationEventPublisher2;
        void clusterTagsCache2;
        void adminConfigurationFactory2;
        void clusterNodeRepository;
        void messagingPlatformConfiguration2;
        ClusterController a2;
        ClusterController clusterController = clusterController2;
        ClusterController clusterController2 = currentNodeProvider;
        ClusterController clusterController3 = a2 = clusterController;
        ClusterController clusterController4 = a2;
        ClusterController clusterController5 = a2;
        ClusterController clusterController6 = a2;
        a2.f = LoggerFactory.getLogger(ClusterController.class);
        clusterController6.M = messagingPlatformConfiguration2;
        clusterController6.l = clusterNodeRepository;
        clusterController5.D = adminConfigurationFactory2;
        clusterController5.I = clusterTagsCache2;
        clusterController4.B = applicationEventPublisher2;
        clusterController4.J = limits2;
        clusterController3.E = remoteConnections2;
        clusterController3.b = clusterController2;
    }

    public String getName() {
        ClusterController a2;
        return a2.getMe().getName();
    }

    public Set<String> remoteNodeNames() {
        ClusterController a2;
        return a2.E.nodes();
    }

    Stream<RemoteConnection> activeConnections() {
        ClusterController a2;
        return a2.E.activeConnections();
    }

    public Stream<ClusterNode> activeNodes() {
        ClusterController a2;
        return a2.nodes().filter(clusterNode -> {
            ClusterController a2 = clusterNode;
            ClusterController a3 = this;
            return a3.isActive(a2.getName());
        });
    }

    public void publishEvent(Object object) {
        Object a2 = object;
        ClusterController a3 = this;
        a3.B.publishEvent(a2);
    }

    @Transactional
    public synchronized void deleteNode(String string) {
        ClusterController clusterController;
        ClusterController a2;
        Object a3 = string;
        ClusterController clusterController2 = a2 = this;
        clusterController2.f.info(ClientVersionUpdate.I((Object)"\u000bp#p;po{ q*/on2"), a3);
        clusterController2.B.publishEvent((Object)new ClusterEvents.AxonServerNodeDeletionRequested((String)a3));
        if (clusterController2.M.getName().equals(a3)) {
            ClusterController clusterController3 = a2;
            clusterController = clusterController3;
            clusterController3.l.deleteAllByNameNot((String)a3);
            clusterController3.E.closeAll();
        } else {
            a2.l.findById((String)a3).ifPresent(arg_0 -> a2.I((String)a3, arg_0));
            clusterController = a2;
        }
        clusterController.B.publishEvent((Object)new ClusterEvents.AxonServerNodeDeleted((String)a3));
        a2.E.sync();
    }

    public void closeConnection(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        a3.E.disconnect((String)a2);
    }

    public synchronized void handleRemoteConnection(NodeInfo nodeInfo) {
        ClusterController a2;
        ClusterController a3 = nodeInfo;
        ClusterController clusterController = a2 = this;
        clusterController.I((NodeInfo)a3);
        clusterController.E.updateNodeInfo((NodeInfo)a3);
        clusterController.B.publishEvent((Object)new ClusterEvents.AxonServerNodeConnected((NodeInfo)a3));
    }

    public boolean isActive(String string) {
        String a2 = string;
        ClusterController a3 = this;
        if (a2.equals(a3.M.getName()) || a3.E.get(a2) != null && a3.E.get(a2).isConnected()) {
            return true;
        }
        return false;
    }

    public int getPhase() {
        return 50;
    }

    public Stream<ClusterNode> nodes() {
        ClusterController a2;
        return a2.l.findAll().peek(clusterNode -> {
            ClusterController a2 = clusterNode;
            ClusterController a3 = this;
            if (a2 == null) {
                return null;
            }
            a2.setTags(a3.I.getClusterTags().getOrDefault(a2.getName(), Collections.emptyMap()));
            return a2;
        });
    }

    public void deleteOtherNodes() {
        ClusterController a2;
        ClusterController clusterController = a2;
        a2.l.deleteAllByNameNot(clusterController.getName());
        clusterController.E.sync();
    }

    @Transactional
    public void start() {
        ClusterController a2;
        a2.I();
        a2.A = true;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void I(String string, Integer n) {
        Integer a2 = n;
        ClusterController a3 = this;
        if (a3.E.size() + 1 >= a2) {
            void a4;
            throw new MessagingPlatformException(ErrorCode.MAX_CLUSTER_SIZE_REACHED, "Maximum allowed number of nodes reached " + (String)a4);
        }
    }

    public ClusterNode getMe() {
        ClusterController a2;
        ClusterController clusterController = a2;
        return clusterController.I((ClusterNode)clusterController.b.get());
    }

    private /* synthetic */ void I(String string, ClusterNode clusterNode) {
        Object a2 = string;
        ClusterController a3 = this;
        a3.l.deleteById((String)a2);
    }

    private /* synthetic */ void I(NodeInfo nodeInfo) {
        ClusterController a2 = nodeInfo;
        ClusterController a3 = this;
        if (a2.getNodeName().equals(a3.M.getName())) {
            return;
        }
        a3.E.connect((NodeInfo)a2, true);
    }

    private /* synthetic */ ClusterNode I(NodeInfo nodeInfo) {
        ClusterController a2;
        ClusterController a3 = nodeInfo;
        ClusterController clusterController = a2 = this;
        clusterController.f.info(CommandInformation.I((Object)"T\u001eqZ{\u0015q\u001f5\u0001h"), (Object)a3);
        a3 = clusterController.D.clusterNode((NodeInfo)a3);
        return clusterController.l.save((ClusterNode)a3);
    }

    public boolean isAdminNode() {
        ClusterController a2;
        return a2.b.isAdmin();
    }

    public Optional<RemoteConnection> getRemoteConnection(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        return Optional.ofNullable(a3.E.get((String)a2));
    }

    public ClusterNode getNode(String string) {
        String a2 = string;
        Object a3 = this;
        if (a2.equals(a3.getName())) {
            return a3.getMe();
        }
        ClusterController clusterController = a3;
        return clusterController.I(clusterController.l.findById(a2).orElseGet(() -> {
            Object a2 = a2;
            ClusterController a3 = this;
            if ((a2 = a3.E.get((String)a2)) == null) {
                return null;
            }
            return a2.getClusterNode();
        }));
    }

    @Transactional
    public synchronized ClusterNode addConnection(NodeInfo nodeInfo) {
        ClusterController a2 = nodeInfo;
        ClusterController a3 = this;
        ClusterController clusterController = a2;
        a3.I(clusterController.getNodeName());
        if (clusterController.getNodeName().equals(a3.M.getName())) {
            ClusterController clusterController2 = a3;
            clusterController2.f.info(CommandInformation.I((Object)"A\bl\u0013{\u001d5\u000ezZ\u007f\u0015|\u00145\r|\u000e}Zv\u000fg\bp\u0014aZ{\u0015q\u001f5\u0014t\u0017p@5\u0001h"), (Object)a2.getNodeName());
            return clusterController2.getMe();
        }
        if (a2.getInternalHostName().equals(a3.M.getInternalHostname()) && a2.getGrpcInternalPort() == a3.M.getInternalPort()) {
            throw new MessagingPlatformException(ErrorCode.SAME_NODE_NAME, ClientVersionUpdate.I((Object)"V.{!z;5%z&{ov#`<a*gob&a'5<t\"po} f;{.x*5.{+5&{;p={.yoe g;"));
        }
        ClusterNode clusterNode = a3.l.findById(a2.getNodeName()).orElseGet(() -> a3.I((NodeInfo)a2));
        if (!a3.E.contains(a2.getNodeName())) {
            a3.I((NodeInfo)a2);
        }
        return clusterNode;
    }

    private /* synthetic */ void I() {
        Object a2;
        ClusterController clusterController;
        ClusterController clusterController2 = clusterController = this;
        Object object = clusterController2.l.findById(clusterController2.M.getName());
        if (((Optional)object).isEmpty()) {
            if (clusterController.l.findAll().findAny().isPresent()) {
                Object[] objectArray = new Object[1];
                objectArray[0] = clusterController.M.getName();
                a2 = String.format(CommandInformation.I((Object)"9`\bg\u001f{\u000e5\u0014z\u001epZ{\u001bx\u001f5\u0012t\t5\u0019}\u001b{\u001dp\u001e9Z{\u001fbZ{\u001bx\u001f5_fT5)a\u001bg\u000e5;m\u0015{)p\bc\u001fgZb\u0013a\u00125\bp\u0019z\fp\blZs\u0013y\u001f;"), objectArray);
                throw new FailedToStartException((String)a2);
            }
            ClusterController clusterController3 = clusterController;
            a2 = clusterController3.D.clusterNode(clusterController3.M.getName(), clusterController.M.getFullyQualifiedHostname(), clusterController.M.getFullyQualifiedInternalHostname(), clusterController.M.getPort(), clusterController.M.getInternalPort(), clusterController.M.getHttpPort());
            clusterController3.l.save((ClusterNode)a2);
            return;
        }
        a2 = (ClusterNode)((Optional)object).get();
        if (!a2.getInternalHostName().equals(clusterController.M.getFullyQualifiedInternalHostname()) || !a2.getGrpcInternalPort().equals(clusterController.M.getInternalPort())) {
            Object[] objectArray = new Object[4];
            objectArray[0] = a2.getInternalHostName();
            objectArray[1] = a2.getGrpcInternalPort();
            objectArray[2] = clusterController.M.getFullyQualifiedInternalHostname();
            objectArray[3] = clusterController.M.getInternalPort();
            object = String.format(ClientVersionUpdate.I((Object)"V:g=p!ao{ q*2<5&{;p={.yo} f;{.x*:?z=ao=jfu0+<o}.fov't!r*qc5o{*boc.y:p<5jfu0+;oF;t=aoT7z!F*g9p=58|;}og*v c*g65)|#pa"), objectArray);
            throw new FailedToStartException((String)object);
        }
    }

    public boolean isRunning() {
        ClusterController a2;
        return a2.A;
    }

    public Collection<RemoteConnection> getRemoteConnections() {
        ClusterController a2;
        return a2.E.connections();
    }

    public void stop() {
        a.A = false;
    }

    private /* synthetic */ void I(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        if (a3.E.contains((String)a2) || a3.M.getName().equals(a2)) {
            return;
        }
        a3.J.getMaxClusterSize().ifPresent(arg_0 -> a3.I((String)a2, arg_0));
    }
}

