/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.component.version.ClientVersionUpdate;
import io.axoniq.axonserver.config.AxonServerRoutingConfiguration;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.grpc.AuthenticationProvider;
import io.axoniq.axonserver.grpc.AxonServerClientService;
import io.axoniq.axonserver.grpc.ClientIdRegistry;
import io.axoniq.axonserver.grpc.CommandService;
import io.axoniq.axonserver.grpc.ContextProvider;
import io.axoniq.axonserver.grpc.GrpcCommandDispatcherListener;
import io.axoniq.axonserver.grpc.GrpcExceptionBuilder;
import io.axoniq.axonserver.grpc.InstructionAck;
import io.axoniq.axonserver.grpc.InstructionAckSource;
import io.axoniq.axonserver.grpc.SerializedCommand;
import io.axoniq.axonserver.grpc.SerializedCommandProviderInbound;
import io.axoniq.axonserver.grpc.SerializedCommandResponse;
import io.axoniq.axonserver.grpc.command.CommandProviderOutbound;
import io.axoniq.axonserver.grpc.command.CommandServiceGrpc;
import io.axoniq.axonserver.grpc.heartbeat.ApplicationInactivityException;
import io.axoniq.axonserver.message.ByteStringMarshaller;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.message.command.CommandDispatcher;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.rest.json.MessageJson;
import io.axoniq.axonserver.topology.Topology;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service(value="CommandService")
public class CommandService
implements AxonServerClientService {
    private final AuthenticationProvider e;
    private final ContextProvider G;
    private final Topology i;
    @Value(value="${axoniq.axonserver.command-threads:1}")
    private int j;
    private final Logger b;
    private final Map<ClientStreamIdentification, GrpcCommandDispatcherListener> I;
    private static final MethodDescriptor<ByteString, SerializedCommandResponse> l = CommandServiceGrpc.getDispatchMethod().toBuilder((MethodDescriptor.Marshaller)ByteStringMarshaller.I(), ProtoUtils.marshaller((Message)SerializedCommandResponse.getDefaultInstance())).build();
    private final CommandDispatcher J;
    private final ClientIdRegistry A;
    private final MeterFactory B;
    private static final MethodDescriptor<CommandProviderOutbound, SerializedCommandProviderInbound> D = CommandServiceGrpc.getOpenStreamMethod().toBuilder(ProtoUtils.marshaller((Message)CommandProviderOutbound.getDefaultInstance()), ProtoUtils.marshaller((Message)SerializedCommandProviderInbound.getDefaultInstance())).build();
    private final ApplicationEventPublisher f;
    private final InstructionAckSource<SerializedCommandProviderInbound> E;
    private final AxonServerRoutingConfiguration M;

    /*
     * WARNING - void declaration
     */
    public CommandService(Topology topology, CommandDispatcher commandDispatcher, ContextProvider contextProvider, AuthenticationProvider authenticationProvider, ClientIdRegistry clientIdRegistry, MeterFactory meterFactory, ApplicationEventPublisher applicationEventPublisher, @Qualifier(value="commandInstructionAckSource") InstructionAckSource<SerializedCommandProviderInbound> instructionAckSource, AxonServerRoutingConfiguration axonServerRoutingConfiguration) {
        void instructionAckSource2;
        void eventPublisher;
        void meterFactory2;
        void clientIdRegistry2;
        void authenticationProvider2;
        void contextProvider2;
        void commandDispatcher2;
        void topology2;
        CommandService a2;
        CommandService commandService = commandService2;
        CommandService commandService2 = axonServerRoutingConfiguration;
        CommandService commandService3 = a2 = commandService;
        CommandService commandService4 = a2;
        CommandService commandService5 = a2;
        CommandService commandService6 = a2;
        CommandService commandService7 = a2;
        a2.b = LoggerFactory.getLogger(CommandService.class);
        CommandService commandService8 = a2;
        a2.I = new ConcurrentHashMap();
        commandService7.j = 1;
        commandService7.i = topology2;
        commandService6.J = commandDispatcher2;
        commandService6.G = contextProvider2;
        commandService5.e = authenticationProvider2;
        commandService5.A = clientIdRegistry2;
        commandService4.B = meterFactory2;
        commandService4.f = eventPublisher;
        commandService3.E = instructionAckSource2;
        commandService3.M = commandService2;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void I(String string, StreamObserver streamObserver, SerializedCommandResponse serializedCommandResponse) {
        void a2;
        void a3;
        CommandService a4 = serializedCommandResponse;
        CommandService a5 = this;
        a5.I((String)a3, (SerializedCommandResponse)a4, (StreamObserver)a2);
    }

    @PreDestroy
    public void cleanup() {
        CommandService a2;
        a2.I.forEach((clientStreamIdentification, grpcCommandDispatcherListener) -> {
            ClientStreamIdentification a2 = grpcCommandDispatcherListener;
            ClientStreamIdentification a3 = clientStreamIdentification;
            a2.cancel();
        });
        a2.I.clear();
    }

    public Set<GrpcCommandDispatcherListener> listeners() {
        CommandService a2;
        return new HashSet<GrpcCommandDispatcherListener>(a2.I.values());
    }

    private /* synthetic */ boolean I(InstructionAck instructionAck) {
        CommandService a2 = instructionAck;
        CommandService a3 = this;
        if (a2.hasError() && a2.getError().getErrorCode().equals(ErrorCode.UNSUPPORTED_INSTRUCTION.getCode())) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public StreamObserver<CommandProviderOutbound> openStream(StreamObserver<SerializedCommandProviderInbound> streamObserver) {
        void a2;
        CommandService commandService = this;
        String string = commandService.G.getContext();
        Object a3 = new ConcurrentHashMap();
        1 var4_4 = new /* Unavailable Anonymous Inner Class!! */;
        CommandService commandService2 = commandService;
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    /*
     * WARNING - void declaration
     */
    public void dispatch(ByteString byteString, StreamObserver<SerializedCommandResponse> streamObserver) {
        void a2;
        CommandService a222 = byteString;
        CommandService a3 = this;
        a222 = new SerializedCommand((ByteString)a222);
        String string = a222.wrapped().getClientId();
        if (a3.b.isTraceEnabled()) {
            a3.b.trace(ClientVersionUpdate.I((Object)"n2/oG*v*|9p+5,z\"x.{+/on2"), (Object)string, (Object)a222.wrapped().getName());
        }
        try {
            CommandService commandService = a3;
            commandService.J.dispatch(commandService.G.getContext(), (Authentication)a3.e.get(), (SerializedCommand)a222, arg_0 -> a3.I(string, (StreamObserver)a2, arg_0));
            return;
        }
        catch (Exception a222) {
            Exception exception = a222;
            a3.b.warn(MessageJson.I((Object)"?\u001f\b\u0006\u001a\u0002\u0018\u001e\u0012\u0018\u001cV\u001d\u0017\u0012\u001a\u001e\u0012[\u0001\u0012\u0002\u0013V\u000e\u0018\u001e\u000e\u000b\u0013\u0018\u0002\u001e\u0012[\u0013\t\u0004\u0014\u0004"), (Throwable)exception);
            a2.onError((Throwable)GrpcExceptionBuilder.build((Throwable)exception));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void completeStreamForInactivity(String string, ClientStreamIdentification clientStreamIdentification) {
        CommandService a2 = clientStreamIdentification;
        CommandService a3 = this;
        if (a3.I.containsKey(a2)) {
            void a4;
            String string2 = "Command stream inactivity for " + a2.I();
            string2 = new ApplicationInactivityException(string2);
            ((GrpcCommandDispatcherListener)a3.I.remove(a2)).cancelAndCompleteStreamExceptionally((Throwable)((Object)string2));
            CommandService commandService = a3;
            commandService.b.debug(MessageJson.I((Object)"8\u0019\u0016\u001b\u001a\u0018\u001fV(\u0002\t\u0013\u001a\u001b[\u0015\u0017\u0019\b\u0013\u001fV\u001d\u0019\tV\u0018\u001a\u0012\u0013\u0015\u0002AV\u0000\u000b"), (Object)a2);
            commandService.f.publishEvent((Object)new TopologyEvents.CommandHandlerDisconnected(a2.M(), (String)a4, a2.I()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void I(String string, SerializedCommandResponse serializedCommandResponse, StreamObserver<SerializedCommandResponse> streamObserver) {
        CommandService a22 = serializedCommandResponse;
        CommandService a3 = this;
        try {
            void a4;
            void v0 = a4;
            v0.onNext((Object)a22);
            v0.onCompleted();
            return;
        }
        catch (RuntimeException a22) {
            void a5;
            a3.b.debug(ClientVersionUpdate.I((Object)"G*f?z!f*5;zov#|*{;54hos.|#p+"), (Object)a5, (Object)a22);
            return;
        }
    }

    public final ServerServiceDefinition bindService() {
        CommandService a2;
        return ServerServiceDefinition.builder((String)MessageJson.I((Object)"\u0012\u0019U\u0017\u0003\u0019\u0015\u001f\nX\u001a\u000e\u0014\u0018\b\u0013\t\u0000\u001e\u0004U\u0011\t\u0006\u0018X\u0018\u0019\u0016\u001b\u001a\u0018\u001fX8\u0019\u0016\u001b\u001a\u0018\u001f%\u001e\u0004\r\u001f\u0018\u0013")).addMethod(D, ServerCalls.asyncBidiStreamingCall(arg_0 -> a2.openStream(arg_0))).addMethod(l, ServerCalls.asyncUnaryCall((arg_0, arg_1) -> a2.dispatch(arg_0, arg_1))).build();
    }
}

