/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc;

import io.axoniq.axonserver.AxonServerAccessController;
import io.axoniq.axonserver.LicenseAccessController;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.grpc.AuthenticationInterceptor;
import io.axoniq.axonserver.grpc.AxonServerClientService;
import io.axoniq.axonserver.grpc.ContextInterceptor;
import io.axoniq.axonserver.grpc.GrpcBufferingInterceptor;
import io.axoniq.axonserver.grpc.LicenseInterceptor;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.rest.QueryRestController;
import io.axoniq.axonserver.transport.rest.v2.ApplicationRestControllerV2;
import io.grpc.Server;
import io.grpc.ServerCredentials;
import io.grpc.ServerInterceptor;
import io.grpc.ServerTransportFilter;
import io.grpc.TlsServerCredentials;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.util.AdvancedTlsX509KeyManager;
import java.io.File;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;

@Component(value="Gateway")
public class Gateway
implements SmartLifecycle {
    private final Supplier<ScheduledExecutorService> i;
    private final Logger j;
    private final MeterFactory b;
    private boolean I;
    private final ExecutorService l;
    private final AxonServerAccessController J;
    private final LicenseAccessController A;
    private Server B;
    private final List<AxonServerClientService> D;
    private final List<ServerTransportFilter> f;
    private AdvancedTlsX509KeyManager.Closeable E;
    private final MessagingPlatformConfiguration M;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        Gateway gateway = this;
        String string = QueryRestController.I((Object)".0`\f\u0013\u0013");
        try {
            Gateway a2;
            Gateway gateway2;
            if (gateway.M.getSsl() != null && gateway.M.getSsl().isEnabled()) {
                AdvancedTlsX509KeyManager advancedTlsX509KeyManager = new AdvancedTlsX509KeyManager();
                gateway.E = advancedTlsX509KeyManager.updateIdentityCredentialsFromFile(new File(gateway.M.getSsl().getPrivateKeyFile()), new File(gateway.M.getSsl().getCertChainFile()), 1L, TimeUnit.MINUTES, (ScheduledExecutorService)gateway.i.get());
                KeyManager[] keyManagerArray = new KeyManager[1];
                keyManagerArray[0] = advancedTlsX509KeyManager;
                ServerCredentials serverCredentials = TlsServerCredentials.newBuilder().keyManager(keyManagerArray).clientAuth(TlsServerCredentials.ClientAuth.NONE).build();
                string = ApplicationRestControllerV2.I((Object)"!\u0012>a\u0017/\u0013#\u001e$\u0016");
                Gateway gateway3 = gateway;
                gateway2 = gateway3;
                a2 = NettyServerBuilder.forPort((int)gateway3.M.getPort(), (ServerCredentials)serverCredentials);
            } else {
                Gateway gateway4 = gateway;
                gateway2 = gateway4;
                a2 = NettyServerBuilder.forPort((int)gateway4.M.getPort());
            }
            if (gateway2.M.getMaxMessageSize() > 0) {
                a2.maxInboundMessageSize(gateway.M.getMaxMessageSize());
            }
            a2.permitKeepAliveWithoutCalls(true).permitKeepAliveTime(gateway.M.getMinKeepAliveTime(), TimeUnit.MILLISECONDS);
            gateway.D.forEach(arg_0 -> ((NettyServerBuilder)a2).addService(arg_0));
            a2.intercept((ServerInterceptor)new GrpcBufferingInterceptor(gateway.M.getGrpcBufferedMessages()));
            if (gateway.M.getAccesscontrol().isEnabled()) {
                Gateway gateway5 = gateway;
                a2.intercept((ServerInterceptor)new AuthenticationInterceptor(gateway5.J, gateway5.b));
            }
            a2.intercept((ServerInterceptor)new LicenseInterceptor(gateway.A));
            a2.intercept((ServerInterceptor)new ContextInterceptor());
            if (gateway.M.getKeepAliveTime() > 0L) {
                a2.keepAliveTime(gateway.M.getKeepAliveTime(), TimeUnit.MILLISECONDS).keepAliveTimeout(gateway.M.getKeepAliveTimeout(), TimeUnit.MILLISECONDS);
            }
            a2.executor((Executor)gateway.l);
            gateway.f.forEach(arg_0 -> ((NettyServerBuilder)a2).addTransportFilter(arg_0));
            gateway.B = a2.build();
            gateway.B.start();
            gateway.j.info(QueryRestController.I((Object)"\u0001'/1`\f%-6:2\u007f\u0007>4:7>9\u007f3+!-4:$\u007f/1`//-4e`$=\u007fm\u007f;\""), (Object)gateway.M.getPort(), (Object)string);
            gateway.I = true;
            return;
        }
        catch (Exception exception) {
            throw new FailedToStartException(ApplicationRestControllerV2.I((Object)"!5\u00133\u0006(\u001c&R\u0000\n.\u001ca!$\u00007\u00173R\u0006\u00135\u00176\u00138R'\u0013(\u001e$\u0016"), (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Autowired
    public Gateway(MessagingPlatformConfiguration messagingPlatformConfiguration, List<AxonServerClientService> list, List<ServerTransportFilter> list2, AxonServerAccessController axonServerAccessController, LicenseAccessController licenseAccessController, Supplier<ScheduledExecutorService> supplier, MeterFactory meterFactory) {
        Gateway a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        Gateway a9;
        Gateway gateway = gateway2;
        Gateway gateway2 = meterFactory;
        Gateway gateway3 = a9 = gateway;
        Gateway gateway4 = a9;
        Gateway gateway5 = a9;
        Gateway gateway6 = a9;
        gateway6.j = LoggerFactory.getLogger(Gateway.class);
        gateway6.M = a8;
        gateway5.D = a7;
        gateway5.f = a6;
        gateway4.J = a5;
        gateway4.A = a4;
        a9.i = a3;
        gateway3.b = a2;
        gateway3.l = Executors.newFixedThreadPool(a9.M.getExecutorThreadCount(), (ThreadFactory)new CustomizableThreadFactory(QueryRestController.I((Object)"'-0<m:8:#*402r")));
    }

    public int getPhase() {
        return 200;
    }

    public void stop() {
        Gateway gateway = this;
        if (gateway.E != null) {
            gateway.E.close();
        }
        Gateway gateway2 = gateway;
        gateway2.l.shutdown();
        if (gateway2.I) {
            try {
                if (!gateway.B.shutdown().awaitTermination(1L, TimeUnit.SECONDS)) {
                    Gateway gateway3 = gateway;
                    gateway3.j.debug(ApplicationRestControllerV2.I((Object)"\u0007\u001d3\u0011$\u00144\u001e-\u000ba\u00015\u001d1\u0002(\u001c&R\u0002\u001e4\u00015\u00173R\u0012\u00173\u0004$\u0000"));
                    gateway3.B.shutdownNow();
                }
            }
            catch (InterruptedException a2) {
                gateway.j.debug(QueryRestController.I((Object)"\t14:2-5/4:$\u007f$*26.8`,(*4;/(.\u007f/9`\u0018\u0012\u000f\u0003\u007f3:2)%-"), (Throwable)a2);
                Thread.currentThread().interrupt();
            }
        }
        gateway.I = false;
        gateway.j.info(ApplicationRestControllerV2.I((Object)"39\u001d/R\u0012\u00173\u0004$\u0000a5 \u0006$\u0005 \u000ba\u00015\u001d1\u0002$\u0016"));
    }

    public boolean isAutoStartup() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public Gateway(MessagingPlatformConfiguration messagingPlatformConfiguration, List<AxonServerClientService> list, List<ServerTransportFilter> list2, AxonServerAccessController axonServerAccessController, LicenseAccessController licenseAccessController, MeterFactory meterFactory) {
        Gateway a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        Gateway gateway = gateway2;
        Gateway gateway2 = meterFactory;
        Gateway a8 = gateway;
        a8((MessagingPlatformConfiguration)a7, (List)a6, (List)a5, (AxonServerAccessController)a4, (LicenseAccessController)a3, Executors::newSingleThreadScheduledExecutor, (MeterFactory)a2);
    }

    public boolean isRunning() {
        Gateway a2;
        return a2.I;
    }
}

