/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage;

import io.axoniq.axonserver.admin.tier.api.LocalTierInfoJSON;
import io.axoniq.axonserver.component.ComponentItems;
import io.axoniq.axonserver.grpc.event.Event;
import io.axoniq.axonserver.grpc.event.EventWithToken;
import io.axoniq.axonserver.localstorage.EventStorageEngine;
import io.axoniq.axonserver.localstorage.EventTypeContext;
import io.axoniq.axonserver.localstorage.IndexBackup;
import io.axoniq.axonserver.localstorage.QueryOptions;
import io.axoniq.axonserver.localstorage.Registration;
import io.axoniq.axonserver.localstorage.SerializedEvent;
import io.axoniq.axonserver.localstorage.SerializedEventWithToken;
import io.axoniq.axonserver.localstorage.SerializedTransactionWithToken;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.springframework.data.util.CloseableIterator;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface EventStorageEngine {
    public Flux<SerializedEvent> eventsPerAggregate(String var1, long var2, long var4, long var6);

    public void processEventsPerAggregate(String var1, long var2, long var4, long var6, Consumer<SerializedEvent> var8);

    public CloseableIterator<SerializedTransactionWithToken> transactionIterator(long var1, long var3);

    default public long getFirstCompletedSegment() {
        return -1L;
    }

    public void query(QueryOptions var1, Predicate<EventWithToken> var2);

    default public long getLastToken() {
        return -1L;
    }

    public long getFirstToken();

    public Registration registerCloseListener(Runnable var1);

    public void processEventsPerAggregateHighestFirst(String var1, long var2, long var4, int var6, Predicate<SerializedEvent> var7, Consumer<SerializedEvent> var8);

    default public long store(List<Event> list) {
        Object a2 = list;
        EventStorageEngine a3 = this;
        return a3.store((List)a2, 0);
    }

    default public long store(List<Event> list, int n) {
        int a2 = n;
        EventStorageEngine a3 = this;
        throw new UnsupportedOperationException(ComponentItems.I((Object)"e*Y,S~Y.S,W*_1X~X1B~E+F.Y,B;R"));
    }

    default public byte transactionVersion() {
        return 0;
    }

    public CloseableIterator<SerializedEventWithToken> getGlobalIterator(long var1);

    public EventTypeContext getType();

    public long nextToken();

    default public void validateTransaction(long l2, List<Event> eventStorageEngine) {
        Object a2 = eventStorageEngine;
        eventStorageEngine = this;
    }

    default public Registration registerEventListener(BiConsumer<Long, List<Event>> biConsumer) {
        Object a2 = biConsumer;
        EventStorageEngine a3 = this;
        return () -> {};
    }

    default public void close(boolean bl) {
        boolean a2 = bl;
        EventStorageEngine eventStorageEngine = this;
    }

    default public void init(boolean bl) {
        boolean a2 = bl;
        EventStorageEngine a3 = this;
        a3.init(a2, 0L);
    }

    default public Mono<Void> deleteOldVersions() {
        return Mono.error((Throwable)new UnsupportedOperationException(LocalTierInfoJSON.I((Object)"\t#\u0001#\u0019#>#\n+\b(\u00195Wf\"6\b4\f2\u0004)\u0003f\u0003)\u0019f\u001e3\u001d6\u00024\u0019#\tf\u000f?M2\u0005/\u001ef(0\b(\u0019\u0015\u0019)\u001f'\n#((\n/\u0003#")));
    }

    default public Optional<Long> getLastSequenceNumber(String string, SearchHint searchHint, long l2) {
        Object a2 = string;
        EventStorageEngine a3 = this;
        return a3.getLastSequenceNumber((String)a2, new SearchHint[0]);
    }

    default public IndexBackup.BackupIndexResult backupIndex(IndexBackup.BackupIndexConfig backupIndexConfig) {
        EventStorageEngine a2 = backupIndexConfig;
        EventStorageEngine a3 = this;
        throw new UnsupportedOperationException();
    }

    public void init(boolean var1, long var2);

    public long size();

    default public boolean validateSnapshot(SerializedEvent serializedEvent) {
        EventStorageEngine a2 = serializedEvent;
        EventStorageEngine a3 = this;
        return true;
    }

    default public Stream<String> getBackupFilenames(long l2, int n, boolean bl) {
        boolean bl2 = bl;
        EventStorageEngine a2 = this;
        throw new UnsupportedOperationException();
    }

    public long getTokenAt(long var1);

    public Flux<Long> transformContents(int var1, Flux<EventWithToken> var2);

    public Optional<SerializedEvent> getLastEvent(String var1, long var2, long var4);

    public Optional<Long> getLastSequenceNumber(String var1, SearchHint ... var2);
}

