/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file;

import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.localstorage.file.AggregateSequence;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.rest.json.QueryRequestJson;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class FileUtils {
    public static final Logger M = LoggerFactory.getLogger(FileUtils.class);

    public static boolean I(File file) {
        File file2 = file;
        if (!file2.exists()) {
            return true;
        }
        M.debug(AggregateSequence.I((Object)"\u000eM&M>MjN#D/\b1U"), (Object)file2.getAbsolutePath());
        try {
            Files.delete(file2.toPath());
        }
        catch (DirectoryNotEmptyException a2) {
            M.info(QueryRequestJson.I((Object)"T\u0012{\u001fw\u00172\u0007}Sv\u0016~\u0016f\u00162\u0017{\u0001w\u0010f\u001c`\n(Si\u000e>S{\u00072\u001aaS|\u001cfSw\u001eb\u0007k"), (Object)file2);
            return false;
        }
        catch (IOException a2) {
            M.warn(AggregateSequence.I((Object)"\fI#D/Lj\\%\b.M&M>Mp\b1U"), (Object)file2, (Object)a2);
            return false;
        }
        return true;
    }

    public static FileVersion I(String string) {
        String string2 = string;
        String string3 = string2;
        String a2 = string3.substring(0, string3.indexOf(46));
        int n = a2.indexOf(95);
        if (n < 0) {
            return new FileVersion(Long.parseLong(a2), 0);
        }
        return new FileVersion(Long.parseLong(a2.substring(0, n)), Integer.parseInt(a2.substring(n + 1)));
    }

    private static /* synthetic */ boolean I(String string, File file, String string2) {
        String a2 = string2;
        String a3 = string;
        return a2.endsWith(a3);
    }

    private /* synthetic */ FileUtils() {
        FileUtils a2;
    }

    public static String I(File a2) {
        try {
            return a2.getCanonicalFile().getAbsolutePath();
        }
        catch (IOException iOException) {
            return a2.getAbsolutePath();
        }
    }

    public static String[] I(File file, String string) {
        String[] a2 = string;
        File a3 = file;
        if ((a2 = a3.list((arg_0, arg_1) -> FileUtils.I((String)a2, arg_0, arg_1))) == null) {
            throw new MessagingPlatformException(ErrorCode.DATAFILE_READ_ERROR, "Could not list files in " + a3.getAbsolutePath());
        }
        return a2;
    }

    public static void I(File a2) {
        if (a2.exists() && !a2.isDirectory()) {
            throw new MessagingPlatformException(ErrorCode.DIRECTORY_CREATION_FAILED, "Could not setup directory " + a2.getAbsolutePath());
        }
        if (!a2.exists() && !a2.mkdirs()) {
            throw new MessagingPlatformException(ErrorCode.DIRECTORY_CREATION_FAILED, "Could not setup directory " + a2.getAbsolutePath());
        }
    }

    public static Mono<Void> I(File file, File file2) {
        File a2 = file2;
        File a3 = file;
        return Mono.create(monoSink -> {
            void a2;
            File file3 = a3;
            try {
                void v1;
                void a3;
                if (Files.getFileStore(file3.toPath()).equals(Files.getFileStore(a3.getParentFile().toPath()))) {
                    CopyOption[] copyOptionArray = new CopyOption[1];
                    copyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
                    Files.move(file3.toPath(), a3.toPath(), copyOptionArray);
                    v1 = a2;
                } else {
                    File a4 = File.createTempFile(a3.getName(), QueryRequestJson.I((Object)"]f\u001eb"), a3.getParentFile());
                    a4.deleteOnExit();
                    CopyOption[] copyOptionArray = new CopyOption[1];
                    copyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
                    Files.copy(file3.toPath(), a4.toPath(), copyOptionArray);
                    Files.delete(file3.toPath());
                    CopyOption[] copyOptionArray2 = new CopyOption[1];
                    copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
                    Files.move(a4.toPath(), a3.toPath(), copyOptionArray2);
                    v1 = a2;
                }
                v1.success();
                return;
            }
            catch (Exception a4) {
                a2.error((Throwable)a4);
                return;
            }
        }).subscribeOn(Schedulers.boundedElastic());
    }
}

