/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file;

import io.axoniq.axonserver.config.FileSystemMonitor;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.event.Event;
import io.axoniq.axonserver.localstorage.EventTypeContext;
import io.axoniq.axonserver.localstorage.file.AbstractFileStorageTier;
import io.axoniq.axonserver.localstorage.file.ByteBufferEventSource;
import io.axoniq.axonserver.localstorage.file.E;
import io.axoniq.axonserver.localstorage.file.EventInformation;
import io.axoniq.axonserver.localstorage.file.EventSource;
import io.axoniq.axonserver.localstorage.file.FilePreparedTransaction;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.IndexEntry;
import io.axoniq.axonserver.localstorage.file.IndexManager;
import io.axoniq.axonserver.localstorage.file.Segment;
import io.axoniq.axonserver.localstorage.file.StorageProperties;
import io.axoniq.axonserver.localstorage.file.StorageTier;
import io.axoniq.axonserver.localstorage.file.Synchronizer;
import io.axoniq.axonserver.localstorage.file.WritableEventSource;
import io.axoniq.axonserver.localstorage.file.WritePosition;
import io.axoniq.axonserver.localstorage.transformation.EventTransformer;
import io.axoniq.axonserver.localstorage.transformation.EventTransformerFactory;
import io.axoniq.axonserver.localstorage.transformation.ProcessedEvent;
import io.axoniq.axonserver.localstorage.transformation.WrappedEvent;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.rest.json.MessageJson;
import io.axoniq.axonserver.taskscheduler.TaskPublisher;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tags;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class WritableFileStorageTier
extends AbstractFileStorageTier {
    private final EventTransformer I;
    protected final ConcurrentNavigableMap<Long, ByteBufferEventSource> l;
    private static final Logger a = LoggerFactory.getLogger(WritableFileStorageTier.class);
    private final Synchronizer J;
    private final Gauge A;
    private Path B;
    private final MeterFactory D;
    protected final AtomicReference<WritePosition> f;
    private final FileSystemMonitor E;
    protected final AtomicLong M;

    public void initSegments(long a2) {
    }

    /*
     * WARNING - void declaration
     */
    public void I(long l2, long l3) {
        void a2;
        void a3;
        WritableFileStorageTier writableFileStorageTier = this;
        WritableFileStorageTier a4 = (StorageProperties)writableFileStorageTier.f.get();
        File file = new File(writableFileStorageTier.g);
        FileUtils.I((File)file);
        WritableFileStorageTier writableFileStorageTier2 = writableFileStorageTier;
        writableFileStorageTier.D.init();
        writableFileStorageTier2.I((long)a3, file, (long)a2, (StorageProperties)a4);
        writableFileStorageTier2.B = file.toPath();
        writableFileStorageTier2.E.registerPath(writableFileStorageTier.I(), writableFileStorageTier.B, a4.minFreeSpace(), a4.warnFreeSpace());
    }

    private /* synthetic */ void M() {
        WritableFileStorageTier writableFileStorageTier = this;
        Object a2 = writableFileStorageTier.segmentsWithoutIndex();
        if (a2.size() > 0) {
            writableFileStorageTier.I((SortedSet)a2);
        }
        a.info(MessageJson.I((Object)"\r\u0006L[?\u0015\u0012\u001e\u000e[\u0019\u0015V\u001f\u001f\b\u001d[\u001f\bV\u000e\u0006[\u0002\u0014V\u001f\u0017\u000f\u0013"), (Object)writableFileStorageTier.l);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void I(WritePosition writePosition, List<ProcessedEvent> list, Map<String, List<IndexEntry>> map) {
        void a2;
        void a3;
        WritableFileStorageTier a4 = writePosition;
        WritableFileStorageTier a5 = this;
        WritableFileStorageTier writableFileStorageTier = a4;
        a4.E.I((List)a3, writableFileStorageTier.l, writableFileStorageTier.A, (arg_0, arg_1, arg_2) -> a5.I((Map)a2, arg_0, arg_1, arg_2));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void I(long l2, Integer n) {
        void a2;
        Integer a3 = n;
        WritableFileStorageTier a4 = this;
        a4.I((long)a2, a3.intValue());
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ WritePosition I(int n, int n2, int n3, WritePosition writePosition) {
        void a2;
        void a3;
        WritePosition a4 = writePosition;
        int a5 = n;
        return a4.I(a5, (int)a3, (int)a2);
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeSegment(long l2, int n) {
        void a2;
        int a3 = n;
        WritableFileStorageTier a4 = this;
        if (a4.l.containsKey((long)a2)) {
            return a4.I((long)a2, a3);
        }
        return (Boolean)a4.I(arg_0 -> WritableFileStorageTier.I((long)a2, a3, arg_0), (Object)true);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void M(WritePosition writePosition) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        WritableFileStorageTier a3 = (ByteBufferEventSource)writableFileStorageTier.l.remove(a2.J);
        a.debug(TaskPublisher.I((Object)"> \u0018%\u0013%V.\u0000$\u0004a\r<Za\u0004$\u001b \u001f/\u001f/\u0011a\u0005$\u0011,\u0013/\u00022La\r<"), (Object)a2.J, (Object)writableFileStorageTier.getSegments());
        if (a3 != null) {
            a3.I((long)((StorageProperties)writableFileStorageTier.f.get()).getPrimaryCleanupDelay());
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean I(long l2, int n) {
        void a2;
        int a3 = n;
        WritableFileStorageTier a4 = this;
        ByteBufferEventSource byteBufferEventSource = (ByteBufferEventSource)a4.l.remove((long)a2);
        if (byteBufferEventSource != null) {
            byteBufferEventSource.I(0L);
        }
        if (a4.D.remove(a3 = new FileVersion((long)a2, a3)) && FileUtils.I((File)a4.I(a3))) {
            return true;
        }
        return false;
    }

    private static /* synthetic */ Optional I(long a2, StorageTier a3) {
        return a3.eventSource(a2);
    }

    public long size() {
        WritableFileStorageTier a3;
        return a3.l.values().stream().mapToLong(a2 -> a2.I.capacity()).sum() + (Long)a3.I(StorageTier::size, (Object)0L);
    }

    /*
     * WARNING - void declaration
     */
    public Integer currentSegmentVersion(Long l2) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        WritableFileStorageTier a3 = (ByteBufferEventSource)writableFileStorageTier.l.get(a2);
        if (a3 != null) {
            return a3.I();
        }
        return (Integer)writableFileStorageTier.I(arg_0 -> WritableFileStorageTier.I((Long)a2, arg_0), (Object)0);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void I(long l2, File file, long l3, StorageProperties storageProperties) {
        WritableFileStorageTier writableFileStorageTier;
        int n;
        WritableFileStorageTier a3;
        HashMap<String, List> a222;
        WritableEventSource a4;
        FileVersion a5;
        long a6;
        WritableFileStorageTier writableFileStorageTier2;
        block10: {
            block8: {
                void a222;
                WritableFileStorageTier writableFileStorageTier3 = writableFileStorageTier2 = this;
                a5 = writableFileStorageTier3.I(a6, (File)a5, new FileVersion((long)a222, 0), (StorageProperties)a4);
                writableFileStorageTier3.I(a5.I());
                a5 = writableFileStorageTier3.I(a5, (StorageProperties)a4);
                writableFileStorageTier3.I((T storageTier) -> {
                    FileVersion a2 = storageTier;
                    FileVersion a3 = a5;
                    a2.initSegments(a3.I());
                });
                WritableFileStorageTier writableFileStorageTier4 = writableFileStorageTier2;
                writableFileStorageTier4.M();
                a4 = writableFileStorageTier4.I(a5, a4.getSegmentSize(), false);
                writableFileStorageTier4.D.remove(a5);
                a6 = a5.I();
                a222 = new HashMap<String, List>();
                a3 = a4.createEventIterator();
                try {
                    WritableFileStorageTier writableFileStorageTier5 = a3;
                    while (writableFileStorageTier5.hasNext()) {
                        EventInformation eventInformation = a3.I();
                        if (eventInformation.I()) {
                            IndexEntry indexEntry = new IndexEntry(eventInformation.I().getAggregateSequenceNumber(), eventInformation.I(), a6);
                            a222.computeIfAbsent(eventInformation.I().getAggregateIdentifier(), a2 -> new LinkedList()).add(indexEntry);
                        }
                        ++a6;
                        writableFileStorageTier5 = a3;
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block9: {
                        if (a3 != null) {
                            try {
                                a3.close();
                                throwable2 = throwable;
                                break block9;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                n = a3.I();
                writableFileStorageTier2.M.set(a6 - 1L);
                if (a3 == null) break block8;
                writableFileStorageTier = writableFileStorageTier2;
                a3.close();
                break block10;
            }
            writableFileStorageTier = writableFileStorageTier2;
        }
        writableFileStorageTier.D.addToActiveSegment(Long.valueOf(a5.I()), a222);
        a4.I(n, 0);
        a3 = new WritePosition(a6, n, a5.I(), a4, Long.valueOf(a5.I()), 0);
        WritableFileStorageTier writableFileStorageTier6 = writableFileStorageTier2;
        writableFileStorageTier6.f.set(a3);
        writableFileStorageTier6.J.M((WritePosition)a3);
        a.info(TaskPublisher.I((Object)"\r<La%$\u0011,\u0013/\u00022V(\u0018(\u0002(\u0017-\u001f;\u0013%"), (Object)writableFileStorageTier2.l);
    }

    public void close(boolean bl) {
        boolean a2 = bl;
        WritableFileStorageTier a3 = this;
        File file = new File(a3.g);
        WritableFileStorageTier writableFileStorageTier = a3;
        WritableFileStorageTier writableFileStorageTier2 = a3;
        writableFileStorageTier.E.unregisterPath(writableFileStorageTier2.I());
        writableFileStorageTier.D.remove((Meter)a3.A);
        writableFileStorageTier2.J.M();
        writableFileStorageTier.l.forEach((l2, byteBufferEventSource) -> {
            void a2;
            WritableFileStorageTier a3 = byteBufferEventSource;
            WritableFileStorageTier a4 = this;
            a3.I(0L);
            if (a2 != false) {
                void a5;
                a4.d(a5.longValue());
            }
        });
        a3.I((T storageTier) -> {
            StorageTier a2 = storageTier;
            boolean a3 = a2;
            a2.close(a3);
        });
        boolean bl2 = a2;
        a3.D.cleanup(bl2);
        if (bl2) {
            FileUtils.I((File)file);
        }
    }

    /*
     * WARNING - void declaration
     */
    public WritableFileStorageTier(EventTypeContext eventTypeContext, IndexManager indexManager, Supplier<StorageProperties> supplier, Supplier<StorageTier> supplier2, MeterFactory meterFactory, ScheduledExecutorService scheduledExecutorService, String string, EventTransformerFactory eventTransformerFactory, FileSystemMonitor fileSystemMonitor) {
        void a2;
        void a3;
        void a4;
        void a5;
        WritableFileStorageTier a6;
        void a7;
        void a8;
        void a9;
        void a10;
        WritableFileStorageTier a11;
        WritableFileStorageTier writableFileStorageTier = writableFileStorageTier2;
        WritableFileStorageTier writableFileStorageTier2 = meterFactory;
        WritableFileStorageTier writableFileStorageTier3 = a11 = writableFileStorageTier;
        WritableFileStorageTier writableFileStorageTier4 = a11;
        super((EventTypeContext)a10, (IndexManager)a9, (Supplier)a8, (Supplier)a7, (MeterFactory)a6, (String)a5);
        WritableFileStorageTier writableFileStorageTier5 = a11;
        writableFileStorageTier5.f = new AtomicReference();
        WritableFileStorageTier writableFileStorageTier6 = a11;
        writableFileStorageTier4.M = new AtomicLong(-1L);
        WritableFileStorageTier writableFileStorageTier7 = a11;
        writableFileStorageTier4.l = new ConcurrentSkipListMap(Comparator.reverseOrder());
        writableFileStorageTier4.D = a6;
        writableFileStorageTier3.E = a4;
        writableFileStorageTier3.I = a3.get(((StorageProperties)a8.get()).getFlags());
        WritableFileStorageTier writableFileStorageTier8 = a11;
        writableFileStorageTier8.J = new Synchronizer((EventTypeContext)a10, (StorageProperties)a8.get(), (MeterFactory)a6, (ScheduledExecutorService)a2, writePosition -> {
            WritableFileStorageTier a2;
            WritableFileStorageTier a3 = writePosition;
            WritableFileStorageTier writableFileStorageTier = a2 = this;
            writableFileStorageTier.D.complete(new FileVersion(a3.J.longValue(), 0));
            writableFileStorageTier.I(arg_0 -> writableFileStorageTier.I((WritePosition)a3, arg_0));
        });
        String[] stringArray = new String[4];
        stringArray[0] = "context";
        stringArray[1] = a10.I();
        stringArray[2] = "type";
        stringArray[3] = a10.I().name();
        a11.A = a6.gauge((MetricName)BaseMetricName.Z, Tags.of((String[])stringArray), (Object)a11.J, synchronizer -> {
            WritableFileStorageTier a2 = synchronizer;
            WritableFileStorageTier a3 = this;
            return (double)a3.M.get() - (double)a2.I();
        });
    }

    public Flux<FileVersion> fileVersions(String string) {
        Object a2 = string;
        WritableFileStorageTier a3 = this;
        return (Flux)a3.I(arg_0 -> WritableFileStorageTier.I((String)a2, arg_0), (Object)Flux.empty());
    }

    public long d() {
        WritableFileStorageTier a2;
        return ((WritePosition)a2.f.get()).A;
    }

    protected Optional<EventSource> I(long a2) {
        WritableFileStorageTier a3;
        if (a3.l.containsKey(a2)) {
            return Optional.of((EventSource)a3.l.get(a2));
        }
        return Optional.empty();
    }

    private static /* synthetic */ Stream M(long l2, int n, StorageTier storageTier) {
        long a2;
        StorageTier a3 = storageTier;
        int a4 = n;
        return a3.getBackupFilenames(a2, a4);
    }

    private static /* synthetic */ Optional M(FileVersion fileVersion, StorageTier storageTier) {
        FileVersion a2 = storageTier;
        FileVersion a3 = fileVersion;
        return a2.eventSource(a3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ FileVersion I(FileVersion fileVersion, StorageProperties storageProperties) {
        WritableFileStorageTier writableFileStorageTier;
        WritableEventSource a2;
        void a3;
        WritableFileStorageTier writableFileStorageTier2 = this;
        if (!writableFileStorageTier2.D.validIndex((FileVersion)a3)) {
            return a3;
        }
        a2 = writableFileStorageTier2.I((FileVersion)a3, a2.getSegmentSize(), false);
        long l2 = a3.I();
        try {
            WritableFileStorageTier a42222 = a2.createEventIterator(a3.I());
            try {
                while (a42222.hasNext()) {
                    a42222.I();
                    ++l2;
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (a42222 != null) {
                    try {
                        a42222.close();
                        throwable2 = throwable;
                        throw throwable2;
                    }
                    catch (Throwable a42222) {
                        throwable.addSuppressed(a42222);
                    }
                }
                throwable2 = throwable;
                throw throwable2;
            }
        }
        catch (Throwable a42222) {
            writableFileStorageTier2.l.remove(a3.I());
            a2.I(0L);
            throw a42222;
        }
        if (a42222 != null) {
            writableFileStorageTier = writableFileStorageTier2;
            a42222.close();
        } else {
            writableFileStorageTier = writableFileStorageTier2;
        }
        writableFileStorageTier.l.remove(a3.I());
        a2.I(0L);
        return new FileVersion(l2, 0);
    }

    public int I() {
        WritableFileStorageTier a2;
        return a2.l.size();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ WritePosition I(int n, int n2, int n3) {
        void a2;
        void a3;
        int a4 = n;
        WritableFileStorageTier a5 = this;
        int n4 = (int)Math.ceil((double)a3 / 32767.0);
        if ((n4 = a4 + n4 * 11) > 0x7FFFFFF6 || a4 <= 0) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a4;
            throw new MessagingPlatformException(ErrorCode.DATAFILE_WRITE_ERROR, String.format(TaskPublisher.I((Object)"?-\u001a$\u0011 \u001aa\u00023\u0017/\u0005 \u00155\u001f.\u0018a\u0005(\f$LaS%"), objectArray));
        }
        do {
            if (!(a4 = (WritePosition)a5.f.getAndUpdate(arg_0 -> WritableFileStorageTier.I((int)a3, n4, (int)a2, arg_0))).M(n4) && !a4.d((int)a2)) continue;
            a.debug(MessageJson.I((Object)"\r\u0006L[5\t\u0013\u001a\u0002\u0012\u0018\u001cV\u0015\u0013\fV\b\u0013\u001c\u001b\u001e\u0018\u000fV\u0000\u000b"), (Object)a5.l, (Object)a4.A);
            WritePosition writePosition = a4;
            writePosition.E.I(writePosition.l, -1);
            WritableEventSource writableEventSource = a5.I(new FileVersion(a4.A, (int)a2), n4 + 5 + 4, true);
            a5.f.set(a4.I(writableEventSource, (int)a2));
        } while (!a4.I(n4) || a4.d((int)a2));
        return a4;
    }

    public long M() {
        WritableFileStorageTier a3;
        return (Long)a3.I((T a2) -> a2.allSegments().findFirst().orElse(-1L), (Object)-1L);
    }

    /*
     * WARNING - void declaration
     */
    public Stream<String> I(long l2, int n, boolean bl) {
        void a2;
        void a3;
        int a4 = n;
        WritableFileStorageTier a5 = this;
        if (a3 != false) {
            return Stream.concat(a5.l.entrySet().stream().map(entry -> {
                Map.Entry a2 = entry;
                Object a3 = this;
                return FileUtils.I((File)a3.I(new FileVersion(((Long)a2.getKey()).longValue(), ((ByteBufferEventSource)a2.getValue()).I())));
            }), (Stream)a5.I(arg_0 -> WritableFileStorageTier.I((long)a2, a4, arg_0), Stream.empty()));
        }
        return (Stream)a5.I(arg_0 -> WritableFileStorageTier.M((long)a2, a4, arg_0), Stream.empty());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ FileVersion I(long l2, File file, FileVersion fileVersion, StorageProperties storageProperties) {
        void a2;
        void a3;
        WritableFileStorageTier a4;
        void a5;
        WritableFileStorageTier writableFileStorageTier = writableFileStorageTier2;
        WritableFileStorageTier writableFileStorageTier2 = storageProperties;
        WritableFileStorageTier a6 = writableFileStorageTier;
        return Arrays.stream(FileUtils.I((File)a5, (String)a4.getEventsSuffix())).map(FileUtils::I).filter(arg_0 -> WritableFileStorageTier.I((long)a3, arg_0)).max(FileVersion::I).orElse((FileVersion)a2);
    }

    private /* synthetic */ void I() {
        WritableFileStorageTier writableFileStorageTier;
        WritableFileStorageTier writableFileStorageTier2 = writableFileStorageTier = this;
        while (true) {
            if (writableFileStorageTier2.l.size() == 1) break;
            try {
                Thread.sleep(10L);
                writableFileStorageTier2 = writableFileStorageTier;
            }
            catch (InterruptedException a2) {
                Thread.currentThread().interrupt();
                throw new MessagingPlatformException(ErrorCode.OTHER, writableFileStorageTier.l + ": Interrupted while waiting for completion", (Throwable)a2);
            }
        }
    }

    protected Optional<EventSource> I(FileVersion fileVersion) {
        WritableFileStorageTier a2 = fileVersion;
        WritableFileStorageTier a3 = this;
        return a3.I(a2.I());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ FilePreparedTransaction I(List<Event> list, int n) {
        void a22;
        Object a3 = list;
        WritableFileStorageTier a4 = this;
        a3 = a3.stream().map(event -> {
            WritableFileStorageTier a2 = event;
            WritableFileStorageTier a3 = this;
            return new WrappedEvent((Event)a2, a3.I);
        }).collect(Collectors.toList());
        WritableFileStorageTier writableFileStorageTier = a4;
        int n2 = writableFileStorageTier.I((List)a3);
        WritePosition a22 = writableFileStorageTier.I(n2, a3.size(), (int)a22);
        return new FilePreparedTransaction(a22, n2, (List)a3);
    }

    public SortedSet<Long> getSegments() {
        WritableFileStorageTier a2;
        return a2.l.keySet();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void I(WritePosition writePosition, StorageTier storageTier) {
        void a2;
        WritableFileStorageTier a3 = writePosition;
        WritableFileStorageTier a4 = this;
        a2.handover((Segment)new E(a4, (WritePosition)a3), () -> a4.M((WritePosition)a3));
    }

    public SortedSet<FileVersion> segmentsWithoutIndex() {
        WritableFileStorageTier a2;
        return (SortedSet)a2.I(StorageTier::segmentsWithoutIndex, Collections.emptySortedSet());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void I(ProcessedEvent processedEvent, long l2, int n, Map<String, List<IndexEntry>> map) {
        WritableFileStorageTier a3 = processedEvent;
        WritableFileStorageTier a4 = this;
        if (a3.isDomainEvent()) {
            void a5;
            void a6;
            void a7;
            a7.computeIfAbsent(a3.getAggregateIdentifier(), a2 -> new ArrayList()).add(new IndexEntry(a3.getAggregateSequenceNumber(), (int)a6, (long)a5));
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void d(long l2) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        ByteBufferEventSource byteBufferEventSource = (ByteBufferEventSource)writableFileStorageTier.l.remove((long)a2);
        int a3 = 0;
        if (byteBufferEventSource != null) {
            ByteBufferEventSource byteBufferEventSource2 = byteBufferEventSource;
            a3 = byteBufferEventSource2.I();
            byteBufferEventSource2.I(0L);
        }
        writableFileStorageTier.I((long)a2, a3).forEach(arg_0 -> writableFileStorageTier.I((long)a2, arg_0));
    }

    public long I(List<Event> list, int n) {
        FilePreparedTransaction a2;
        WritableFileStorageTier a3;
        int a222 = n;
        WritableFileStorageTier writableFileStorageTier = a3 = this;
        WritableFileStorageTier writableFileStorageTier2 = a3;
        writableFileStorageTier.E.checkFreeSpace(writableFileStorageTier2.B);
        HashMap hashMap = new HashMap();
        a2 = writableFileStorageTier.I((List)a2, a222);
        WritePosition a222 = a2.I();
        writableFileStorageTier2.I(a222, a2.I(), hashMap);
        writableFileStorageTier.D.addToActiveSegment(a222.J, hashMap);
        writableFileStorageTier.M.set(a222.A + (long)a2.I().size() - 1L);
        writableFileStorageTier.J.I(a222);
        return a222.A;
    }

    private /* synthetic */ String I() {
        WritableFileStorageTier a2;
        WritableFileStorageTier writableFileStorageTier = a2;
        return writableFileStorageTier.l + "-" + writableFileStorageTier.l.I().name().toLowerCase();
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    protected WritableEventSource I(FileVersion fileVersion, int n, boolean bl) {
        WritableEventSource a2322;
        Object a32222;
        Object object;
        void a4;
        WritableFileStorageTier writableFileStorageTier;
        block21: {
            void a223322;
            writableFileStorageTier = this;
            StorageProperties storageProperties = (StorageProperties)writableFileStorageTier.f.get();
            File file = storageProperties.dataFile(writableFileStorageTier.g, (FileVersion)a4);
            int n2 = Math.max(storageProperties.getSegmentSize(), (int)a223322);
            if (file.exists()) {
                void a2322;
                if (a2322 != false && file.length() < (long)a223322) {
                    object = (ByteBufferEventSource)writableFileStorageTier.l.remove(a4.I());
                    if (object != null) {
                        object.I(0L);
                    }
                    FileUtils.I((File)file);
                } else {
                    n2 = (int)file.length();
                }
            } else if (a4.I() > 0) {
                object = storageProperties.dataFile(writableFileStorageTier.g, new FileVersion(a4.I(), 0));
                if (((File)object).exists()) {
                    a32222 = (ByteBufferEventSource)writableFileStorageTier.l.remove(a4.I());
                    if (a32222 != null) {
                        a32222.I(0L);
                    }
                    FileUtils.I((File)object);
                }
            }
            object = new RandomAccessFile(file, TaskPublisher.I((Object)"\u00046"));
            a32222 = ((RandomAccessFile)object).getChannel();
            a.info(MessageJson.I((Object)"\r\u0006L[9\u000b\u0013\u0015\u001f\u0015\u0011[\u0010\u0012\u001a\u001eV\u0000\u000b"), (Object)writableFileStorageTier.l, (Object)file);
            MappedByteBuffer mappedByteBuffer = ((FileChannel)a32222).map(FileChannel.MapMode.READ_WRITE, 0L, n2);
            mappedByteBuffer.put((byte)2);
            mappedByteBuffer.putInt(storageProperties.getFlags());
            WritableEventSource a223322 = new WritableEventSource(file.getAbsolutePath(), (ByteBuffer)mappedByteBuffer, a4.I(), a4.I(), writableFileStorageTier.I, storageProperties);
            writableFileStorageTier.l.put(a4.I(), a223322);
            a2322 = a223322;
            if (a32222 == null) break block21;
            ((AbstractInterruptibleChannel)a32222).close();
        }
        ((RandomAccessFile)object).close();
        return a2322;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        Throwable throwable2;
                        block22: {
                            if (a32222 != null) {
                                try {
                                    ((AbstractInterruptibleChannel)a32222).close();
                                    throwable2 = throwable;
                                    break block22;
                                }
                                catch (Throwable a223322) {
                                    throwable.addSuppressed(a223322);
                                }
                            }
                            throwable2 = throwable;
                        }
                        throw throwable2;
                    }
                    catch (Throwable a32222) {
                        Throwable throwable3;
                        try {
                            ((RandomAccessFile)object).close();
                            throwable3 = a32222;
                        }
                        catch (Throwable throwable4) {
                            Throwable throwable5 = a32222;
                            throwable3 = throwable5;
                            throwable5.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Exception exception) {
                    throw new MessagingPlatformException(ErrorCode.DATAFILE_WRITE_ERROR, writableFileStorageTier.l + ": Failed to create segment: " + (FileVersion)a4, (Throwable)exception);
                }
            }
        }
    }

    private static /* synthetic */ void I(long l2, int n, StorageTier storageTier) {
        long a2;
        StorageTier a3 = storageTier;
        int a4 = n;
        a3.activateSegmentVersion(a2, a4);
    }

    /*
     * WARNING - void declaration
     */
    public void activateSegmentVersion(long l2, int n) {
        void a2;
        int a3 = n;
        WritableFileStorageTier a4 = this;
        a4.I(arg_0 -> WritableFileStorageTier.I((long)a2, a3, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public void M(long l2) {
        void a22;
        WritableFileStorageTier writableFileStorageTier = this;
        if (!writableFileStorageTier.l.containsKey((long)a22)) {
            return;
        }
        if (a22 == ((Long)writableFileStorageTier.l.firstKey()).longValue()) {
            a.info(TaskPublisher.I((Object)"\r<La0.\u0004\"\u001f/\u0011a\u0018$\u000e5V2\u0013&\u001b$\u00185V5\u0019a\u0014$V\"\u0004$\u00175\u0013%"), (Object)writableFileStorageTier.l);
            StorageProperties a22 = (StorageProperties)writableFileStorageTier.f.get();
            WritePosition writePosition2 = (WritePosition)writableFileStorageTier.f.getAndUpdate(writePosition -> {
                StorageProperties a2 = writePosition;
                StorageProperties a3 = a22;
                return a2.I(0, a3.getSegmentSize(), 0);
            });
            if (writePosition2.M(a22.getSegmentSize())) {
                a.debug(MessageJson.I((Object)"\r\u0006L[5\t\u0013\u001a\u0002\u0012\u0018\u001cV\u0015\u0013\fV\b\u0013\u001c\u001b\u001e\u0018\u000fV\u0000\u000b"), (Object)writableFileStorageTier.l, (Object)writePosition2.A);
                WritePosition writePosition3 = writePosition2;
                writePosition3.E.I(writePosition3.l, -1);
                WritableFileStorageTier writableFileStorageTier2 = writableFileStorageTier;
                WritableFileStorageTier writableFileStorageTier3 = writableFileStorageTier;
                WritableFileStorageTier a3 = writableFileStorageTier2.I(new FileVersion(writePosition2.A, 0), a22.getSegmentSize(), false);
                writableFileStorageTier.f.set(writePosition2.I((WritableEventSource)a3, 0));
                writableFileStorageTier2.J.I(new WritePosition(writePosition2.A, 0, 0, (WritableEventSource)a3, Long.valueOf(writePosition2.A), writePosition2.D));
            }
        }
        writableFileStorageTier.I();
    }

    /*
     * WARNING - void declaration
     */
    public Optional<EventSource> eventSource(long l2) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        Object a3 = writableFileStorageTier.I((long)a2);
        if (a3.isPresent()) {
            return a3;
        }
        return (Optional)writableFileStorageTier.I(arg_0 -> WritableFileStorageTier.I((long)a2, arg_0), Optional.empty());
    }

    private /* synthetic */ void I(SortedSet<FileVersion> sortedSet) {
        SortedSet<FileVersion> a2 = sortedSet;
        WritableFileStorageTier a3 = this;
        a.warn(TaskPublisher.I((Object)":\u000b{V\u0003\u0003-\u001dl\u00153\u0013 \u0002(\u0018&V(\u0018%\u00139V$\u00185\u0004(\u00132V'\u00193V:\u000ba\u0005$\u0011,\u0013/\u00022"), (Object)a3.l, (Object)a2.size());
        Instant instant = Instant.now();
        if (a3.D.canBatchIndexParallel() && ((StorageProperties)a3.f.get()).isBulkIndexAllowParallel()) {
            a.info(MessageJson.I((Object)"\u0000\u000bAV2\u0018\u001f\u0013\u0003\u001f\u0015\u0011[\u0001\u0012\u0002\u0013V\u000b\u0017\t\u0017\u0017\u001a\u001e\u001a[\u0005\u000e\u0006\u000b\u0019\t\u0002"), (Object)a3.l);
            a2.parallelStream().forEach(fileVersion -> {
                HashMap<String, List> hashMap;
                void a3;
                Object object = this;
                Object a4 = (Optional)object.I(arg_0 -> WritableFileStorageTier.I((FileVersion)a3, arg_0), Optional.empty());
                if (!((Optional)a4).isPresent()) return;
                a4 = ((EventSource)((Optional)a4).get()).createEventIterator(a3.I());
                try {
                    hashMap = new HashMap<String, List>();
                    while (a4.hasNext()) {
                        EventInformation eventInformation = a4.I();
                        if (!eventInformation.I()) continue;
                        IndexEntry indexEntry = new IndexEntry(eventInformation.I().getAggregateSequenceNumber(), eventInformation.I(), eventInformation.I());
                        hashMap.computeIfAbsent(eventInformation.I().getAggregateIdentifier(), a2 -> new LinkedList()).add(indexEntry);
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    if (a4 != null) {
                        try {
                            a4.close();
                            throwable2 = throwable;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throwable2 = throwable;
                    throw throwable2;
                }
                object.D.createIndex((FileVersion)a3, hashMap);
                if (a4 == null) return;
                a4.close();
            });
        } else {
            Object[] objectArray = new Object[3];
            objectArray[0] = a3.l;
            objectArray[1] = a3.D.canBatchIndexParallel();
            objectArray[2] = ((StorageProperties)a3.f.get()).isBulkIndexAllowParallel();
            a.info(TaskPublisher.I((Object)":\u000b{V\b\u0018%\u00139\u001f/\u0011a\u0005$\u00074\u0013/\u0002(\u0017-\u001a8Vi37\u0017-\u0003 \u0002(\u0019/V.\u0010a\u0006 \u0004 \u001a-\u0013-V(\u0018%\u00139\u001f/\u0011{V(\u0018%\u001395 \u0006 \u0014(\u001a(\u0002(\u00132L:\u000baPgV\"\u0019/\u0002$\u000e5%$\u00025\u001f/\u00112L:\u000bh"), objectArray);
            a2.forEach(fileVersion -> {
                HashMap<String, List> hashMap;
                void a3;
                Object object = this;
                Object a4 = (Optional)object.I(arg_0 -> WritableFileStorageTier.I((FileVersion)a3, arg_0), Optional.empty());
                if (!((Optional)a4).isPresent()) return;
                a4 = ((EventSource)((Optional)a4).get()).createEventIterator(a3.I());
                try {
                    hashMap = new HashMap<String, List>();
                    while (a4.hasNext()) {
                        EventInformation eventInformation = a4.I();
                        if (!eventInformation.I()) continue;
                        IndexEntry indexEntry = new IndexEntry(eventInformation.I().getAggregateSequenceNumber(), eventInformation.I(), eventInformation.I());
                        hashMap.computeIfAbsent(eventInformation.I().getAggregateIdentifier(), a2 -> new LinkedList()).add(indexEntry);
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    if (a4 != null) {
                        try {
                            a4.close();
                            throwable2 = throwable;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throwable2 = throwable;
                    throw throwable2;
                }
                object.D.createIndex((FileVersion)a3, hashMap);
                if (a4 == null) return;
                a4.close();
            });
        }
        a.warn(MessageJson.I((Object)"\r\u0006L[4\u000e\u001a\u0010[\u0018\u0004\u001e\u0017\u000f\u001f\u0015\u0011[\u001f\u0015\u0012\u001e\u000e[\u0002\u0014\u0019\u0010V\u0000\u000b"), (Object)a3.l, (Object)Duration.between(instant, Instant.now()));
    }

    public long I() {
        WritableFileStorageTier a2;
        return a2.M.get();
    }

    private static /* synthetic */ Boolean I(long l2, int n, StorageTier storageTier) {
        long a2;
        StorageTier a3 = storageTier;
        int a4 = n;
        return a3.removeSegment(a2, a4);
    }

    private static /* synthetic */ Integer I(Long l2, StorageTier storageTier) {
        Long a2 = storageTier;
        Long a3 = l2;
        return a2.currentSegmentVersion(a3);
    }

    private static /* synthetic */ boolean I(long a2, FileVersion a3) {
        if (a3.I() < a2) {
            return true;
        }
        return false;
    }

    public void handover(Segment segment, Runnable runnable) {
        Runnable a2 = runnable;
        WritableFileStorageTier a3 = this;
        a2.run();
    }

    private static /* synthetic */ Stream I(long l2, int n, StorageTier storageTier) {
        long a2;
        StorageTier a3 = storageTier;
        int a4 = n;
        return a3.getBackupFilenames(a2, a4);
    }

    private /* synthetic */ int I(List<ProcessedEvent> list) {
        Object a2 = list;
        WritableFileStorageTier a3 = this;
        long l2 = 0L;
        Object object = a2 = a2.iterator();
        while (object.hasNext()) {
            ProcessedEvent processedEvent = (ProcessedEvent)a2.next();
            l2 += (long)(4 + processedEvent.getSerializedSize());
            object = a2;
        }
        if (l2 > Integer.MAX_VALUE) {
            throw new MessagingPlatformException(ErrorCode.DATAFILE_WRITE_ERROR, a3.l + ": Transaction size exceeds maximum size");
        }
        return (int)l2;
    }

    /*
     * WARNING - void declaration
     */
    public Optional<EventSource> eventSource(FileVersion fileVersion) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        Object a3 = writableFileStorageTier.I((FileVersion)a2);
        if (a3.isPresent()) {
            return a3;
        }
        return (Optional)writableFileStorageTier.I(arg_0 -> WritableFileStorageTier.M((FileVersion)a2, arg_0), Optional.empty());
    }

    private static /* synthetic */ Optional I(FileVersion fileVersion, StorageTier storageTier) {
        FileVersion a2 = storageTier;
        FileVersion a3 = fileVersion;
        return a2.eventSource(a3);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void I(Map map, ProcessedEvent processedEvent, long l2, int n) {
        void a2;
        void a3;
        void a4;
        void a5;
        int n2 = n;
        WritableFileStorageTier a6 = this;
        a6.I((ProcessedEvent)a5, (long)a4, (int)a3, (Map)a2);
    }

    private static /* synthetic */ Flux I(String string, StorageTier storageTier) {
        String a2 = storageTier;
        String a3 = string;
        return a2.fileVersions(a3);
    }
}

