/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.logging;

import io.axoniq.axonserver.applicationevents.UserEvents;
import io.axoniq.axonserver.logging.E;
import io.axoniq.axonserver.rest.json.QueryRequestJson;
import io.axoniq.axonserver.util.StringUtils;
import io.axoniq.axonserver.websocket.WebsocketApplicationContext;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.security.authentication.event.AbstractAuthenticationEvent;
import org.springframework.security.authentication.event.AbstractAuthenticationFailureEvent;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class AuditLog {
    private static final Logger M = AuditLog.getLogger();

    @EventListener
    public void on(AbstractAuthenticationEvent abstractAuthenticationEvent) {
        AuditLog a2 = abstractAuthenticationEvent;
        AuditLog a3 = this;
        if (a2 instanceof InteractiveAuthenticationSuccessEvent) {
            return;
        }
        Authentication authentication = a2.getAuthentication();
        if (M.isDebugEnabled()) {
            M.debug(a2.toString());
            return;
        }
        if (a2 instanceof AuthenticationSuccessEvent && authentication.isAuthenticated()) {
            M.info(WebsocketApplicationContext.I((Object)"z\nQ\fXEA\fB\r\u0016\u0010E\u0000D\u000bW\bSE\u0014\u001eKG\u0018"), (Object)authentication.getName());
            return;
        }
        if (a2 instanceof AbstractAuthenticationFailureEvent) {
            a2 = (AbstractAuthenticationFailureEvent)a2;
            M.error(QueryRequestJson.I((Object)"^\u001cu\u001a|Se\u001af\u001b2\u0006a\u0016`\u001ds\u001ewS0\boQ25S:^6VI2\bo"), (Object)authentication.getName(), (Object)a2.getException().getMessage());
        }
    }

    @EventListener
    public void on(UserEvents.AdminUserDeleted adminUserDeleted) {
        AuditLog a2 = adminUserDeleted;
        AuditLog a3 = this;
        if (M.isDebugEnabled()) {
            M.debug(a2.toString());
        }
    }

    @EventListener
    public void on(UserEvents.AdminUserUpdated adminUserUpdated) {
        AuditLog a2 = adminUserUpdated;
        AuditLog a3 = this;
        if (M.isDebugEnabled()) {
            M.debug(a2.toString());
        }
    }

    public static String username(String a2) {
        if (a2 == null) {
            return WebsocketApplicationContext.I((Object)"\n\u0004X\nX\u001c[\nC\u0016\b");
        }
        return StringUtils.sanitize((String)a2);
    }

    public static String enablement(boolean a2) {
        if (a2) {
            return WebsocketApplicationContext.I((Object)"s+w'z r");
        }
        return QueryRequestJson.I((Object)"7[ S1^6V");
    }

    public static String username(Principal a2) {
        if (a2 == null) {
            return QueryRequestJson.I((Object)".\u0012|\u001c|\n\u007f\u001cg\u0000,");
        }
        return StringUtils.sanitize((String)a2.getName());
    }

    public static <T> Logger getLogger() {
        return LoggerFactory.getLogger((String)("AUDIT." + E.M.I()[2].getName()));
    }

    public AuditLog() {
        AuditLog a2;
    }
}

