/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.message.query;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.message.command.InsufficientBufferCapacityException;
import io.axoniq.axonserver.message.query.ActiveQuery;
import io.axoniq.axonserver.transport.rest.v2.ApplicationRestControllerV2;
import io.axoniq.axonserver.transport.rest.v2.ScheduledEventsRestControllerV2;
import io.axoniq.axonserver.util.NonReplacingConstraintCache;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.util.unit.DataSize;

@Component(value="QueryCache")
public class QueryCache
implements NonReplacingConstraintCache<String, ActiveQuery> {
    private final long B;
    private final long D;
    private final Logger f;
    private final int E = 25000;
    private final Map<String, ActiveQuery> M;

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void I(ActiveQuery activeQuery, String string) {
        void a2;
        Object a3 = string;
        QueryCache a4 = this;
        a4.f.debug(ScheduledEventsRestControllerV2.I((Object)"\u001719.8; ;t/!;&'t%)~21&~%+1,-~<?::8;&~=:10 7271:t<-~72=;:*\u0007*&;53\u001d:t%)p"), (Object)a2.L(), a3);
        if (a2.M((String)a3)) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a3;
            if (a2.I((String)a3, ErrorCode.CONNECTION_TO_HANDLER_LOST, String.format(ApplicationRestControllerV2.I((Object)"1.\u001c/\u0017\"\u0006(\u001d/R5\u001da\u001a \u001c%\u001e$\u0000aW2R-\u001d2\u0006"), objectArray))) {
                a4.remove(a2.L());
            }
        }
    }

    public ActiveQuery get(String string) {
        Object a2 = string;
        QueryCache a3 = this;
        return (ActiveQuery)a3.M.get(a2);
    }

    public ActiveQuery remove(String string) {
        QueryCache a2;
        Object a3 = string;
        QueryCache queryCache = a2 = this;
        queryCache.f.debug(ApplicationRestControllerV2.I((Object)" $\u001f.\u0004$R,\u00172\u0001 \u0015$;%R:\u000f"), a3);
        return (ActiveQuery)queryCache.M.remove(a3);
    }

    private /* synthetic */ void I() {
        QueryCache a2;
        if ((long)a2.M.size() >= a2.B) {
            throw new InsufficientBufferCapacityException("Query buffer is full (" + a2.B + "/" + a2.B + ") Query handlers might be slow. Try increasing 'axoniq.axonserver.query-cache-capacity' property.");
        }
    }

    /*
     * WARNING - void declaration
     */
    public ActiveQuery putIfAbsent(String string, ActiveQuery activeQuery) {
        void a2;
        QueryCache a3;
        QueryCache a4 = activeQuery;
        QueryCache queryCache = a3 = this;
        queryCache.I();
        return (ActiveQuery)queryCache.M.putIfAbsent(a2, a4);
    }

    public boolean isEmpty() {
        QueryCache a2;
        return a2.M.isEmpty();
    }

    public QueryCache(@Value(value="${axoniq.axonserver.default-query-timeout:300000}") long defaultQueryTimeout, @Value(value="${axoniq.axonserver.query-cache-capacity:0}") long a2) {
        QueryCache queryCache = this;
        QueryCache queryCache2 = this;
        queryCache2.f = LoggerFactory.getLogger(QueryCache.class);
        queryCache2.E = 25000;
        QueryCache queryCache3 = this;
        queryCache.M = new ConcurrentHashMap();
        queryCache.D = defaultQueryTimeout;
        if (a2 > 0L) {
            this.B = a2;
            return;
        }
        defaultQueryTimeout = DataSize.ofBytes((long)Runtime.getRuntime().maxMemory()).toGigabytes();
        this.B = defaultQueryTimeout > 0L ? 25000L * defaultQueryTimeout : 25000L;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void I(TopologyEvents.QueryHandlerDisconnected queryHandlerDisconnected, String string, ActiveQuery activeQuery) {
        void a2;
        QueryCache a3 = activeQuery;
        QueryCache a4 = this;
        a4.I((ActiveQuery)a3, a2.d());
    }

    public int size() {
        QueryCache a2;
        return a2.M.size();
    }

    @EventListener
    public void on(TopologyEvents.QueryHandlerDisconnected queryHandlerDisconnected) {
        QueryCache a2 = queryHandlerDisconnected;
        QueryCache a3 = this;
        a3.M.forEach((arg_0, arg_1) -> a3.I((TopologyEvents.QueryHandlerDisconnected)a2, arg_0, arg_1));
    }

    public Set<Map.Entry<String, ActiveQuery>> timedOut() {
        QueryCache a4;
        long l2 = System.currentTimeMillis() - a4.D;
        return a4.entrySet().stream().filter(a3 -> {
            if (((ActiveQuery)a3.getValue()).I() < l2) {
                return true;
            }
            return false;
        }).filter(a2 -> {
            if (!((ActiveQuery)a2.getValue()).I()) {
                return true;
            }
            return false;
        }).collect(Collectors.toSet());
    }

    public Collection<Map.Entry<String, ActiveQuery>> entrySet() {
        QueryCache a2;
        return a2.M.entrySet();
    }
}

