/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.ClusterTemplateController;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.cluster.DistributeLicenseService;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.context.ContextNameValidation;
import io.axoniq.axonserver.enterprise.replication.admin.RaftConfigServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.ContextRole;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.licensing.LicenseException;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.rest.ClusterRestController;
import io.axoniq.axonserver.rest.json.CommandResponseJson;
import io.axoniq.axonserver.rest.json.RestResponse;
import io.axoniq.axonserver.rest.svg.mapping.Applications;
import io.axoniq.axonserver.topology.ClusterTopology;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/*
 * Duplicate member names - consider using --renamedupmembers true
 * Exception performing whole class analysis ignored.
 */
@CrossOrigin
@RestController(value="ClusterRestController")
@RequestMapping(value={"/v1/cluster"})
public class ClusterRestController {
    private final ClusterController j;
    private final RaftConfigServiceFactory b;
    private final ApplicationEventPublisher I;
    private static final Logger l = AuditLog.getLogger();
    private final ClusterTemplateController J;
    private final Predicate<String> A;
    private static final Logger B = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ClusterTopology D;
    public static final String f = "_none";
    private final FeatureChecker E;
    private final DistributeLicenseService M;

    @PostMapping
    public ResponseEntity<RestResponse> I(@Valid @RequestBody ClusterJoinRequest clusterJoinRequest, @Parameter(hidden=true) Principal principal) {
        ClusterRestController clusterRestController;
        NodeInfo.Builder a2;
        ClusterRestController clusterRestController2 = clusterRestController3;
        ClusterRestController clusterRestController3 = clusterJoinRequest;
        ClusterRestController jsonClusterNode = clusterRestController2;
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = clusterRestController3.getInternalHostName();
        objectArray[2] = clusterRestController3.internalGrpcPort;
        l.info(Applications.I((Object)"\u0004\u0000\"&\u007f):\n*\u001e,\u000f\u007f\u000f0[5\u00146\u0015\u007f\u00183\u000e,\u000f:\t\u007f\u001a+[$\u0006e\u0000\"U"), objectArray);
        a2 = NodeInfo.newBuilder((NodeInfo)jsonClusterNode.j.getMe().toNodeInfo());
        String string = clusterRestController3.getContext();
        if (string != null && !string.isEmpty()) {
            if (clusterRestController3.getNoContexts() != null && clusterRestController3.getNoContexts().booleanValue()) {
                throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, CommandResponseJson.I((Object)"~\u001bS\u0014R\u000e\u001d\u0019R\u0017_\u0013S\u001f\u001d\u0010R\u0013S\u0013S\u001d\u001d\u0019R\u0014I\u001fE\u000e\u001d\rT\u000eUZS\u0015~\u0015S\u000eX\u0002I\t\u0013"));
            }
            if (!RaftAdminGroup.I((String)string) && !jsonClusterNode.A.test(string)) {
                throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, "Invalid context name: " + string);
            }
            B.debug(Applications.I((Object)">\u001f;SvA\u007f):\u001c6\b+\u001e-\u00121\u001c\u007f\u0016&\b:\u00179[>\u0015;[>\u001f;\u00121\u001c\u007f\u0016:[+\u0014\u007f\u00180\u0015+\u001e'\u000f\u007fY$\u0006}U"), (Object)string);
            clusterRestController = jsonClusterNode;
            a2.addContexts(ContextRole.newBuilder().setName(string).build());
        } else if (clusterRestController3.getNoContexts() != null && clusterRestController3.getNoContexts().booleanValue()) {
            B.debug(CommandResponseJson.I((Object)"\\\u001eYR\u0014@\u001d(X\u001dT\tI\u001fO\u0013S\u001d\u001d\u0017D\tX\u0016[Z\\\u0014YZ\\\u001eY\u0013S\u001d\u001d\u0017XZI\u0015\u001d\u0014RZ^\u0015S\u000eX\u0002I\t\u0013"));
            clusterRestController = jsonClusterNode;
            a2.addContexts(ContextRole.newBuilder().setName("_none").build());
        } else {
            B.debug(Applications.I((Object)">\u001f;SvA\u007f):\u001c6\b+\u001e-\u00121\u001c\u007f\u0016&\b:\u00179[>\u0015;[>\u001f;\u00121\u001c\u007f\u0016:[+\u0014\u007f\u001a3\u0017\u007f\u00180\u0015+\u001e'\u000f,U"));
            clusterRestController = jsonClusterNode;
        }
        if (clusterRestController.j.nodes().count() > 1L) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)new RestResponse(false, CommandResponseJson.I((Object)"4R\u001eXZ\\\u0016O\u001f\\\u001eDZO\u001fZ\u0013N\u000eX\bX\u001e\u001d\u0013SZ\\Z^\u0016H\tI\u001fO")));
        }
        try {
            ClusterRestController clusterRestController4 = jsonClusterNode;
            ClusterRestController clusterRestController5 = clusterRestController3;
            clusterRestController3 = clusterRestController4.b.getRaftConfigServiceStub(clusterRestController5.internalHostName, clusterRestController5.internalGrpcPort.intValue()).joinCluster(a2.build());
            clusterRestController4.I.publishEvent((Object)new ClusterEvents.LicenseUpdated(clusterRestController3.getLicense().toByteArray()));
            return ResponseEntity.accepted().body((Object)new RestResponse(true, Applications.I((Object)"\u001e\u0018<\u001e/\u000f:\u001f\u007f\u00110\u00121[-\u001e.\u000e:\b+W\u007f\u0016>\u0002\u007f\u000f>\u0010:[>[(\u00136\u0017:[+\u0014\u007f\u000b-\u0014<\u001e,\b")));
        }
        catch (Exception this2) {
            return new RestResponse(false, this2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)this2));
        }
    }

    @GetMapping
    public List<JsonClusterNode> I(@Parameter(hidden=true) Principal principal) {
        ClusterRestController clusterRestController = object;
        Object object = principal;
        ClusterRestController a2 = clusterRestController;
        l.info(Applications.I((Object)" $\u0006\u0002[\r\u001e.\u000e:\b+[+\u0014\u007f\u00176\b+[1\u0014;\u001e,U"), (Object)AuditLog.username((Principal)object));
        return a2.j.nodes().map(clusterNode -> {
            ClusterRestController a2 = clusterNode;
            ClusterRestController a3 = this;
            ClusterRestController clusterRestController = a2;
            return JsonClusterNode.from((ClusterNode)clusterRestController, (boolean)a3.j.isActive(clusterRestController.getName()));
        }).collect(Collectors.toList());
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(path={"{name}"})
    public void I(@PathVariable(value="name") String string, @Parameter(hidden=true) Principal principal) {
        void a2;
        ClusterRestController clusterRestController = object;
        Object object = string;
        ClusterRestController name = clusterRestController;
        l.info(CommandResponseJson.I((Object)"f\u0001@'\u001d(X\u000bH\u001fN\u000e\u001d\u000eRZY\u001fQ\u001fI\u001f\u001d\u0014R\u001eXZF\u0007\u0013"), (Object)AuditLog.username((Principal)a2), object);
        name.b.getRaftConfigService().deleteNode((String)object);
    }

    /*
     * WARNING - void declaration
     */
    public ClusterRestController(ClusterController clusterController, RaftConfigServiceFactory raftConfigServiceFactory, FeatureChecker featureChecker, DistributeLicenseService distributeLicenseService, ApplicationEventPublisher applicationEventPublisher, ClusterTopology clusterTopology, ClusterTemplateController clusterTemplateController) {
        ClusterRestController a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        ClusterRestController a9;
        ClusterRestController clusterRestController = clusterRestController2;
        ClusterRestController clusterRestController2 = clusterTemplateController;
        ClusterRestController clusterRestController3 = a9 = clusterRestController;
        ClusterRestController clusterRestController4 = a9;
        ClusterRestController clusterRestController5 = a9;
        ClusterRestController clusterRestController6 = a9;
        a9.A = new ContextNameValidation();
        a9.j = a8;
        clusterRestController5.b = a7;
        clusterRestController5.E = a6;
        clusterRestController4.M = a5;
        clusterRestController4.I = a4;
        clusterRestController3.D = a3;
        clusterRestController3.J = a2;
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/upload-license"})
    public void I(@RequestParam(value="licenseFile") MultipartFile multipartFile, @Parameter(hidden=true) Principal principal) throws IOException {
        void a2;
        ClusterRestController clusterRestController = this;
        l.info(Applications.I((Object)"\u0004\u0000\"&\u007f):\n*\u001e,\u000f\u007f\u00176\u0018:\u0015,\u001e\u007f\u000e/\u001f>\u000f:U"), (Object)AuditLog.username((Principal)a2));
        B.info(CommandResponseJson.I((Object)"4X\r\u001d\u0016T\u0019X\u0014N\u001f\u001d\u000fM\u0016R\u001bY\u001fYV\u001d\nX\b[\u0015O\u0017T\u0014ZZQ\u0013^\u001fS\tXZH\nY\u001bI\u001f\u0013T\u0013"));
        try {
            void licenseFile;
            clusterRestController.M.distributeLicense(licenseFile.getBytes());
            return;
        }
        catch (MessagingPlatformException messagingPlatformException) {
            if (ErrorCode.NO_LEADER_AVAILABLE.equals((Object)messagingPlatformException.getErrorCode())) {
                throw new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, Applications.I((Object)"50[3\u001e>\u001f:\t\u007f\u001d0\t\u007f$>\u001f2\u00121U\u007f>1\b*\t:[+\u0013>\u000f\u007f\u000f7\u001e\u007f$>\u001f2\u00121[-\u001e/\u00176\u0018>\u000f6\u00141[8\t0\u000e/[6\b\u007f\u0018-\u001e>\u000f:\u001f\u007f\u0019:\u001d0\t:[*\u000b3\u0014>\u001f6\u00158[>[3\u0012<\u001e1\b:U"));
            }
            throw messagingPlatformException;
        }
        catch (LicenseException messagingPlatformException) {
            throw new MessagingPlatformException(ErrorCode.INVALID_PROPERTY_VALUE, messagingPlatformException.getMessage());
        }
    }

    @GetMapping(path={"{name}"})
    public JsonClusterNode I(@PathVariable(value="name") String string, @Parameter(hidden=true) Principal principal) {
        ClusterNode a2;
        ClusterRestController clusterRestController = object;
        Object object = string;
        ClusterRestController name = clusterRestController;
        l.info(CommandResponseJson.I((Object)"f\u0001@'\u001d(X\u000bH\u001fN\u000e\u001d\u0014R\u001eXZY\u001fI\u001bT\u0016NZ[\u0015OZF\u0007\u0013"), (Object)AuditLog.username((Principal)a2), object);
        a2 = name.j.getNode((String)object);
        if (a2 == null) {
            throw new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, "Node " + (String)object + " not found");
        }
        return JsonClusterNode.from((ClusterNode)a2, (boolean)name.j.isActive((String)object));
    }

    @GetMapping(value={"/download-template"})
    @ResponseBody
    public void I(HttpServletResponse httpServletResponse, @Parameter(hidden=true) Principal principal) throws IOException {
        ClusterRestController clusterRestController = object;
        Object object = principal;
        ClusterRestController a2 = clusterRestController;
        l.info(CommandResponseJson.I((Object)"f\u0001@'\u001d(X\u000bH\u001fN\u000e\u001d\u0019Q\u000fN\u000eX\b\u001d\u000eX\u0017M\u0016\\\u000eXZY\u0015J\u0014Q\u0015\\\u001e\u0013"), (Object)AuditLog.username((Principal)object));
        if (a2.D.isAdminNode()) {
            ServletOutputStream resp;
            object = Applications.I((Object)"<\u0017*\b+\u001e-V+\u001e2\u000b3\u001a+\u001eq\u00022\u0017");
            String string = a2.J.buildYamlTemplate();
            void v1 = resp;
            resp = v1.getOutputStream();
            v1.setContentType(CommandResponseJson.I((Object)"I\u001fE\u000e\u0012\nQ\u001bT\u0014\u0006Z^\u0012\\\bN\u001fIGH\u000e[W\u0005"));
            v1.addHeader(Applications.I((Object)"80\u0015+\u001e1\u000fr?6\b/\u0014,\u0012+\u00120\u0015"), "attachment; filename=\"" + (String)object + "\"");
            ServletOutputStream servletOutputStream = resp;
            servletOutputStream.write(string.getBytes(StandardCharsets.UTF_8));
            servletOutputStream.flush();
            servletOutputStream.close();
            return;
        }
        throw new RuntimeException(CommandResponseJson.I((Object)"d\u0015HZ^\u001bSZH\tXZI\u0012T\t\u001d\u001cH\u0014^\u000eT\u0015S\u001bQ\u0013I\u0003\u001d\u0015S\u0016DZ[\bR\u0017\u001d\u001bY\u0017T\u0014\u001d\u0014R\u001eX"));
    }
}

