/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.component.ComponentItems;
import io.axoniq.axonserver.component.command.ComponentCommand;
import io.axoniq.axonserver.component.command.DefaultCommands;
import io.axoniq.axonserver.config.GrpcContextAuthenticationProvider;
import io.axoniq.axonserver.grpc.SerializedCommand;
import io.axoniq.axonserver.grpc.SerializedCommandResponse;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.message.command.CommandDispatcher;
import io.axoniq.axonserver.message.command.CommandRegistrationCache;
import io.axoniq.axonserver.metric.Metrics;
import io.axoniq.axonserver.rest.CommandRestController;
import io.axoniq.axonserver.rest.i;
import io.axoniq.axonserver.rest.json.CommandRequestJson;
import io.axoniq.axonserver.rest.json.CommandResponseJson;
import io.axoniq.axonserver.util.ObjectUtils;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import jakarta.validation.Valid;
import java.security.Principal;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="CommandRestController")
@RequestMapping(value={"/v1"})
public class CommandRestController {
    private static final Logger f = AuditLog.getLogger();
    private final CommandRegistrationCache E;
    private final CommandDispatcher M;

    @GetMapping(value={"commands/count"})
    public int I(@Parameter(hidden=true) Principal principal) {
        CommandRestController commandRestController = object;
        Object object = principal;
        CommandRestController a2 = commandRestController;
        if (f.isDebugEnabled()) {
            f.debug(Metrics.I((Object)"';\u0001\u001d\\\u0012\u00191\t%\u000f4\\&\u00132\\4\u0014%\\!\u001f4\u00156\u0019`\u001f/\u0011-\u001d.\u0018`\u001f/\t.\bn"), (Object)AuditLog.username((Principal)object));
        }
        return a2.M.activeCommandCount();
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/components/{component}/commands"})
    public Iterable<ComponentCommand> I(@PathVariable(value="component") String string, @RequestParam(value="context") String string2, @Parameter(hidden=true) Principal principal) {
        void component;
        void a2;
        CommandRestController commandRestController = object;
        Object object = string2;
        CommandRestController context = commandRestController;
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = component;
        objectArray[2] = StringUtils.sanitize((String)object);
        f.info(Metrics.I((Object)"';\u0001\u001d\\\u0012\u00191\t%\u000f4\\4\u0013`\u0010)\u000f4\\!\u0010,\\\u0003\u0013-\u0011!\u0012$\u000f`\u001a/\u000e`\u000b(\u0015#\u0014`\u001f/\u00110\u0013.\u0019.\b`^;\u0001b\\)\u0012`\u001f/\u00124\u00198\b`^;\u0001b\\(\u001d3\\!\\2\u0019'\u00153\b%\u000e%\u0018`\u0014!\u0012$\u0010%\u000en"), objectArray);
        return new ComponentItems((String)component, (String)object, (Iterable)new DefaultCommands(context.E));
    }

    /*
     * WARNING - void declaration
     */
    public CommandRestController(CommandDispatcher commandDispatcher, CommandRegistrationCache commandRegistrationCache) {
        void a2;
        CommandRestController a3;
        CommandRestController a4 = commandRegistrationCache;
        CommandRestController commandRestController = a3 = this;
        commandRestController.M = a2;
        commandRestController.E = a4;
    }

    @GetMapping(value={"commands/queues"})
    public List<i> M(@Parameter(hidden=true) Principal principal) {
        CommandRestController commandRestController = object;
        Object object = principal;
        CommandRestController a2 = commandRestController;
        f.info(TopologyEvents.I((Object)"h?N\u0019\u0013\u0016V5F!@0\u00130\\d_-@0\u0013%_(\u0013\u0007\\)^%] b1V1V7\u001d"), (Object)AuditLog.username((Principal)object));
        return a2.M.getCommandQueues().I().entrySet().stream().map(i::I).collect(Collectors.toList());
    }

    @GetMapping(value={"commands"})
    public List<JsonClientMapping> I(@Parameter(hidden=true) Principal principal) {
        CommandRestController commandRestController = object;
        Object object = principal;
        CommandRestController a2 = commandRestController;
        f.info(TopologyEvents.I((Object)"\u001fH9nda!B1V7GdG+\u0013(Z7GdR(_dp+^)R*W7\u00133[-P,\u0013,R2VdRdA!T-@0V6V \u0013,R*W(V6\u001d"), (Object)AuditLog.username((Principal)object));
        return a2.E.getAll().entrySet().stream().map(JsonClientMapping::I).collect(Collectors.toList());
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"commands/run"})
    @Parameters(value={@Parameter(name="AxonIQ-Access-Token", description="Access Token", in=ParameterIn.HEADER)})
    public Future<CommandResponseJson> I(@RequestHeader(value="AxonIQ-Context", defaultValue="default", required=false) String string, @RequestBody @Valid CommandRequestJson commandRequestJson, @Parameter(hidden=true) Authentication authentication) {
        void context;
        void command;
        void a2;
        CommandRestController commandRestController = object;
        f.info(Metrics.I((Object)"';\u0001\u001d\\\u0012\u00191\t%\u000f4\\4\u0013`\u0018)\u000f0\u001d4\u001f(\\!\\b\u0007=^`?/\u0011-\u001d.\u0018n"), (Object)AuditLog.username((Principal)a2), (Object)command.getName());
        Object object = new CompletableFuture();
        commandRestController.M.dispatch((String)context, (Authentication)ObjectUtils.I((Object)a2, (Object)GrpcContextAuthenticationProvider.M), new SerializedCommand(command.asCommand()), arg_0 -> CommandRestController.I((CompletableFuture)object, arg_0));
        return object;
    }

    private static /* synthetic */ void I(CompletableFuture completableFuture, SerializedCommandResponse serializedCommandResponse) {
        CompletableFuture a2 = serializedCommandResponse;
        CompletableFuture a3 = completableFuture;
        a3.complete(new CommandResponseJson(a2.wrapped()));
    }
}

