/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.common.PluginKey;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ApplicationProtoConverter;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.plugin.PluginController;
import io.axoniq.axonserver.plugin.PluginInfo;
import io.axoniq.axonserver.plugin.SimplePluginKey;
import io.axoniq.axonserver.rest.PluginConfigurationJSON;
import io.axoniq.axonserver.rest.PluginPropertyGroup;
import io.axoniq.axonserver.transport.rest.ApplicationRestController;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Parameter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"v1/plugins"})
@CrossOrigin
public class PluginsRestController {
    private final Logger A;
    private static final Logger B = AuditLog.getLogger();
    private final boolean D;
    private final PluginController f;
    public static final String E = "Plugins disabled";
    private final FeatureChecker M;

    @PostMapping(consumes={"multipart/form-data"})
    public PluginKey I(@RequestPart(value="bundle") MultipartFile multipartFile, @Parameter(hidden=true) Principal principal) throws IOException {
        PluginKey pluginBundle2;
        block6: {
            PluginsRestController pluginsRestController = object;
            Object object = principal;
            PluginsRestController a2 = pluginsRestController;
            if (!a2.D || !a2.M.plugins()) {
                throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, E);
            }
            B.info(ApplicationRestController.I((Object)"\u001a8<\u001ea\u0011$24&27a7.c(-27 /-c1/4$(-a8<ma"), (Object)AuditLog.username((Principal)object), (Object)StringUtils.sanitize((String)pluginBundle2.getOriginalFilename()));
            object = pluginBundle2.getInputStream();
            try {
                PluginsRestController pluginsRestController2 = a2;
                String string = pluginsRestController2.I(pluginBundle2.getOriginalFilename());
                pluginBundle2 = pluginsRestController2.f.addPlugin(string, (InputStream)object);
                if (object == null) break block6;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                block7: {
                    if (object != null) {
                        try {
                            ((InputStream)object).close();
                            throwable2 = throwable;
                            break block7;
                        }
                        catch (Throwable pluginBundle2) {
                            throwable.addSuppressed(pluginBundle2);
                        }
                    }
                    throwable2 = throwable;
                }
                throw throwable2;
            }
            ((InputStream)object).close();
        }
        return pluginBundle2;
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"configuration"})
    public void I(@RequestBody PluginConfigurationJSON pluginConfigurationJSON, @Parameter(hidden=true) Principal principal) {
        void a2;
        PluginsRestController pluginsRestController = pluginsRestController2;
        PluginsRestController pluginsRestController2 = pluginConfigurationJSON;
        PluginsRestController configurationJSON = pluginsRestController;
        if (!configurationJSON.D || !configurationJSON.M.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, E);
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)pluginsRestController2.getName());
        objectArray[2] = StringUtils.sanitize((String)pluginsRestController2.getVersion());
        B.info(ApplicationProtoConverter.I((Object)"B1d\u00179\u0018|;l/j>9>vjl:}+m/9)v$\u007f#~?k+m#v$9%\u007fjb761dd9"), objectArray);
        configurationJSON.f.updateConfiguration((PluginKey)new SimplePluginKey(pluginsRestController2.getName(), pluginsRestController2.getVersion()), pluginsRestController2.getContext(), pluginsRestController2.getProperties());
    }

    private /* synthetic */ String I(String string) {
        String a2 = string;
        PluginsRestController a3 = this;
        if (a2 == null) {
            throw new MessagingPlatformException(ErrorCode.OTHER, ApplicationProtoConverter.I((Object)"\u0004vji&l-p$9:x)r+~/9:k%o#}/}"));
        }
        if (a2.contains(File.separator)) {
            throw new MessagingPlatformException(ErrorCode.OTHER, ApplicationRestController.I((Object)"\u0007*-&/\",&a0),4/%c/,5c\",/7 */c%*3&\"7.18c2&1\"3\"5,3"));
        }
        int n = a2.lastIndexOf(46);
        if (n > 0) {
            return a2.substring(0, n) + "-" + System.currentTimeMillis() + a2.substring(n);
        }
        return (String)a2 + "-" + System.currentTimeMillis();
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(value={"context"})
    public void I(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @RequestParam(required=false, name="targetContext") String string3, @Parameter(hidden=true) Principal principal) {
        void version;
        void name;
        void a2;
        PluginsRestController pluginsRestController = object;
        Object object = string3;
        PluginsRestController context = pluginsRestController;
        if (!context.D || !context.M.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, E);
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)version);
        objectArray[3] = StringUtils.sanitize((String)object);
        B.info(ApplicationProtoConverter.I((Object)"B1d\u00179\u0018|;l/j>9>vjl$k/~#j>|89:u?~#wjb761dj\u007f%kjz%w>|2mjb77"), objectArray);
        context.f.unregisterPluginForContext((PluginKey)new SimplePluginKey((String)name, (String)version), (String)object);
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"status"})
    public void I(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @RequestParam(required=false, name="targetContext") String string3, @RequestParam(value="active") boolean bl, @Parameter(hidden=true) Principal principal) {
        void context;
        void version;
        void name;
        void a2;
        boolean bl2 = bl;
        PluginsRestController active = this;
        if (!active.D || !active.M.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, E);
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = this != false ? ApplicationProtoConverter.I((Object)"j>x8m") : ApplicationRestController.I((Object)"05,1");
        objectArray[2] = StringUtils.sanitize((String)name);
        objectArray[3] = StringUtils.sanitize((String)version);
        B.info(ApplicationRestController.I((Object)"\u001a8<\u001ea\u0011$24&27a7.c:>a3-6&*/c:>n8<ma"), objectArray);
        active.f.updatePluginStatus((PluginKey)new SimplePluginKey((String)name, (String)version), (String)context, (boolean)this);
    }

    /*
     * WARNING - void declaration
     */
    public PluginsRestController(PluginController pluginController, MessagingPlatformConfiguration messagingPlatformConfiguration, FeatureChecker featureChecker) {
        void a2;
        void a3;
        PluginsRestController a4;
        PluginsRestController a5 = featureChecker;
        PluginsRestController pluginsRestController = a4 = this;
        PluginsRestController pluginsRestController2 = a4;
        pluginsRestController2.A = LoggerFactory.getLogger(PluginsRestController.class);
        pluginsRestController2.D = a3.isPluginsEnabled();
        pluginsRestController.f = a2;
        pluginsRestController.M = a5;
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping
    public void I(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @Parameter(hidden=true) Principal principal) {
        void name;
        void a2;
        PluginsRestController pluginsRestController = object;
        Object object = string2;
        PluginsRestController version = pluginsRestController;
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)object);
        B.info(ApplicationProtoConverter.I((Object)"\u0011b7DjK/h?|9mjm%9?w#w9m+u&9:u?~#wjb761dd9"), objectArray);
        version.f.uninstallPlugin((PluginKey)new SimplePluginKey((String)name, (String)object));
    }

    @GetMapping
    public Iterable<PluginInfo> I(@Parameter(hidden=true) Principal principal) {
        PluginsRestController pluginsRestController = object;
        Object object = principal;
        PluginsRestController a2 = pluginsRestController;
        B.info(ApplicationRestController.I((Object)"\u0018:>\u001cc\u0013&06$05c5,a/(05c\"631$-5c1/4$(-2ma"), (Object)AuditLog.username((Principal)object));
        return a2.f.listPlugins();
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"configuration"})
    public Iterable<PluginPropertyGroup> I(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @RequestParam(required=false, name="targetContext") String string3, @Parameter(hidden=true) Principal principal) {
        void version;
        void name;
        void a2;
        PluginsRestController pluginsRestController = this;
        if (!pluginsRestController.D || !pluginsRestController.M.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, E);
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)version);
        B.info(ApplicationRestController.I((Object)"\u001a8<\u001ea\u0011$24&27a%.1a .-'*&63\"5*.-a,'c:>n8<ma"), objectArray);
        try {
            void context;
            return pluginsRestController.f.listProperties((PluginKey)new SimplePluginKey((String)name, (String)version), (String)context);
        }
        catch (RuntimeException runtimeException) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = name;
            objectArray2[1] = version;
            objectArray2[2] = runtimeException;
            pluginsRestController.A.warn(ApplicationProtoConverter.I((Object)"_+p&|.9>vjk/m8p/o/9:k%i/k>p/jj\u007f%kjb7#1d"), objectArray2);
            throw runtimeException;
        }
    }
}

