/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.taskscheduler;

import io.axoniq.axonserver.configuration.runtime.Task;
import io.axoniq.axonserver.configuration.runtime.Tasks;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.TaskStatus;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.rest.json.CommandResponseJson;
import io.axoniq.axonserver.taskscheduler.ScheduledTaskExecutor;
import io.axoniq.axonserver.taskscheduler.TransientException;
import io.axoniq.axonserver.util.StreamObserverUtils;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Tags;
import java.time.Clock;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.SmartLifecycle;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class BaseTaskManager
implements SmartLifecycle {
    private final MeterFactory h;
    protected final Supplier<Set<String>> a;
    private static final String c = "transient";
    private static final String C = "false";
    protected final Clock L;
    protected static final long e = TimeUnit.MINUTES.toMillis(1L);
    protected final ScheduledExecutorService G;
    protected final Tasks i;
    protected final Map<String, Map<String, ScheduledFuture<?>>> j;
    private static final String b = "true";
    private final Map<String, Gauge> I;
    private final long l;
    private static final String J = "replicationGroup";
    private boolean A;
    protected final AtomicLong B;
    protected static final Logger D = LoggerFactory.getLogger(BaseTaskManager.class);
    protected final Predicate<String> f;
    protected final PlatformTransactionManager E;
    protected final ScheduledTaskExecutor M;

    private /* synthetic */ ScheduledFuture I(Task task, String string) {
        BaseTaskManager a2 = task;
        BaseTaskManager a3 = this;
        return a3.G.schedule(() -> a3.I((Task)a2), a3.I((Task)a2), TimeUnit.MILLISECONDS);
    }

    protected void doScheduleTask(Task task) {
        BaseTaskManager a2 = task;
        BaseTaskManager a3 = this;
        if (a3.f.test(a2.getReplicationGroup()) && a2.getTimestamp() < a3.B.get() && TaskStatus.SCHEDULED.equals((Object)a2.getStatus())) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a2.getReplicationGroup();
            objectArray[1] = a2.getTimestamp();
            objectArray[2] = a3.B;
            D.debug(CommandResponseJson.I((Object)"\u0001@@\u001d\u001bY\u001eT\u0014ZZI\u001bN\u0011\u001d\u000eRZN\u0019U\u001fY\u000fQ\u001fOZI\u0013P\u001f\u001d\u0001@Z_\u001f[\u0015O\u001f\u001d\u0001@"), objectArray);
            a3.schedule((Task)a2);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void completed(Task task, long l2) {
        void a2;
        BaseTaskManager a3 = task;
        BaseTaskManager a4 = this;
        a4.processResult(a3.getReplicationGroup(), a3.getTaskId(), TaskStatus.COMPLETED, a4.L.millis(), 0L, null).exceptionally(arg_0 -> BaseTaskManager.d((Task)a3, arg_0));
        String[] stringArray = new String[4];
        stringArray[0] = J;
        stringArray[1] = a3.getReplicationGroup();
        stringArray[2] = "request";
        stringArray[3] = a3.getTaskExecutor();
        a4.h.timer((MetricName)BaseMetricName.ba, Tags.of((String[])stringArray)).record(a4.L.millis() - a2, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void I(Task task, long l2, Void void_) {
        void a2;
        BaseTaskManager a3 = task;
        BaseTaskManager a4 = this;
        a4.completed((Task)a3, (long)a2);
    }

    private static /* synthetic */ Void d(Task task, Throwable throwable) {
        Object a2 = throwable;
        Task a3 = task;
        Object[] objectArray = new Object[4];
        objectArray[0] = a3.getReplicationGroup();
        objectArray[1] = a3.getTaskId();
        objectArray[2] = a3.getTaskExecutor();
        objectArray[3] = a2;
        D.warn(CommandResponseJson.I((Object)"\u0001@@\u001d<\\\u0013Q\u001fYZI\u0015\u001d\nO\u0015^\u001fN\t\u001d\bX\tH\u0016IZ[\u0015OZ^\u0015P\nQ\u001fI\u001fYZI\u001bN\u0011\u001d\u0001@@\u001d\u0001@"), objectArray);
        return null;
    }

    public void start() {
        BaseTaskManager a2;
        a2.A = true;
        a2.I();
    }

    private /* synthetic */ long I(Task task) {
        BaseTaskManager a2 = task;
        BaseTaskManager a3 = this;
        return a2.getTimestamp() - a3.L.millis();
    }

    private /* synthetic */ Number M(String string) {
        Object a2 = string;
        BaseTaskManager a3 = this;
        return a3.I((String)a2);
    }

    protected void saveAndSchedule(Task task) {
        BaseTaskManager a2 = task;
        BaseTaskManager a3 = this;
        a3.I.computeIfAbsent(a2.getReplicationGroup(), string -> {
            Object a2 = string;
            BaseTaskManager a3 = this;
            return a3.h.gauge((MetricName)BaseMetricName.q, Tags.of((String)J, (String)a2), () -> a3.M((String)a2));
        });
        new TransactionTemplate(a3.E).execute(arg_0 -> a3.I((Task)a2, arg_0));
        D.debug(StreamObserverUtils.I((Object)"h\u001d)@G\u0001`\u000b3\u0013p\bv\u0004f\fv\u00043\u001bn"), (Object)a2.getReplicationGroup(), (Object)a2.getTaskId());
        a3.doScheduleTask((Task)a2);
    }

    private /* synthetic */ void M(Task task) {
        BaseTaskManager a2;
        BaseTaskManager a3 = task;
        BaseTaskManager baseTaskManager = a2 = this;
        long l2 = baseTaskManager.L.millis();
        baseTaskManager.j.getOrDefault(a3.getReplicationGroup(), Collections.emptyMap()).remove(a3.getTaskId());
        if (D.isDebugEnabled()) {
            Object[] objectArray = new Object[4];
            objectArray[0] = a3.getReplicationGroup();
            objectArray[1] = a3.getTaskId();
            objectArray[2] = a3.getTaskExecutor();
            objectArray[3] = a2.L.millis() - a3.getTimestamp();
            D.debug(CommandResponseJson.I((Object)"\u0001@@\u001d?E\u001f^\u000fI\u001f\u001d\u000e\\\tVZF\u0007\u0007ZF\u0007\u001d\nQ\u001bS\u0014X\u001e\u001d\u001fE\u001f^\u000fI\u0013R\u0014\u001d\u0001@\u0017NZ\\\u001dR"), objectArray);
        }
        try {
            ((CompletableFuture)a2.M.executeTask((Task)a3).thenAccept(arg_0 -> a2.I((Task)a3, l2, arg_0))).exceptionally(arg_0 -> a2.I((Task)a3, arg_0));
            return;
        }
        catch (Exception exception) {
            a2.error((Task)a3, (Throwable)exception);
            return;
        }
    }

    public void stop() {
        BaseTaskManager a2;
        a2.A = false;
        D.info(StreamObserverUtils.I((Object)"3g\u000fc@G\u0001`\u000b^\u0001}\u0001t\u0005a"));
        a2.G.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    protected void unschedule(String string, String string2) {
        void a2;
        Object a3 = string;
        BaseTaskManager a4 = this;
        if ((a3 = (ScheduledFuture)a4.j.getOrDefault(a3, Collections.emptyMap()).remove(a2)) != null) {
            a3.cancel(false);
        }
    }

    private /* synthetic */ void I(Task task) {
        BaseTaskManager a2 = task;
        BaseTaskManager a3 = this;
        a3.M((Task)a2);
    }

    public boolean isRunning() {
        BaseTaskManager a2;
        return a2.A;
    }

    protected void schedule(Task task) {
        BaseTaskManager a3 = task;
        BaseTaskManager a4 = this;
        a4.j.computeIfAbsent(a3.getReplicationGroup(), a2 -> new ConcurrentHashMap()).computeIfAbsent(a3.getTaskId(), arg_0 -> a4.I((Task)a3, arg_0));
    }

    private /* synthetic */ Number I(String string) {
        Object a2 = string;
        BaseTaskManager a3 = this;
        return a3.i.countByContext((String)a2);
    }

    /*
     * WARNING - void declaration
     */
    protected void error(Task task, Throwable throwable) {
        CompletableFuture completableFuture;
        void a2;
        BaseTaskManager a3 = task;
        BaseTaskManager a4 = this;
        if (a4.isTransient((Throwable)a2)) {
            BaseTaskManager baseTaskManager;
            BaseTaskManager baseTaskManager2 = a3;
            long l2 = Math.min(baseTaskManager2.getRetryInterval() * 2L, e);
            if (baseTaskManager2.getRetryInterval() < e) {
                Object[] objectArray = new Object[3];
                objectArray[0] = a3.getReplicationGroup();
                objectArray[1] = a3.getPayload().getType();
                objectArray[2] = l2;
                D.info(StreamObserverUtils.I((Object)"\u001bnZ3&r\t\u007f\u0005w@g\u000f3\u0005k\u0005p\u0015g\u00053\u0014r\u0013x@4\u001bnG=@32v\u0014a\u0019z\u000et@z\u000e3\u001bn@~\u0013=N="), objectArray);
                baseTaskManager = a4;
            } else {
                Object[] objectArray = new Object[5];
                objectArray[0] = a3.getReplicationGroup();
                objectArray[1] = a3.getTaskId();
                objectArray[2] = a3.getTaskExecutor();
                objectArray[3] = a2.getMessage();
                objectArray[4] = l2;
                D.warn(CommandResponseJson.I((Object)"\u0001@@\u001d<\\\u0013Q\u001fYZI\u0015\u001d\u001fE\u001f^\u000fI\u001f\u001d\u000e\\\tVZF\u0007\u0007ZF\u0007\u001dW\u001d\u0001@T\u001d(X\u000eO\u0003T\u0014ZZT\u0014\u001d\u0001@ZP\t\u0013T\u0013"), objectArray);
                baseTaskManager = a4;
            }
            CompletableFuture completableFuture2 = baseTaskManager.processResult(a3.getReplicationGroup(), a3.getTaskId(), TaskStatus.SCHEDULED, a4.newSchedule((Task)a3), l2, a4.asString((Throwable)a2));
            String[] stringArray = new String[8];
            stringArray[0] = J;
            stringArray[1] = a3.getReplicationGroup();
            stringArray[2] = "request";
            stringArray[3] = a3.getTaskExecutor();
            stringArray[4] = c;
            stringArray[5] = b;
            stringArray[6] = "error";
            stringArray[7] = ErrorCode.fromException((Throwable)a2).getCode();
            a4.h.counter((MetricName)BaseMetricName.Ka, Tags.of((String[])stringArray)).increment();
            completableFuture = completableFuture2;
        } else {
            Object[] objectArray = new Object[4];
            objectArray[0] = a3.getReplicationGroup();
            objectArray[1] = a3.getTaskId();
            objectArray[2] = a3.getTaskExecutor();
            objectArray[3] = a2;
            D.warn(StreamObserverUtils.I((Object)"h\u001d)@U\u0001z\fv\u00043\u0014|@v\u0018v\u0003f\u0014v@g\u0001`\u000b3\u001bnZ3\u001bn"), objectArray);
            BaseTaskManager baseTaskManager = a4;
            CompletableFuture completableFuture3 = baseTaskManager.processResult(a3.getReplicationGroup(), a3.getTaskId(), TaskStatus.FAILED, a4.L.millis(), 0L, a4.asString((Throwable)a2));
            String[] stringArray = new String[8];
            stringArray[0] = J;
            stringArray[1] = a3.getReplicationGroup();
            stringArray[2] = "request";
            stringArray[3] = a3.getTaskExecutor();
            stringArray[4] = c;
            stringArray[5] = C;
            stringArray[6] = "error";
            stringArray[7] = ErrorCode.fromException((Throwable)a2).getCode();
            baseTaskManager.h.counter((MetricName)BaseMetricName.Ka, Tags.of((String[])stringArray)).increment();
            completableFuture = completableFuture3;
        }
        completableFuture.exceptionally(arg_0 -> BaseTaskManager.M((Task)a3, arg_0));
    }

    protected String asString(Throwable throwable) {
        Object a2 = throwable;
        BaseTaskManager a3 = this;
        return MessagingPlatformException.create((Throwable)a2).getMessage();
    }

    private /* synthetic */ void I() {
        BaseTaskManager a2;
        D.debug(CommandResponseJson.I((Object)"t\u0014T\u000e\u001d\u001cX\u000e^\u0012i\u001bN\u0011o\u000fS\u0014X\b\u0011ZJ\u0013S\u001eR\r\u001dG\u001d\u0001@"), (Object)a2.l);
        a2.G.scheduleWithFixedDelay(() -> {
            BaseTaskManager a2;
            if (!a2.A) {
                return;
            }
            try {
                BaseTaskManager baseTaskManager = a2;
                long l2 = baseTaskManager.B.getAndSet(baseTaskManager.L.millis() + a2.l);
                ((Set)baseTaskManager.a.get()).forEach(string -> {
                    void a2;
                    void a3;
                    BaseTaskManager baseTaskManager = this;
                    List a4 = baseTaskManager.i.findScheduled((String)a3, (long)a2, baseTaskManager.B.get());
                    Object[] objectArray = new Object[4];
                    objectArray[0] = a3;
                    objectArray[1] = a4.size();
                    objectArray[2] = (long)a2;
                    objectArray[3] = baseTaskManager.B.get();
                    D.debug(CommandResponseJson.I((Object)"F\u0007\u0007ZN\u0019U\u001fY\u000fQ\u0013S\u001d\u001d\u0001@ZI\u001bN\u0011NZ_\u001fI\rX\u001fSZF\u0007\u001d\u001bS\u001e\u001d\u0001@"), objectArray);
                    a4.forEach(arg_0 -> baseTaskManager.schedule(arg_0));
                });
                return;
            }
            catch (Exception exception) {
                D.warn(StreamObserverUtils.I((Object)"%k\u0003v\u0010g\t|\u000e3\u0006v\u0014p\bz\u000et@`\u0003{\u0005w\u0015\u007f\u0005w@g\u0001`\u000b`L3\u0017z\f\u007f@g\u0012j@r\u0007r\t}@\u007f\u0001g\u0005a"), (Throwable)exception);
                return;
            }
        }, 0L, a2.l, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - void declaration
     */
    public BaseTaskManager(ScheduledTaskExecutor scheduledTaskExecutor, Tasks tasks, Supplier<Set<String>> supplier, Predicate<String> predicate, PlatformTransactionManager platformTransactionManager, @Qualifier(value="taskScheduler") ScheduledExecutorService scheduledExecutorService, MeterFactory meterFactory, Clock clock) {
        void meterFactory2;
        void scheduler;
        void platformTransactionManager2;
        void raftLeaderTest;
        void leaderForGroupProvider;
        void taskRepository;
        void taskExecutor;
        BaseTaskManager a2;
        BaseTaskManager baseTaskManager = object;
        Object object = clock;
        BaseTaskManager baseTaskManager2 = a2 = baseTaskManager;
        BaseTaskManager baseTaskManager3 = a2;
        BaseTaskManager baseTaskManager4 = a2;
        BaseTaskManager baseTaskManager5 = a2;
        BaseTaskManager baseTaskManager6 = a2;
        BaseTaskManager baseTaskManager7 = a2;
        a2.j = new ConcurrentHashMap();
        BaseTaskManager baseTaskManager8 = a2;
        baseTaskManager7.I = new ConcurrentHashMap();
        BaseTaskManager baseTaskManager9 = a2;
        baseTaskManager6.B = new AtomicLong();
        baseTaskManager6.l = Duration.ofMinutes(5L).toMillis();
        baseTaskManager5.M = taskExecutor;
        baseTaskManager5.i = taskRepository;
        baseTaskManager4.a = leaderForGroupProvider;
        baseTaskManager4.f = raftLeaderTest;
        baseTaskManager3.E = platformTransactionManager2;
        baseTaskManager3.G = scheduler;
        baseTaskManager2.h = meterFactory2;
        baseTaskManager2.L = object;
    }

    private /* synthetic */ Task I(Task task, TransactionStatus transactionStatus) {
        BaseTaskManager a2 = task;
        BaseTaskManager a3 = this;
        return a3.i.save((Task)a2);
    }

    protected long newSchedule(Task task) {
        BaseTaskManager a2 = task;
        BaseTaskManager a3 = this;
        return a3.L.millis() + Math.min(a2.getRetryInterval(), e);
    }

    private static /* synthetic */ Void M(Task task, Throwable throwable) {
        Object a2 = throwable;
        Task a3 = task;
        Object[] objectArray = new Object[4];
        objectArray[0] = a3.getReplicationGroup();
        objectArray[1] = a3.getTaskId();
        objectArray[2] = a3.getTaskExecutor();
        objectArray[3] = a2;
        D.warn(StreamObserverUtils.I((Object)"\u001bnZ3&r\t\u007f\u0005w@g\u000f3\u0010a\u000fp\u0005`\u00133\u0012v\u0013f\fg@u\u000fa@g\u0001`\u000b3\u001bnZ3\u001bn"), objectArray);
        return null;
    }

    protected abstract CompletableFuture<Void> processResult(String var1, String var2, TaskStatus var3, long var4, long var6, String var8);

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Void I(Task task, Throwable throwable) {
        void a2;
        Object a3 = throwable;
        BaseTaskManager a4 = this;
        a4.error((Task)a2, (Throwable)a3);
        return null;
    }

    protected boolean isTransient(Throwable throwable) {
        Throwable a2 = throwable;
        BaseTaskManager a3 = this;
        if (a2 == null) {
            return false;
        }
        if (a2 instanceof TransientException) {
            return true;
        }
        return a3.isTransient(a2.getCause());
    }
}

