/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest;

import io.axoniq.axonserver.access.application.ReplicationGroupApplicationController;
import io.axoniq.axonserver.access.roles.RoleController;
import io.axoniq.axonserver.admin.user.api.UserAdminService;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.configuration.admin.AdminUserRole;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.ExceptionUtils;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.transport.rest.E;
import io.axoniq.axonserver.transport.rest.PrincipalAuthentication;
import io.axoniq.axonserver.transport.rest.UserRestController;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.validation.Valid;
import java.security.Principal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="UserRestController")
@CrossOrigin
@RequestMapping(value={"/v1"})
public class UserRestController {
    private static final Logger D;
    private final RoleController f;
    private static final Logger E;
    private final UserAdminService M;

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(path={"users/{name}"})
    public void I(@PathVariable(value="name") String string, @Parameter(hidden=true) Principal principal) {
        void a2;
        void name;
        UserRestController userRestController = this;
        try {
            userRestController.M.deleteUser((String)name, (Authentication)new PrincipalAuthentication((Principal)a2));
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = AuditLog.username((Principal)a2);
            objectArray[1] = name;
            objectArray[2] = exception.getMessage();
            D.error(ExceptionUtils.I((Object)"\u0007\u001c!:|#9\u000b9\u00139G)\u00149\u0015|\u001c!G:\u00065\u000b9\u0003|J|\u001c!"), objectArray);
            throw new MessagingPlatformException(ErrorCode.OTHER, exception.getMessage());
        }
    }

    static {
        E = LoggerFactory.getLogger(UserRestController.class);
        D = AuditLog.getLogger();
    }

    /*
     * WARNING - void declaration
     */
    public UserRestController(UserAdminService userAdminService, RoleController roleController) {
        void a2;
        UserRestController a3;
        UserRestController a4 = roleController;
        UserRestController userRestController = a3 = this;
        userRestController.M = a2;
        userRestController.f = a4;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"public/users"})
    public List<UserJson> I(@Parameter(hidden=true) Principal principal) {
        void a2;
        UserRestController userRestController = this;
        try {
            return userRestController.M.users((Authentication)new PrincipalAuthentication((Principal)a2)).stream().map(UserJson::new).sorted(Comparator.comparing(UserJson::getUserName)).collect(Collectors.toList());
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = AuditLog.username((Principal)a2);
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            E.info(ReplicationGroupApplicationController.I((Object)"4/\u0012\tO\u0018\u0006'\u001bt\u001a'\n&\u001ct\t5\u00068\n0OyO/\u0012"), objectArray);
            throw new MessagingPlatformException(ErrorCode.OTHER, exception.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"users"})
    public void I(@RequestBody @Valid UserJson userJson, @Parameter(hidden=true) Principal principal) {
        void a2;
        UserRestController userRestController = userRestController2;
        UserRestController userRestController2 = userJson;
        UserRestController userJson2 = userRestController;
        if (a2 != null && userRestController2.userName.equals(a2.getName())) {
            throw new MessagingPlatformException(ErrorCode.AUTHENTICATION_INVALID_TOKEN, ExceptionUtils.I((Object)")3\u0013|\u00060\u000b3\u00109\u0003|\u00133G?\u000f=\t;\u0002|\u001e3\u0012.G3\u00102G?\u00159\u00039\t(\u000e=\u000b/"));
        }
        Set<Object> set = new HashSet();
        if (userRestController2.roles != null) {
            set = Arrays.stream(userRestController2.roles).map(AdminUserRole::parse).collect(Collectors.toSet());
        }
        UserRestController userRestController3 = userRestController2;
        userJson2.M.createOrUpdateUser(userRestController3.userName, userRestController3.password, set.stream().map(adminUserRole -> {
            UserRestController a2 = adminUserRole;
            UserRestController a3 = this;
            return new E(a3, (AdminUserRole)a2);
        }).collect(Collectors.toSet()), (Authentication)new PrincipalAuthentication((Principal)a2));
    }
}

