/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.migration.source.mongo;

import io.axoniq.axonserver.migration.source.DomainEvent;
import io.axoniq.axonserver.migration.source.SnapshotEvent;
import java.nio.charset.StandardCharsets;
import java.time.Instant;

public class MongoDomainEvent
implements DomainEvent,
SnapshotEvent {
    private String timestamp;
    private String serializedPayload;
    private String serializedMetaData;
    private String eventIdentifier;
    private String payloadType;
    private String payloadRevision;
    private String type;
    private String aggregateIdentifier;
    private long sequenceNumber;

    public MongoDomainEvent(String timestamp, String serializedPayload, String serializedMetaData, String eventIdentifier, String payloadType, String payloadRevision, String type, String aggregateIdentifier, long sequenceNumber) {
        this.timestamp = timestamp;
        this.serializedPayload = serializedPayload;
        this.serializedMetaData = serializedMetaData;
        this.eventIdentifier = eventIdentifier;
        this.payloadType = payloadType;
        this.payloadRevision = payloadRevision;
        this.type = type;
        this.aggregateIdentifier = aggregateIdentifier;
        this.sequenceNumber = sequenceNumber;
    }

    public long getGlobalIndex() {
        return Instant.parse(this.timestamp).toEpochMilli();
    }

    public String getType() {
        return this.type;
    }

    public String getAggregateIdentifier() {
        return this.aggregateIdentifier;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public String getTimeStamp() {
        return this.timestamp;
    }

    public String getEventIdentifier() {
        return this.eventIdentifier;
    }

    public long getTimeStampAsLong() {
        return Instant.parse(this.timestamp).toEpochMilli();
    }

    public String getPayloadType() {
        return this.payloadType;
    }

    public String getPayloadRevision() {
        return this.payloadRevision;
    }

    public byte[] getPayload() {
        return this.serializedPayload.getBytes(StandardCharsets.UTF_8);
    }

    public byte[] getMetaData() {
        return this.serializedMetaData.getBytes(StandardCharsets.UTF_8);
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public void setSerializedPayload(String serializedPayload) {
        this.serializedPayload = serializedPayload;
    }

    public void setSerializedMetaData(String serializedMetaData) {
        this.serializedMetaData = serializedMetaData;
    }

    public void setEventIdentifier(String eventIdentifier) {
        this.eventIdentifier = eventIdentifier;
    }

    public void setPayloadType(String payloadType) {
        this.payloadType = payloadType;
    }

    public void setPayloadRevision(String payloadRevision) {
        this.payloadRevision = payloadRevision;
    }

    public void setGlobalIndex(long timestamp) {
        this.timestamp = Instant.ofEpochMilli(timestamp).toString();
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setAggregateIdentifier(String aggregateIdentifier) {
        this.aggregateIdentifier = aggregateIdentifier;
    }

    public void setSequenceNumber(long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }
}

