/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.migration.source.jpa;

import io.axoniq.axonserver.migration.source.BaseEvent;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Lob;
import javax.persistence.MappedSuperclass;

@MappedSuperclass
public class BaseEventEntry
implements BaseEvent {
    @Column(nullable=false, unique=true)
    private String eventIdentifier;
    @Basic(optional=false)
    private String timeStamp;
    @Basic(optional=false)
    private String payloadType;
    @Basic
    private String payloadRevision;
    @Basic(optional=false)
    @Lob
    @Column(length=10000)
    private byte[] payload;
    @Basic
    @Lob
    @Column(length=10000)
    private byte[] metaData;

    public String getEventIdentifier() {
        return this.eventIdentifier;
    }

    public void setEventIdentifier(String eventIdentifier) {
        this.eventIdentifier = eventIdentifier;
    }

    public String getTimeStamp() {
        return this.timeStamp;
    }

    public long getTimeStampAsLong() {
        if (this.timeStamp == null) {
            return 0L;
        }
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(this.timeStamp, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        return zonedDateTime.toInstant().toEpochMilli();
    }

    public String getPayloadType() {
        return this.payloadType;
    }

    public String getPayloadRevision() {
        return this.payloadRevision;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public byte[] getMetaData() {
        return this.metaData;
    }
}

