/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.cli;

import io.axoniq.cli.CommandOptions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Objects;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

/*
 * Exception performing whole class analysis ignored.
 */
public class AxonIQCliUtil {
    private AxonIQCliUtil() {
    }

    static CommandLine processCommandLine(String name, String[] args, Option ... options) {
        Options cliOptions = new Options().addOption(CommandOptions.ADDRESS).addOption(CommandOptions.USE_HTTPS).addOption(CommandOptions.CONNECT_INSECURE).addOption(CommandOptions.OUTPUT);
        for (Option option : options) {
            cliOptions.addOption(option);
        }
        DefaultParser parser = new DefaultParser();
        try {
            return parser.parse(cliOptions, args);
        }
        catch (ParseException ex) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(name, cliOptions);
            throw new RuntimeException("Invalid command", ex);
        }
    }

    static String option(CommandLine commandLine, Option option) {
        return commandLine.getOptionValue(option.getOpt());
    }

    static boolean jsonOutput(CommandLine commandLine) {
        return "json".equals(AxonIQCliUtil.option((CommandLine)commandLine, (Option)CommandOptions.OUTPUT));
    }

    static String getToken(CommandLine commandLine) {
        File tokenFile;
        String token = commandLine.getOptionValue(CommandOptions.TOKEN.getOpt());
        if (token == null && (tokenFile = new File("security/.token")).exists() && tokenFile.canRead()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(tokenFile));){
                token = reader.readLine();
            }
            catch (IOException e) {
                System.err.println("Cannot read token file: " + e.getMessage());
            }
        }
        return token;
    }

    static String getServerHttpAddress(CommandLine commandLine) {
        String address = commandLine.getOptionValue(CommandOptions.ADDRESS.getOpt());
        if (Objects.nonNull(address)) {
            return address;
        }
        return commandLine.hasOption(CommandOptions.USE_HTTPS.getOpt()) ? "https://localhost:8024" : "http://localhost:8024";
    }

    static boolean getConnectInsecure(CommandLine commandLine) {
        return commandLine.hasOption(CommandOptions.CONNECT_INSECURE.getOpt());
    }
}

