/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.cli;

import io.axoniq.cli.AxonIQCliUtil;
import io.axoniq.cli.CommandOptions;
import io.axoniq.tools.ToolResult;
import io.axoniq.tools.http.PluginTool;
import io.axoniq.tools.http.json.PluginInfo;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

/*
 * Exception performing whole class analysis ignored.
 */
public class ListPlugins {
    private ListPlugins() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void run(String[] args) throws Throwable {
        CommandLine commandLine = AxonIQCliUtil.processCommandLine((String)args[0], (String[])args, (Option[])new Option[]{CommandOptions.TOKEN});
        String serverHttpAddress = AxonIQCliUtil.getServerHttpAddress((CommandLine)commandLine);
        boolean connectInsecure = AxonIQCliUtil.getConnectInsecure((CommandLine)commandLine);
        String token = AxonIQCliUtil.getToken((CommandLine)commandLine);
        if (AxonIQCliUtil.jsonOutput((CommandLine)commandLine)) {
            ToolResult result = PluginTool.listPluginsRaw((String)serverHttpAddress, (boolean)connectInsecure, (String)token);
            if (!result.isSuccess()) throw result.getFailure();
            System.out.println((String)result.getSuccessValue());
            return;
        } else {
            ToolResult result = PluginTool.listPlugins((String)serverHttpAddress, (boolean)connectInsecure, (String)token);
            if (!result.isSuccess()) throw result.getFailure();
            ListPlugins.showExtensionsAsTable((List)((List)result.getSuccessValue()));
        }
    }

    private static void showExtensionsAsTable(List<PluginInfo> plugins) {
        System.out.printf("%-30s %-15s %-20s %-10s%n", "Name", "Version", "Context", "Status");
        for (PluginInfo pluginInfo : plugins) {
            if (pluginInfo.getContextInfoList().length == 0) {
                System.out.printf("%-30s %-15s%n", pluginInfo.getName(), pluginInfo.getVersion());
                continue;
            }
            for (int i = 0; i < pluginInfo.getContextInfoList().length; ++i) {
                PluginInfo.PluginContextInfo contextInfo = pluginInfo.getContextInfoList()[i];
                System.out.printf("%-30s %-15s %-20s %-10s%n", i == 0 ? pluginInfo.getName() : "", i == 0 ? pluginInfo.getVersion() : "", contextInfo.getContext(), contextInfo.isActive() ? "Active" : "Registered");
            }
        }
    }
}

