/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.cluster.replication.file;

import io.axoniq.axonserver.cluster.MissingNodeForGroupException;
import io.axoniq.axonserver.cluster.exception.LogEntryApplyException;
import java.io.File;
import java.time.Duration;
import org.springframework.util.Assert;
import org.springframework.util.unit.DataSize;

public class StorageProperties {
    private int forceInterval;
    private String logStorageFolder;
    private int flags;
    private long secondaryCleanupDelay;
    private String indexSuffix;
    protected Boolean forceCleanMmapIndex;
    private String logSuffix;
    private int minActiveBackups;
    private int primaryCleanupDelay;
    private int segmentSize;
    private long numberOfSegments;
    private int maxIndexesInMemory;
    private int syncInterval;
    private long warnFreeSpace;
    private static final String FILENAME_PATTERN = "%s" + File.separator + "%020d%s";
    protected Boolean useMmapIndex;
    private long minFreeSpace;
    private int validationSegments;
    private static final boolean WINDOWS = System.getProperty(LogEntryApplyException.b((Object)"1=p ?#;"), MissingNodeForGroupException.b((Object)"\u0011Q+m:J")).toLowerCase().startsWith(LogEntryApplyException.b((Object)")'0"));

    public void setIndexSuffix(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.indexSuffix = a2;
    }

    public int getFlags() {
        StorageProperties a2;
        return a2.flags;
    }

    public StorageProperties() {
        StorageProperties a2;
        StorageProperties storageProperties = a2;
        StorageProperties storageProperties2 = a2;
        StorageProperties storageProperties3 = a2;
        StorageProperties storageProperties4 = a2;
        StorageProperties storageProperties5 = a2;
        StorageProperties storageProperties6 = a2;
        StorageProperties storageProperties7 = a2;
        StorageProperties storageProperties8 = a2;
        storageProperties8.forceCleanMmapIndex = true;
        storageProperties8.syncInterval = 1000;
        storageProperties7.forceInterval = 1000;
        storageProperties7.logSuffix = ".log";
        storageProperties6.indexSuffix = ".index";
        storageProperties6.validationSegments = 2;
        storageProperties5.flags = 0;
        storageProperties5.primaryCleanupDelay = 5;
        storageProperties4.segmentSize = 0x1000000;
        storageProperties4.numberOfSegments = 1000L;
        storageProperties3.secondaryCleanupDelay = 30L;
        storageProperties3.logStorageFolder = "log";
        storageProperties2.minActiveBackups = 1;
        storageProperties2.maxIndexesInMemory = 5;
        storageProperties.minFreeSpace = DataSize.ofMegabytes((long)512L).toBytes();
        storageProperties.warnFreeSpace = DataSize.ofGigabytes((long)5L).toBytes();
    }

    public long warnFreeSpace() {
        StorageProperties a2;
        return a2.warnFreeSpace;
    }

    public void setLogSuffix(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.logSuffix = a2;
    }

    public void setNumberOfSegments(long a2) {
        a.numberOfSegments = a2;
    }

    public void setForceInterval(Duration duration) {
        Duration a2 = duration;
        StorageProperties a3 = this;
        a3.forceInterval = (int)a2.toMillis();
    }

    public int getPrimaryCleanupDelay() {
        StorageProperties a2;
        return a2.primaryCleanupDelay;
    }

    public void setFlags(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.flags = a2;
    }

    public String getIndexSuffix() {
        StorageProperties a2;
        return a2.indexSuffix;
    }

    /*
     * WARNING - void declaration
     */
    public File indexFile(String string, Long l) {
        void a2;
        Object a3 = l;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a4.getStorage((String)a2);
        objectArray[1] = a3;
        objectArray[2] = a4.indexSuffix;
        return new File(String.format(FILENAME_PATTERN, objectArray));
    }

    public void setMinActiveBackups(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.minActiveBackups = a2;
    }

    public String getStorage(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        return a3.logStorageFolder + File.separator + (String)a2;
    }

    public int getValidationSegments() {
        StorageProperties a2;
        return a2.validationSegments;
    }

    public long getSyncInterval() {
        StorageProperties a2;
        return a2.syncInterval;
    }

    public long getSecondaryCleanupDelay() {
        StorageProperties a2;
        return a2.secondaryCleanupDelay;
    }

    public void setWarnFreeSpace(DataSize dataSize) {
        StorageProperties a2 = dataSize;
        StorageProperties a3 = this;
        a3.warnFreeSpace = a2.toBytes();
    }

    public String getLogStorageFolder() {
        StorageProperties a2;
        return a2.logStorageFolder;
    }

    public String getLogSuffix() {
        StorageProperties a2;
        return a2.logSuffix;
    }

    public void setSyncInterval(Duration duration) {
        Duration a2 = duration;
        StorageProperties a3 = this;
        a3.syncInterval = (int)a2.toMillis();
    }

    public boolean isUseMmapIndex() {
        StorageProperties a2;
        if (a2.useMmapIndex != null) {
            return a2.useMmapIndex;
        }
        return false;
    }

    public void setForceCleanMmapIndex(Boolean bl) {
        Object a2 = bl;
        StorageProperties a3 = this;
        a3.forceCleanMmapIndex = a2;
    }

    public void setMaxIndexesInMemory(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.maxIndexesInMemory = a2;
    }

    /*
     * WARNING - void declaration
     */
    public File indexTempFile(String string, Long l) {
        void a2;
        Object a3 = l;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a4.getStorage((String)a2);
        objectArray[1] = a3;
        objectArray[2] = a4.indexSuffix + ".temp";
        return new File(String.format(FILENAME_PATTERN, objectArray));
    }

    public void setUseMmapIndex(Boolean bl) {
        Object a2 = bl;
        StorageProperties a3 = this;
        a3.useMmapIndex = a2;
    }

    public long getNumberOfSegments() {
        StorageProperties a2;
        return a2.numberOfSegments;
    }

    public long getSegmentSize() {
        StorageProperties a2;
        return a2.segmentSize;
    }

    /*
     * WARNING - void declaration
     */
    public File logFile(String string, Long l) {
        void a2;
        Object a3 = l;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a4.getStorage((String)a2);
        objectArray[1] = a3;
        objectArray[2] = a4.logSuffix;
        return new File(String.format(FILENAME_PATTERN, objectArray));
    }

    public int getMaxIndexesInMemory() {
        StorageProperties a2;
        return a2.maxIndexesInMemory;
    }

    public void setSegmentSize(DataSize dataSize) {
        StorageProperties a2 = dataSize;
        StorageProperties a3 = this;
        Assert.isTrue((a2.toBytes() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)LogEntryApplyException.b((Object)"\r+9#; *n-'$+~#+=*n<+~\";=-n*&? ~|ozizf}hzi"));
        Assert.isTrue((a2.toBytes() > 0L ? 1 : 0) != 0, (String)MissingNodeForGroupException.b((Object)"\f[8S:P+\u001e,W%[\u007fS*M+\u001e=[\u007fS0L:\u001e+V>P\u007f\u000e"));
        a3.segmentSize = (int)a2.toBytes();
    }

    public void setLogStorageFolder(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.logStorageFolder = a2;
    }

    public long minFreeSpace() {
        StorageProperties a2;
        return a2.minFreeSpace;
    }

    public void setSecondaryCleanupDelay(long a2) {
        a.secondaryCleanupDelay = a2;
    }

    public int getForceInterval() {
        StorageProperties a2;
        return a2.forceInterval;
    }

    public boolean isForceCleanMmapIndex() {
        StorageProperties a2;
        if (a2.forceCleanMmapIndex != null) {
            return a2.forceCleanMmapIndex;
        }
        return WINDOWS;
    }

    public void setMinFreeSpace(DataSize dataSize) {
        StorageProperties a2 = dataSize;
        StorageProperties a3 = this;
        a3.minFreeSpace = a2.toBytes();
    }

    public void setPrimaryCleanupDelay(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.primaryCleanupDelay = a2;
    }

    public int getMinActiveBackups() {
        StorageProperties a2;
        return a2.minActiveBackups;
    }

    public void setValidationSegments(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.validationSegments = a2;
    }
}

