/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.config;

import db.callback.CleanupRepairs;
import db.callback.MigrateControlDB;
import db.callback.SeMigration;
import io.axoniq.axonserver.ClusterTagsCache;
import io.axoniq.axonserver.component.instance.Clients;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.config.k;
import io.axoniq.axonserver.enterprise.cluster.HealthBasedNodeSelectionStrategy;
import io.axoniq.axonserver.enterprise.cluster.MatchingTagsNodeSelectionStrategy;
import io.axoniq.axonserver.enterprise.cluster.NodeSelectionStrategy;
import io.axoniq.axonserver.enterprise.cluster.SubscriptionCountBasedNodeSelectionStrategy;
import io.axoniq.axonserver.enterprise.cluster.internal.ClusterHealth;
import io.axoniq.axonserver.grpc.ClientIdRegistry;
import io.axoniq.axonserver.grpc.DefaultInstructionAckSource;
import io.axoniq.axonserver.grpc.InstructionAckSource;
import io.axoniq.axonserver.grpc.SerializedCommandProviderInbound;
import io.axoniq.axonserver.grpc.command.CommandProviderInbound;
import io.axoniq.axonserver.grpc.control.PlatformOutboundInstruction;
import io.axoniq.axonserver.grpc.query.QueryProviderInbound;
import io.axoniq.axonserver.localstorage.DefaultEventDecorator;
import io.axoniq.axonserver.localstorage.EventDecorator;
import io.axoniq.axonserver.localstorage.transformation.DefaultEventTransformerFactory;
import io.axoniq.axonserver.localstorage.transformation.EventTransformerFactory;
import io.axoniq.axonserver.message.SubscriptionKey;
import io.axoniq.axonserver.message.command.CommandRegistrationCache;
import io.axoniq.axonserver.message.query.QueryRegistrationCache;
import io.axoniq.axonserver.replication.ReplicationGroupProvider;
import io.axoniq.axonserver.util.DaemonThreadFactory;
import java.time.Clock;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.flywaydb.core.api.callback.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.system.DiskSpaceHealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.flyway.FlywayConfigurationCustomizer;
import org.springframework.boot.autoconfigure.flyway.FlywayMigrationStrategy;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;

@Configuration
public class AxonServerStandardConfiguration {
    private final Logger G = LoggerFactory.getLogger(AxonServerStandardConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={EventTransformerFactory.class})
    public EventTransformerFactory eventTransformerFactory() {
        return new DefaultEventTransformerFactory();
    }

    public AxonServerStandardConfiguration() {
        AxonServerStandardConfiguration a2;
    }

    @Bean
    public Clock clock() {
        return Clock.systemUTC();
    }

    @Bean
    @Qualifier(value="platformInstructionAckSource")
    public InstructionAckSource<PlatformOutboundInstruction> platformInstructionAckSource() {
        return new DefaultInstructionAckSource(a2 -> PlatformOutboundInstruction.newBuilder().setAck(a2).build());
    }

    @Bean
    public FlywayConfigurationCustomizer flywayConfigurationCustomizer() {
        return a2 -> {
            Callback[] callbackArray = new Callback[3];
            callbackArray[0] = new CleanupRepairs();
            callbackArray[1] = new SeMigration();
            callbackArray[2] = new MigrateControlDB();
            a2.callbacks(callbackArray);
        };
    }

    @Bean
    @Qualifier(value="commandInstructionAckSource")
    public InstructionAckSource<SerializedCommandProviderInbound> commandInstructionAckSource() {
        return new DefaultInstructionAckSource(a2 -> new SerializedCommandProviderInbound(CommandProviderInbound.newBuilder().setAck(a2).build()));
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public NodeSelectionStrategy nodeSelectionStrategy(CommandRegistrationCache commandRegistrationCache, QueryRegistrationCache queryRegistrationCache, ClientIdRegistry clientIdRegistry, Clients clients, MessagingPlatformConfiguration messagingPlatformConfiguration, ClusterTagsCache clusterTagsCache, FeatureChecker featureChecker, ClusterHealth clusterHealth, ReplicationGroupProvider replicationGroupProvider) {
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        void a9;
        AxonServerStandardConfiguration a10 = commandRegistrationCache;
        AxonServerStandardConfiguration a11 = this;
        a10 = new SubscriptionCountBasedNodeSelectionStrategy((CommandRegistrationCache)a10, (QueryRegistrationCache)a9, (ClientIdRegistry)a8, (Clients)a7, (MessagingPlatformConfiguration)a6);
        a10 = new MatchingTagsNodeSelectionStrategy((ClusterTagsCache)a5, (MessagingPlatformConfiguration)a6, (FeatureChecker)a4, (NodeSelectionStrategy)a10);
        return new HealthBasedNodeSelectionStrategy((ClusterHealth)a3, arg_0 -> ((ReplicationGroupProvider)a2).replicationGroup(arg_0), (NodeSelectionStrategy)a10, a6.getName());
    }

    public static String b(Object object) {
        Object object2 = object;
        object2 = (String)object2;
        int n = ((String)object2).length();
        int a2 = n - 1;
        char[] cArray = new char[n];
        int n2 = (2 ^ 5) << 4 ^ 1;
        int cfr_ignored_0 = 1 << 3 ^ (3 ^ 5);
        int n3 = a2;
        int n4 = 1 << 3 ^ 5;
        while (n3 >= 0) {
            int n5 = a2--;
            cArray[n5] = (char)(((String)object2).charAt(n5) ^ n4);
            if (a2 < 0) break;
            int n6 = a2--;
            cArray[n6] = (char)(((String)object2).charAt(n6) ^ n2);
            n3 = a2;
        }
        return new String(cArray);
    }

    @Bean
    public DiskSpaceHealthIndicator diskSpaceHealthIndicator() {
        return null;
    }

    @Bean
    @Qualifier(value="queryInstructionAckSource")
    public InstructionAckSource<QueryProviderInbound> queryInstructionAckSource() {
        return new DefaultInstructionAckSource(a2 -> QueryProviderInbound.newBuilder().setAck(a2).build());
    }

    @Bean
    @Qualifier(value="taskScheduler")
    public ScheduledExecutorService scheduler() {
        return Executors.newScheduledThreadPool(10, (ThreadFactory)new DaemonThreadFactory(SubscriptionKey.b((Object)"'\u0003 \t~\u00110\n6\u0006&\u000e6\u0010")));
    }

    @Bean
    public ApplicationEventMulticaster applicationEventMulticaster() {
        AxonServerStandardConfiguration a2;
        return new k(a2);
    }

    @Bean
    @ConditionalOnMissingBean(value={EventDecorator.class})
    public EventDecorator eventDecorator() {
        return new DefaultEventDecorator();
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    public FlywayMigrationStrategy cleanMigrateStrategy() {
        return a2 -> {
            a2.repair();
            a2.migrate();
        };
    }
}

