/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.config;

import io.axoniq.axonserver.config.AccessControlConfiguration;
import io.axoniq.axonserver.config.EventTransformationConfiguration;
import io.axoniq.axonserver.config.SslConfiguration;
import io.axoniq.axonserver.config.SystemInfoProvider;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.localstorage.file.AppendOnlyList;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.replication.ServerProperties;
import io.axoniq.axonserver.transport.rest.v2.ReplicationRestControllerV2;
import io.axoniq.axonserver.util.StringUtils;
import jakarta.annotation.PostConstruct;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;
import org.springframework.util.unit.DataSize;

@Configuration
@ConfigurationProperties(prefix="axoniq.axonserver")
public class MessagingPlatformConfiguration
implements ServerProperties {
    private String internalDomain;
    private static final int RESERVED = 10000;
    private int eventStoreBackgroundThreadCount;
    private int clusterExecutorThreadCount;
    public static final int DEFAULT_INTERNAL_GRPC_PORT = 8224;
    private static final Logger auditLog;
    private final SystemInfoProvider systemInfoProvider;
    private String hostname;
    private String name;
    private boolean setWebSocketAllowedOrigins;
    private String controldbBackupLocation;
    private String pluginPackageDirectory;
    private boolean pluginsEnabled;
    private boolean forceConnectionToPrimaryOrMessagingNode;
    private int port;
    @NestedConfigurationProperty
    private SslConfiguration ssl;
    private String pidFileLocation;
    @NestedConfigurationProperty
    private AccessControlConfiguration accesscontrol;
    private Duration metricsInterval;
    private int httpPort;
    private Duration keepAliveTime;
    private int eventStoreProcessorsThreadCount;
    private String webSocketAllowedOrigins;
    @Value(value="${spring.datasource.url:#{null}}")
    private String datasourceUrl;
    private String pluginCleanPolicy;
    private int maxMessageSize;
    private String internalHostname;
    private int executorThreadCount;
    private static final Logger logger;
    private String domain;
    private final Map<String, Boolean> preview;
    private static final int DEFAULT_MAX_TRANSACTION_SIZE = 4184304;
    private String pluginCacheDirectory;
    private Duration minKeepAliveTime;
    private Duration keepAliveTimeout;
    @NestedConfigurationProperty
    private EventTransformationConfiguration eventTransformation;
    private int internalPort;
    private int grpcBufferedMessages;
    private int metricsSynchronizationRate;

    public int getPort() {
        MessagingPlatformConfiguration a2;
        return a2.port;
    }

    public void setDomain(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.domain = a2;
    }

    public void setMetricsSynchronizationRate(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.metricsSynchronizationRate = a2;
    }

    public Duration getMetricsInterval() {
        MessagingPlatformConfiguration a2;
        return a2.metricsInterval;
    }

    public int getEventStoreProcessorsThreadCount() {
        MessagingPlatformConfiguration a2;
        return a2.eventStoreProcessorsThreadCount;
    }

    public void setEventStoreBackgroundThreadCount(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.eventStoreBackgroundThreadCount = a2;
    }

    public long getKeepAliveTimeout() {
        MessagingPlatformConfiguration a2;
        return a2.keepAliveTimeout.toMillis();
    }

    public void setName(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.name = a2;
    }

    public void setAccesscontrol(AccessControlConfiguration accessControlConfiguration) {
        MessagingPlatformConfiguration a2;
        block3: {
            MessagingPlatformConfiguration messagingPlatformConfiguration;
            MessagingPlatformConfiguration a3;
            block1: {
                block2: {
                    a2 = accessControlConfiguration;
                    a3 = this;
                    if (!auditLog.isInfoEnabled()) break block1;
                    if (a2 != null) break block2;
                    if (a3.accesscontrol == null) break block1;
                    auditLog.info(ReplicationRestControllerV2.b((Object)"9V\u001bP\u000bFXV\u0017[\fG\u0017YXV\u0017[\u001e\\\u001f@\nT\f\\\u0017[Xg=x7c=qV"));
                    messagingPlatformConfiguration = a3;
                    break block3;
                }
                if (a3.accesscontrol == null || a2.isEnabled() != a3.accesscontrol.isEnabled()) {
                    auditLog.info(AppendOnlyList.b((Object)"gVEPUF\u0006VI[RGIY\u0006\\U\u0015HZQ\u0015]H\b"), (Object)AuditLog.enablement((boolean)a2.isEnabled()));
                }
            }
            messagingPlatformConfiguration = a3;
        }
        messagingPlatformConfiguration.accesscontrol = a2;
    }

    @PostConstruct
    public void postConstruct() {
        MessagingPlatformConfiguration a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration = a2;
        messagingPlatformConfiguration.A();
        messagingPlatformConfiguration.b();
        messagingPlatformConfiguration.f();
    }

    public String getWebSocketAllowedOrigins() {
        MessagingPlatformConfiguration a2;
        return a2.webSocketAllowedOrigins;
    }

    public void setKeepAliveTime(Duration duration) {
        Object a2 = duration;
        MessagingPlatformConfiguration a3 = this;
        a3.keepAliveTime = a2;
    }

    public int getEventStoreBackgroundThreadCount() {
        MessagingPlatformConfiguration a2;
        return a2.eventStoreBackgroundThreadCount;
    }

    private /* synthetic */ void A() {
        if (auditLog.isInfoEnabled()) {
            MessagingPlatformConfiguration a2;
            a2.preview.forEach((string, bl) -> {
                Boolean a2 = bl;
                String a3 = string;
                if (Boolean.TRUE.equals(a2)) {
                    auditLog.info(ReplicationRestControllerV2.b((Object)"e\nP\u000e\\\u001dBXZ\u001e\u0015\u001eP\u0019A\rG\u001d\u0015\u0003HXP\u0016T\u001aY\u001dQV"), (Object)a3);
                }
            });
            auditLog.info(ReplicationRestControllerV2.b((Object)"v\u0017[\u001e\\\u001f@\nT\f\\\u0017[X\\\u0016\\\f\\\u0019Y\u0011O\u001dQXB\u0011A\u0010\u0015+f4\u0015\u0003HXT\u0016QXT\u001bV\u001dF\u000b\u0015\u001bZ\u0016A\nZ\u0014\u0015\u0003HV"), (Object)AuditLog.enablement((boolean)a2.ssl.isEnabled()), (Object)AuditLog.enablement((boolean)a2.accesscontrol.isEnabled()));
        }
    }

    public String getHostname() {
        MessagingPlatformConfiguration messagingPlatformConfiguration = this;
        if (StringUtils.isEmpty((String)messagingPlatformConfiguration.hostname)) {
            try {
                MessagingPlatformConfiguration messagingPlatformConfiguration2 = messagingPlatformConfiguration;
                messagingPlatformConfiguration2.hostname = messagingPlatformConfiguration2.systemInfoProvider.getHostName();
                if (!StringUtils.isEmpty((String)messagingPlatformConfiguration2.domain)) {
                    MessagingPlatformConfiguration messagingPlatformConfiguration3 = messagingPlatformConfiguration;
                    if (messagingPlatformConfiguration3.hostname.endsWith("." + messagingPlatformConfiguration3.domain)) {
                        messagingPlatformConfiguration.hostname = messagingPlatformConfiguration.hostname.substring(0, messagingPlatformConfiguration.hostname.length() - messagingPlatformConfiguration.domain.length() - 1);
                    }
                }
            }
            catch (UnknownHostException a2) {
                logger.warn(ReplicationRestControllerV2.b((Object)"v\u0017@\u0014QX[\u0017AXQ\u001dA\u001dG\u0015\\\u0016PX]\u0017F\f[\u0019X\u001d\u0015\u001eG\u0017XX\\\u0016P\f\u0015\u0019Q\u001cG\u001dF\u000b\u000fXN\u0005"), (Object)a2.getMessage());
            }
        }
        return messagingPlatformConfiguration.hostname;
    }

    public void setSsl(SslConfiguration sslConfiguration) {
        MessagingPlatformConfiguration a2;
        block3: {
            MessagingPlatformConfiguration messagingPlatformConfiguration;
            MessagingPlatformConfiguration a3;
            block1: {
                block2: {
                    a2 = sslConfiguration;
                    a3 = this;
                    if (!auditLog.isInfoEnabled()) break block1;
                    if (a2 != null) break block2;
                    if (a3.ssl == null) break block1;
                    auditLog.info(ReplicationRestControllerV2.b((Object)"f+yXV\u0017[\u001e\\\u001f@\nT\f\\\u0017[Xg=x7c=qV"));
                    messagingPlatformConfiguration = a3;
                    break block3;
                }
                if (a3.ssl == null || a2.isEnabled() != a3.ssl.isEnabled()) {
                    auditLog.info(AppendOnlyList.b((Object)"fuy\u0006\\U\u0015HZQ\u0015]H\b"), (Object)AuditLog.enablement((boolean)a2.isEnabled()));
                }
            }
            messagingPlatformConfiguration = a3;
        }
        messagingPlatformConfiguration.ssl = a2;
    }

    public void setPluginCacheDirectory(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.pluginCacheDirectory = a2;
    }

    public String getName() {
        MessagingPlatformConfiguration a2;
        if (a2.name == null) {
            a2.name = a2.getHostname();
        }
        return a2.name;
    }

    public boolean isExperimentalFeatureEnabled(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        return a3.preview.getOrDefault(a2, false);
    }

    public int getMaxTransactionSize() {
        MessagingPlatformConfiguration a2;
        if (a2.maxMessageSize == 0) {
            return 4184304;
        }
        return a2.maxMessageSize - 10000;
    }

    public void setHostname(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.hostname = a2;
    }

    public void setMetricsInterval(Duration duration) {
        Object a2 = duration;
        MessagingPlatformConfiguration a3 = this;
        a3.metricsInterval = a2;
    }

    public void setExecutorThreadCount(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.executorThreadCount = a2;
    }

    public void setEventStoreProcessorsThreadCount(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.eventStoreProcessorsThreadCount = a2;
    }

    public void setClusterExecutorThreadCount(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.clusterExecutorThreadCount = a2;
    }

    public void setMaxMessageSize(DataSize dataSize) {
        MessagingPlatformConfiguration a2 = dataSize;
        MessagingPlatformConfiguration a3 = this;
        Assert.isTrue((a2.toBytes() >= 0L ? 1 : 0) != 0, (String)ReplicationRestControllerV2.b((Object)"5T\u0000\u0015\u0015P\u000bF\u0019R\u001d\u0015\u000b\\\u0002PXX\rF\f\u0015\u001aPXR\nP\u0019A\u001dGXA\u0010T\u0016\u0015H"));
        Assert.isTrue((a2.toBytes() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)AppendOnlyList.b((Object)"kT^\u0015KPUFGRC\u0015U\\\\P\u0006XSFR\u0015DP\u0006YCFU\u0015R]G[\u0006\u0007\u0017\u0001\u0011\u0001\u001e\u0006\u0010\u0001\u0011"));
        a3.maxMessageSize = (int)a2.toBytes();
    }

    public MessagingPlatformConfiguration(SystemInfoProvider systemInfoProvider) {
        MessagingPlatformConfiguration a2;
        MessagingPlatformConfiguration a3 = systemInfoProvider;
        MessagingPlatformConfiguration messagingPlatformConfiguration = a2 = this;
        MessagingPlatformConfiguration messagingPlatformConfiguration2 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration3 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration4 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration5 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration6 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration7 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration8 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration9 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration10 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration11 = a2;
        a2.port = 8124;
        messagingPlatformConfiguration11.internalPort = 8224;
        messagingPlatformConfiguration11.keepAliveTimeout = Duration.ofMillis(5000L);
        messagingPlatformConfiguration10.keepAliveTime = Duration.ofMillis(2500L);
        messagingPlatformConfiguration10.minKeepAliveTime = Duration.ofMillis(1000L);
        messagingPlatformConfiguration9.setWebSocketAllowedOrigins = false;
        messagingPlatformConfiguration9.webSocketAllowedOrigins = "*";
        MessagingPlatformConfiguration messagingPlatformConfiguration12 = a2;
        messagingPlatformConfiguration9.ssl = new SslConfiguration();
        MessagingPlatformConfiguration messagingPlatformConfiguration13 = a2;
        messagingPlatformConfiguration8.accesscontrol = new AccessControlConfiguration();
        MessagingPlatformConfiguration messagingPlatformConfiguration14 = a2;
        messagingPlatformConfiguration8.eventTransformation = new EventTransformationConfiguration();
        messagingPlatformConfiguration8.forceConnectionToPrimaryOrMessagingNode = true;
        messagingPlatformConfiguration7.metricsInterval = Duration.ofMinutes(15L);
        messagingPlatformConfiguration7.controldbBackupLocation = ".";
        messagingPlatformConfiguration6.maxMessageSize = 0x400000;
        messagingPlatformConfiguration6.pidFileLocation = ".";
        messagingPlatformConfiguration5.grpcBufferedMessages = 500;
        messagingPlatformConfiguration5.executorThreadCount = 4;
        messagingPlatformConfiguration4.clusterExecutorThreadCount = 4;
        messagingPlatformConfiguration4.eventStoreBackgroundThreadCount = 8;
        messagingPlatformConfiguration3.eventStoreProcessorsThreadCount = 8;
        messagingPlatformConfiguration3.pluginsEnabled = true;
        messagingPlatformConfiguration2.pluginCacheDirectory = "plugins/cache";
        messagingPlatformConfiguration2.pluginPackageDirectory = "plugins/bundles";
        messagingPlatformConfiguration.pluginCleanPolicy = "onFirstInit";
        MessagingPlatformConfiguration messagingPlatformConfiguration15 = a2;
        messagingPlatformConfiguration.preview = new HashMap();
        messagingPlatformConfiguration.systemInfoProvider = a3;
    }

    public void setInternalPort(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.internalPort = a2;
    }

    public int getHttpPort() {
        MessagingPlatformConfiguration a2;
        if (a2.httpPort == 0) {
            a2.httpPort = a2.systemInfoProvider.getPort();
        }
        return a2.httpPort;
    }

    public void setPidFileLocation(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.pidFileLocation = a2;
    }

    public int getInternalPort() {
        MessagingPlatformConfiguration a2;
        return a2.internalPort;
    }

    static {
        logger = LoggerFactory.getLogger(MessagingPlatformConfiguration.class);
        auditLog = AuditLog.getLogger();
    }

    public int getMaxMessageSize() {
        MessagingPlatformConfiguration a2;
        return a2.maxMessageSize;
    }

    public EventTransformationConfiguration getEventTransformation() {
        MessagingPlatformConfiguration a2;
        return a2.eventTransformation;
    }

    public void setGrpcBufferedMessages(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.grpcBufferedMessages = a2;
    }

    public void setForceConnectionToPrimaryOrMessagingNode(boolean bl) {
        boolean a2 = bl;
        MessagingPlatformConfiguration a3 = this;
        a3.forceConnectionToPrimaryOrMessagingNode = a2;
    }

    public String getPluginCacheDirectory() {
        MessagingPlatformConfiguration a2;
        return a2.pluginCacheDirectory;
    }

    public void setEventTransformation(EventTransformationConfiguration eventTransformationConfiguration) {
        MessagingPlatformConfiguration a2 = eventTransformationConfiguration;
        MessagingPlatformConfiguration a3 = this;
        a3.eventTransformation = a2;
    }

    public String getPluginCleanPolicy() {
        MessagingPlatformConfiguration a2;
        return a2.pluginCleanPolicy;
    }

    public boolean isForceConnectionToPrimaryOrMessagingNode() {
        MessagingPlatformConfiguration a2;
        return a2.forceConnectionToPrimaryOrMessagingNode;
    }

    public AccessControlConfiguration getAccesscontrol() {
        MessagingPlatformConfiguration a2;
        return a2.accesscontrol;
    }

    public String getPidFileLocation() {
        MessagingPlatformConfiguration a2;
        return a2.pidFileLocation;
    }

    public long getKeepAliveTime() {
        MessagingPlatformConfiguration a2;
        return a2.keepAliveTime.toMillis();
    }

    public String getInternalHostname() {
        MessagingPlatformConfiguration a2;
        if (StringUtils.isEmpty((String)a2.internalHostname)) {
            a2.internalHostname = a2.getHostname();
        }
        return a2.internalHostname;
    }

    private /* synthetic */ void f() {
        MessagingPlatformConfiguration a2;
        if (a2.datasourceUrl != null && !a2.datasourceUrl.contains(AppendOnlyList.b((Object)"\u001cXCX\u001c")) && !a2.datasourceUrl.contains(ReplicationRestControllerV2.b((Object)"\u0019M\u0017[\u000bP\nC\u001dGUV\u0017[\u001e\\\u001fQ\u001a"))) {
            throw new FailedToStartException(AppendOnlyList.b((Object)"r]C\u0015BTRTDTUP\u0006[GXC\u0015@ZT\u0015gMI[\u0006fCGPPT\u0015K@UA\u0006WC\u0015\u0001T^ZHFCGPPT\u0018EZHSORBW\u0001\u001b\u0006|@\u0015_ZS\u0015GGC\u0015K\\AGGAO[A\u0015@GIX\u0006TH\u0015IYBPT\u0015PPTFOZH\u0015C[U@TP\u0006ANTR\u0015R]C\u0015eZHATZJ\u0015bw\u0006\\U\u0015O[\u0006\u0012GMI[UPTCCG\u000bVI[RGIYBW\u0001\u0015G[B\u0015SEBTRP\u0006ANP\u0006FVGO[A\u001bBTRTUZSGEP\b@TY\u0006ETZVPTA_\u0015RZ\u0006@UP\u0006QGAGWGFC\u0015HTKP\u0006\u0012GMI[UPTCCG\u000bVI[@\\AQD\u0012\b"));
        }
    }

    public String getPluginPackageDirectory() {
        MessagingPlatformConfiguration a2;
        return a2.pluginPackageDirectory;
    }

    public String getControldbBackupLocation() {
        MessagingPlatformConfiguration a2;
        return a2.controldbBackupLocation;
    }

    public void setSetWebSocketAllowedOrigins(boolean bl) {
        boolean a2 = bl;
        MessagingPlatformConfiguration a3 = this;
        a3.setWebSocketAllowedOrigins = a2;
    }

    public int getExecutorThreadCount() {
        MessagingPlatformConfiguration a2;
        return a2.executorThreadCount;
    }

    public int getClusterExecutorThreadCount() {
        MessagingPlatformConfiguration a2;
        return a2.clusterExecutorThreadCount;
    }

    public void setKeepAliveTimeout(Duration duration) {
        Object a2 = duration;
        MessagingPlatformConfiguration a3 = this;
        a3.keepAliveTimeout = a2;
    }

    public String getFullyQualifiedInternalHostname() {
        MessagingPlatformConfiguration messagingPlatformConfiguration = this;
        Object a2 = messagingPlatformConfiguration.getInternalDomain();
        if (!StringUtils.isEmpty((String)a2)) {
            return messagingPlatformConfiguration.getInternalHostname() + "." + (String)a2;
        }
        return messagingPlatformConfiguration.getInternalHostname();
    }

    public void setInternalHostname(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.internalHostname = a2;
    }

    public void setMinKeepAliveTime(Duration duration) {
        Object a2 = duration;
        MessagingPlatformConfiguration a3 = this;
        a3.minKeepAliveTime = a2;
    }

    public String getDomain() {
        MessagingPlatformConfiguration messagingPlatformConfiguration = this;
        if (messagingPlatformConfiguration.domain == null) {
            block4: {
                String a2 = messagingPlatformConfiguration.systemInfoProvider.getHostName();
                int n = a2.indexOf(46);
                if (n == -1) break block4;
                messagingPlatformConfiguration.domain = a2.substring(n + 1);
            }
            try {
                messagingPlatformConfiguration.domain = "";
            }
            catch (UnknownHostException a2) {
                logger.warn(AppendOnlyList.b((Object)"vI@JQ\u0006[IA\u0006QCACGK\\HP\u0006]IFR[GXC\u0015@GIX\u0006\\HPR\u0015GQBGCFU\u000f\u0006N["), (Object)a2.getMessage());
            }
        }
        return messagingPlatformConfiguration.domain;
    }

    public int getGrpcBufferedMessages() {
        MessagingPlatformConfiguration a2;
        return a2.grpcBufferedMessages;
    }

    public long getMinKeepAliveTime() {
        MessagingPlatformConfiguration a2;
        return a2.minKeepAliveTime.toMillis();
    }

    public Map<String, Boolean> getPreview() {
        MessagingPlatformConfiguration a2;
        return a2.preview;
    }

    public void setInternalDomain(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.internalDomain = a2;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void b(String string, String string2, boolean bl, BiConsumer<String, String> biConsumer) {
        void a2;
        boolean a3 = bl;
        MessagingPlatformConfiguration a4 = this;
        String string3 = a3 = a3 ? AppendOnlyList.b((Object)"O[RPT[GY\u0006") : "";
        if (StringUtils.isEmpty((String)a2)) {
            logger.error(ReplicationRestControllerV2.b((Object)";Z\rY\u001c\u0015\u0016Z\f\u0015\u001cP\fP\nX\u0011[\u001d\u0015\u0019\u0015\u000eT\u0014\\\u001c\u0015\u0003H\u0010Z\u000bA\u0016T\u0015PV"), (Object)a3);
            throw new MessagingPlatformException(ErrorCode.VALIDATION_FAILED, "No " + a3 + "hostname set and system could not provide one.");
        }
        if (Character.isDigit(a2.charAt(0))) {
            logger.warn(AppendOnlyList.b((Object)"aNP\u0006N[]IFR[GXC\u0015NTU\u0015DPC[\u0006FCA\u0006TU\u0015G[\u0006|v\u0015GQBGCFU\u001b\u0006aN\\U\u0015KT_\u0015VGIQSVC\u0015S[QTHACQ\u0006GCFSYRF\b"), (Object)a3);
            return;
        }
        int n = a2.indexOf(46);
        if (n != -1) {
            void a5;
            void a6;
            void v1 = a2;
            String string4 = v1.substring(0, n);
            String string5 = v1.substring(n + 1);
            if (StringUtils.isEmpty((String)a6)) {
                Object[] objectArray = new Object[3];
                objectArray[0] = a3;
                objectArray[1] = string4;
                objectArray[2] = string5;
                logger.info(ReplicationRestControllerV2.b((Object)";Z\u0016S\u0011R\rG\u0011[\u001f\u0015\u001cZ\u0015T\u0011[XS\nZ\u0015\u0015\u0003H\u0010Z\u000bA\u0016T\u0015PXE\nZ\bP\nA\u0001\u000fX]\u0017F\f[\u0019X\u001d\b\u0003HT\u0015\u001cZ\u0015T\u0011[EN\u0005"), objectArray);
                a5.accept(string4, string5);
                return;
            }
            Object[] objectArray = new Object[4];
            objectArray[0] = a3;
            objectArray[1] = a2;
            objectArray[2] = string4;
            objectArray[3] = a6;
            logger.warn(AppendOnlyList.b((Object)"oRHZT\\HR\u0006QIXG\\H\u0015VTTA\u0006Z@\u0015R]C\u0015]HNZUAHTKP\u0006\u0012]H\u0001\u000f\u0006]IFR[GXC\b]H\n\u0015BZKTO[\u001bN["), objectArray);
            a5.accept(string4, a6);
        }
    }

    public String getFullyQualifiedHostname() {
        MessagingPlatformConfiguration messagingPlatformConfiguration = this;
        Object a2 = messagingPlatformConfiguration.getDomain();
        if (!StringUtils.isEmpty((String)a2)) {
            return messagingPlatformConfiguration.getHostname() + "." + (String)a2;
        }
        return messagingPlatformConfiguration.getHostname();
    }

    private /* synthetic */ void b() {
        MessagingPlatformConfiguration a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration = a2;
        messagingPlatformConfiguration.b(a2.getHostname(), messagingPlatformConfiguration.getDomain(), false, (string, string2) -> {
            void a2;
            MessagingPlatformConfiguration a3;
            Object a4 = string2;
            MessagingPlatformConfiguration messagingPlatformConfiguration = a3 = this;
            messagingPlatformConfiguration.setHostname((String)a2);
            messagingPlatformConfiguration.setDomain((String)a4);
        });
        MessagingPlatformConfiguration messagingPlatformConfiguration2 = a2;
        messagingPlatformConfiguration2.b(a2.getInternalHostname(), messagingPlatformConfiguration2.getInternalDomain(), true, (string, string2) -> {
            void a2;
            MessagingPlatformConfiguration a3;
            Object a4 = string2;
            MessagingPlatformConfiguration messagingPlatformConfiguration = a3 = this;
            messagingPlatformConfiguration.setInternalHostname((String)a2);
            messagingPlatformConfiguration.setInternalDomain((String)a4);
        });
    }

    public void setPort(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.port = a2;
    }

    public SslConfiguration getSsl() {
        MessagingPlatformConfiguration a2;
        return a2.ssl;
    }

    public boolean isSetWebSocketAllowedOrigins() {
        MessagingPlatformConfiguration a2;
        return a2.setWebSocketAllowedOrigins;
    }

    public void setPluginsEnabled(boolean bl) {
        boolean a2 = bl;
        MessagingPlatformConfiguration a3 = this;
        a3.pluginsEnabled = a2;
    }

    public String getInternalDomain() {
        MessagingPlatformConfiguration a2;
        if (a2.internalDomain == null) {
            a2.internalDomain = a2.getDomain();
        }
        return a2.internalDomain;
    }

    public void setPluginPackageDirectory(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.pluginPackageDirectory = a2;
    }

    public void setWebSocketAllowedOrigins(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.webSocketAllowedOrigins = a2;
    }

    public void setPluginCleanPolicy(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.pluginCleanPolicy = a2;
    }

    public boolean isPluginsEnabled() {
        MessagingPlatformConfiguration a2;
        return a2.pluginsEnabled;
    }

    public void setControldbBackupLocation(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.controldbBackupLocation = a2;
    }
}

