/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.component.tags.ClientTagsCache;
import io.axoniq.axonserver.enterprise.cluster.NodeSelector;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.cluster.internal.ReadyForConnections;
import io.axoniq.axonserver.grpc.PlatformService;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.util.TimeLimitedCache;
import java.util.Map;
import java.util.NavigableSet;
import java.util.concurrent.ConcurrentSkipListSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class AutoRebalancing {
    private final PlatformService K;
    private final ClientTagsCache F;
    private final boolean c;
    private final Logger I;
    private final NodeSelector j;
    private final NavigableSet<PlatformService.ClientComponent> G;

    @EventListener
    public void on(TopologyEvents.ApplicationDisconnected applicationDisconnected) {
        AutoRebalancing a2;
        AutoRebalancing a3 = applicationDisconnected;
        AutoRebalancing autoRebalancing = a2 = this;
        autoRebalancing.I.debug(MeterFactory.b((Object)"\u000001,(# 4(//`\u0005)2#../%\"4$${`:="), (Object)a3.I());
        a3 = new PlatformService.ClientComponent(a3.I(), a3.j(), a3.A(), a3.b());
        autoRebalancing.G.remove(a3);
        a2.I.debug(TimeLimitedCache.b((Object)"bE\\YPA\\^A\u0017\u0015VH"), (Object)a2.G);
    }

    @Scheduled(fixedRateString="${axoniq.axonserver.cluster.balancing-rate:15000}")
    protected void b() {
        boolean bl;
        AutoRebalancing autoRebalancing = this;
        if (!autoRebalancing.c) {
            return;
        }
        autoRebalancing.I.debug(MeterFactory.b((Object)"\u0012$\" , .\"%{`:="), (Object)autoRebalancing.G);
        boolean bl2 = false;
        do {
            AutoRebalancing a2;
            if ((a2 = (PlatformService.ClientComponent)autoRebalancing.G.pollFirst()) != null && autoRebalancing.j.canRebalance(a2.getClientId(), a2.getComponent(), a2.getContext(), autoRebalancing.b(a2.getContext(), a2.getClientStreamId()))) {
                bl = bl2;
                autoRebalancing.b((PlatformService.ClientComponent)a2);
                continue;
            }
            bl = bl2 = a2 != null;
        } while (bl);
    }

    /*
     * WARNING - void declaration
     */
    public AutoRebalancing(PlatformService platformService, ClientTagsCache clientTagsCache, NodeSelector nodeSelector, @Value(value="${axoniq.axonserver.cluster.auto-balancing:true}") boolean bl) {
        void nodeSelector2;
        void clientsTags;
        void platformService2;
        AutoRebalancing a2;
        boolean bl2 = bl;
        AutoRebalancing autoRebalancing = a2 = this;
        AutoRebalancing autoRebalancing2 = a2;
        a2.I = LoggerFactory.getLogger(AutoRebalancing.class);
        AutoRebalancing autoRebalancing3 = a2;
        a2.G = new ConcurrentSkipListSet();
        autoRebalancing2.K = platformService2;
        autoRebalancing2.F = clientsTags;
        autoRebalancing.j = nodeSelector2;
        autoRebalancing.c = this;
    }

    private /* synthetic */ Map<String, String> b(String string, String string2) {
        Object a2 = string2;
        AutoRebalancing a3 = this;
        return a3.F.apply((String)a2);
    }

    @EventListener
    public void on(ReadyForConnections readyForConnections) {
        AutoRebalancing a2 = readyForConnections;
        AutoRebalancing a3 = this;
        if (a2.ready()) {
            AutoRebalancing autoRebalancing = a3;
            autoRebalancing.G.clear();
            autoRebalancing.G.addAll(a3.K.getConnectedClients());
        }
    }

    @EventListener
    public void on(ClusterEvents.AxonServerNodeHealthChanged axonServerNodeHealthChanged) {
        AutoRebalancing a2;
        AutoRebalancing a3 = axonServerNodeHealthChanged;
        AutoRebalancing autoRebalancing = a2 = this;
        autoRebalancing.I.debug(TimeLimitedCache.b((Object)"\u007fPNPDCHQ\r]HTAAE\u0015N]L[JPI\u0015KZ_\u0015VH"), (Object)a3.getNode());
        autoRebalancing.G.clear();
        autoRebalancing.G.addAll(a2.K.getConnectedClients());
    }

    private /* synthetic */ void b(PlatformService.ClientComponent clientComponent) {
        AutoRebalancing a2;
        AutoRebalancing a3 = clientComponent;
        AutoRebalancing autoRebalancing = a2 = this;
        autoRebalancing.I.info(TimeLimitedCache.b((Object)"gHDXP^AD[J\u0015_PNZC[HVY\u0015KZ_\u0015VH"), (Object)a3.getClientStreamId());
        autoRebalancing.K.requestReconnect((PlatformService.ClientComponent)a3, MeterFactory.b((Object)"2$#../%\"4a2$14%24$$a\"8` 55/a\" , .\")/'"));
    }
}

