/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster;

import io.axoniq.axonserver.ClusterTagsCache;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.admin.AdminConfigurationFactory;
import io.axoniq.axonserver.configuration.admin.AdminNodes;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.cluster.CurrentNodeProvider;
import io.axoniq.axonserver.enterprise.cluster.NodeAddress;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteConnection;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteConnections;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.licensing.Limits;
import io.axoniq.axonserver.localstorage.transaction.PreparedTransaction;
import io.axoniq.axonserver.message.command.CommandRegistrationCache;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;

@Controller
public class ClusterController
implements SmartLifecycle {
    private volatile boolean B;
    private final CurrentNodeProvider g;
    private final ClusterTagsCache C;
    private final Limits H;
    private final MessagingPlatformConfiguration K;
    private final Logger F;
    private final ApplicationEventPublisher c;
    private final RemoteConnections I;
    private final AdminNodes j;
    private final AdminConfigurationFactory G;

    private /* synthetic */ void b(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        if (a3.I.contains((String)a2) || a3.K.getName().equals(a2)) {
            return;
        }
        a3.H.getMaxClusterSize().ifPresent(arg_0 -> a3.b((String)a2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void b(String string, Integer n) {
        Integer a2 = n;
        ClusterController a3 = this;
        if (a3.I.size() + 1 >= a2) {
            void a4;
            throw new MessagingPlatformException(ErrorCode.MAX_CLUSTER_SIZE_REACHED, "Maximum allowed number of nodes reached " + (String)a4);
        }
    }

    public synchronized void handleRemoteConnection(NodeInfo nodeInfo) {
        ClusterController a2;
        ClusterController a3 = nodeInfo;
        ClusterController clusterController = a2 = this;
        clusterController.b((NodeInfo)a3);
        clusterController.I.updateNodeInfo((NodeInfo)a3);
        clusterController.c.publishEvent((Object)new ClusterEvents.AxonServerNodeConnected((NodeInfo)a3));
    }

    public int getPhase() {
        return 50;
    }

    @Transactional
    public synchronized void deleteNode(String string) {
        ClusterController clusterController;
        ClusterController a2;
        Object a3 = string;
        ClusterController clusterController2 = a2 = this;
        clusterController2.F.info(CommandRegistrationCache.b((Object)"BOjOrO&DiNc\u0010&Q{"), a3);
        clusterController2.c.publishEvent((Object)new ClusterEvents.AxonServerNodeDeletionRequested((String)a3));
        if (clusterController2.K.getName().equals(a3)) {
            ClusterController clusterController3 = a2;
            clusterController = clusterController3;
            clusterController3.j.deleteAllByNameNot((String)a3);
            clusterController3.I.closeAll();
        } else {
            a2.j.findById((String)a3).ifPresent(arg_0 -> a2.b((String)a3, arg_0));
            clusterController = a2;
        }
        clusterController.c.publishEvent((Object)new ClusterEvents.AxonServerNodeDeleted((String)a3));
        a2.I.sync();
    }

    private /* synthetic */ void b(String string, ClusterNode clusterNode) {
        Object a2 = string;
        ClusterController a3 = this;
        a3.j.deleteById((String)a2);
    }

    public boolean isActive(String string) {
        String a2 = string;
        ClusterController a3 = this;
        if (a2.equals(a3.K.getName()) || a3.I.get(a2) != null && a3.I.get(a2).isConnected()) {
            return true;
        }
        return false;
    }

    public boolean isAdminNode() {
        ClusterController a2;
        return a2.g.isAdmin();
    }

    public ClusterNode getMe() {
        ClusterController a2;
        ClusterController clusterController = a2;
        return clusterController.b((ClusterNode)clusterController.g.get());
    }

    @Transactional
    public synchronized ClusterNode addConnection(NodeInfo nodeInfo) {
        ClusterController a2 = nodeInfo;
        ClusterController a3 = this;
        ClusterController clusterController = a2;
        a3.b(clusterController.getNodeName());
        if (clusterController.getNodeName().equals(a3.K.getName())) {
            ClusterController clusterController2 = a3;
            clusterController2.F.info(PreparedTransaction.b((Object)"axLc[m\u0015~Z*_e\\d\u0015}\\~]*V\u007fGxPdA*[eQo\u0015dTgP0\u0015qH"), (Object)a2.getNodeName());
            return clusterController2.getMe();
        }
        if (a2.getInternalHostName().equals(a3.K.getInternalHostname()) && a2.getGrpcInternalPort() == a3.K.getInternalPort()) {
            throw new MessagingPlatformException(ErrorCode.SAME_NODE_NAME, CommandRegistrationCache.b((Object)"igDhEr\nlEoD&Ij_u^cX&]o^n\nuKkO&BiYrDgGc\ngDb\noDrOtDgF&ZiXr"));
        }
        ClusterNode clusterNode = a3.j.findById(a2.getNodeName()).orElseGet(() -> a3.b((NodeInfo)a2));
        if (!a3.I.contains(a2.getNodeName())) {
            a3.b((NodeInfo)a2);
        }
        return clusterNode;
    }

    public Set<String> remoteNodeNames() {
        ClusterController a2;
        return a2.I.nodes();
    }

    public Collection<RemoteConnection> getRemoteConnections() {
        ClusterController a2;
        return a2.I.connections();
    }

    private /* synthetic */ void b() {
        Object a2;
        ClusterController clusterController;
        ClusterController clusterController2 = clusterController = this;
        Object object = clusterController2.j.findById(clusterController2.K.getName());
        if (((Optional)object).isEmpty()) {
            if (clusterController.j.findAll().findAny().isPresent()) {
                Object[] objectArray = new Object[1];
                objectArray[0] = clusterController.K.getName();
                a2 = String.format(PreparedTransaction.b((Object)"I@xGo[~\u0015dZnP*[kXo\u0015bTy\u0015i]k[mPn\u0019*[oB*[kXo\u0015/F$\u0015YAkG~\u0015KMe[YPxCoG*BcAb\u0015xPiZ|PxL*ScYo\u001b"), objectArray);
                throw new FailedToStartException((String)a2);
            }
            ClusterController clusterController3 = clusterController;
            a2 = clusterController3.G.clusterNode(clusterController3.K.getName(), clusterController.K.getFullyQualifiedHostname(), clusterController.K.getFullyQualifiedInternalHostname(), clusterController.K.getPort(), clusterController.K.getInternalPort(), clusterController.K.getHttpPort());
            clusterController3.j.save((ClusterNode)a2);
            return;
        }
        a2 = (ClusterNode)((Optional)object).get();
        if (!a2.getInternalHostName().equals(clusterController.K.getFullyQualifiedInternalHostname()) || !a2.getGrpcInternalPort().equals(clusterController.K.getInternalPort())) {
            Object[] objectArray = new Object[4];
            objectArray[0] = a2.getInternalHostName();
            objectArray[1] = a2.getGrpcInternalPort();
            objectArray[2] = clusterController.K.getFullyQualifiedInternalHostname();
            objectArray[3] = clusterController.K.getInternalPort();
            object = String.format(CommandRegistrationCache.b((Object)"isXtOh^&DiNc\ru\noDrOtDgF&BiYrDgGc\u0005vEt^&\u0002#Y<\u000fb\u0003&BgY&InKhMcN*\n&Dc]&\\gFsOu\n#Y<\u000fb\u0004&yrKt^&k~EhycXpOt\nqCrB&XcIi\\cX\u007f\n`CjO("), objectArray);
            throw new FailedToStartException((String)object);
        }
    }

    private /* synthetic */ void b(NodeInfo nodeInfo) {
        ClusterController a2 = nodeInfo;
        ClusterController a3 = this;
        if (a2.getNodeName().equals(a3.K.getName())) {
            return;
        }
        a3.I.connect((NodeInfo)a2, true);
    }

    public void closeConnection(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        a3.I.disconnect((String)a2);
    }

    public ClusterNode getNode(String string) {
        Object a2 = string;
        Object a3 = this;
        if (((String)a2).equals(a3.getName())) {
            return a3.getMe();
        }
        a2 = a3.j.findById((String)a2).orElseGet(() -> ((ClusterController)a3).b((String)a2));
        return a3.b((ClusterNode)a2);
    }

    public void deleteOtherNodes() {
        ClusterController a2;
        ClusterController clusterController = a2;
        a2.j.deleteAllByNameNot(clusterController.getName());
        clusterController.I.sync();
    }

    Stream<RemoteConnection> activeConnections() {
        ClusterController a2;
        return a2.I.activeConnections();
    }

    public boolean isRunning() {
        ClusterController a2;
        return a2.B;
    }

    /*
     * WARNING - void declaration
     */
    public NodeAddress nodeAddress(String string) {
        ClusterController a2;
        void a3;
        ClusterController clusterController = this;
        if (a3.equals(clusterController.getName())) {
            return new NodeAddress(clusterController.getMe());
        }
        RemoteConnection remoteConnection = clusterController.I.get((String)a3);
        ClusterNode clusterNode = a2 = remoteConnection == null ? (ClusterNode)clusterController.j.findById((String)a3).orElse(null) : remoteConnection.getClusterNode();
        if (a2 == null) {
            return null;
        }
        return new NodeAddress((ClusterNode)a2);
    }

    @Transactional
    public void start() {
        ClusterController a2;
        a2.b();
        a2.B = true;
    }

    public void publishEvent(Object object) {
        Object a2 = object;
        ClusterController a3 = this;
        a3.c.publishEvent(a2);
    }

    private /* synthetic */ ClusterNode b(NodeInfo nodeInfo) {
        ClusterController a2;
        ClusterController a3 = nodeInfo;
        ClusterController clusterController = a2 = this;
        clusterController.F.info(PreparedTransaction.b((Object)"tnQ*[eQo\u0015qH"), (Object)a3);
        a3 = clusterController.G.clusterNode((NodeInfo)a3);
        return clusterController.j.save((ClusterNode)a3);
    }

    public Optional<RemoteConnection> getRemoteConnection(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        return Optional.ofNullable(a3.I.get((String)a2));
    }

    public Stream<ClusterNode> activeNodes() {
        ClusterController a2;
        return a2.nodes().filter(clusterNode -> {
            ClusterController a2 = clusterNode;
            ClusterController a3 = this;
            return a3.isActive(a2.getName());
        });
    }

    private /* synthetic */ ClusterNode b(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        if ((a2 = a3.I.get((String)a2)) == null) {
            return null;
        }
        return a2.getClusterNode();
    }

    /*
     * WARNING - void declaration
     */
    public ClusterController(MessagingPlatformConfiguration messagingPlatformConfiguration, AdminNodes adminNodes, AdminConfigurationFactory adminConfigurationFactory, ClusterTagsCache clusterTagsCache, @Qualifier(value="localEventPublisher") ApplicationEventPublisher applicationEventPublisher, Limits limits, RemoteConnections remoteConnections, CurrentNodeProvider currentNodeProvider) {
        void remoteConnections2;
        void limits2;
        void applicationEventPublisher2;
        void clusterTagsCache2;
        void adminConfigurationFactory2;
        void clusterNodeRepository;
        void messagingPlatformConfiguration2;
        ClusterController a2;
        ClusterController clusterController = clusterController2;
        ClusterController clusterController2 = currentNodeProvider;
        ClusterController clusterController3 = a2 = clusterController;
        ClusterController clusterController4 = a2;
        ClusterController clusterController5 = a2;
        ClusterController clusterController6 = a2;
        a2.F = LoggerFactory.getLogger(ClusterController.class);
        clusterController6.K = messagingPlatformConfiguration2;
        clusterController6.j = clusterNodeRepository;
        clusterController5.G = adminConfigurationFactory2;
        clusterController5.C = clusterTagsCache2;
        clusterController4.c = applicationEventPublisher2;
        clusterController4.H = limits2;
        clusterController3.I = remoteConnections2;
        clusterController3.g = clusterController2;
    }

    public void stop() {
        a.B = false;
    }

    public Stream<ClusterNode> nodes() {
        ClusterController a2;
        return a2.j.findAll().peek(clusterNode -> {
            ClusterController a2 = clusterNode;
            ClusterController a3 = this;
            if (a2 == null) {
                return null;
            }
            a2.setTags(a3.C.getClusterTags().getOrDefault(a2.getName(), Collections.emptyMap()));
            return a2;
        });
    }

    public String getName() {
        ClusterController a2;
        return a2.getMe().getName();
    }
}

