/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster.internal;

import io.axoniq.axonserver.cluster.grpc.LeaderElectionService;
import io.axoniq.axonserver.cluster.grpc.LogReplicationService;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.enterprise.cluster.internal.InternalAuthenticationInterceptor;
import io.axoniq.axonserver.enterprise.cluster.internal.ReplicationServerStarted;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.grpc.AxonServerInternalService;
import io.axoniq.axonserver.grpc.ContextInterceptor;
import io.axoniq.axonserver.grpc.GrpcBufferingInterceptor;
import io.axoniq.axonserver.grpc.SerializedTransactionWithTokenConverter;
import io.axoniq.axonserver.message.query.subscription.metric.GlobalSubscriptionMetricRegistry;
import io.axoniq.axonserver.util.DaemonThreadFactory;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerCredentials;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.TlsServerCredentials;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.Epoll;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollServerSocketChannel;
import io.grpc.netty.shaded.io.netty.channel.nio.NioEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import io.grpc.util.AdvancedTlsX509KeyManager;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.unit.DataSize;

@Component(value="MessagingClusterServer")
public class MessagingClusterServer
implements SmartLifecycle {
    private final LogReplicationService L;
    private boolean m;
    private AdvancedTlsX509KeyManager.Closeable B;
    private final List<AxonServerInternalService> g;
    private final ApplicationEventPublisher C;
    private final LeaderElectionService H;
    private final Logger K;
    private final ExecutorService F;
    private Server c;
    private final MessagingPlatformConfiguration I;
    private static final DataSize j = DataSize.ofMegabytes((long)32L);
    private final Supplier<ScheduledExecutorService> G;

    public int getPhase() {
        return 50;
    }

    public void stop() {
        MessagingClusterServer messagingClusterServer = this;
        if (messagingClusterServer.B != null) {
            messagingClusterServer.B.close();
        }
        messagingClusterServer.F.shutdown();
        try {
            if (!messagingClusterServer.c.shutdown().awaitTermination(1L, TimeUnit.SECONDS)) {
                MessagingClusterServer messagingClusterServer2 = messagingClusterServer;
                messagingClusterServer2.K.debug(SerializedTransactionWithTokenConverter.b((Object)">\"\n.\u001d+\r!\u00144X>\f\"\b=\u0011#\u001fm;!\r>\f(\nm+(\n;\u001d?"));
                messagingClusterServer2.c.shutdownNow();
            }
        }
        catch (InterruptedException a2) {
            messagingClusterServer.K.debug(GlobalSubscriptionMetricRegistry.b((Object)"rfOmIzNxOm_(_}IaUo\u001b{S}OlT\u007fU(Tn\u001baU|^zUiW(zpTfhmI~^z"), (Throwable)a2);
            Thread.currentThread().interrupt();
        }
        messagingClusterServer.m = false;
        messagingClusterServer.K.info(SerializedTransactionWithTokenConverter.b((Object)"95\u0017#X\u001e\u001d?\u000e(\nm;!\r>\f(\nm+(\n;\u001d?X>\f\"\b=\u001d)"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        MessagingClusterServer messagingClusterServer = this;
        try {
            NettyServerBuilder nettyServerBuilder;
            MessagingClusterServer a2;
            String string = GlobalSubscriptionMetricRegistry.b((Object)"Ug\u001b[hD");
            if (messagingClusterServer.I.getSsl() != null && messagingClusterServer.I.getSsl().isEnabled()) {
                Object object = messagingClusterServer.I.getSsl().getInternalCertChainFile();
                if (object == null) {
                    throw new RuntimeException(SerializedTransactionWithTokenConverter.b((Object)",\u0000\"\u0016$\tc\u00195\u0017#\u000b(\n;\u001d?V>\u000b!V.\u001d?\f`\u001b%\u0019$\u0016`\u001e$\u0014(X#\u00179X>\u001d9"));
                }
                Object object2 = messagingClusterServer.I.getSsl().getInternalPrivateKeyFile();
                if (object2 == null) {
                    throw new RuntimeException(GlobalSubscriptionMetricRegistry.b((Object)"ZpTfRy\u0015iCgU{^zMmI&H{W&KzR~Z|^%PmB%]aWm\u001bfT|\u001b{^|"));
                }
                object2 = new File((String)object2);
                object = new File((String)object);
                if (!((File)object2).canRead()) {
                    throw new RuntimeException("Cannot access " + ((File)object2).getCanonicalPath());
                }
                if (!((File)object).canRead()) {
                    throw new RuntimeException("Cannot access " + ((File)object).getCanonicalPath());
                }
                AdvancedTlsX509KeyManager advancedTlsX509KeyManager = new AdvancedTlsX509KeyManager();
                messagingClusterServer.B = advancedTlsX509KeyManager.updateIdentityCredentialsFromFile((File)object2, (File)object, 1L, TimeUnit.MINUTES, (ScheduledExecutorService)messagingClusterServer.G.get());
                KeyManager[] keyManagerArray = new KeyManager[1];
                keyManagerArray[0] = advancedTlsX509KeyManager;
                object = TlsServerCredentials.newBuilder().keyManager(keyManagerArray).clientAuth(TlsServerCredentials.ClientAuth.NONE).build();
                a2 = NettyServerBuilder.forPort((int)messagingClusterServer.I.getInternalPort(), (ServerCredentials)object);
                string = SerializedTransactionWithTokenConverter.b((Object)"\u001e+\u0001X(\u0016,\u001a!\u001d)");
                nettyServerBuilder = a2;
            } else {
                a2 = NettyServerBuilder.forPort((int)messagingClusterServer.I.getInternalPort());
                nettyServerBuilder = a2;
            }
            nettyServerBuilder.permitKeepAliveTime(messagingClusterServer.I.getMinKeepAliveTime(), TimeUnit.MILLISECONDS).permitKeepAliveWithoutCalls(true);
            a2.maxInboundMessageSize((int)Math.max(j.toBytes(), Math.min(Integer.MAX_VALUE, (long)messagingClusterServer.I.getMaxMessageSize() + DataSize.ofMegabytes((long)1L).toBytes())));
            a2.intercept((ServerInterceptor)new InternalAuthenticationInterceptor(messagingClusterServer.I));
            messagingClusterServer.g.forEach(arg_0 -> MessagingClusterServer.b((NettyServerBuilder)a2, arg_0));
            MessagingClusterServer messagingClusterServer2 = messagingClusterServer;
            a2.addService((BindableService)messagingClusterServer.H);
            a2.addService((BindableService)messagingClusterServer2.L);
            if (messagingClusterServer2.I.getKeepAliveTime() > 0L) {
                a2.keepAliveTime(messagingClusterServer.I.getKeepAliveTime(), TimeUnit.MILLISECONDS);
                a2.keepAliveTimeout(messagingClusterServer.I.getKeepAliveTimeout(), TimeUnit.MILLISECONDS);
            }
            a2.intercept((ServerInterceptor)new GrpcBufferingInterceptor(messagingClusterServer.I.getGrpcBufferedMessages()));
            a2.executor((Executor)messagingClusterServer.F);
            if (Epoll.isAvailable()) {
                v3 = messagingClusterServer;
                a2.bossEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(1, (ThreadFactory)new DaemonThreadFactory(GlobalSubscriptionMetricRegistry.b((Object)"kW}H|^z\u0016jT{H%"))));
                a2.workerEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(0, (ThreadFactory)new DaemonThreadFactory(SerializedTransactionWithTokenConverter.b((Object)".\u00148\u000b9\u001d?U:\u0017?\u0013(\n`"))));
                a2.channelType(EpollServerSocketChannel.class);
            } else {
                a2.bossEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(1, (ThreadFactory)new DaemonThreadFactory(GlobalSubscriptionMetricRegistry.b((Object)"kW}H|^z\u0016jT{H%"))));
                a2.workerEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(0, (ThreadFactory)new DaemonThreadFactory(SerializedTransactionWithTokenConverter.b((Object)".\u00148\u000b9\u001d?U:\u0017?\u0013(\n`"))));
                a2.channelType(NioServerSocketChannel.class);
                v3 = messagingClusterServer;
            }
            v3.c = a2.build();
            messagingClusterServer.c.start();
            messagingClusterServer.K.info(GlobalSubscriptionMetricRegistry.b((Object)"ICgU(hmI~^z\u001bKW}H|^z\u001b[^zMmI(H|ZzOm_(Tf\u001bxTzO2\u001bsF(\u0016(@u"), (Object)messagingClusterServer.I.getInternalPort(), (Object)string);
            messagingClusterServer.C.publishEvent((Object)new ReplicationServerStarted());
            messagingClusterServer.m = true;
            return;
        }
        catch (Exception a2) {
            throw new FailedToStartException(SerializedTransactionWithTokenConverter.b((Object)"\u001e\f,\n9\u0011#\u001fm95\u0017#X\u001e\u001d?\u000e(\nm;!\r>\f(\nm+(\n;\u001d?X+\u0019$\u0014(\u001cm"), (Throwable)a2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void b(NettyServerBuilder nettyServerBuilder, AxonServerInternalService axonServerInternalService) {
        void a2;
        NettyServerBuilder nettyServerBuilder2 = nettyServerBuilder;
        LinkedList a3 = new LinkedList(a2.interceptors());
        if (a2.requiresContextInterceptor()) {
            a3.add(new ContextInterceptor());
        }
        nettyServerBuilder2.addService(ServerInterceptors.intercept((BindableService)a2, (List)a3));
    }

    /*
     * WARNING - void declaration
     */
    public MessagingClusterServer(MessagingPlatformConfiguration messagingPlatformConfiguration, LogReplicationService logReplicationService, LeaderElectionService leaderElectionService, List<AxonServerInternalService> list, Supplier<ScheduledExecutorService> supplier, ApplicationEventPublisher applicationEventPublisher) {
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        MessagingClusterServer a7;
        MessagingClusterServer a8 = messagingPlatformConfiguration;
        MessagingClusterServer messagingClusterServer = a7 = this;
        MessagingClusterServer messagingClusterServer2 = a7;
        MessagingClusterServer messagingClusterServer3 = a7;
        MessagingClusterServer messagingClusterServer4 = a7;
        messagingClusterServer4.K = LoggerFactory.getLogger(MessagingClusterServer.class);
        messagingClusterServer4.I = a8;
        messagingClusterServer3.L = a6;
        messagingClusterServer3.H = a5;
        messagingClusterServer2.g = a4;
        messagingClusterServer2.G = a3;
        messagingClusterServer.C = a2;
        messagingClusterServer.F = Executors.newFixedThreadPool(a8.getClusterExecutorThreadCount(), (ThreadFactory)new CustomizableThreadFactory(GlobalSubscriptionMetricRegistry.b((Object)"kW}H|^z\u0016mCmX}OgI%")));
    }

    public boolean isAutoStartup() {
        return true;
    }

    public boolean isRunning() {
        MessagingClusterServer a2;
        return a2.m;
    }
}

