/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.replication;

import io.axoniq.axonserver.LifecycleController;
import io.axoniq.axonserver.cluster.RaftGroup;
import io.axoniq.axonserver.cluster.RaftNode;
import io.axoniq.axonserver.cluster.StateChanged;
import io.axoniq.axonserver.cluster.grpc.RaftGroupManager;
import io.axoniq.axonserver.config.FileSystemMonitor;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.config.RaftProperties;
import io.axoniq.axonserver.configuration.runtime.ReplicationGroupMember;
import io.axoniq.axonserver.enterprise.cluster.GrpcRaftGroupFactory;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.replication.GrpcRaftGroup;
import io.axoniq.axonserver.enterprise.replication.RaftGroupRepositoryManager;
import io.axoniq.axonserver.enterprise.replication.group.ReplicationGroupController;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.cluster.Node;
import io.axoniq.axonserver.grpc.cluster.Role;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.message.SubscriptionKey;
import io.axoniq.axonserver.plugin.PluginContextManager;
import io.axoniq.axonserver.util.StringUtils;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Controller;

@Controller
public class GrpcRaftController
implements SmartLifecycle,
RaftGroupManager {
    private final Map<String, RaftGroup> h;
    private final GrpcRaftGroupFactory b;
    private final RaftGroupRepositoryManager L;
    private final MessagingPlatformConfiguration m;
    private final RaftProperties B;
    private final FileSystemMonitor g;
    public static final String C = "replication-logs";
    private final Map<String, Long> H;
    private final ReplicationGroupController K;
    private final LifecycleController F;
    private final ApplicationEventPublisher c;
    private final Logger I;
    private final AtomicBoolean j;
    private volatile boolean G;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private /* synthetic */ RaftGroup b(String string, String string2) {
        Object a2 = string2;
        GrpcRaftController a3 = this;
        Map map = a3.h;
        synchronized (map) {
            void a4;
            block4: {
                GrpcRaftController grpcRaftController = a3;
                grpcRaftController.I.info(PluginContextManager.b((Object)"nc/>|p|j5lpnywv\u007fawzp5ygq`n"), (Object)a4);
                RaftGroup raftGroup = (RaftGroup)grpcRaftController.h.get(a4);
                if (raftGroup == null) break block4;
                return raftGroup;
            }
            a2 = a3.b.create((String)a4, (String)a2);
            a2.localNode().f(arg_0 -> a3.b((RaftGroup)a2, arg_0));
            a3.h.put(a4, a2);
            return a2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public RaftGroup initRaftGroup(String string, String string2, String string3) {
        void a2;
        Node a3;
        Object a4 = string2;
        GrpcRaftController a5 = this;
        a3 = Node.newBuilder().setNodeId((String)a4).setHost(a5.m.getFullyQualifiedInternalHostname()).setPort(a5.m.getInternalPort()).setNodeName((String)a3).setRole(Role.PRIMARY).build();
        GrpcRaftController grpcRaftController = a5;
        a4 = grpcRaftController.b((String)a2, (String)a4);
        a4.raftConfiguration().update(Collections.singletonList(a3));
        grpcRaftController.I.debug(SubscriptionKey.b((Object)"1'\u0003!\u0016s\u0004!\r>B:\f:\u0016\u0001\u00035\u0016\u0014\u0010<\u0017#B(\u001f"), (Object)a2);
        Object object = a4;
        object.startAndWait(Role.PRIMARY);
        return object;
    }

    public Collection<String> getRaftGroups() {
        GrpcRaftController a2;
        return a2.h.keySet();
    }

    public int electionTimeout() {
        GrpcRaftController a2;
        return a2.B.getMaxElectionTimeout();
    }

    public RaftNode getRaftNode(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        if (!a3.G) {
            throw new IllegalStateException(SubscriptionKey.b((Object)"\u001a\f:\u0016:\u0003?\u000b)\u0003'\u000b<\fs\r!B \n&\u00167\r$\fs\u000b=B#\u0010<\u0005!\u0007 \u0011"));
        }
        if (!a3.h.containsKey(a2)) {
            throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, a3.m.getName() + ": Not a member of " + (String)a2);
        }
        return ((RaftGroup)a3.h.get(a2)).localNode();
    }

    @Scheduled(fixedDelay=1000L)
    public void syncStore() {
        GrpcRaftController a2;
        if (a2.G) {
            a2.h.forEach((string, raftGroup) -> {
                String a2 = raftGroup;
                String a3 = string;
                ((GrpcRaftGroup)a2).b();
            });
        }
    }

    public String getMyName() {
        GrpcRaftController a2;
        return a2.m.getName();
    }

    private /* synthetic */ MessagingPlatformException b(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        return new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, a3.m.getName() + ": Not a member of " + (String)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void b(RaftGroup raftGroup, StateChanged stateChanged) {
        void a2;
        GrpcRaftController a3 = stateChanged;
        GrpcRaftController a4 = this;
        a4.b(a2.localNode(), (StateChanged)a3);
    }

    /*
     * WARNING - void declaration
     */
    public void prepareDeleteNodeFromReplicationGroup(String string, String string2) {
        void a2;
        GrpcRaftController a3;
        Object a4 = string2;
        GrpcRaftController grpcRaftController = a3 = this;
        grpcRaftController.L.prepareDeleteNodeFromReplicationGroup((String)a2, (String)a4);
        grpcRaftController.c.publishEvent((Object)new ClusterEvents.DeleteNodeFromReplicationGroupRequested((String)a2, (String)a4));
    }

    public Optional<RaftNode> raftNode(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        if ((a2 = (RaftGroup)a3.h.get(a2)) != null) {
            return Optional.of(a2.localNode());
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public RaftNode getOrCreateRaftNode(String string, String string2) {
        void a2;
        GrpcRaftController grpcRaftController = this;
        if (!grpcRaftController.G) {
            throw new IllegalStateException(SubscriptionKey.b((Object)"16\u0010%\u0007!B \u00162\u0010'\u0017#M \n&\u00167\r$\fs\u000b=B#\u0010<\u0005!\u0007 \u0011"));
        }
        GrpcRaftController a3 = (RaftGroup)grpcRaftController.h.get(a2);
        if (a3 != null) {
            return a3.localNode();
        }
        Map map = grpcRaftController.h;
        synchronized (map) {
            a3 = (RaftGroup)grpcRaftController.h.get(a2);
            if (a3 == null) {
                void a4;
                if (grpcRaftController.b((String)a2)) {
                    throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, PluginContextManager.b((Object)"G{er|}tj|q{>rlzke>q{y{awzp5w{>elzyg{fm"));
                }
                a3 = grpcRaftController.b((String)a2, (String)a4);
                a3.startAndWait(null);
            }
        }
        return a3.localNode();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void b(RaftNode raftNode, StateChanged stateChanged) {
        void a2;
        void a3;
        GrpcRaftController grpcRaftController = this;
        void v0 = a3;
        Object a4 = v0.f();
        long l = a2.f();
        if (v0.A() && !a3.K()) {
            grpcRaftController.c.publishEvent((Object)new ClusterEvents.LeaderStepDown((String)a4, l));
            return;
        }
        if (a3.K() && !a3.A()) {
            grpcRaftController.c.publishEvent((Object)new ClusterEvents.BecomeLeader((String)a4, () -> ((RaftNode)a2).b(), l));
            return;
        }
        if (a3.f()) {
            grpcRaftController.c.publishEvent((Object)new ClusterEvents.LeaderConfirmation((String)a4, null, l));
            return;
        }
        if (!StringUtils.isEmpty((String)a2.f())) {
            grpcRaftController.c.publishEvent((Object)new ClusterEvents.LeaderConfirmation((String)a4, a2.f(), l));
        }
    }

    /*
     * WARNING - void declaration
     */
    public GrpcRaftController(MessagingPlatformConfiguration messagingPlatformConfiguration, RaftProperties raftProperties, RaftGroupRepositoryManager raftGroupRepositoryManager, ApplicationEventPublisher applicationEventPublisher, ReplicationGroupController replicationGroupController, GrpcRaftGroupFactory grpcRaftGroupFactory, FileSystemMonitor fileSystemMonitor, LifecycleController lifecycleController) {
        GrpcRaftController a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        void a9;
        GrpcRaftController a10;
        GrpcRaftController grpcRaftController = grpcRaftController2;
        GrpcRaftController grpcRaftController2 = lifecycleController;
        GrpcRaftController grpcRaftController3 = a10 = grpcRaftController;
        GrpcRaftController grpcRaftController4 = a10;
        GrpcRaftController grpcRaftController5 = a10;
        GrpcRaftController grpcRaftController6 = a10;
        GrpcRaftController grpcRaftController7 = a10;
        a10.I = LoggerFactory.getLogger(GrpcRaftController.class);
        GrpcRaftController grpcRaftController8 = a10;
        grpcRaftController7.h = new ConcurrentHashMap();
        GrpcRaftController grpcRaftController9 = a10;
        grpcRaftController8.H = new ConcurrentHashMap();
        GrpcRaftController grpcRaftController10 = a10;
        grpcRaftController7.j = new AtomicBoolean();
        grpcRaftController6.m = a9;
        grpcRaftController6.L = a8;
        grpcRaftController5.K = a7;
        grpcRaftController5.B = a6;
        grpcRaftController4.c = a5;
        grpcRaftController4.b = a4;
        grpcRaftController3.g = a3;
        grpcRaftController3.F = a2;
    }

    public void stop() {
        GrpcRaftController a2;
        GrpcRaftController grpcRaftController = a2;
        grpcRaftController.g.unregisterPath(C);
        grpcRaftController.h.forEach((string, raftGroup) -> {
            String a2 = raftGroup;
            String a3 = string;
            a2.stop();
        });
        a2.G = false;
    }

    public int getPhase() {
        return 100;
    }

    private /* synthetic */ boolean b(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        if (a3.H.getOrDefault(a2, 0L) > System.currentTimeMillis()) {
            return true;
        }
        return false;
    }

    public boolean ready() {
        GrpcRaftController a2;
        return a2.j.get();
    }

    public RaftGroup getRaftGroup(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        return (RaftGroup)a3.h.get(a2);
    }

    public boolean isRunning() {
        GrpcRaftController a2;
        return a2.G;
    }

    public String getMyLabel(List<Node> list) {
        Object a2 = list;
        GrpcRaftController a3 = this;
        a2 = a2.iterator();
        while (a2.hasNext()) {
            Node node = (Node)a2.next();
            if (!node.getNodeName().equals(a3.m.getName())) continue;
            return node.getNodeId();
        }
        throw new RuntimeException(SubscriptionKey.b((Object)"\u0010\r&\u000e7B=\r'B5\u000b=\u0006s\u0001&\u0010!\u0007=\u0016s\f<\u00066B:\fs\f<\u00066\u0011"));
    }

    public Set<String> raftGroups() {
        GrpcRaftController a2;
        return a2.h.keySet();
    }

    private /* synthetic */ void b(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        a3.H.put(a2, System.currentTimeMillis() + 2L * (long)a3.B.getMaxElectionTimeout());
    }

    public void start() {
        GrpcRaftController grpcRaftController = this;
        Object a2 = new File(grpcRaftController.B.getLogStorageFolder());
        GrpcRaftController grpcRaftController2 = grpcRaftController;
        FileUtils.b((File)a2);
        grpcRaftController2.g.registerPath(C, ((File)a2).toPath(), grpcRaftController.B.minFreeSpace(), grpcRaftController.B.warnFreeSpace());
        a2 = grpcRaftController2.L.getMyReplicationGroups();
        a2.forEach(replicationGroupMember -> {
            GrpcRaftController a2 = replicationGroupMember;
            GrpcRaftController a3 = this;
            a3.b(a2.groupId(), a2.nodeId());
        });
        grpcRaftController.G = true;
        AtomicInteger atomicInteger = new AtomicInteger(a2.size());
        a2.forEach(replicationGroupMember -> {
            GrpcRaftController a2 = replicationGroupMember;
            GrpcRaftController a3 = this;
            try {
                void a4;
                GrpcRaftController grpcRaftController = a3;
                grpcRaftController.I.info(PluginContextManager.b((Object)"nc/>G{er|}tj|q{>rlzke>fjtlaw{y"), (Object)a2.groupId());
                ((RaftGroup)grpcRaftController.h.get(a2.groupId())).start(a2.role()).whenComplete((arg_0, arg_1) -> a3.b((ReplicationGroupMember)a2, (AtomicInteger)a4, arg_0, arg_1));
                return;
            }
            catch (Exception a4) {
                a3.I.warn(SubscriptionKey.b((Object)"\u0019.Xs$2\u000b?\u00077B'\rs\u000b=\u000b'\u000b2\u000e:\u00186B!\u0007#\u000e:\u00012\u0016:\r=%!\r&\u0012"), (Object)a2.groupId(), (Object)a4);
                return;
            }
        });
        grpcRaftController.I.info(PluginContextManager.b((Object)"G{er|}tj|q{>rlzke>vq{jgqyrpl5l`p{w{y"));
        if (a2.isEmpty()) {
            grpcRaftController.j.set(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void delete(String string, boolean bl) {
        void a2;
        Object a3 = string;
        GrpcRaftController a4 = this;
        if (a2 == false) {
            a4.b((String)a3);
        }
        a4.h.remove(a3);
        GrpcRaftController grpcRaftController = a4;
        grpcRaftController.K.deleteReplicationGroup((String)a3, (boolean)a2);
        grpcRaftController.c.publishEvent((Object)new ClusterEvents.ReplicationGroupDeleted((String)a3, (boolean)a2));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void b(ReplicationGroupMember replicationGroupMember, AtomicInteger atomicInteger, Void void_, Throwable throwable) {
        Object a2;
        GrpcRaftController grpcRaftController = object;
        Object object = throwable;
        GrpcRaftController a3 = grpcRaftController;
        if (a2 == null) {
            void a4;
            a3.I.info(PluginContextManager.b((Object)"eh$5Lpnywv\u007fawzp5ygq`n5ma\u007fgjpz"), (Object)a.groupId());
            if (a4.decrementAndGet() == 0) {
                GrpcRaftController grpcRaftController2 = a3;
                grpcRaftController2.F.setCleanShutdown();
                grpcRaftController2.j.set(true);
                return;
            }
        } else {
            a3.I.warn(SubscriptionKey.b((Object)"(\u001fiB\u0001\u0007#\u000e:\u00012\u0016:\r=B4\u0010<\u0017#B \u00162\u0010'B5\u0003:\u000e6\u0006"), (Object)a.groupId(), a2);
        }
    }

    public RaftNode getRaftNodeForContext(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        return a3.K.findReplicationGroupByContext((String)a2).map(arg_0 -> a3.getRaftNode(arg_0)).orElseThrow(() -> a3.b((String)a2));
    }

    public RaftNode waitForLeader(RaftGroup raftGroup) {
        GrpcRaftController a2 = raftGroup;
        GrpcRaftController a3 = this;
        GrpcRaftController grpcRaftController = a2;
        while (!grpcRaftController.localNode().j() || a2.logEntryProcessor().f() == 0L) {
            try {
                Thread.sleep(100L);
                grpcRaftController = a2;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(PluginContextManager.b((Object)"\\pa{gl`na>bv|rp>b\u007f|j|pr>aq5|p}zsp>y{tzpl"));
            }
        }
        return a2.localNode();
    }

    public boolean isHealthy(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        return a3.getRaftNodeForContext((String)a2).K();
    }

    public Iterable<String> getAllNonAdminContexts() {
        GrpcRaftController a2;
        return a2.L.contexts();
    }
}

