/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.replication.admin;

import com.google.protobuf.ByteString;
import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroup;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroupMember;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.cluster.internal.AddressValidator;
import io.axoniq.axonserver.enterprise.replication.admin.LeaderElectionCheck;
import io.axoniq.axonserver.enterprise.replication.group.RaftGroupServiceFactory;
import io.axoniq.axonserver.enterprise.replication.logconsumer.AdminNodeConsumer;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.DeleteNode;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.grpc.internal.UpdateLicense;
import io.axoniq.axonserver.licensing.LicenseManager;
import io.axoniq.axonserver.message.query.subscription.DirectSubscriptionQueries;
import io.axoniq.axonserver.taskscheduler.TaskPublisher;
import io.axoniq.axonserver.taskscheduler.TransientException;
import io.axoniq.axonserver.taskscheduler.task.NodeContext;
import io.axoniq.axonserver.taskscheduler.task.PrepareDeleteNodeFromContextTask;
import io.axoniq.axonserver.taskscheduler.task.UnregisterNodeTask;
import io.axoniq.axonserver.transport.rest.EventStoreTransformationRestController;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ClusterChangesHandler {
    private final AddressValidator H;
    private final LicenseManager K;
    private final RaftGroupServiceFactory F;
    private final FeatureChecker c;
    private final Logger I;
    private final TaskPublisher j;
    private final ClusterController G;

    private /* synthetic */ void b(Duration duration) {
        Duration a22 = duration;
        ClusterChangesHandler a3 = this;
        try {
            Thread.sleep(a22.toMillis());
            return;
        }
        catch (InterruptedException a22) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(a22);
        }
    }

    public void deleteNode(String string) {
        String a2 = string;
        ClusterChangesHandler a3 = this;
        ClusterNode clusterNode = a3.G.getNode(a2);
        if (clusterNode == null) {
            a3.I.info(DirectSubscriptionQueries.b((Object)"&\u0016\u000e\u0016\u0016\u0016B=\r\u0017\u0007IB\b\u001fSOS,\u001c\u0006\u0016B\u001d\r\u0007B\u0015\r\u0006\f\u0017L"), (Object)a2);
            return;
        }
        for (AdminReplicationGroupMember adminReplicationGroupMember2 : clusterNode.getReplicationGroups()) {
            if (LeaderElectionCheck.b((ClusterController)a3.G, (AdminReplicationGroup)adminReplicationGroupMember2.getReplicationGroup(), (String)a2)) continue;
            throw new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, "Cannot delete node at this moment, without the node there is no leader for " + adminReplicationGroupMember2.getReplicationGroup().getName());
        }
        a3.j.publishScheduledTask(RaftAdminGroup.b(), UnregisterNodeTask.class.getName(), (Object)a2, Duration.ofSeconds(1L));
        if (a2.equals(a3.G.getName())) {
            a3.b(Duration.ofSeconds(3L));
        }
        clusterNode.getReplicationGroups().forEach(adminReplicationGroupMember -> {
            void a2;
            ClusterChangesHandler a3 = adminReplicationGroupMember;
            ClusterChangesHandler a4 = this;
            a4.j.publishScheduledTask(RaftAdminGroup.b(), PrepareDeleteNodeFromContextTask.class.getName(), (Object)new NodeContext((String)a2, a3.getReplicationGroup().getName(), true), Duration.ZERO);
        });
    }

    /*
     * WARNING - void declaration
     */
    public ClusterChangesHandler(ClusterController clusterController, TaskPublisher taskPublisher, RaftGroupServiceFactory raftGroupServiceFactory, FeatureChecker featureChecker, AddressValidator addressValidator, LicenseManager licenseManager) {
        ClusterChangesHandler a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        ClusterChangesHandler a8;
        ClusterChangesHandler clusterChangesHandler = clusterChangesHandler2;
        ClusterChangesHandler clusterChangesHandler2 = licenseManager;
        ClusterChangesHandler clusterChangesHandler3 = a8 = clusterChangesHandler;
        ClusterChangesHandler clusterChangesHandler4 = a8;
        ClusterChangesHandler clusterChangesHandler5 = a8;
        a8.I = LoggerFactory.getLogger(ClusterChangesHandler.class);
        clusterChangesHandler5.G = a7;
        clusterChangesHandler5.j = a6;
        clusterChangesHandler4.F = a5;
        clusterChangesHandler4.c = a4;
        clusterChangesHandler3.H = a3;
        clusterChangesHandler3.K = a2;
    }

    private /* synthetic */ byte[] b() {
        ClusterChangesHandler a2;
        return a2.K.readLicense();
    }

    /*
     * WARNING - void declaration
     */
    public UpdateLicense join(NodeInfo nodeInfo) {
        void a2;
        ClusterChangesHandler clusterChangesHandler = this;
        clusterChangesHandler.c.getMaxClusterSize().ifPresent(n -> {
            Integer a2 = n;
            ClusterChangesHandler a3 = this;
            if (a3.G.nodes().count() >= (long)a2.intValue()) {
                throw new MessagingPlatformException(ErrorCode.MAX_CLUSTER_SIZE_REACHED, "Maximum allowed number of nodes reached: " + a3.c.getMaxClusterSize());
            }
        });
        ClusterChangesHandler clusterChangesHandler2 = clusterChangesHandler;
        Object a3 = clusterChangesHandler2.F.getLeader(RaftAdminGroup.b());
        if (!clusterChangesHandler2.G.getName().equals(a3)) {
            throw new MessagingPlatformException(ErrorCode.NODE_IS_REPLICA, "Send join request to the leader of _admin context: " + (String)a3);
        }
        a3 = clusterChangesHandler.G.getNode(a2.getNodeName());
        if (!(a3 == null || a3.getInternalHostName().equals(a2.getInternalHostName()) && a3.getGrpcInternalPort().equals(a2.getGrpcInternalPort()))) {
            throw new MessagingPlatformException(ErrorCode.SAME_NODE_NAME, EventStoreTransformationRestController.b((Object)"&H\t\u0007\u0003\rG\u001f\u000e\u001c\u000fH\u0013\u0000\u0002H\u0014\t\n\rG\u0006\u0006\u0005\u0002H\u0006\u0006\u0003H\u0003\u0001\u0001\u000e\u0002\u001a\u0002\u0006\u0013H\u000e\u0006\u0013\r\u0015\u0006\u0006\u0004G\u0000\b\u001b\u0013H\t\t\n\rG\t\t\fG\u0018\b\u001a\u0013H\u0006\u0004\u0015\r\u0006\f\u001eH\u0002\u0010\u000e\u001b\u0013\u001b"));
        }
        ClusterChangesHandler clusterChangesHandler3 = clusterChangesHandler;
        clusterChangesHandler3.H.validateAddress(a2.getInternalHostName(), a2.getGrpcInternalPort());
        a3 = clusterChangesHandler3.b();
        clusterChangesHandler3.F.appendToAdminAndWait(AdminNodeConsumer.class.getName(), a2.toByteArray());
        return UpdateLicense.newBuilder().setLicense(ByteString.copyFrom((byte[])a3)).build();
    }

    /*
     * WARNING - void declaration
     */
    public void deleteNodeIfEmpty(String string) {
        void a3;
        ClusterChangesHandler clusterChangesHandler = this;
        ClusterChangesHandler a4 = clusterChangesHandler.G.getNode((String)a3);
        if (a4 == null) {
            return;
        }
        if (a4.getReplicationGroups().stream().anyMatch(a2 -> {
            if (a2.getReplicationGroup() != null) {
                if (a2.getReplicationGroup().getMembers().size() > 1) {
                    return true;
                }
            }
            return false;
        })) {
            throw new TransientException(EventStoreTransformationRestController.b((Object)")\u0007\u0003\rG\u001b\u0013\u0001\u000b\u0004G\u0005\u0002\u0005\u0005\r\u0015H\b\u000eG\u000b\b\u0006\u0013\r\u001f\u001c\u0014F"));
        }
        clusterChangesHandler.F.appendToAdminAndWait(DeleteNode.class.getName(), DeleteNode.newBuilder().setNodeName((String)a3).build().toByteArray());
    }
}

