/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc.heartbeat;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.grpc.ClientContext;
import io.axoniq.axonserver.grpc.PlatformService;
import io.axoniq.axonserver.grpc.Publisher;
import io.axoniq.axonserver.grpc.control.Heartbeat;
import io.axoniq.axonserver.grpc.control.PlatformInboundInstruction;
import io.axoniq.axonserver.grpc.control.PlatformOutboundInstruction;
import io.axoniq.axonserver.grpc.heartbeat.HeartbeatMonitor;
import io.axoniq.axonserver.grpc.heartbeat.HeartbeatPublisher;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.plugin.PluginConfigurationSerializer;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"axoniq.axonserver.heartbeat.enabled"})
public class HeartbeatMonitor {
    private final long H;
    private final Map<ClientStreamIdentification, ClientInformation> K;
    private final Map<ClientStreamIdentification, Instant> F;
    private final Logger c;
    private final Clock I;
    private final Publisher<PlatformOutboundInstruction> j;
    private final ApplicationEventPublisher G;

    /*
     * WARNING - void declaration
     */
    public HeartbeatMonitor(Consumer<BiConsumer<ClientStreamIdentification, PlatformInboundInstruction>> consumer, ApplicationEventPublisher applicationEventPublisher, Publisher<PlatformOutboundInstruction> publisher, long l, Clock clock) {
        void a2;
        void a3;
        void a4;
        Object a5;
        void a6;
        HeartbeatMonitor heartbeatMonitor = object;
        Object object = clock;
        HeartbeatMonitor a7 = heartbeatMonitor;
        a7.c = LoggerFactory.getLogger(HeartbeatMonitor.class);
        HeartbeatMonitor heartbeatMonitor2 = a7;
        a7.K = new ConcurrentHashMap();
        HeartbeatMonitor heartbeatMonitor3 = a7;
        heartbeatMonitor2.F = new ConcurrentHashMap();
        a6.accept((clientStreamIdentification, platformInboundInstruction) -> {
            HeartbeatMonitor a2;
            HeartbeatMonitor a3 = clientStreamIdentification;
            HeartbeatMonitor heartbeatMonitor = a2 = this;
            heartbeatMonitor.c.trace(TopologyEvents.b((Object)"c3J$_\u0014N7_vY3H3B N2\u000b0Y9FvP+"), (Object)a3);
            heartbeatMonitor.F.put(a3, Instant.now(a2.I));
        });
        HeartbeatMonitor heartbeatMonitor4 = a7;
        HeartbeatMonitor heartbeatMonitor5 = a7;
        heartbeatMonitor5.I = a5;
        heartbeatMonitor5.G = a4;
        heartbeatMonitor4.H = a3;
        heartbeatMonitor4.j = a2;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void b(BiConsumer biConsumer, PlatformService.ClientComponent clientComponent, PlatformInboundInstruction platformInboundInstruction) {
        void a2;
        BiConsumer a3 = clientComponent;
        BiConsumer a4 = biConsumer;
        a4.accept(new ClientStreamIdentification(a3.getContext(), a3.getClientStreamId()), a2);
    }

    @Scheduled(initialDelayString="${axoniq.axonserver.client-heartbeat-initial-delay:5000}", fixedRateString="${axoniq.axonserver.client-heartbeat-frequency:500}")
    public void sendHeartbeat() {
        HeartbeatMonitor a2;
        a2.j.publish((Object)PlatformOutboundInstruction.newBuilder().setHeartbeat(Heartbeat.newBuilder()).build());
    }

    @Scheduled(initialDelayString="${axoniq.axonserver.client-heartbeat-check-initial-delay:10000}", fixedRateString="${axoniq.axonserver.client-heartbeat-check-rate:1000}")
    public void checkClientsStillAlive() {
        HeartbeatMonitor heartbeatMonitor;
        HeartbeatMonitor heartbeatMonitor2 = heartbeatMonitor = this;
        heartbeatMonitor2.c.debug(PluginConfigurationSerializer.b((Object)"G\u000ea\u0005o\u000fj\u0001$\u0005k\bj\u0003g\u0012a\u0002$\u0005h\u000fa\bp\u0015$\u0007v\u0003$\u0015p\u000fh\n$\u0007h\u000fr\u0003*H*"));
        HeartbeatMonitor heartbeatMonitor3 = heartbeatMonitor;
        Object a2 = Instant.now(heartbeatMonitor2.I).minus(heartbeatMonitor3.H, ChronoUnit.MILLIS);
        heartbeatMonitor3.F.forEach((arg_0, arg_1) -> heartbeatMonitor.b((Instant)a2, arg_0, arg_1));
    }

    @EventListener
    public void on(TopologyEvents.ApplicationConnected applicationConnected) {
        HeartbeatMonitor a2 = applicationConnected;
        HeartbeatMonitor a3 = this;
        ClientStreamIdentification clientStreamIdentification = new ClientStreamIdentification(a2.K(), a2.b());
        a3.K.put(clientStreamIdentification, new ClientInformation(a2.j(), a2.f(), a2.K()));
    }

    @EventListener
    public void on(TopologyEvents.ApplicationDisconnected applicationDisconnected) {
        HeartbeatMonitor a2 = applicationDisconnected;
        HeartbeatMonitor a3 = this;
        a2 = new ClientStreamIdentification(a2.b(), a2.I());
        a3.F.remove(a2);
        a3.K.remove(a2);
        a3.c.debug(TopologyEvents.b((Object)"x\"D&\u000b;D8B\"D$B8LvC3J$_4N7_vM9YvH:B3E\"\u000b-Vx"), (Object)a2);
    }

    private static /* synthetic */ void b(PlatformService platformService, BiConsumer biConsumer) {
        Object a2 = biConsumer;
        PlatformService a3 = platformService;
        a3.onInboundInstruction(PlatformInboundInstruction.RequestCase.HEARTBEAT, (arg_0, arg_1) -> HeartbeatMonitor.b((BiConsumer)a2, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    @Autowired
    public HeartbeatMonitor(PlatformService platformService, HeartbeatPublisher heartbeatPublisher, ApplicationEventPublisher applicationEventPublisher, @Value(value="${axoniq.axonserver.client-heartbeat-timeout:5000}") long l) {
        void a2;
        void heartbeatPublisher2;
        void platformService2;
        HeartbeatMonitor heartbeatMonitor = heartbeatMonitor2;
        HeartbeatMonitor heartbeatMonitor2 = applicationEventPublisher;
        HeartbeatMonitor eventPublisher = heartbeatMonitor;
        eventPublisher(arg_0 -> HeartbeatMonitor.b((PlatformService)platformService2, arg_0), (ApplicationEventPublisher)heartbeatMonitor2, (Publisher)heartbeatPublisher2, (long)a2, Clock.systemUTC());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void b(Instant instant, ClientStreamIdentification clientStreamIdentification, Instant instant2) {
        void a2;
        void a3;
        HeartbeatMonitor a4 = clientStreamIdentification;
        HeartbeatMonitor a5 = this;
        if (a3.isBefore((Instant)a2) && a5.K.containsKey(a4)) {
            ClientInformation clientInformation = (ClientInformation)a5.K.get(a4);
            String string = clientInformation.G;
            String string2 = clientInformation.I;
            Object[] objectArray = new Object[4];
            objectArray[0] = a5.H;
            objectArray[1] = a4;
            objectArray[2] = a3;
            objectArray[3] = a2;
            a5.c.info(PluginConfigurationSerializer.b((Object)"G\nm\u0003j\u0012$\u000fj\u0007g\u0012m\u0010m\u0012}F`\u0003p\u0003g\u0012a\u0002$\u0000k\u0014$\u000bk\u0014aFp\u000ee\b$\u001dyFi\u000fh\nm\u0015a\u0005k\b`\u0015*FG\nm\u0003j\u0012>F\u007f\u001b(Fh\u0007w\u0012E\u0005p\u000fr\u000fp\u001f>F\u007f\u001b(Fp\u000fi\u0003k\u0013p\\$\u001dyH$"), objectArray);
            a5.G.publishEvent((Object)new TopologyEvents.ApplicationInactivityTimeout((ClientStreamIdentification)a4, string, new ClientContext(string2, clientInformation.j)));
        }
    }
}

